/***************************************************************************
# Copyright (c) 2018, NVIDIA CORPORATION. All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#  * Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
#  * Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#  * Neither the name of NVIDIA CORPORATION nor the names of its
#    contributors may be used to endorse or promote products derived
#    from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY
# EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
# PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
# CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
# EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
# PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
# OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
***************************************************************************/
#pragma once
#include "RenderGraph/RenderPass.h"
#include "Core/Program/ProgramReflection.h"
#include "Core/Program/ProgramVars.h"

namespace Falcor
{
    class dlldecl SkyBox : public RenderPass
    {
    public:
        using SharedPtr = std::shared_ptr<SkyBox>;
        static const char* kDesc;

        static SharedPtr create(RenderContext* pRenderContext = nullptr, const Dictionary& dict = {});

        std::string getDesc() override { return kDesc; }
        virtual Dictionary getScriptingDictionary() override;
        virtual RenderPassReflection reflect(const CompileData& compileData) override;
        virtual void compile(RenderContext* pContext, const CompileData& compileData) override;
        virtual void execute(RenderContext* pRenderContext, const RenderData& renderData) override;
        virtual void setScene(RenderContext* pRenderContext, const Scene::SharedPtr& pScene) override;
        virtual void renderUI(Gui::Widgets& widget) override;

        void setScale(float scale) { mScale = scale; }
        void setFilter(uint32_t filter);
        float getScale() { return mScale; }
        uint32_t getFilter() { return (uint32_t)mFilter; }

    private:
        SkyBox();
        void loadImage();
        void setTexture(const Texture::SharedPtr& pTexture);

        float mScale = 1;
        bool mLoadSrgb = true;
        bool mRenderStereo = false;
        Sampler::Filter mFilter = Sampler::Filter::Linear;
        Texture::SharedPtr mpTexture;
        std::string mTexName;

        Scene::SharedPtr mpCubeScene;
        GraphicsProgram::SharedPtr mpProgram;
        GraphicsVars::SharedPtr mpVars;
        GraphicsState::SharedPtr mpState;
        Fbo::SharedPtr mpFbo;
        Scene::SharedPtr mpScene;
        Sampler::SharedPtr mpSampler;
    };
}
