/***************************************************************************
 # Copyright (c) 2019, NVIDIA CORPORATION.  All rights reserved.
 #
 # NVIDIA CORPORATION and its licensors retain all intellectual property
 # and proprietary rights in and to this software, related documentation
 # and any modifications thereto.  Any use, reproduction, disclosure or
 # distribution of this software and related documentation without an express
 # license agreement from NVIDIA CORPORATION is strictly prohibited.
 **************************************************************************/
#pragma once
#include "Falcor.h"
#include "FalcorExperimental.h"
#include "Core/Framework.h"
#include "RenderGraph/BasePasses/ComputePass.h"
#include "Utils/Sampling/SampleGenerator.h"
#include "RenderGraph/RenderPassHelpers.h"

using namespace Falcor;

class PrtPrecompute : public RenderPass, inherit_shared_from_this<RenderPass, PrtPrecompute>
{
public:
    using SharedPtr = std::shared_ptr<PrtPrecompute>;

    /** Create a new object
    */
    static SharedPtr create(RenderContext* pRenderContext = nullptr, const Dictionary& dict = {});

    virtual std::string getDesc() override { return "Precompute transfer matrix"; }
    virtual Dictionary getScriptingDictionary() override;
    virtual RenderPassReflection reflect(const CompileData& compileData) override;
    virtual void compile(RenderContext* pContext, const CompileData& compileData) override;
    virtual void setScene(RenderContext* pRenderContext, const Scene::SharedPtr& pScene) override;
    virtual void execute(RenderContext* pRenderContext, const RenderData& renderData) override;
    virtual void renderUI(Gui::Widgets& widget) override;
    virtual bool onMouseEvent(const MouseEvent& mouseEvent) override { return false; }
    virtual bool onKeyEvent(const KeyboardEvent& keyEvent) override { return false; }

private:
    PrtPrecompute() = default;
    bool init(const Dictionary& dict);
    bool parseDictionary(const Dictionary& dict);

    void preprocessScene();

    void precomputeTransfer(RenderContext* pRenderContext, const RenderData& renderData);

    bool mPrecomputeDone = false;

    // Internal state
    SampleGenerator::SharedPtr      mpSampleGenerator;
    Scene::SharedPtr                mpScene;

    std::string mOutDir;
    std::string mOutFilename;

    uint2 mFrameSize;
    uint mSqrtSpp;
    uint mSampleCount;

    std::vector<uint2> mVertexToMeshData;
    TypedBufferBase::SharedPtr mpVertexToMesh;

    uint mNumVertex;
    TypedBufferBase::SharedPtr mpTcoeffs;

    // Ray tracing resources
    struct
    {
        RtState::SharedPtr pState;
        RtProgram::SharedPtr pProgram;
        RtProgramVars::SharedPtr pVars;
    } mRaytrace;

    ComputePass::SharedPtr mpPixelPass;
};
