/***************************************************************************
 # Copyright (c) 2019, NVIDIA CORPORATION.  All rights reserved.
 #
 # NVIDIA CORPORATION and its licensors retain all intellectual property
 # and proprietary rights in and to this software, related documentation
 # and any modifications thereto.  Any use, reproduction, disclosure or
 # distribution of this software and related documentation without an express
 # license agreement from NVIDIA CORPORATION is strictly prohibited.
 **************************************************************************/
#pragma once
#include "GBuffer.h"
#include "PrtBase.h"
#include "Falcor.h"
#include "FalcorExperimental.h"
#include "Core/Framework.h"
#include "RenderGraph/BasePasses/ComputePass.h"
#include "Utils/Sampling/SampleGenerator.h"
#include "RenderGraph/RenderPassHelpers.h"

using namespace Falcor;

/** Prt for only diffuse materials
*/
class PrtGlossy : public PrtBase, inherit_shared_from_this<PrtBase, PrtGlossy>
{
public:
    using SharedPtr = std::shared_ptr<PrtGlossy>;

    /** Create a new object
    */
    static SharedPtr create(RenderContext* pRenderContext = nullptr, const Dictionary& dict = {});

    std::string getDesc(void) override { return "PRT with glossy materials"; }

private:
    PrtGlossy() = default;
    bool init(const Dictionary& dict);

    void preparePRT() override;

    void computePerVertex(RenderContext* pRenderContext, const RenderData& renderData) override;
    void computePerVertexPerLight(RenderContext* pRenderContext, const RenderData& renderData) override;

    TypedBufferBase::SharedPtr mpLcoeffs;
};
