#pragma once
#include "Data/HostDeviceData.h"

BEGIN_NAMESPACE_FALCOR

/* Constants shared between host and device.
    Make sure struct layout follows the HLSL packing rules as it is uploaded as a memory blob.
    Do not use bool's as they are 1 byte in Visual Studio, 4 bytes in HLSL.
    https://msdn.microsoft.com/en-us/library/windows/desktop/bb509632(v=vs.85).aspx
*/
struct PrtParams
{
    uint3 gridReso;
    uint lmax;

    float3 gridMin;
    uint numVertex;

    float3 gridStep;
    uint legendreReso;

    uint stReceiverIndex;
    uint numReceivers;
    uint stEmitterIndex;
    uint numEmitters;

    uint numEmitterTriangles;
    uint emitterGroupSize;
    float lightDisplayScale;
    float lightIntensityScale;
};

END_NAMESPACE_FALCOR
