/***************************************************************************
 # Copyright (c) 2019, NVIDIA CORPORATION.  All rights reserved.
 #
 # NVIDIA CORPORATION and its licensors retain all intellectual property
 # and proprietary rights in and to this software, related documentation
 # and any modifications thereto.  Any use, reproduction, disclosure or
 # distribution of this software and related documentation without an express
 # license agreement from NVIDIA CORPORATION is strictly prohibited.
 **************************************************************************/
#include "Falcor.h"
#include "PrtViewer.h"
#include "RenderGraph/RenderPassStandardFlags.h"
#include "RenderPasses/DepthPass.h"

namespace
{
    // Shaders
    const char* kShShaderFile = "PrtViewer.slang";

    const char* kUnitTestShaderFile = "ShUnitTest.cs.slang";
}

PrtViewer::SharedPtr PrtViewer::create(RenderContext* pRenderContext, const Dictionary& dict)
{
    SharedPtr pPass = SharedPtr(new PrtViewer);
    return pPass->init(dict) ? pPass : nullptr;
}

bool PrtViewer::init(const Dictionary& dict)
{
    mShaderDir = std::string(PROJECT_DIR) + R"(diffuseShaders\)";

    // Create raster program
    Program::Desc desc;
    desc.addShaderLibrary(mShaderDir + kShShaderFile).vsEntry("vs").psEntry("ps").setShaderModel("5_1");
    mRaster.pProgram = GraphicsProgram::create(desc, Program::DefineList());
    if (!mRaster.pProgram) throw std::exception("Failed to create program");

    // Initialize graphics state
    mRaster.pState = GraphicsState::create();
    mRaster.pState->setProgram(mRaster.pProgram);

    // Set default cull mode
    setCullMode(mCullMode);

    // Set depth function
    DepthStencilState::Desc dsDesc;
    dsDesc.setDepthFunc(DepthStencilState::Func::Equal).setDepthWriteMask(false);
    DepthStencilState::SharedPtr pDsState = DepthStencilState::create(dsDesc);
    mRaster.pState->setDepthStencilState(pDsState);

    mpFbo = Fbo::create();

    // Parse dictionary parameters
    bool flag = parseDictionary(dict);
    if (!flag) throw std::exception("Failed to parse dictionary");

    // Create random engine
    mpSampleGenerator = SampleGenerator::create(SAMPLE_GENERATOR_TINY_UNIFORM);
    if (!mpSampleGenerator) throw std::exception("Failed to create sample generator");
    mpSampleGenerator->prepareProgram(mRaster.pProgram.get());

    // Prepare PRT: loading coefficients
    preparePRT();

    prepareShaders();

    return true;
}
