/***************************************************************************
 # Copyright (c) 2019, NVIDIA CORPORATION.  All rights reserved.
 #
 # NVIDIA CORPORATION and its licensors retain all intellectual property
 # and proprietary rights in and to this software, related documentation
 # and any modifications thereto.  Any use, reproduction, disclosure or
 # distribution of this software and related documentation without an express
 # license agreement from NVIDIA CORPORATION is strictly prohibited.
 **************************************************************************/
#pragma once
#include "GBuffer.h"
#include "PrtBase.h"
#include "Falcor.h"
#include "FalcorExperimental.h"
#include "Core/Framework.h"
#include "RenderGraph/BasePasses/ComputePass.h"
#include "Utils/Sampling/SampleGenerator.h"
#include "RenderGraph/RenderPassHelpers.h"

using namespace Falcor;

/** Prt for only diffuse materials
*/
class PrtViewer : public PrtBase, inherit_shared_from_this<PrtBase, PrtViewer>
{
public:
    using SharedPtr = std::shared_ptr<PrtViewer>;

    /** Create a new object
    */
    static SharedPtr create(RenderContext* pRenderContext = nullptr, const Dictionary& dict = {});

    std::string getDesc(void) override { return "PRT with only diffuse materials"; }

private:
    PrtViewer() = default;
    bool init(const Dictionary& dict);
};
