import torch
import pyvredner
import numpy as np

param = torch.tensor(np.loadtxt(
    'results_standard/iterations/iter_param.log', delimiter=','))[-1, 1:]

obj = pyvredner.load_obj('heightmap.obj')[0]

with open('heightmap_opt.obj', 'w') as f:
    for i in range(len(obj.vertices)):
        f.write('v {} {} {}\n'.format(
            obj.vertices[i][0], param[i], obj.vertices[i][2]))

    for i in range(len(obj.indices)):
        f.write('f {} {} {}\n'.format(
            obj.indices[i][0] + 1, obj.indices[i][1] + 1, obj.indices[i][2] + 1))
