import torch
import pyvredner
import numpy as np

param = torch.tensor(np.loadtxt(
    'results_standard/iterations/iter_param.log', delimiter=','))[-1, 1:].tolist()
param = [p + 50.0 for p in param[:-3]]

fixed = [0, 1, 2, 3, 4, 6, 8, 9, 10, 11, 12, 13]
fixed_h = [0.0, 50.0, 0.0, 50.0, 0.0, 0.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0]
for f, f_h in zip(fixed, fixed_h):
    param.insert(f, f_h)

obj = pyvredner.load_obj('sofa_init.obj')[0]

with open('sofa_opt.obj', 'w') as f:
    for i in range(len(obj.vertices)):
        f.write('v {} {} {}\n'.format(
            obj.vertices[i][0], param[i], obj.vertices[i][2]))

    for i in range(len(obj.indices)):
        f.write('f {} {} {}\n'.format(
            obj.indices[i][0] + 1, obj.indices[i][1] + 1, obj.indices[i][2] + 1))
