import pyvredner
import torch

param_id = list(range(8 * 8 + 4))
fixed = [0, 1, 2, 3, 4, 6, 8, 9, 10, 11, 12, 13]
albedo_init = [0.95, 0.95, 0.95]
albedo_target = [0.5, 0.5, 0.8]
albedo_param_init = [0.0, 0.0, 0.0]
albedo_param_target = [(t - i) / 0.01 for i, t in zip(albedo_init, albedo_target)]

for f in fixed:
    param_id.remove(f)
print('nder: {}'.format(len(param_id) + 3))
torch.save(param_id, 'param_id.pt')

print(torch.load('param_id.pt'))

obj = pyvredner.load_obj('sofa_target.obj')[0]
param = obj.vertices[:, 1].tolist()
for i, f in enumerate(fixed):
    param.pop(f - i)
param = [p - 50 for p in param]
param += albedo_param_target
torch.save(torch.tensor(param, dtype=torch.float), 'param_target.pt')

print(torch.load('param_target.pt'))

obj = pyvredner.load_obj('sofa_init.obj')[0]
param = obj.vertices[:, 1].tolist()
for i, f in enumerate(fixed):
    param.pop(f - i)
param = [p - 50 for p in param]
param += albedo_param_init
torch.save(torch.tensor(param, dtype=torch.float), 'param_init.pt')

print(torch.load('param_init.pt'))
