from pyvredner import SceneTransform
import torch
import os
import numpy as np
import vredner

opt_options = {
    # Teaser 
    'plant_teaser': {
        'render': {
            'standard': {
                'integrator':   vredner.BinnedPathTracerADps(),
                'spp':          1000,
                'sppse0':       1000,
                'sppse1':       1000,
                'sppe':         1000,
                'sppte':        0,
                'guiding': {
                    'direct_param':     [50000, 1, 1, 64],
                    'indirect_param':   [1000, 30, 30, 64],
                    'num_cam_path':     10000,
                    'num_light_path':   10000,
                    'min_radius':       1e-4,
                    'indirect_type':    'knn'
                }
            },
        },

        'xforms':               [ [SceneTransform("SHAPE_GLOBAL_ROTATE", torch.tensor([0, 1, 0], dtype=torch.float), 1),
        						   SceneTransform("SHAPE_GLOBAL_ROTATE", torch.tensor([0, 1, 0], dtype=torch.float), 2)] ],
        'spp_target':           10,
        'max_bounces':          5,
        'param_init':           torch.tensor([0.0]),
        'param_target':         torch.tensor([0.0]),
        'lr':                   1e-2,
        'num_iters':            500,
        'gen_ref':              True,

        'pif':                  2,
        'tau':                  0,
        'deltaTau':             3,
        'stepTau':              10,
        'num_bins':             30,

        "use_antithetic_boundary": True,
        "use_antithetic_interior": True,

        'color_range':          [-0.01, 0.01],
        'amp':                  True,
        'amp_value':            1,
    },

    # Validation (Fig. 8)
    'cbox_diffuse_boxcar': {
        'render': {
            'standard': {
                'integrator':   vredner.BinnedPathTracerADps(),
                'spp':          50000,
                'sppse0':       50000,
                'sppse1':       50000,
                'sppe':         50000,
                'sppte':        50000,
                'guiding': {
                    'direct_param':     [50000, 1, 1, 64],
                    'indirect_param':   [1000, 30, 30, 64],
                    'num_cam_path':     10000,
                    'num_light_path':   10000,
                    'min_radius':       1e-4,
                    'indirect_type':    'knn'
                }
            },
        },

        'xforms':               [[SceneTransform("SHAPE_TRANSLATE", torch.tensor([0, 1.0, 0], dtype=torch.float), 1)]],
        'spp_target':           1000000,
        'max_bounces':          5,
        'param_init':           torch.tensor([1.0]),
        'param_target':         torch.tensor([0.0]),
        'lr':                   1e-2,
        'num_iters':            500,
        'gen_ref':              True,

        'pif':                  1,
        'tau':                  1200,
        'deltaTau':             10,
        'stepTau':              50,
        'num_bins':             1,

        'color_range':          [-0.01, 0.01],
        'amp':                  True,
        'amp_value':            2,
        'exposure_scale':       4,
    },

    'cbox_diffuse_gaussian': {
        'render': {
            'standard': {
                'integrator':   vredner.BinnedPathTracerADps(),
                'spp':          50000,
                'sppse0':       50000,
                'sppse1':       50000,
                'sppe':         50000,
                'sppte':        0,
                'guiding': {
                    'direct_param':     [50000, 1, 1, 64],
                    'indirect_param':   [1000, 30, 30, 64],
                    'num_cam_path':     10000,
                    'num_light_path':   10000,
                    'min_radius':       1e-4,
                    'indirect_type':    'knn'
                }
            },
        },

        'xforms':               [[SceneTransform("SHAPE_TRANSLATE", torch.tensor([0, 1.0, 0], dtype=torch.float), 1)]],
        'spp_target':           1000000,
        'max_bounces':          5,
        'param_init':           torch.tensor([1.0]),
        'param_target':         torch.tensor([0.0]),
        'lr':                   1e-2,
        'num_iters':            500,
        'gen_ref':              True,

        'pif':                  2,
        'tau':                  1250,
        'deltaTau':             10,
        'stepTau':              50,
        'num_bins':             1,

        'color_range':          [-0.01, 0.01],
        'amp':                  True,
        'amp_value':            2,
        'exposure_scale':       4,
    },

    'cbox_diffuse_truncated_gaussian': {
        'render': {
            'standard': {
                'integrator':   vredner.BinnedPathTracerADps(),
                'spp':          50000,
                'sppse0':       50000,
                'sppse1':       50000,
                'sppe':         50000,
                'sppte':        50000,
                'guiding': {
                    'direct_param':     [50000, 1, 1, 64],
                    'indirect_param':   [1000, 30, 30, 64],
                    'num_cam_path':     10000,
                    'num_light_path':   10000,
                    'min_radius':       1e-4,
                    'indirect_type':    'knn'
                }
            },
        },

        'xforms':               [[SceneTransform("SHAPE_TRANSLATE", torch.tensor([0, 1.0, 0], dtype=torch.float), 1)]],
        'spp_target':           1000000,
        'max_bounces':          5,
        'param_init':           torch.tensor([1.0]),
        'param_target':         torch.tensor([0.0]),
        'lr':                   1e-2,
        'num_iters':            500,
        'gen_ref':              True,

        'pif':                  4,
        'tau':                  1300,
        'deltaTau':             10,
        'stepTau':              50,
        'num_bins':             1,

        'color_range':          [-0.01, 0.01],
        'amp':                  True,
        'amp_value':            2,
        'exposure_scale':       8,
    },

    # Cube (Fig. 9 & Fig. 11)
    'cube_with_anti': {
        'render': {
            'standard': {
                'integrator':   vredner.BinnedPathTracerADps(),
                'spp':          256,
                'sppse0':       256,
                'sppse1':       256,
                'sppe':         256,
                'sppte':        256,
                'guiding': {
                    'direct_param':     [50000, 1, 1, 64],
                    'indirect_param':   [1000, 30, 30, 64],
                    'num_cam_path':     10000,
                    'num_light_path':   10000,
                    'min_radius':       1e-4,
                    'indirect_type':    'knn'
                }
            },
            'ellip_nee': {
                'integrator':   vredner.BinnedTofPathTracerADps(),
                'spp':          128,
                'sppse0':       128,
                'sppse1':       128,
                'sppe':         128,
                'sppte':        0,
                "num_ellipsoidal_connections": 1,
                'guiding': {
                    'direct_param':     [50000, 1, 1, 64],
                    'indirect_param':   [1000, 30, 30, 64],
                    'num_cam_path':     10000,
                    'num_light_path':   10000,
                    'min_radius':       1e-4,
                    'indirect_type':    'knn'
                }
            }
        },

        'xforms':               [[SceneTransform("SHAPE_TRANSLATE", torch.tensor([0, 1.0, 0], dtype=torch.float), 1)] ],
        'spp_target':           1000,
        'max_bounces':          5,
        'param_init':           torch.tensor( [20.0] ),
        'param_target':         torch.tensor( [15.0] ),
        'lr':                   1e-1,
        'num_iters':            100,
        'gen_ref':              True,

        'pif':                  2,
        'tau':                  1130,
        'deltaTau':             0.001,
        'stepTau' :             5,
        'num_bins':             4, 
        'exposure_scale':       10000,

        "use_antithetic_boundary": True,
        "use_antithetic_interior": True,

        'color_range':          [-0.001, 0.001],
        'amp':                  False,
        'amp_value':            1,

        'paper_2x2_indices':    [0, 1, 2, 3],
    },

    'cube_without_anti': {
        'render': {
            'standard': {
                'integrator':   vredner.BinnedPathTracerADps(),
                'spp':          128 + 64,
                'sppse0':       128 + 64,
                'sppse1':       128 + 64,
                'sppe':         128 + 64,
                'sppte':        0,
                'guiding': {
                    'direct_param':     [50000, 1, 1, 64],
                    'indirect_param':   [1000, 30, 30, 64],
                    'num_cam_path':     10000,
                    'num_light_path':   10000,
                    'min_radius':       1e-4,
                    'indirect_type':    'knn'
                }
            },
        },

        'xforms':               [ [SceneTransform("SHAPE_TRANSLATE", torch.tensor([0, 1.0, 0], dtype=torch.float), 1)] ],
        'spp_target':           1000,
        'max_bounces':          5,
        'param_init':           torch.tensor( [20.0] ),
        'param_target':         torch.tensor( [15.0] ),
        'lr':                   1e-1,
        'num_iters':            100,
        'gen_ref':              False,

        'pif':                  2,
        'tau':                  1130,
        'deltaTau':             0.001,
        'stepTau' :             5,
        'num_bins':             4, 
        'exposure_scale':       10000,

        "use_antithetic_boundary": False,
        "use_antithetic_interior": False,

        'color_range':          [-0.001, 0.001],
        'amp':                  False,
        'amp_value':            1,

        'paper_2x2_indices':    [0, 1, 2, 3],
    },

    # Corridor (Fig.10)
    'corridor_10_bounces': {
        'render': {
            'standard': {
                'integrator':   vredner.BinnedPathTracerADps(),
                'spp':          1000,
                'sppse0':       100,
                'sppse1':       100,
                'sppe':         10,
                'guiding': {
                    'direct_param':     [50000, 1, 1, 64],
                    'indirect_param':   [1000, 30, 30, 64],
                    'num_cam_path':     10000,
                    'num_light_path':   10000,
                    'min_radius':       1e-4,
                    'indirect_type':    'knn'
                }
            },
        },

        'xforms':               [
                                    [
                                        SceneTransform("VERTEX_TRANSLATE", torch.tensor([1, 0, 0], dtype=torch.float), 1, 6),
                                        SceneTransform("VERTEX_TRANSLATE", torch.tensor([1, 0, 0], dtype=torch.float), 1, 12),
                                        SceneTransform("VERTEX_TRANSLATE", torch.tensor([1, 0, 0], dtype=torch.float), 1, 14),
                                        SceneTransform("VERTEX_TRANSLATE", torch.tensor([1, 0, 0], dtype=torch.float), 1, 15)
                                    ],
                                    [
                                        SceneTransform("VERTEX_TRANSLATE", torch.tensor([0, 0, 1], dtype=torch.float), 1, 6),
                                        SceneTransform("VERTEX_TRANSLATE", torch.tensor([0, 0, 1], dtype=torch.float), 1, 12),
                                        SceneTransform("VERTEX_TRANSLATE", torch.tensor([0, 0, 1], dtype=torch.float), 1, 14),
                                        SceneTransform("VERTEX_TRANSLATE", torch.tensor([0, 0, 1], dtype=torch.float), 1, 15)
                                    ]
                                ],
        'spp_target':           10000,
        'max_bounces':          10,
        'param_init':           torch.tensor([-30.0, 0]),
        'param_target':         torch.tensor([30.0, 50]),
        'lr':                   1,
        'num_iters':            200,
        'gen_ref':              True,

        'pif':                  0,
        'tau':                  200,
        'deltaTau':             25,
        'stepTau':              50,
        'num_bins':             10,

        'color_range':          [-0.002, 0.002],
        'amp':                  False,
        'amp_value':            1,

        'paper_2x2_indices':    [0, 1, 2, 3],
    },

    'corridor_10_bounces_fd': {
        'render': {
            'standard': {
                'integrator':   vredner.BinnedPathTracerADps(),
                'spp':          1000,
                'sppse0':       0,
                'sppse1':       0,
                'sppe':         0,
                'guiding':      {}
            },
        },

        'xforms':               [
                                    [
                                        SceneTransform("VERTEX_TRANSLATE", torch.tensor([1, 0, 0], dtype=torch.float), 1, 6),
                                        SceneTransform("VERTEX_TRANSLATE", torch.tensor([1, 0, 0], dtype=torch.float), 1, 12),
                                        SceneTransform("VERTEX_TRANSLATE", torch.tensor([1, 0, 0], dtype=torch.float), 1, 14),
                                        SceneTransform("VERTEX_TRANSLATE", torch.tensor([1, 0, 0], dtype=torch.float), 1, 15)
                                    ],
                                    [
                                        SceneTransform("VERTEX_TRANSLATE", torch.tensor([0, 0, 1], dtype=torch.float), 1, 6),
                                        SceneTransform("VERTEX_TRANSLATE", torch.tensor([0, 0, 1], dtype=torch.float), 1, 12),
                                        SceneTransform("VERTEX_TRANSLATE", torch.tensor([0, 0, 1], dtype=torch.float), 1, 14),
                                        SceneTransform("VERTEX_TRANSLATE", torch.tensor([0, 0, 1], dtype=torch.float), 1, 15)
                                    ]
                                ],
        'spp_target':           10000,
        'max_bounces':          10,
        'param_init':           torch.tensor([-30.0, 0]),
        'param_target':         torch.tensor([30.0, 50]),
        'lr':                   1,
        'num_iters':            200,
        'gen_ref':              True,

        'pif':                  2,
        'tau':                  200,
        'deltaTau':             25,
        'stepTau':              50,
        'num_bins':             10,

        'color_range':          [-0.002, 0.002],
        'amp':                  False,
        'amp_value':            1,

        'paper_2x2_indices':    [0, 1, 2, 3],
    },

    'corridor_3_bounces': {
        'render': {
            'standard': {
                'integrator':   vredner.BinnedPathTracerADps(),
                'spp':          1000 * 2,
                'sppse0':       100 * 2,
                'sppse1':       100 * 2,
                'sppe':         10 * 2,
                'guiding': {
                    'direct_param':     [50000, 1, 1, 64],
                    'indirect_param':   [1000, 30, 30, 64],
                    'num_cam_path':     10000,
                    'num_light_path':   10000,
                    'min_radius':       1e-4,
                    'indirect_type':    'knn'
                }
            },
        },

        'xforms':               [
                                    [
                                        SceneTransform("VERTEX_TRANSLATE", torch.tensor([1, 0, 0], dtype=torch.float), 1, 6),
                                        SceneTransform("VERTEX_TRANSLATE", torch.tensor([1, 0, 0], dtype=torch.float), 1, 12),
                                        SceneTransform("VERTEX_TRANSLATE", torch.tensor([1, 0, 0], dtype=torch.float), 1, 14),
                                        SceneTransform("VERTEX_TRANSLATE", torch.tensor([1, 0, 0], dtype=torch.float), 1, 15)
                                    ],
                                    [
                                        SceneTransform("VERTEX_TRANSLATE", torch.tensor([0, 0, 1], dtype=torch.float), 1, 6),
                                        SceneTransform("VERTEX_TRANSLATE", torch.tensor([0, 0, 1], dtype=torch.float), 1, 12),
                                        SceneTransform("VERTEX_TRANSLATE", torch.tensor([0, 0, 1], dtype=torch.float), 1, 14),
                                        SceneTransform("VERTEX_TRANSLATE", torch.tensor([0, 0, 1], dtype=torch.float), 1, 15)
                                    ]
                                ],
        'spp_target':           10000,
        'max_bounces':          3,
        'param_init':           torch.tensor([-30.0, 0]),
        'param_target':         torch.tensor([30.0, 50]),
        'lr':                   1,
        'num_iters':            200,
        'gen_ref':              False,

        'pif':                  2,
        'tau':                  200,
        'deltaTau':             25,
        'stepTau':              50,
        'num_bins':             10,

        'color_range':          [-0.002, 0.002],
        'amp':                  False,
        'amp_value':            1,

        'paper_2x2_indices':    [0, 1, 2, 3],
    },

    # Branches (Fig. 12)
    'tree': {
        'render': {
            'standard': {
                'integrator':   vredner.BinnedPathTracerADps(),
                'spp':          32,
                'sppse0':       32,
                'sppse1':       32,
                'sppe':         0,
                'sppte':        0,
                'guiding': {
                    'direct_param':     [50000, 1, 1, 64],
                    'indirect_param':   [1000, 30, 30, 64],
                    'num_cam_path':     10000,
                    'num_light_path':   10000,
                    'min_radius':       1e-4,
                    'indirect_type':    'knn'
                }
            },
            'ellip_nee': {
                'integrator':   vredner.BinnedTofPathTracerADps(),
                'spp':          32,
                'sppse0':       32,
                'sppse1':       32,
                'sppe':         0,
                "num_ellipsoidal_connections": 10,
                'guiding': {
                    'direct_param':     [50000, 1, 1, 64],
                    'indirect_param':   [1000, 30, 30, 64],
                    'num_cam_path':     10000,
                    'num_light_path':   10000,
                    'min_radius':       1e-4,
                    'indirect_type':    'knn'
                }
            }
        },

        'xforms':               [ 
                                    [SceneTransform("SHAPE_GLOBAL_ROTATE", torch.tensor([0, 0, 1], dtype=torch.float), 1)],
                                ],
        'spp_target':           10000,
        'max_bounces':          5,
        'param_init':           torch.tensor( [0.4], dtype=torch.float ),
        'param_target':         torch.tensor( [0.0], dtype=torch.float ),
        'lr':                   1e-2,
        'num_iters':            100,
        'gen_ref':              True,

        'pif':                  2,
        'tau':                  100,
        'deltaTau':             0.5,
        'stepTau' :             1,
        'num_bins':             5,

        'color_range':          [-1, 1],
        'amp':                  False,
        'amp_value':            1,

        'paper_2x2_indices':    [0, 1, 2, 3],
    },

    # Height field (Fig. 13 & Fig. 14)
    'los_heightmap_10x10': {
        'render': {
            'standard': {
                'integrator':   vredner.BinnedPathTracerADps(),
                'spp':          100,
                'sppse0':       100,
                'sppse1':       100,
                'sppe':         100,
                'guiding': {
                    'direct_param':     [5000, 1, 1, 64],
                    'indirect_param':   [100, 10, 10, 64],
                    'num_cam_path':     10000,
                    'num_light_path':   10000,
                    'min_radius':       1e-4,
                    'indirect_type':    'knn'
                }
            },
        },

        'xforms':               [
                                    [SceneTransform("VERTEX_TRANSLATE", torch.tensor([0, 1, 0], dtype=torch.float), 1, i)]
                                        for i in range(121)
                                ],
        'spp_target':           10000,
        'max_bounces':          5,
        'param_init':           torch.load('los_heightmap_10x10/param_init.pt'),
        'param_target':         torch.load('los_heightmap_10x10/param_target.pt'),
        'lr':                   1,
        'num_iters':            500,
        'gen_ref':              True,

        'pif':                  2,
        'tau':                  160,
        'deltaTau':             10,
        'stepTau':              10,
        'num_bins':             12,

        'color_range':          [-0.05, 0.05],
        'amp':                  False,
        'amp_value':            1,

        'der_to_visualize':     81,
        'paper_2x2_indices':    [4, 5, 6, 7],
    },

    'los_heightmap_10x10_steady': {
        'render': {
            'standard': {
                'integrator':   vredner.BinnedPathTracerADps(),
                'spp':          100 * 12,
                'sppse0':       100 * 12,
                'sppse1':       100 * 12,
                'sppe':         100 * 12,
                'guiding': {
                    'direct_param':     [5000, 1, 1, 64],
                    'indirect_param':   [100, 10, 10, 64],
                    'num_cam_path':     10000,
                    'num_light_path':   10000,
                    'min_radius':       1e-4,
                    'indirect_type':    'knn'
                }
            },
        },

        'xforms':               [
                                    [SceneTransform("VERTEX_TRANSLATE", torch.tensor([0, 1, 0], dtype=torch.float), 1, i)]
                                        for i in range(121)
                                ],
        'spp_target':           10000,
        'max_bounces':          5,
        'param_init':           torch.load('los_heightmap_10x10_steady/param_init.pt'),
        'param_target':         torch.load('los_heightmap_10x10_steady/param_target.pt'),
        'lr':                   1,
        'num_iters':            500,
        'gen_ref':              True,

        'pif':                  0,
        'tau':                  1000,
        'deltaTau':             999,
        'stepTau':              1000,
        'num_bins':             1,

        'color_range':          [-0.05, 0.05],
        'amp':                  False,
        'amp_value':            1,

        'der_to_visualize':     81,
        'paper_2x2_indices':    [4, 5, 6, 7],
    },

    # Bunny (Fig. 15)
    'nlos_room': {
        'render': {
            'standard': {
                'integrator':   vredner.BinnedPathTracerADps(),
                'spp':          3036,
                'sppse0':       1024,
                'sppse1':       1024,
                'sppe':         10,
                'sppte':        0,
                'guiding': {
                    'direct_param':     [50000, 1, 1, 64],
                    'indirect_param':   [1000, 30, 30, 64],
                    'num_cam_path':     10000,
                    'num_light_path':   10000,
                    'min_radius':       1e-4,
                    'indirect_type':    'knn'
                }
            },
        },

        'xforms':               [
                                    [SceneTransform("SHAPE_TRANSLATE", torch.tensor([1, 0, 0], dtype=torch.float), 1)], 
                                    [SceneTransform("SHAPE_TRANSLATE", torch.tensor([0, 1, 0], dtype=torch.float), 1)], 
                                ],
        'spp_target':           50000,
        'max_bounces':          10,
        'param_init':           torch.tensor( [50.0, -50.0], dtype=torch.float ),
        'param_target':         torch.tensor( [0.0, -30.0], dtype=torch.float ),
        'lr':                   1e1,
        'num_iters':            200,
        'gen_ref':              True,

        'pif':                  2,
        'tau':                  600,
        'deltaTau':             50,
        'stepTau' :             50,
        'num_bins':             20,

        'color_range':          [-0.01, 0.01],
        'amp':                  True,
        'amp_value':            5,

        'paper_2x2_indices':    [4, 6, 8, 10],
    },

    # Sofa (Fig. 16)
    'nlos_sofa': {
        'render': {
            'standard': {
                'integrator':   vredner.BinnedPathTracerADps(),
                'spp':          100,
                'sppse0':       100,
                'sppse1':       100,
                'sppe':         10,
                'sppte':        10,
                'guiding': {
                    'direct_param':     [50000, 1, 1, 64],
                    'indirect_param':   [1000, 30, 30, 64],
                    'num_cam_path':     10000,
                    'num_light_path':   10000,
                    'min_radius':       1e-4,
                    'indirect_type':    'knn'
                }
            },
        },

        'xforms':               [
                                    [SceneTransform("VERTEX_TRANSLATE", torch.tensor([0, 1, 0], dtype=torch.float), 1, i)]
                                        for i in torch.load('nlos_sofa/param_id.pt')
                                ] + 
                                [
                                    [SceneTransform("BSDF_VARY", "diffuse", 0, torch.tensor([0.01, 0.0, 0.0], dtype=torch.float))],
                                    [SceneTransform("BSDF_VARY", "diffuse", 0, torch.tensor([0.0, 0.01, 0.0], dtype=torch.float))],
                                    [SceneTransform("BSDF_VARY", "diffuse", 0, torch.tensor([0.0, 0.0, 0.01], dtype=torch.float))], 
                                ],
        'spp_target':           10000,
        'max_bounces':          10,
        'param_init':           torch.load('nlos_sofa/param_init.pt'),
        'param_target':         torch.load('nlos_sofa/param_target.pt'),
        'lr':                   1,
        'num_iters':            1000,
        'gen_ref':              True,

        'pif':                  1,
        'tau':                  100,
        'deltaTau':             50,
        'stepTau':              50,
        'num_bins':             20,

        "use_antithetic_boundary": False,
        "use_antithetic_interior": False,

        'color_range':          [-0.0002, 0.0002],
        'amp':                  True,
        'amp_value':            1,
        'exposure_scale':       2,
        
        'paper_2x2_indices':    [6, 7, 8, 9],
    },

    # Tree (Fig. 17)
    'plant_light': {
        'render': {
            'ellip_nee': {
                'integrator':   vredner.BinnedTofPathTracerADps(),
                'spp':          256,
                'sppse0':       256,
                'sppse1':       256,
                'sppe':         256,
                'sppte':        256,
                'guiding': {
                    'direct_param':     [50000, 1, 1, 64],
                    'indirect_param':   [1000, 30, 30, 64],
                    'num_cam_path':     10000,
                    'num_light_path':   10000,
                    'min_radius':       1e-4,
                    'indirect_type':    'knn'
                }
            },
            'standard': {
                'integrator':   vredner.BinnedPathTracerADps(),
                'spp':          1000,
                'sppse0':       500,
                'sppse1':       500,
                'sppe':         500,
                'sppte':        500,
                'guiding': {
                    'direct_param':     [50000, 1, 1, 64],
                    'indirect_param':   [1000, 30, 30, 64],
                    'num_cam_path':     10000,
                    'num_light_path':   10000,
                    'min_radius':       1e-4,
                    'indirect_type':    'knn'
                }
            },
        },

        'xforms':               [ 
                                    [SceneTransform("SHAPE_TRANSLATE", torch.tensor([1, 0, 0], dtype=torch.float), 0)],
                                ],
        'spp_target':           10000,
        'max_bounces':          5,
        'param_init':           torch.tensor([15.0]),
        'param_target':         torch.tensor([10.0]),
        'lr':                   3e-2,
        'num_iters':            200,
        'gen_ref':              True,

        'pif':                  4,
        'tau':                  115,
        'deltaTau':             0.1,
        'stepTau':              2.5,
        'num_bins':             14,

        "use_antithetic_boundary": True,
        "use_antithetic_interior": True,

        'color_range':          [-0.1, 0.1],
        'amp':                  False,
        'amp_value':            1,
        'exposure_scale':       30,

        'paper_2x2_indices':    [3, 4, 5, 6],
    },
}
