#pragma once
#ifndef EPC_SAMPLER_H__
#define EPC_SAMPLER_H__

#include "ellipsoid.h"
#include "scene.h"

struct EPCSampler { // Ellipsoidal Path Connection Sampler
    EPCSampler(const Vector& x1_, const Vector& n1_, const Vector& x2_, const Vector& n2_, Float tau, const Scene& scene_);
    void init();
    bool sample(const Vector2& rn2, Intersection& x_its, Float& jacobian, Float& pdf);

    Ellipsoid ellipsoid;
    std::vector<ECBVHManager::TriWithID> tri_list;
    const Scene& scene;
};

#endif