#pragma once
#ifndef EPC_SAMPLER_AD_H__
#define EPC_SAMPLER_AD_H__

#include "ellipsoid.h"
#include "ellipsoidAD.h"
#include "scene.h"

struct EPCSamplerAD { // Ellipsoidal Path Connection Sampler
    EPCSamplerAD(const VectorAD& x1_, const VectorAD& n1_, const VectorAD& x2_, const VectorAD& n2_, const FloatAD& tau, const Scene& scene_);
    void init();
    bool sample(const Vector2& rn2, IntersectionAD& x_its, FloatAD& jacobian, Float& pdf);

    EllipsoidAD ellipsoid;
    std::vector<ECBVHManager::TriWithID> tri_list;
    const Scene& scene;
};

#endif
