#pragma once
#ifndef SPHERE_SAMPLER_H__
#define SPHERE_SAMPLER_H__

#include "sphere.h"
#include "scene.h"

struct SphereSampler { // Spherical Path Connection Sampler
    SphereSampler(const Vector& x_, const Vector& n_, Float tau, const Scene& scene_);
    void init();
    bool sample(const Vector2& rnd2, Intersection& x_its, Float& jacobian, Float& pdf);

    Sphere sphere;
    std::vector<ECBVHManager::TriWithID> tri_list;
    const Scene& scene;
};

#endif
