#pragma once
#ifndef SPHERE_SAMPLER_AD_H__
#define SPHERE_SAMPLER_AD_H__

#include "sphereAD.h"
#include "scene.h"

struct SphereSamplerAD { // Spherical Path Connection Sampler
    SphereSamplerAD(const VectorAD& x_, const VectorAD& n_, const FloatAD& tau, const Scene& scene_);
    void init();
    bool sample(const Vector2& rnd2, IntersectionAD& x_its, FloatAD& jacobian, Float& pdf);

    SphereAD sphere;
    std::vector<ECBVHManager::TriWithID> tri_list;
    const Scene& scene;
};

#endif
