#pragma once
#ifndef TOF_INTEGRATOR_AD_PATHSPACE_H__
#define TOF_INTEGRATOR_AD_PATHSPACE_H__

#include "integratorADps.h"

struct TofIntegratorAD_PathSpace : IntegratorAD_PathSpace {
    // Boundary term due to box time gates
    void renderBoxTimeGateBoundary(const Scene& scene, const RenderOptions& options, ptr<float> rendered_image) const;
    void renderBoxTimeGateBoundary_ZeroAndOneBounce(const Scene& scene, const RenderOptions& options, ptr<float> rendered_image) const;
    void renderBoxTimeGateBoudnary_MultiBounces(const Scene& scene, const RenderOptions& options, ptr<float> rendered_image) const;

    // Helper functions

    // Returns <path_contribution, idx_pixel, idx_bin>.
    std::vector<std::tuple<Spectrum, int, int>> ellipsoidalConnectToCamera(const Scene& scene, RndSampler* sampler,
        const Intersection& x1_its, int idx_bin, Float ec_length, const Spectrum& throughput) const;

    // Returns <path_contribution, path_length, idx_pixel>.
    std::vector<std::tuple<SpectrumAD, FloatAD, int>> ellipsoidalConnectToLightAD(const Scene& scene, RndSampler* sampler,
        const IntersectionAD& x1_its_AD, Float ec_length, bool x1_is_camera, Float throughput) const;

    // Returns <path_contribution, path_length, idx_pixel>.
    std::vector<std::tuple<SpectrumAD, FloatAD, int>> sphericalConnectToLightAD(const Scene& scene, RndSampler* sampler,
        const IntersectionAD& x1_its_AD, Float sph_radius, bool x1_is_camera, Float throughput) const;
    
    // Returns <path_contribution, path_length>.
    std::vector<std::tuple<SpectrumAD, FloatAD>> LiAD(const Scene &scene, RndSampler* sampler, const RayAD &_ray,
        Float ec_length, int pixel_x, int pixel_y, int max_depth) const;

    // Returns <path_contribution, path_length, idx_pixel>.
    std::vector<std::tuple<SpectrumAD, FloatAD, int>> LiAD_ZeroAndOneBounce(const Scene& scene, RndSampler* sampler,
        Float ec_length) const;

    mutable int num_ellipsoidal_connections = 1;

    mutable bool use_antithetic_boundary = true;
};

#endif //TOF_INTEGRATOR_AD_PATHSPACE_H__
