#pragma once
#ifndef INV_DIRECT_AD_PATHSPACE_H__
#define INV_DIRECT_AD_PATHSPACE_H__

#include "integratorADps.h"

struct InvDirectAD_PathSpace : IntegratorAD_PathSpace {
    Spectrum pixelColor(const Scene &scene, const RenderOptions &options, RndSampler *sampler, Float x, Float y) const { assert(false); };
    SpectrumAD pixelColorAD(const Scene &scene, const RenderOptions &options, RndSampler *sampler, Float x, Float y) const { assert(false); };

    void handleEmissionAD(const Intersection& its, const Scene& scene, RndSampler *sampler, const Spectrum& weight, int max_bounces, int thread_id) const;

    void handleSurfaceInteractionAD(const Intersection& its, const IntersectionAD its0_ad, const Scene& scene, const Medium* ptr_med, RndSampler *sampler, const SpectrumAD& weight, int max_bounces, int thread_id) const;

    void traceParticleAD(const Scene& scene, RndSampler *sampler, int max_bounces, int thread_id) const;
    void renderAD(const Scene &scene, const RenderOptions &options, ptr<float> rendered_image) const;
    void render(const Scene &scene, const RenderOptions &options, ptr<float> rendered_image) const;
    std::string getName() const { return "invDirect_ps"; }

    mutable std::vector<std::vector<Spectrum>> image_per_thread;
    mutable omp_lock_t messageLock;
};

#endif //DIRECT_INTEGRATOR_AD_PATHSPACE_H__
