#pragma once
#ifndef PATH_TRACER_AD_PATHSPACE_H__
#define PATH_TRACER_AD_PATHSPACE_H__

#include "integratorADps.h"

struct PathTracerAD_PathSpace : IntegratorAD_PathSpace {
    Spectrum Li(const Scene& scene, RndSampler* sampler, const Ray& _ray, int max_depth) const;
    SpectrumAD LiAD(const Scene &scene, RndSampler* sampler, const RayAD &_ray, int max_depth) const;

    Spectrum pixelColor(const Scene &scene, const RenderOptions &options, RndSampler *sampler, Float x, Float y) const;
    SpectrumAD pixelColorAD(const Scene &scene, const RenderOptions &options, RndSampler *sampler, Float x, Float y) const;

    void render(const Scene &scene, const RenderOptions &options, ptr<float> rendered_image) const;

    std::string getName() const { return "pathAD_ps"; }
};

#endif //DIRECT_INTEGRATOR_AD_PATHSPACE_H__