#pragma once
#ifndef PARTICLE_TRACER_AD_PATHSPACE_H__
#define PARTICLE_TRACER_AD_PATHSPACE_H__

#include "integratorADps.h"
#include "bidir_utils.h"

#define PTRACE_MAX_THREADS 256
#define PTRACE_MAX_PATH_LENGTH 50


struct ParticleTracerAD_PathSpace : IntegratorAD_PathSpace {

    Spectrum pixelColor(const Scene &scene, const RenderOptions &options, RndSampler *sampler, Float x, Float y) const { assert(false); };
    SpectrumAD pixelColorAD(const Scene &scene, const RenderOptions &options, RndSampler *sampler, Float x, Float y) const { assert(false); };

    void renderAD(const Scene &scene, const RenderOptions &options, ptr<float> rendered_image) const;
    void traceParticleAD(const Scene& scene, RndSampler *sampler, int max_bounces, int thread_id, Float grad_threshold) const;
    void render(const Scene &scene, const RenderOptions &options, ptr<float> rendered_image) const;
    std::string getName() const { return "ptracerADps"; }

    // For pixelColor()
    mutable bidir::PathNodeAD m_path[PTRACE_MAX_THREADS][PTRACE_MAX_PATH_LENGTH];
    mutable bidir::PathNode m_path2[PTRACE_MAX_THREADS][PTRACE_MAX_PATH_LENGTH];
    mutable std::vector<std::vector<Spectrum>> image_per_thread;
    mutable omp_lock_t messageLock;

};

#endif //PARTICLE_INTEGRATOR_AD_PATHSPACE_H__
