#include "boxcar.h"

Float BoxcarPIF::evalSingle(Float x, Float centerTau) const {
    Float min_tau = centerTau - deltaTau.val - Epsilon;
    Float max_tau = centerTau + deltaTau.val + Epsilon;
    return (min_tau < x && x < max_tau) ? 1.0 : 0.0;
}

FloatAD BoxcarPIF::evalSingleAD(const FloatAD &x, const FloatAD &centerTau) const {
    Float min_tau = centerTau.val - deltaTau.val - Epsilon;
    Float max_tau = centerTau.val + deltaTau.val + Epsilon;
    return (min_tau < x.val && x.val < max_tau) ? 1.0 : 0.0;
}

Float BoxcarPIF::sampleSingle(RndSampler *sampler, const Vector2 &rnd2, Float centerTau, Float &pdf) const {
    pdf = 1.0 / (2.0 * deltaTau.val);
    return centerTau - deltaTau.val + rnd2.x() * 2.0 * deltaTau.val;
}

Vector2 BoxcarPIF::sampleSingleBoundary(Float centerTau, Float &pdf) const {
    Vector2 res(centerTau - deltaTau.val, centerTau + deltaTau.val);
    pdf = 1.0 / (Float)num_bins;
    return res;
}

Vector2i BoxcarPIF::getBinIndexRange(Float x) const {
    return Vector2i(getPotentialBinIndex(x - deltaTau.val, 0),
                    getPotentialBinIndex(x + deltaTau.val, 1));
}