#include "delta.h"

Float DeltaPIF::evalSingle(Float x, Float centerTau) const {
    return std::abs(x - centerTau) < Epsilon ? 1.0 : 0.0;
}

FloatAD DeltaPIF::evalSingleAD(const FloatAD &x, const FloatAD &centerTau) const {
    return std::abs(x.val - centerTau.val) < Epsilon ? 1.0 : 0.0;
}

Float DeltaPIF::sampleSingle(RndSampler *sampler, const Vector2 &rnd2, Float centerTau, Float &pdf) const {
    pdf = 1.0;
    return centerTau;
}

Vector2 DeltaPIF::sampleSingleBoundary(Float centerTau, Float &pdf) const {
    pdf = 0.0;
    return Vector2(0);
}

Vector2i DeltaPIF::getBinIndexRange(Float x) const {
    return Vector2i(0, 0);
}