#pragma once
#ifndef PIF_Delta_H__
#define PIF_Delta_H__

#include "pif.h"

struct DeltaPIF : PIF {
    DeltaPIF(Float _tau, Float _deltaTau, int _num_bins, Float _stepTau) : 
            PIF(_tau, _deltaTau, _num_bins, _stepTau) { name = "Delta"; }

    Float evalSingle(Float x, Float centerTau) const override;
    FloatAD evalSingleAD(const FloatAD &x, const FloatAD &centerTau) const override;
    Float sampleSingle(RndSampler *sampler, const Vector2 &rnd2, Float centerTau, Float &pdf) const override;
    Vector2 sampleSingleBoundary(Float centerTau, Float &pdf) const override;
    Vector2i getBinIndexRange(Float x) const override;
};

#endif // PIF_Delta_H__