#include "gaussian.h"
#include "utils.h"

Float GaussianPIF::evalSingle(Float x, Float centerTau) const {
    // make sure \int pif(x) dx = 2 * deltaTau
    return normalPdf(x, centerTau, deltaTau.val) * 2.0 * deltaTau.val;
}

FloatAD GaussianPIF::evalSingleAD(const FloatAD &x, const FloatAD &centerTau) const {
    // make sure \int pif(x) dx = 2 * deltaTau
    return normalPdfAD(x, centerTau, deltaTau) * 2.0 * deltaTau;
}

Float GaussianPIF::sampleSingle(RndSampler *sampler, const Vector2 &rnd2, Float centerTau, Float &pdf) const {
    Vector2 uv = squareToStdNormal(rnd2);
    Float x = uv.x() * deltaTau.val + centerTau;
    pdf = normalPdf(x, centerTau, deltaTau.val);
    return x;
}

Vector2 GaussianPIF::sampleSingleBoundary(Float centerTau, Float &pdf) const {
    pdf = 0.0;
    return Vector2(0);
}

Vector2i GaussianPIF::getBinIndexRange(Float x) const {
    return Vector2i(getPotentialBinIndex(x - 3 * deltaTau.val, 0),
                    getPotentialBinIndex(x + 3 * deltaTau.val, 1));
}