#include "pif_test.h"
#include "../pif/boxcar.h"
#include "../pif/gaussian.h"
#include "../pif/t_gaussian.h"
#include "../pif/steady.h"
#include "../pif/delta.h"
#include "sampler.h"
#include <iostream>
#include <memory>

void pif_test() {
    Float tau = 100;
    Float deltaTau = 50;
    int num_bins = 5;
    Float stepTau = 100;

    BoxcarPIF boxcar(tau, deltaTau, num_bins, stepTau);
    GaussianPIF gaussian(tau, deltaTau, num_bins, stepTau);
    TruncatedGaussianPIF t_guassian(tau, deltaTau, num_bins, stepTau);
    DeltaPIF delta(tau, deltaTau, num_bins, stepTau);

    PIF *pifs[] = { &boxcar, &gaussian, &t_guassian, &delta };

    RndSampler sampler(0, 0);

    for (auto pif : pifs) {
        std::cout << "PIF being tested: " << pif->name << std::endl;
        
        int bin_index;
        Float pdf;
        Float path_length = pif->sample(&sampler, bin_index, pdf);
        Float pif_kernel = pif->eval(path_length, bin_index);
        std::cout << path_length << " " << bin_index << " " << pdf << " " << pif_kernel << std::endl;
    }
}
