# Accurate Appearance Preserving Prefiltering for Rendering Displacement-Mapped Surfaces

## Overview
- Folder `mitsuba/` is a modified version of the Mitsuba renderer (official repo: https://github.com/mitsuba-renderer/mitsuba).
  We add plugins for rendering displacement-mapped surfaces and its corresponding prefiltered models.
- Folder `python/` contains scripts to generate prefiltered models.
- Folder `data/` contains data of the `twill` example, including a displacement map, scene files and rendered images.

## Usage (Tested on Windows 10 x64)
- Open `mitsuba/build/mitsuba-msvc2017.sln` using Visual Studio 2017 and build mitsuba with `build solution`.
- To render images, inside folder `data/render_twill/`, run `"../mitsuba/dist/mitsuba [scene_xml]"`.
- To compute prefiltered models, inside folder `python/`, run `python prefilter_twill.py`. 
  Python requirements: python 3.x, numpy, scipy, opencv.

## New Mitsuba plugins
### Shapes
- `tiled_heightfield`: a large displacement map tiled repeatedly by smaller ones in x and y directions.
- `shellmap_heightfield`: a deformed displacement map by shell mapping (Porumbescu et al. 2005: https://dl.acm.org/citation.cfm?id=1073239).

### BSDFs
- `multilobe_bsdf`: a composite bsdf defined by a base bsdf and an NDF represented as a mixture of multiple vMF lobes.
- `tabulated_scaled_bsdf`: a composite bsdf defined by a base bsdf, a spatial scaling table and an angular scaling table.

### Utils
- `normalMipmap`: given a displacement map, compute an NDF represented as a mixture of multiple vMF lobes by normal mapping (Han et al. 2007: https://dl.acm.org/citation.cfm?id=1276412).
- `LEADR_plane`: compute surface statistics by LEAN mapping (Olano and Baker 2010: https://www.csee.umbc.edu/~olano/papers/lean/, Dupuy et al. 2013: https://dl.acm.org/citation.cfm?id=2508363.2508422).
- `bsdfSimulator`: given wi, compute effective BRDFs as a function of wo (represented as an image output).
- `effBrdfEstimator`: given wi and wo, compute the effective BRDF value.

## Notes
- Mitsuba is compiled using `double` precision.
- Welcome to send an email to Lifan Wu (liw086@eng.ucsd.edu) if you have any questions or comments.
