/*
This source is published under the following 3-clause BSD license.

Copyright (c) 2012, Lukas Hosek and Alexander Wilkie
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * None of the names of the contributors may be used to endorse or promote
      products derived from this software without specific prior written
      permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/


/* ============================================================================

This file is part of a sample implementation of the analytical skylight model
presented in the SIGGRAPH 2012 paper


           "An Analytic Model for Full Spectral Sky-Dome Radiance"

                                    by

                       Lukas Hosek and Alexander Wilkie
                Charles University in Prague, Czech Republic


                        Version: 1.1, July 4th, 2012

Version history:

1.1  The coefficients of the spectral model are now scaled so that the output
     is given in physical units: W / (m^-2 * sr * nm). Also, the output of the
     XYZ model is now no longer scaled to the range [0...1]. Instead, it is
     the result of a simple conversion from spectral data via the CIE 2 degree
     standard observer matching functions. Therefore, after multiplication
     with 683 lm / W, the Y channel now corresponds to luminance in lm.

1.0  Initial release (May 11th, 2012).


Please visit http://cgg.mff.cuni.cz/projects/SkylightModelling/ to check if
an updated version of this code has been published!

============================================================================ */


/*

This file contains the coefficient data for both the spectral and the colour
space version of the model.

*/

double dataset320[] =
{
    // albedo 0, turbidity 1
    -1.341049e+001,
    -3.742293e+000,
    -5.229614e+000,
    5.307180e+000,
    -2.182658e-002,
    1.497676e-001,
    -8.561730e-006,
    1.733480e+000,
    8.826913e-001,
    -1.426825e+001,
    -3.550926e+000,
    5.719350e-002,
    3.165753e-001,
    -5.870693e-002,
    1.333896e-001,
    1.779338e-005,
    1.504276e+000,
    9.750357e-001,
    -2.239068e+000,
    -4.290407e+000,
    -7.494879e-001,
    2.864989e-001,
    -6.017855e-002,
    1.325901e-001,
    -1.661674e-004,
    1.732120e+000,
    6.513374e-001,
    -1.336194e+000,
    -2.467808e-001,
    3.961139e-001,
    -6.723820e-002,
    -1.817268e-001,
    1.017581e-002,
    6.096079e-004,
    1.986859e+000,
    1.415296e+000,
    -1.554271e+000,
    -1.811527e+000,
    7.309756e-001,
    1.766793e-003,
    5.779090e-001,
    6.186216e-001,
    -1.755338e-003,
    -2.701090e-002,
    2.699530e-001,
    -8.449639e-001,
    -5.665198e-001,
    5.525823e-001,
    -2.838870e-003,
    -4.555228e+000,
    2.824945e-001,
    4.002014e-003,
    1.114208e+000,
    6.637074e-001,
    // albedo 0, turbidity 2
    -1.298333e+001,
    -3.775577e+000,
    -5.173531e+000,
    5.316518e+000,
    -2.572615e-002,
    1.516601e-001,
    -8.297168e-006,
    1.669649e+000,
    9.000495e-001,
    -1.402639e+001,
    -3.787558e+000,
    7.611941e-002,
    2.521881e-001,
    -5.859973e-002,
    1.753711e-001,
    4.670097e-005,
    1.459275e+000,
    8.998629e-001,
    -2.190256e+000,
    -3.575495e+000,
    -4.930996e-001,
    4.826321e-002,
    -6.797145e-002,
    3.425922e-002,
    -3.512550e-004,
    1.978419e+000,
    8.866517e-001,
    -2.415991e+000,
    -1.453294e+000,
    2.170671e-001,
    1.341284e-001,
    -1.926330e-001,
    1.059103e-001,
    1.360739e-003,
    1.587725e+000,
    9.821154e-001,
    -5.254592e-001,
    -8.181026e-001,
    7.535702e-001,
    -3.323364e-002,
    4.503149e-001,
    5.778285e-001,
    -4.089673e-003,
    3.335089e-001,
    6.827164e-001,
    -1.280108e+000,
    -1.013716e+000,
    5.577676e-001,
    9.539205e-004,
    -4.934956e+000,
    2.642883e-001,
    1.005169e-002,
    9.265844e-001,
    4.999698e-001,
    // albedo 0, turbidity 3
    -1.292247e+001,
    -3.819777e+000,
    -4.478733e+000,
    4.582924e+000,
    -2.364370e-002,
    1.619828e-001,
    -3.053548e-006,
    1.646629e+000,
    5.103371e-001,
    -1.433099e+001,
    -3.766213e+000,
    4.930150e-001,
    -3.081235e-002,
    -6.522199e-002,
    1.564198e-001,
    3.455657e-004,
    1.428507e+000,
    4.312273e-001,
    -2.539220e+000,
    -3.459074e+000,
    -3.774393e-001,
    -3.628419e-001,
    -2.124451e-001,
    -1.358132e-002,
    -1.812805e-003,
    2.245152e+000,
    7.247429e-001,
    -2.393246e+000,
    -1.937898e+000,
    1.005834e-001,
    5.867890e-001,
    2.645044e-001,
    1.413695e-001,
    6.378716e-003,
    1.140715e+000,
    1.263014e+000,
    -1.185583e-001,
    -1.960943e-001,
    7.212723e-001,
    -1.763978e-001,
    -1.000190e+000,
    6.259726e-001,
    -1.783726e-002,
    7.790644e-001,
    3.244710e-001,
    -1.550325e+000,
    -1.333575e+000,
    5.618137e-001,
    2.563595e-002,
    -5.007716e+000,
    6.522985e-002,
    4.262830e-002,
    7.371930e-001,
    5.239972e-001,
    // albedo 0, turbidity 4
    -1.234358e+001,
    -3.851875e+000,
    -3.911206e+000,
    4.011324e+000,
    -2.734425e-002,
    1.272306e-001,
    -7.628210e-006,
    1.661843e+000,
    8.993903e-001,
    -1.349727e+001,
    -3.592681e+000,
    1.335192e+000,
    -9.426446e-001,
    -5.741127e-002,
    9.765267e-002,
    5.518099e-005,
    1.428554e+000,
    -4.278471e-001,
    -3.399618e+000,
    -3.818725e+000,
    -8.698171e-001,
    2.723930e-001,
    -3.644369e-001,
    1.238759e-001,
    -5.189179e-004,
    2.279175e+000,
    1.841076e+000,
    -1.925152e+000,
    -1.539333e+000,
    2.757771e-001,
    -6.435980e-002,
    6.466700e-001,
    3.084382e-002,
    3.114730e-003,
    1.259818e+000,
    5.121617e-001,
    -5.706832e-001,
    -6.696186e-001,
    6.798158e-001,
    6.920162e-001,
    -3.898854e+000,
    5.954021e-001,
    -1.196667e-002,
    5.714991e-001,
    6.528481e-001,
    -1.371907e+000,
    -1.142330e+000,
    5.207805e-001,
    -4.480298e-003,
    -5.008950e+000,
    1.251549e-001,
    3.531514e-002,
    8.776759e-001,
    4.999465e-001,
    // albedo 0, turbidity 5
    -1.459738e+001,
    -3.833562e+000,
    -4.148717e+000,
    4.203270e+000,
    -2.484405e-002,
    1.189704e-001,
    4.166397e-004,
    1.748850e+000,
    4.999721e-001,
    -1.223022e+001,
    -3.942049e+000,
    1.183072e+000,
    -9.018678e-001,
    -4.644071e-002,
    1.237476e-001,
    -2.359994e-003,
    1.471013e+000,
    5.298845e-001,
    -4.078262e+000,
    -3.261096e+000,
    -5.520001e-001,
    2.174261e-001,
    -3.582576e-001,
    2.000597e-002,
    9.890182e-003,
    2.199274e+000,
    2.756320e-001,
    -2.499065e+000,
    -2.408391e+000,
    3.391663e-002,
    -6.167543e-002,
    7.555424e-001,
    2.349252e-001,
    -2.443140e-002,
    1.328540e+000,
    1.348906e+000,
    5.456648e-002,
    -9.221401e-002,
    7.403428e-001,
    5.565324e-001,
    -5.134970e+000,
    3.021763e-001,
    3.638500e-002,
    5.560149e-001,
    1.818210e-001,
    -1.590269e+000,
    -1.344330e+000,
    4.805789e-001,
    5.038509e-001,
    -3.370644e+000,
    3.040357e-001,
    2.418483e-003,
    8.979818e-001,
    7.477974e-001,
    // albedo 0, turbidity 6
    -6.775680e+000,
    -3.436745e+000,
    -2.696730e+000,
    2.740681e+000,
    -4.032382e-002,
    1.036486e-001,
    8.133034e-005,
    1.767160e+000,
    5.401354e-001,
    -7.800595e+000,
    -2.867058e+000,
    1.478909e+000,
    -1.380160e+000,
    -1.658909e-001,
    1.962673e-001,
    -6.512798e-004,
    1.634359e+000,
    4.300704e-001,
    -4.392403e+000,
    -3.857979e+000,
    -1.022020e+000,
    1.449394e+000,
    2.769695e-001,
    -3.331834e-001,
    3.513950e-003,
    1.942113e+000,
    3.970742e-001,
    -2.469701e+000,
    -1.357319e+000,
    2.132600e-001,
    -1.918729e+000,
    -4.193060e+000,
    8.101579e-001,
    -9.605279e-003,
    1.844443e+000,
    1.582310e+000,
    -7.759612e-001,
    -1.298076e+000,
    7.162377e-001,
    2.906682e+000,
    -8.261148e-001,
    -2.892123e-001,
    1.491449e-002,
    6.529387e-002,
    -4.180287e-002,
    -9.962340e-001,
    -6.488730e-001,
    3.933344e-001,
    -4.752111e-003,
    -4.721793e+000,
    6.053196e-001,
    3.453563e-003,
    1.247655e+000,
    8.673379e-001,
    // albedo 0, turbidity 7
    -7.552689e+000,
    -3.219112e+000,
    -2.730242e+000,
    2.755929e+000,
    -3.925138e-002,
    8.394617e-002,
    1.514980e-004,
    1.844410e+000,
    5.389194e-001,
    -8.494732e+000,
    -3.138528e+000,
    1.424739e+000,
    -1.269326e+000,
    -1.561580e-001,
    1.767060e-001,
    -1.175921e-003,
    1.659123e+000,
    3.746132e-001,
    -4.672972e+000,
    -4.049529e+000,
    -1.027600e+000,
    1.072252e+000,
    7.908165e-002,
    -2.243835e-001,
    6.190595e-003,
    1.988822e+000,
    6.684758e-001,
    -2.256117e+000,
    -1.258356e+000,
    2.198377e-001,
    -1.296239e+000,
    -3.200970e+000,
    6.407291e-001,
    -1.527762e-002,
    1.735209e+000,
    1.170530e+000,
    -7.790059e-001,
    -1.269213e+000,
    6.315194e-001,
    2.368850e+000,
    -1.199163e+000,
    -1.504024e-001,
    1.733299e-002,
    2.544016e-001,
    2.756763e-001,
    -1.046916e+000,
    -6.991719e-001,
    3.620624e-001,
    7.364236e-002,
    -5.012491e+000,
    4.240417e-001,
    3.580425e-002,
    1.202329e+000,
    6.255804e-001,
    // albedo 0, turbidity 8
    -1.886851e+001,
    -4.491136e+000,
    -3.660440e+000,
    3.704226e+000,
    -3.158478e-002,
    1.229909e-001,
    9.233613e-004,
    1.745459e+000,
    5.011929e-001,
    -1.986322e+001,
    -3.528401e+000,
    1.401749e+000,
    -1.191377e+000,
    -7.474944e-002,
    -2.193835e-002,
    -5.138968e-003,
    1.710181e+000,
    5.473672e-001,
    5.355660e-001,
    -5.459304e+000,
    -8.809226e-001,
    5.959028e-001,
    -3.311339e-001,
    3.876731e-001,
    2.126070e-002,
    1.929868e+000,
    1.883429e-001,
    -3.136053e+000,
    -2.856938e-001,
    1.048390e-001,
    -7.708877e-001,
    2.106630e-001,
    -1.488471e-001,
    -5.172733e-002,
    1.769302e+000,
    1.526253e+000,
    1.496752e-001,
    -9.170428e-001,
    5.628226e-001,
    1.733601e+000,
    -4.784033e+000,
    3.570330e-001,
    7.396580e-002,
    3.954993e-001,
    1.397727e-003,
    -1.839740e+000,
    -1.279260e+000,
    3.173503e-001,
    1.096266e+000,
    -4.168649e+000,
    2.121881e-001,
    2.150917e-002,
    1.151497e+000,
    7.233585e-001,
    // albedo 0, turbidity 9
    -1.841090e+001,
    -4.803089e+000,
    -4.883823e+000,
    4.962235e+000,
    -2.693216e-002,
    1.089917e-001,
    -6.338015e-006,
    1.725865e+000,
    8.890717e-001,
    -1.947081e+001,
    -2.961260e+000,
    1.963002e+000,
    -1.942423e+000,
    -5.550118e-002,
    7.036456e-002,
    -5.990592e-004,
    1.807097e+000,
    -8.871814e-003,
    9.588307e-001,
    -6.379803e+000,
    -1.021090e+000,
    9.560589e-001,
    -2.175500e-001,
    8.613517e-002,
    1.362268e-002,
    1.953529e+000,
    7.422482e-001,
    -3.609766e+000,
    -1.823498e-003,
    2.516424e-002,
    -8.909855e-001,
    2.207805e-001,
    1.783064e-001,
    -4.293958e-002,
    1.607901e+000,
    1.131559e+000,
    6.087707e-001,
    -6.744295e-001,
    4.236310e-001,
    1.505925e+000,
    -4.197126e+000,
    2.046561e-001,
    6.445824e-002,
    7.793118e-001,
    3.262213e-001,
    -2.148492e+000,
    -1.597890e+000,
    3.166858e-001,
    2.414329e+000,
    -4.201339e+000,
    1.005902e-001,
    4.687865e-002,
    9.335376e-001,
    5.289661e-001,
    // albedo 0, turbidity 10
    -1.787767e+001,
    -4.873485e+000,
    -5.861224e+000,
    5.866336e+000,
    -1.564202e-002,
    6.967640e-002,
    7.574926e-004,
    1.768065e+000,
    5.856596e-001,
    -1.932995e+001,
    -4.092647e+000,
    2.679531e+000,
    -2.555671e+000,
    -4.181418e-002,
    1.023654e-001,
    -5.964172e-003,
    1.625691e+000,
    4.036808e-001,
    1.788482e+000,
    -5.652582e+000,
    -1.517519e+000,
    1.251535e+000,
    -2.225912e-001,
    -1.084716e-001,
    3.272584e-002,
    2.139078e+000,
    3.876645e-001,
    -3.363801e+000,
    -3.266475e-001,
    1.313912e-001,
    -6.889075e-001,
    4.356523e-001,
    3.120297e-001,
    -8.700131e-002,
    1.750122e+000,
    1.223546e+000,
    4.668756e-004,
    -9.612337e-001,
    3.082344e-001,
    1.298938e+000,
    -4.371395e+000,
    8.845524e-002,
    1.303481e-001,
    5.843720e-001,
    2.718863e-001,
    -1.759172e+000,
    -1.386072e+000,
    2.349661e-001,
    1.592185e+000,
    -3.063267e+000,
    1.529736e-001,
    3.429185e-002,
    1.030294e+000,
    6.917018e-001,
    // albedo 1, turbidity 1
    -1.341051e+001,
    -3.742047e+000,
    -5.229556e+000,
    5.307222e+000,
    -2.094796e-002,
    1.499787e-001,
    -7.023116e-006,
    1.732898e+000,
    8.826861e-001,
    -1.426829e+001,
    -3.550660e+000,
    5.731266e-002,
    3.166575e-001,
    -5.821080e-002,
    1.335860e-001,
    2.003178e-004,
    1.503788e+000,
    9.750310e-001,
    -2.239143e+000,
    -4.290084e+000,
    -7.493158e-001,
    2.865753e-001,
    -5.993923e-002,
    1.327393e-001,
    -5.399344e-004,
    1.731677e+000,
    6.513329e-001,
    -1.336350e+000,
    -2.463606e-001,
    3.963632e-001,
    -6.721398e-002,
    -1.816244e-001,
    1.021503e-002,
    8.081470e-004,
    1.986453e+000,
    1.415292e+000,
    -1.554584e+000,
    -1.810948e+000,
    7.313475e-001,
    1.703307e-003,
    5.779436e-001,
    6.184790e-001,
    -6.832621e-004,
    -2.739619e-002,
    2.699443e-001,
    -8.456234e-001,
    -5.656772e-001,
    5.531782e-001,
    -2.975361e-003,
    -4.555221e+000,
    2.821035e-001,
    4.007713e-004,
    1.113850e+000,
    6.636719e-001,
    // albedo 1, turbidity 2
    -1.263311e+001,
    -4.099112e+000,
    -5.130792e+000,
    5.526406e+000,
    -2.122841e-002,
    1.202556e-001,
    -8.060670e-006,
    1.209196e+000,
    8.997967e-001,
    -1.361400e+001,
    -3.538236e+000,
    1.570583e-001,
    3.445259e-001,
    -5.306874e-002,
    2.322893e-001,
    1.572516e-005,
    1.152750e+000,
    9.026902e-001,
    -1.477014e+000,
    -3.664310e+000,
    -1.442116e-001,
    -4.293554e-002,
    -3.768326e-002,
    -1.388530e-001,
    -1.687893e-004,
    1.592625e+000,
    8.804841e-001,
    -2.050884e+000,
    -1.470536e+000,
    3.327590e-001,
    1.976143e-001,
    -1.930369e-001,
    2.831960e-001,
    6.940849e-004,
    1.271203e+000,
    9.790242e-001,
    -3.704793e-001,
    -5.829841e-001,
    1.168589e+000,
    -1.387973e-001,
    5.998426e-001,
    3.825096e-001,
    -2.188637e-003,
    -2.273264e-001,
    7.393514e-001,
    -9.877542e-001,
    -7.646946e-001,
    8.859003e-001,
    5.263145e-002,
    -4.849410e+000,
    1.301905e-001,
    5.464872e-003,
    5.270984e-001,
    5.001226e-001,
    // albedo 1, turbidity 3
    -1.294452e+001,
    -3.858933e+000,
    -4.362969e+000,
    4.657159e+000,
    -2.281956e-002,
    1.371565e-001,
    3.552610e-006,
    1.354369e+000,
    5.222053e-001,
    -1.425646e+001,
    -3.745266e+000,
    6.901454e-001,
    -5.345642e-002,
    -5.238708e-002,
    1.157055e-001,
    -1.961110e-005,
    1.030408e+000,
    4.036292e-001,
    -2.236186e+000,
    -3.560196e+000,
    -1.053059e-001,
    -3.002269e-001,
    -1.702750e-001,
    3.290753e-002,
    -7.253274e-005,
    1.846963e+000,
    6.828000e-001,
    -1.991088e+000,
    -2.028027e+000,
    2.747056e-001,
    5.076456e-001,
    2.056096e-001,
    1.537040e-001,
    1.010611e-003,
    8.439763e-001,
    1.286657e+000,
    -2.733597e-001,
    -1.938590e-001,
    1.108079e+000,
    -1.668080e-001,
    -8.136300e-001,
    3.962292e-001,
    -4.757393e-003,
    1.536882e-001,
    4.595467e-001,
    -9.782447e-001,
    -8.452104e-001,
    9.149995e-001,
    2.750126e-002,
    -4.996263e+000,
    1.226836e-001,
    1.533731e-002,
    3.686265e-001,
    5.004484e-001,
    // albedo 1, turbidity 4
    -1.234416e+001,
    -3.818503e+000,
    -3.804408e+000,
    4.093838e+000,
    -2.505623e-002,
    1.149315e-001,
    -7.610563e-006,
    1.361584e+000,
    8.981571e-001,
    -1.349621e+001,
    -3.551853e+000,
    1.469377e+000,
    -8.971164e-001,
    -5.623731e-002,
    1.078524e-001,
    1.491378e-003,
    1.113040e+000,
    -4.279059e-001,
    -3.391950e+000,
    -3.791028e+000,
    -6.935352e-001,
    2.998175e-001,
    -3.155309e-001,
    1.196041e-001,
    -4.708048e-003,
    2.001973e+000,
    1.840166e+000,
    -1.915114e+000,
    -1.493080e+000,
    4.567342e-001,
    -7.334296e-002,
    6.767060e-001,
    -4.562689e-003,
    1.016838e-002,
    1.003272e+000,
    5.102018e-001,
    -5.674128e-001,
    -5.568719e-001,
    9.084369e-001,
    6.684870e-001,
    -3.892720e+000,
    5.312866e-001,
    -1.768715e-002,
    3.252051e-001,
    6.541029e-001,
    -1.343751e+000,
    -9.647458e-001,
    7.945561e-001,
    5.127485e-004,
    -5.009873e+000,
    6.165389e-002,
    2.642926e-002,
    6.213595e-001,
    5.327376e-001,
    // albedo 1, turbidity 5
    -1.450562e+001,
    -4.021778e+000,
    -4.181517e+000,
    4.509518e+000,
    -2.369519e-002,
    6.955582e-002,
    1.149882e-004,
    1.329583e+000,
    5.260857e-001,
    -1.297772e+001,
    -3.655039e+000,
    2.030636e+000,
    -1.537436e+000,
    -4.915490e-002,
    1.511047e-001,
    -9.053517e-004,
    1.156980e+000,
    4.831690e-001,
    -1.991837e+000,
    -3.919397e+000,
    -8.466357e-001,
    5.319508e-001,
    -3.165811e-001,
    1.056172e-001,
    4.836036e-003,
    1.843574e+000,
    3.084513e-001,
    -2.052725e+000,
    -1.606839e+000,
    5.876624e-001,
    -7.464148e-002,
    7.525473e-001,
    1.590947e-003,
    -1.261084e-002,
    8.587516e-001,
    1.404076e+000,
    -3.737447e-001,
    -4.061843e-001,
    8.985804e-001,
    5.700187e-001,
    -5.422882e+000,
    4.334301e-001,
    1.759754e-002,
    2.613056e-001,
    2.062463e-001,
    -1.002263e+000,
    -1.006484e+000,
    9.629219e-001,
    8.528366e-002,
    -4.220831e+000,
    7.848806e-002,
    1.254937e-002,
    2.140208e-001,
    6.187813e-001,
    // albedo 1, turbidity 6
    -7.175451e+000,
    -3.313094e+000,
    -2.396914e+000,
    2.657177e+000,
    -3.936959e-002,
    1.123476e-001,
    7.315860e-005,
    1.431209e+000,
    5.107145e-001,
    -8.058121e+000,
    -3.119458e+000,
    1.729776e+000,
    -1.435370e+000,
    -1.414745e-001,
    2.338787e-001,
    -5.865288e-004,
    1.247225e+000,
    5.037743e-001,
    -4.387785e+000,
    -3.851081e+000,
    -7.774273e-001,
    1.405520e+000,
    1.743075e-001,
    -4.108912e-001,
    3.058571e-003,
    1.519803e+000,
    2.636805e-001,
    -1.807473e+000,
    -1.498491e+000,
    3.237723e-001,
    -1.626737e+000,
    -3.741656e+000,
    8.444519e-001,
    -8.297013e-003,
    1.624861e+000,
    1.753817e+000,
    -6.242455e-001,
    -1.063850e+000,
    1.166897e+000,
    2.283807e+000,
    -1.150947e+000,
    -3.242997e-001,
    1.279340e-002,
    -5.448139e-001,
    -8.653106e-002,
    -8.143405e-001,
    -5.251732e-001,
    7.822692e-001,
    -3.764280e-003,
    -5.011112e+000,
    3.985065e-001,
    3.652394e-003,
    7.140115e-001,
    7.004910e-001,
    // albedo 1, turbidity 7
    -7.579673e+000,
    -3.495594e+000,
    -2.498830e+000,
    2.771470e+000,
    -3.451351e-002,
    8.186886e-002,
    1.272079e-004,
    1.390420e+000,
    5.545117e-001,
    -8.524117e+000,
    -3.121778e+000,
    1.680395e+000,
    -1.329455e+000,
    -1.395912e-001,
    1.911589e-001,
    -1.027988e-003,
    1.259267e+000,
    3.356989e-001,
    -4.579718e+000,
    -4.086739e+000,
    -8.030175e-001,
    1.103390e+000,
    1.429699e-001,
    -2.211841e-001,
    5.620349e-003,
    1.693702e+000,
    7.084432e-001,
    -1.946704e+000,
    -1.512415e+000,
    3.559506e-001,
    -1.318829e+000,
    -3.063409e+000,
    6.250046e-001,
    -1.490672e-002,
    1.414520e+000,
    1.317647e+000,
    -7.123367e-001,
    -1.133848e+000,
    1.064800e+000,
    2.217543e+000,
    -1.247373e+000,
    -2.105594e-001,
    2.261048e-002,
    -3.648618e-001,
    1.147223e-001,
    -7.979833e-001,
    -5.546030e-001,
    7.765850e-001,
    -4.676928e-003,
    -5.014372e+000,
    3.694816e-001,
    2.373221e-003,
    6.783145e-001,
    7.862971e-001,
    // albedo 1, turbidity 8
    -1.886599e+001,
    -4.523457e+000,
    -3.559445e+000,
    3.748747e+000,
    -2.082711e-002,
    1.120505e-001,
    4.908827e-005,
    1.430333e+000,
    4.999603e-001,
    -1.985552e+001,
    -3.530040e+000,
    1.578922e+000,
    -1.170838e+000,
    -6.347814e-002,
    2.032158e-003,
    -7.291357e-004,
    1.399338e+000,
    5.515394e-001,
    5.631541e-001,
    -5.483754e+000,
    -6.832337e-001,
    6.170499e-001,
    -2.824393e-001,
    3.546810e-001,
    6.248420e-003,
    1.638520e+000,
    2.300717e-001,
    -3.083195e+000,
    -3.071409e-001,
    2.822360e-001,
    -7.871125e-001,
    2.420642e-001,
    -1.716096e-001,
    -1.936307e-002,
    1.450902e+000,
    1.590291e+000,
    2.003824e-001,
    -8.374106e-001,
    8.800366e-001,
    1.702679e+000,
    -4.785357e+000,
    3.194078e-001,
    3.028099e-002,
    6.649245e-002,
    -4.459174e-003,
    -1.738851e+000,
    -1.144728e+000,
    6.950894e-001,
    1.073870e+000,
    -4.176611e+000,
    9.901497e-002,
    2.719362e-002,
    6.579628e-001,
    6.542088e-001,
    // albedo 1, turbidity 9
    -1.842858e+001,
    -4.464894e+000,
    -4.876181e+000,
    4.999894e+000,
    -1.680473e-002,
    9.284371e-002,
    8.631599e-005,
    1.551671e+000,
    8.637202e-001,
    -1.946220e+001,
    -2.928492e+000,
    1.932796e+000,
    -2.009963e+000,
    -2.067172e-002,
    2.760643e-001,
    -1.316034e-003,
    1.910005e+000,
    -2.057018e-002,
    1.012726e+000,
    -6.397245e+000,
    -8.570688e-001,
    9.466942e-001,
    -2.428074e-001,
    4.505376e-002,
    1.159119e-002,
    1.686356e+000,
    7.885028e-001,
    -3.502022e+000,
    -9.795202e-002,
    3.286657e-001,
    -8.318684e-001,
    1.254695e-001,
    9.600123e-002,
    -3.501772e-002,
    1.161309e+000,
    1.205342e+000,
    7.024550e-001,
    -6.903001e-001,
    7.519618e-001,
    1.501909e+000,
    -4.224528e+000,
    1.253867e-001,
    5.829515e-002,
    2.671626e-001,
    3.030079e-001,
    -2.056576e+000,
    -1.583471e+000,
    7.947031e-001,
    2.224097e+000,
    -4.127138e+000,
    1.885249e-001,
    1.729132e-005,
    3.336881e-001,
    5.332061e-001,
    // albedo 1, turbidity 10
    -1.825745e+001,
    -5.122861e+000,
    -5.876715e+000,
    5.970876e+000,
    -1.788919e-002,
    1.063934e-001,
    4.770037e-004,
    1.612403e+000,
    5.156506e-001,
    -1.981828e+001,
    -3.746331e+000,
    2.729783e+000,
    -2.477317e+000,
    -2.797536e-002,
    -5.281985e-002,
    -3.739083e-003,
    1.378246e+000,
    5.904024e-001,
    1.346751e+000,
    -6.486837e+000,
    -1.082622e+000,
    1.125524e+000,
    -2.228944e-001,
    3.975587e-001,
    2.035973e-002,
    1.884664e+000,
    1.086023e-003,
    -3.996320e+000,
    -4.646476e-001,
    3.008639e-002,
    -1.193861e+000,
    4.443960e-001,
    -2.593178e-001,
    -5.378377e-002,
    1.528777e+000,
    1.734923e+000,
    4.789259e-001,
    -8.952042e-001,
    8.595191e-001,
    2.353988e+000,
    -4.885398e+000,
    4.438339e-001,
    7.931163e-002,
    -8.144393e-002,
    1.663921e-002,
    -1.772626e+000,
    -1.783205e+000,
    7.322534e-001,
    1.529827e+000,
    -2.789303e+000,
    -1.817210e-001,
    2.737502e-002,
    2.620216e-001,
    6.227585e-001,
};

double datasetRad320[] =
{
    // albedo 0, turbidity 1
    9.282016e-004,
    3.169257e-004,
    5.255138e-003,
    -1.465200e-002,
    7.187172e-002,
    5.400860e-002,
    // albedo 0, turbidity 2
    9.160628e-004,
    2.599956e-004,
    5.466998e-003,
    -1.503537e-002,
    7.200167e-002,
    5.387713e-002,
    // albedo 0, turbidity 3
    9.148749e-004,
    2.164768e-004,
    5.576667e-003,
    -1.537254e-002,
    7.215609e-002,
    5.380753e-002,
    // albedo 0, turbidity 4
    9.090685e-004,
    1.467840e-004,
    5.775870e-003,
    -1.598491e-002,
    7.252530e-002,
    5.329870e-002,
    // albedo 0, turbidity 5
    8.902830e-004,
    1.126529e-004,
    5.945913e-003,
    -1.648173e-002,
    7.220217e-002,
    5.391054e-002,
    // albedo 0, turbidity 6
    8.885423e-004,
    1.142350e-004,
    5.938903e-003,
    -1.668800e-002,
    7.231405e-002,
    5.331532e-002,
    // albedo 0, turbidity 7
    8.674766e-004,
    3.506619e-005,
    6.176212e-003,
    -1.732036e-002,
    7.223472e-002,
    5.318228e-002,
    // albedo 0, turbidity 8
    8.525095e-004,
    -1.752028e-005,
    6.286417e-003,
    -1.779286e-002,
    7.150222e-002,
    5.334072e-002,
    // albedo 0, turbidity 9
    8.232652e-004,
    -1.292152e-004,
    6.645270e-003,
    -1.886566e-002,
    7.052974e-002,
    5.331726e-002,
    // albedo 0, turbidity 10
    7.670001e-004,
    -1.885989e-004,
    6.484739e-003,
    -1.852036e-002,
    6.610758e-002,
    5.484068e-002,
    // albedo 1, turbidity 1
    1.105405e-003,
    2.555979e-005,
    7.984713e-003,
    -2.152422e-002,
    8.452836e-002,
    9.622688e-002,
    // albedo 1, turbidity 2
    1.111427e-003,
    -6.046059e-005,
    8.035207e-003,
    -2.134768e-002,
    8.363698e-002,
    9.641842e-002,
    // albedo 1, turbidity 3
    1.103552e-003,
    -8.229160e-005,
    8.170699e-003,
    -2.189940e-002,
    8.404871e-002,
    9.504912e-002,
    // albedo 1, turbidity 4
    1.075129e-003,
    -1.473970e-004,
    8.391094e-003,
    -2.255482e-002,
    8.415497e-002,
    9.338994e-002,
    // albedo 1, turbidity 5
    1.036467e-003,
    -1.328992e-004,
    8.348236e-003,
    -2.256138e-002,
    8.304671e-002,
    9.263679e-002,
    // albedo 1, turbidity 6
    1.042383e-003,
    -2.016636e-004,
    8.479624e-003,
    -2.296524e-002,
    8.303746e-002,
    9.082494e-002,
    // albedo 1, turbidity 7
    1.014293e-003,
    -2.355927e-004,
    8.551010e-003,
    -2.333261e-002,
    8.258160e-002,
    8.873588e-002,
    // albedo 1, turbidity 8
    9.683336e-004,
    -2.120256e-004,
    8.172046e-003,
    -2.223973e-002,
    7.852279e-002,
    8.864017e-002,
    // albedo 1, turbidity 9
    9.139571e-004,
    -2.688667e-004,
    8.068793e-003,
    -2.224390e-002,
    7.590320e-002,
    8.464876e-002,
    // albedo 1, turbidity 10
    8.457855e-004,
    -3.459869e-004,
    7.626953e-003,
    -2.067614e-002,
    6.841363e-002,
    8.244103e-002,
};

double dataset360[] =
{
    // albedo 0, turbidity 1
    -2.974290e+000,
    -1.670904e+000,
    -5.183199e+000,
    5.377376e+000,
    -2.904124e-002,
    2.486720e-001,
    8.045624e-005,
    1.889212e+000,
    5.188203e-001,
    -2.638402e+000,
    -1.651876e+000,
    -1.229939e+000,
    1.776358e+000,
    -6.372414e-002,
    3.767834e-001,
    -6.475530e-004,
    1.373589e+000,
    4.349252e-001,
    -2.449142e+000,
    -1.541788e+000,
    4.629358e-001,
    -1.149742e+000,
    -7.317185e-002,
    -2.422158e-001,
    3.667113e-003,
    3.146429e+000,
    6.725657e-001,
    -8.559357e-001,
    -5.054959e-001,
    4.334205e-001,
    4.254155e-001,
    -2.920605e-001,
    9.303230e-001,
    -1.212609e-002,
    4.498482e-001,
    2.117838e-001,
    -1.098145e+000,
    -5.123514e-001,
    7.773196e-001,
    -1.325175e-001,
    4.648396e-001,
    1.386648e-001,
    2.427679e-002,
    1.199386e+000,
    7.988611e-001,
    -1.124849e+000,
    -5.693597e-001,
    7.315125e-001,
    2.986435e-002,
    -4.536788e+000,
    6.650081e-001,
    -9.004215e-007,
    1.006380e+000,
    4.999682e-001,
    // albedo 0, turbidity 2
    -2.709497e+000,
    -1.635812e+000,
    -4.594177e+000,
    4.809336e+000,
    -3.672907e-002,
    2.383111e-001,
    3.241989e-005,
    1.885505e+000,
    6.619619e-001,
    -2.590279e+000,
    -1.525236e+000,
    -6.846073e-001,
    1.216080e+000,
    -8.022814e-002,
    3.040074e-001,
    -4.984576e-004,
    1.521429e+000,
    1.746040e-001,
    -2.988403e+000,
    -1.938687e+000,
    4.954649e-002,
    -8.992325e-001,
    -7.157111e-002,
    -4.370068e-002,
    4.336645e-003,
    2.849496e+000,
    8.892788e-001,
    -2.932084e-001,
    -1.323910e-001,
    5.535910e-001,
    7.456284e-001,
    -2.713400e-001,
    6.989175e-001,
    -1.513162e-002,
    6.926848e-001,
    5.719944e-001,
    -1.379400e+000,
    -6.876864e-001,
    7.224534e-001,
    -6.172704e-001,
    1.217500e-001,
    3.074795e-001,
    2.905167e-002,
    1.123563e+000,
    6.837510e-001,
    -1.042446e+000,
    -5.201193e-001,
    7.107656e-001,
    4.182566e-001,
    -4.956238e+000,
    5.315425e-001,
    6.232999e-003,
    1.059015e+000,
    5.116427e-001,
    // albedo 0, turbidity 3
    -2.686687e+000,
    -1.615137e+000,
    -3.811956e+000,
    4.018597e+000,
    -3.953418e-002,
    2.171778e-001,
    -7.374887e-006,
    1.875745e+000,
    8.996180e-001,
    -3.049670e+000,
    -1.775802e+000,
    2.577719e-002,
    5.331200e-001,
    -9.424429e-002,
    3.852753e-001,
    -8.678326e-005,
    1.347053e+000,
    -1.078327e-001,
    -2.414334e+000,
    -1.637863e+000,
    -3.948523e-001,
    -4.867989e-001,
    -1.545516e-001,
    -2.045592e-001,
    2.308206e-003,
    3.257409e+000,
    1.029606e+000,
    -6.821703e-001,
    -3.665215e-001,
    7.496076e-001,
    5.391760e-001,
    -2.903450e-001,
    8.498544e-001,
    -1.388990e-002,
    2.126622e-001,
    6.857005e-001,
    -1.227285e+000,
    -5.958479e-001,
    5.828611e-001,
    -4.050489e-001,
    -2.935835e-001,
    1.410603e-001,
    4.352812e-002,
    1.406076e+000,
    4.955059e-001,
    -1.080553e+000,
    -5.308084e-001,
    6.980027e-001,
    2.193524e-001,
    -5.007206e+000,
    5.895807e-001,
    1.122391e-002,
    1.052433e+000,
    6.643198e-001,
    // albedo 0, turbidity 4
    -2.983088e+000,
    -1.746025e+000,
    -4.564198e+000,
    4.776145e+000,
    -3.208607e-002,
    2.008358e-001,
    -6.578048e-006,
    1.829880e+000,
    9.001069e-001,
    -2.858023e+000,
    -1.624623e+000,
    1.859497e+000,
    -1.348577e+000,
    -7.427284e-002,
    2.943068e-001,
    -1.961205e-004,
    1.502334e+000,
    -3.183648e-001,
    -2.858102e+000,
    -2.072804e+000,
    -1.205584e+000,
    5.674135e-001,
    -3.934144e-001,
    -3.736288e-002,
    4.780332e-003,
    2.831298e+000,
    1.553942e+000,
    -3.305766e-001,
    -8.277591e-003,
    8.561917e-001,
    -2.239172e-001,
    5.896697e-001,
    6.229823e-001,
    -2.242577e-002,
    7.216263e-001,
    4.295956e-001,
    -1.322728e+000,
    -7.101315e-001,
    5.645563e-001,
    9.897384e-001,
    -6.756374e+000,
    2.491515e-001,
    5.308124e-002,
    1.166258e+000,
    5.472501e-001,
    -1.117086e+000,
    -5.760006e-001,
    6.388217e-001,
    1.659290e-001,
    -4.687099e+000,
    4.544540e-001,
    2.672063e-002,
    1.067777e+000,
    6.419825e-001,
    // albedo 0, turbidity 5
    -2.943340e+000,
    -1.779161e+000,
    -3.715839e+000,
    3.949049e+000,
    -4.499824e-002,
    2.234466e-001,
    -8.091518e-006,
    1.825217e+000,
    9.000118e-001,
    -3.717358e+000,
    -1.850324e+000,
    2.277659e+000,
    -2.027790e+000,
    -1.240730e-001,
    3.029522e-001,
    -2.176255e-004,
    1.585933e+000,
    -2.794001e-001,
    -2.439542e+000,
    -2.277701e+000,
    -1.702329e+000,
    2.025885e+000,
    -1.142291e-001,
    -2.011641e-001,
    5.563891e-003,
    2.424957e+000,
    1.399542e+000,
    -1.562453e-001,
    5.099893e-001,
    1.026847e+000,
    -2.516874e+000,
    -2.212969e+000,
    9.252660e-001,
    -2.696795e-002,
    1.443711e+000,
    7.450372e-001,
    -1.579698e+000,
    -1.110703e+000,
    4.743061e-001,
    4.160187e+000,
    -4.597085e+000,
    -2.112156e-001,
    6.791770e-002,
    6.131169e-001,
    2.291635e-001,
    -9.959610e-001,
    -4.119588e-001,
    5.707529e-001,
    -3.505536e-003,
    -4.253949e+000,
    7.498003e-001,
    8.246945e-003,
    1.397857e+000,
    8.021253e-001,
    // albedo 0, turbidity 6
    -2.304734e+000,
    -1.483605e+000,
    -1.531059e+000,
    1.707306e+000,
    -1.150367e-001,
    2.153063e-001,
    -3.351533e-006,
    2.021261e+000,
    5.742842e-001,
    -3.130477e+000,
    -1.966839e+000,
    6.058600e-001,
    -9.209976e-001,
    -1.932901e-001,
    3.242645e-001,
    3.361262e-002,
    1.529938e+000,
    2.851152e-001,
    -1.110129e+000,
    -1.306323e+000,
    -3.235833e-001,
    2.998748e+000,
    -1.535927e-002,
    -4.001906e-001,
    -9.430492e-002,
    2.211086e+000,
    8.632200e-001,
    -1.174540e+000,
    7.550161e-002,
    -1.849588e-001,
    -6.281432e+000,
    -6.186665e+000,
    1.173048e+000,
    1.481656e-001,
    2.668578e+000,
    6.145923e-001,
    -1.104583e+000,
    -8.430389e-001,
    8.668416e-001,
    9.153752e+000,
    -7.289540e-001,
    -4.346537e-001,
    -9.065784e-002,
    2.866983e-001,
    6.920973e-001,
    -1.105893e+000,
    -4.500399e-001,
    4.286451e-001,
    1.207864e+000,
    -5.018291e+000,
    6.988292e-001,
    3.891745e-002,
    1.602324e+000,
    6.269169e-001,
    // albedo 0, turbidity 7
    -3.709341e+000,
    -2.038242e+000,
    -3.127214e+000,
    3.287030e+000,
    -4.565671e-002,
    2.427627e-001,
    -7.503980e-006,
    1.817881e+000,
    9.000389e-001,
    -3.393374e+000,
    -1.710497e+000,
    1.661275e+000,
    -1.388896e+000,
    -1.012293e-001,
    1.676172e-001,
    -5.719846e-004,
    1.694199e+000,
    -3.140071e-001,
    -2.812820e+000,
    -2.678401e+000,
    -1.170428e+000,
    1.560988e+000,
    -4.488218e-001,
    1.088693e-001,
    1.391966e-002,
    2.144426e+000,
    1.525731e+000,
    2.547360e-001,
    8.840167e-001,
    5.469168e-001,
    -2.615530e+000,
    -1.048663e+000,
    4.823171e-001,
    -5.958515e-002,
    1.842479e+000,
    5.322138e-001,
    -1.612173e+000,
    -1.055541e+000,
    4.733463e-001,
    5.083504e+000,
    -5.558403e+000,
    8.029584e-002,
    1.294180e-001,
    7.807964e-001,
    3.949822e-001,
    -1.098367e+000,
    -5.550631e-001,
    4.221569e-001,
    -1.661587e-003,
    -4.970027e+000,
    3.479325e-001,
    4.503648e-002,
    1.369224e+000,
    6.753984e-001,
    // albedo 0, turbidity 8
    -4.292777e+000,
    -2.231300e+000,
    -4.359252e+000,
    4.562131e+000,
    -3.759725e-002,
    2.170783e-001,
    -6.945269e-006,
    1.791630e+000,
    8.996451e-001,
    -4.016595e+000,
    -1.761175e+000,
    2.616213e+000,
    -2.658657e+000,
    -8.209207e-002,
    2.736152e-001,
    -6.864170e-004,
    1.820262e+000,
    -2.712707e-001,
    -2.942646e+000,
    -3.350329e+000,
    -1.645817e+000,
    2.957424e+000,
    -1.073783e-001,
    -1.920050e-001,
    1.665992e-002,
    1.723144e+000,
    1.394962e+000,
    9.793627e-001,
    1.743715e+000,
    5.396545e-001,
    -4.618273e+000,
    -2.186669e+000,
    1.012973e+000,
    -7.213786e-002,
    2.388103e+000,
    6.712519e-001,
    -2.085434e+000,
    -1.445755e+000,
    3.384806e-001,
    7.702938e+000,
    -3.897179e+000,
    -5.947697e-001,
    1.614194e-001,
    7.854754e-001,
    3.291034e-001,
    -9.660466e-001,
    -5.247410e-001,
    4.199048e-001,
    -3.304707e-003,
    -5.014144e+000,
    6.733599e-001,
    2.345161e-002,
    1.225739e+000,
    7.256834e-001,
    // albedo 0, turbidity 9
    -3.950771e+000,
    -2.192673e+000,
    -7.263653e+000,
    7.343312e+000,
    -1.840332e-002,
    1.893809e-001,
    -3.583629e-006,
    1.901172e+000,
    5.902387e-001,
    -6.384690e+000,
    -2.515788e+000,
    3.874778e+000,
    -3.776079e+000,
    -3.484710e-002,
    3.311078e-001,
    8.248395e-003,
    1.612712e+000,
    3.123684e-001,
    -6.207616e-001,
    -2.681061e+000,
    -2.005212e+000,
    2.445498e+000,
    -1.935675e-001,
    -1.988856e-001,
    -1.553754e-002,
    2.210740e+000,
    6.507040e-001,
    -1.241493e+000,
    5.908170e-001,
    3.899777e-001,
    -2.344038e+000,
    -1.820327e-001,
    7.889592e-001,
    -1.468064e-002,
    1.586758e+000,
    1.007885e+000,
    -4.395130e-001,
    -3.700611e-001,
    2.452754e-001,
    3.602006e+000,
    -4.692896e+000,
    -8.620746e-002,
    1.418548e-001,
    1.521301e+000,
    3.989756e-001,
    -1.794977e+000,
    -1.190586e+000,
    3.928989e-001,
    1.946953e+000,
    -1.874118e+000,
    -3.292602e-002,
    2.983309e-002,
    6.737092e-001,
    7.322706e-001,
    // albedo 0, turbidity 10
    -8.896186e+000,
    -3.278330e+000,
    -7.998349e+000,
    8.023312e+000,
    -1.357555e-002,
    1.947910e-001,
    -5.390226e-006,
    1.798414e+000,
    7.881395e-001,
    -8.040403e+000,
    -2.528514e+000,
    3.774303e+000,
    -3.590457e+000,
    -3.551313e-002,
    3.650761e-001,
    -4.401382e-004,
    1.701545e+000,
    -6.992899e-003,
    -4.150010e-001,
    -3.539507e+000,
    -1.527733e+000,
    1.415242e+000,
    -1.831476e-001,
    -3.009746e-001,
    1.211955e-002,
    2.365976e+000,
    9.928240e-001,
    -2.090923e+000,
    1.673638e-001,
    -2.183495e-001,
    -8.374584e-001,
    2.774184e-002,
    7.912769e-001,
    -6.650609e-002,
    1.154446e+000,
    7.863979e-001,
    5.115239e-001,
    2.415831e-001,
    4.022318e-001,
    2.292950e+000,
    -4.061496e+000,
    7.453182e-002,
    1.902451e-001,
    1.587339e+000,
    5.207620e-001,
    -2.334879e+000,
    -1.642495e+000,
    2.384458e-001,
    3.068363e+000,
    -1.699588e+000,
    -3.936924e-001,
    3.028660e-002,
    4.715374e-001,
    7.091893e-001,
    // albedo 1, turbidity 1
    -2.375941e+000,
    -1.508643e+000,
    -5.070151e+000,
    5.509378e+000,
    -2.915769e-002,
    2.122471e-001,
    8.584007e-005,
    1.517285e+000,
    5.163253e-001,
    -2.605398e+000,
    -1.589160e+000,
    -1.137560e+000,
    1.827729e+000,
    -4.939637e-002,
    3.243952e-001,
    -6.464612e-004,
    1.008816e+000,
    4.568463e-001,
    -2.176260e+000,
    -1.601522e+000,
    7.060324e-001,
    -1.060717e+000,
    -5.144614e-002,
    -1.938031e-001,
    3.449257e-003,
    2.641594e+000,
    5.976852e-001,
    -7.365744e-001,
    -3.720296e-001,
    7.315328e-001,
    3.156067e-001,
    -2.739385e-001,
    8.252942e-001,
    -1.055013e-002,
    7.327610e-002,
    3.218251e-001,
    -1.017537e+000,
    -4.631811e-001,
    1.093174e+000,
    -7.215941e-002,
    5.408457e-001,
    -1.848322e-002,
    1.942990e-002,
    6.882763e-001,
    7.268524e-001,
    -1.025215e+000,
    -3.712574e-001,
    9.661278e-001,
    7.791398e-003,
    -4.508617e+000,
    4.371074e-001,
    -1.241898e-006,
    1.152655e+000,
    5.008240e-001,
    // albedo 1, turbidity 2
    -2.621793e+000,
    -1.611544e+000,
    -4.494730e+000,
    4.902741e+000,
    -2.935751e-002,
    1.930048e-001,
    1.821579e-005,
    1.522018e+000,
    6.563013e-001,
    -2.473330e+000,
    -1.495083e+000,
    -5.536781e-001,
    1.305457e+000,
    -7.261347e-002,
    2.967738e-001,
    -2.858526e-004,
    1.132650e+000,
    1.737068e-001,
    -2.843519e+000,
    -1.913751e+000,
    2.006296e-001,
    -8.580922e-001,
    -5.273753e-002,
    -7.800250e-002,
    2.395781e-003,
    2.505017e+000,
    9.023934e-001,
    -1.805184e-001,
    -3.670063e-002,
    7.583717e-001,
    7.594739e-001,
    -2.092951e-001,
    6.278666e-001,
    -8.086828e-003,
    4.136002e-001,
    6.026937e-001,
    -1.274753e+000,
    -5.831501e-001,
    9.711756e-001,
    -6.209175e-001,
    1.488633e-001,
    2.117108e-001,
    1.531499e-002,
    9.306008e-001,
    7.201852e-001,
    -9.224434e-001,
    -3.344822e-001,
    9.964647e-001,
    3.991735e-001,
    -4.951439e+000,
    4.332347e-001,
    -1.082832e-005,
    9.570977e-001,
    5.221054e-001,
    // albedo 1, turbidity 3
    -2.648100e+000,
    -1.587720e+000,
    -3.738681e+000,
    4.084015e+000,
    -3.301163e-002,
    1.736140e-001,
    -5.598265e-006,
    1.628176e+000,
    8.967917e-001,
    -3.004556e+000,
    -1.702983e+000,
    1.060112e-001,
    5.816666e-001,
    -8.140777e-002,
    3.584557e-001,
    -7.793874e-005,
    1.090228e+000,
    -1.079451e-001,
    -2.337937e+000,
    -1.584523e+000,
    -2.912486e-001,
    -4.467895e-001,
    -9.195281e-002,
    -2.355753e-001,
    1.887118e-003,
    3.053238e+000,
    1.043382e+000,
    -5.985994e-001,
    -2.846782e-001,
    8.903642e-001,
    5.578845e-001,
    -2.510042e-001,
    8.033778e-001,
    -9.920460e-003,
    7.388584e-002,
    7.097127e-001,
    -1.155357e+000,
    -4.638306e-001,
    8.041892e-001,
    -4.051351e-001,
    -2.819435e-001,
    8.505708e-002,
    2.749222e-002,
    1.334820e+000,
    5.216620e-001,
    -1.010658e+000,
    -3.816787e-001,
    9.644918e-001,
    2.144477e-001,
    -5.005667e+000,
    5.475125e-001,
    3.758162e-005,
    1.033427e+000,
    6.866266e-001,
    // albedo 1, turbidity 4
    -2.686681e+000,
    -1.694114e+000,
    -4.346908e+000,
    4.745876e+000,
    -2.879846e-002,
    2.237339e-001,
    -6.438656e-006,
    1.456353e+000,
    9.000340e-001,
    -2.684912e+000,
    -1.616888e+000,
    2.447798e+000,
    -1.626883e+000,
    -7.346183e-002,
    2.641722e-001,
    -1.001518e-004,
    1.045501e+000,
    -2.314856e-001,
    -2.587652e+000,
    -1.999748e+000,
    -1.325810e+000,
    7.561102e-001,
    -4.182131e-001,
    -4.285017e-002,
    2.719759e-003,
    2.420598e+000,
    1.281981e+000,
    -2.679506e-001,
    5.139740e-002,
    1.276587e+000,
    -2.286956e-001,
    7.388924e-001,
    5.606395e-001,
    -1.472508e-002,
    5.105614e-001,
    7.670396e-001,
    -1.267160e+000,
    -7.441021e-001,
    9.154665e-001,
    8.190436e-001,
    -6.805266e+000,
    1.013064e-001,
    4.140297e-002,
    3.378301e-001,
    3.128860e-001,
    -9.570978e-001,
    -3.478847e-001,
    9.709923e-001,
    -3.444499e-003,
    -4.677921e+000,
    3.551546e-001,
    6.241534e-003,
    1.052060e+000,
    7.543152e-001,
    // albedo 1, turbidity 5
    -3.093830e+000,
    -1.859478e+000,
    -4.003711e+000,
    4.391665e+000,
    -3.051581e-002,
    2.180265e-001,
    -7.401285e-006,
    1.448366e+000,
    9.000549e-001,
    -3.121106e+000,
    -1.664385e+000,
    2.868256e+000,
    -2.280292e+000,
    -8.456847e-002,
    2.227469e-001,
    -1.681252e-004,
    1.176332e+000,
    -2.605895e-001,
    -2.166025e+000,
    -2.172663e+000,
    -1.705862e+000,
    1.960864e+000,
    -2.185020e-001,
    1.891067e-002,
    4.423413e-003,
    2.071931e+000,
    1.297661e+000,
    -5.263078e-001,
    2.296403e-001,
    1.342025e+000,
    -2.034590e+000,
    -1.024013e+000,
    4.873264e-001,
    -1.982506e-002,
    9.818474e-001,
    1.040041e+000,
    -1.138361e+000,
    -8.186096e-001,
    8.845700e-001,
    3.291911e+000,
    -5.915866e+000,
    1.125846e-001,
    4.477952e-002,
    9.195132e-002,
    -1.138939e-002,
    -1.013651e+000,
    -3.811416e-001,
    9.420266e-001,
    -3.599378e-003,
    -4.895655e+000,
    2.864445e-001,
    1.940262e-002,
    1.026648e+000,
    7.421204e-001,
    // albedo 1, turbidity 6
    -2.379373e+000,
    -1.540348e+000,
    -1.318467e+000,
    1.724703e+000,
    -1.017147e-001,
    1.811106e-001,
    -3.047951e-006,
    1.598808e+000,
    5.796580e-001,
    -3.200327e+000,
    -2.016985e+000,
    9.935187e-001,
    -9.970906e-001,
    -2.159523e-001,
    3.183812e-001,
    1.575987e-002,
    1.180131e+000,
    2.839510e-001,
    -1.107956e+000,
    -1.330969e+000,
    -1.627216e-001,
    2.985435e+000,
    -2.198633e-002,
    -4.401148e-001,
    -5.433064e-002,
    1.701087e+000,
    8.289746e-001,
    -9.423359e-001,
    4.619106e-002,
    3.116348e-002,
    -6.353122e+000,
    -6.192769e+000,
    1.175886e+000,
    1.020452e-001,
    2.180417e+000,
    7.076018e-001,
    -1.037343e+000,
    -5.711080e-001,
    1.282899e+000,
    8.808032e+000,
    -8.741903e-001,
    -6.097972e-001,
    -5.996612e-002,
    1.533313e-001,
    5.842877e-001,
    -1.002208e+000,
    -3.271512e-001,
    7.288675e-001,
    7.950560e-001,
    -5.029931e+000,
    4.493639e-001,
    2.389923e-002,
    1.568465e+000,
    5.653910e-001,
    // albedo 1, turbidity 7
    -3.584221e+000,
    -2.140498e+000,
    -5.324613e+000,
    5.753381e+000,
    -2.662581e-002,
    2.099272e-001,
    -6.879519e-006,
    1.362229e+000,
    9.000467e-001,
    -3.579609e+000,
    -1.804420e+000,
    3.448490e+000,
    -2.929179e+000,
    -6.009529e-002,
    2.821561e-001,
    -6.203809e-004,
    1.312035e+000,
    -3.013934e-001,
    -2.053811e+000,
    -2.420850e+000,
    -1.795999e+000,
    1.835004e+000,
    -3.451800e-001,
    -1.042135e-001,
    1.511574e-002,
    1.751304e+000,
    1.491704e+000,
    -2.602659e-001,
    5.963320e-001,
    1.059632e+000,
    -1.214076e+000,
    6.424455e-001,
    6.890202e-001,
    -6.544341e-002,
    1.457883e+000,
    5.321707e-001,
    -1.266632e+000,
    -8.504227e-001,
    8.680693e-001,
    1.899473e+000,
    -8.680238e+000,
    -1.798563e-001,
    1.477665e-001,
    2.430031e-001,
    4.229871e-001,
    -1.021321e+000,
    -5.129049e-001,
    9.006232e-001,
    1.534018e+000,
    -3.672948e+000,
    2.301115e-001,
    5.151145e-003,
    7.460819e-001,
    5.418252e-001,
    // albedo 1, turbidity 8
    -4.095186e+000,
    -2.274183e+000,
    -4.115160e+000,
    4.514741e+000,
    -3.131440e-002,
    1.475658e-001,
    -5.329133e-006,
    1.411833e+000,
    8.893477e-001,
    -3.691554e+000,
    -1.654418e+000,
    3.158573e+000,
    -2.961366e+000,
    -7.834161e-002,
    3.035141e-001,
    -4.241191e-004,
    1.485200e+000,
    -1.689443e-001,
    -2.697067e+000,
    -3.473351e+000,
    -1.707297e+000,
    3.138823e+000,
    -8.323430e-002,
    -1.605972e-001,
    1.025052e-002,
    1.132282e+000,
    1.093318e+000,
    7.049827e-001,
    1.769870e+000,
    8.659868e-001,
    -4.445404e+000,
    -2.256134e+000,
    7.768538e-001,
    -4.741793e-002,
    2.212406e+000,
    1.109562e+000,
    -1.771411e+000,
    -1.358270e+000,
    7.604506e-001,
    7.191590e+000,
    -4.358366e+000,
    -3.375251e-001,
    1.136852e-001,
    1.844576e-001,
    -1.208189e-003,
    -9.623648e-001,
    -5.518470e-001,
    9.623684e-001,
    -5.697517e-003,
    -5.015884e+000,
    2.811964e-001,
    2.100168e-002,
    4.434131e-001,
    7.212648e-001,
    // albedo 1, turbidity 9
    -5.131552e+000,
    -2.558716e+000,
    -8.066753e+000,
    8.403192e+000,
    -1.450692e-002,
    1.494495e-001,
    -2.898774e-006,
    1.427512e+000,
    5.020826e-001,
    -6.192910e+000,
    -2.261479e+000,
    5.059205e+000,
    -4.892079e+000,
    -2.703716e-002,
    3.381259e-001,
    2.231257e-002,
    1.490697e+000,
    5.441761e-001,
    -6.741018e-001,
    -3.356237e+000,
    -2.207329e+000,
    3.300094e+000,
    -1.801120e-001,
    -2.560242e-001,
    -6.216731e-002,
    1.180699e+000,
    2.241782e-001,
    -8.312435e-001,
    1.325391e+000,
    5.324159e-001,
    -2.912438e+000,
    -8.384977e-002,
    7.600872e-001,
    7.749519e-002,
    2.129188e+000,
    1.328287e+000,
    -7.455272e-001,
    -8.504579e-001,
    9.021474e-001,
    3.426594e+000,
    -4.607412e+000,
    -1.706127e-001,
    4.792024e-002,
    2.354077e-001,
    2.718195e-001,
    -1.448374e+000,
    -9.739004e-001,
    8.801628e-001,
    1.705262e+000,
    -2.420298e+000,
    -1.077392e-002,
    2.691713e-002,
    1.854876e-001,
    7.097466e-001,
    // albedo 1, turbidity 10
    -8.672396e+000,
    -3.339107e+000,
    -7.666257e+000,
    7.916291e+000,
    -1.396976e-002,
    1.676538e-001,
    -5.816416e-006,
    1.448247e+000,
    8.178892e-001,
    -7.852799e+000,
    -2.606120e+000,
    4.231840e+000,
    -3.774406e+000,
    -3.540722e-002,
    2.178494e-001,
    6.198617e-005,
    1.295236e+000,
    1.130678e-001,
    -1.374103e-001,
    -3.570476e+000,
    -1.588768e+000,
    1.538806e+000,
    -1.923629e-001,
    -1.793545e-002,
    3.373950e-003,
    2.008581e+000,
    6.041668e-001,
    -2.211224e+000,
    1.190704e-001,
    6.700025e-002,
    -8.972445e-001,
    2.133056e-001,
    4.471730e-001,
    -3.148150e-002,
    9.759721e-001,
    1.166537e+000,
    5.932825e-001,
    2.482606e-001,
    9.239617e-001,
    2.382787e+000,
    -4.611846e+000,
    1.608983e-001,
    1.385590e-001,
    7.641781e-001,
    3.076032e-001,
    -2.098394e+000,
    -1.561705e+000,
    7.602298e-001,
    1.783879e+000,
    -1.486238e+000,
    -4.025919e-001,
    2.965074e-002,
    -8.717180e-002,
    7.279518e-001,
};

double datasetRad360[] =
{
    // albedo 0, turbidity 1
    2.494129e-003,
    3.556297e-003,
    2.965923e-004,
    2.713084e-003,
    1.335823e-001,
    8.293879e-002,
    // albedo 0, turbidity 2
    2.473622e-003,
    3.518055e-003,
    4.432438e-004,
    1.754027e-003,
    1.352516e-001,
    8.253805e-002,
    // albedo 0, turbidity 3
    2.485307e-003,
    3.507686e-003,
    4.235269e-004,
    1.120748e-003,
    1.360769e-001,
    8.328522e-002,
    // albedo 0, turbidity 4
    2.421491e-003,
    3.278595e-003,
    1.395344e-003,
    -1.953245e-003,
    1.392978e-001,
    8.376885e-002,
    // albedo 0, turbidity 5
    2.403587e-003,
    3.114517e-003,
    2.224702e-003,
    -5.305220e-003,
    1.435766e-001,
    8.315234e-002,
    // albedo 0, turbidity 6
    2.351950e-003,
    2.915308e-003,
    3.179213e-003,
    -8.297787e-003,
    1.471589e-001,
    8.200387e-002,
    // albedo 0, turbidity 7
    2.347797e-003,
    2.761449e-003,
    3.671854e-003,
    -1.012039e-002,
    1.480091e-001,
    8.399335e-002,
    // albedo 0, turbidity 8
    2.296250e-003,
    2.420416e-003,
    5.106803e-003,
    -1.515460e-002,
    1.526421e-001,
    8.454641e-002,
    // albedo 0, turbidity 9
    2.193368e-003,
    1.826966e-003,
    7.606333e-003,
    -2.312584e-002,
    1.588488e-001,
    8.547295e-002,
    // albedo 0, turbidity 10
    2.037533e-003,
    9.415569e-004,
    1.104382e-002,
    -3.348390e-002,
    1.637893e-001,
    8.792408e-002,
    // albedo 1, turbidity 1
    3.061048e-003,
    2.126839e-003,
    1.132767e-002,
    -2.788848e-002,
    1.948610e-001,
    1.618476e-001,
    // albedo 1, turbidity 2
    3.047180e-003,
    2.153513e-003,
    1.116935e-002,
    -2.810228e-002,
    1.949994e-001,
    1.614103e-001,
    // albedo 1, turbidity 3
    3.038920e-003,
    2.051613e-003,
    1.130934e-002,
    -2.861029e-002,
    1.941964e-001,
    1.617911e-001,
    // albedo 1, turbidity 4
    2.963024e-003,
    1.869150e-003,
    1.189063e-002,
    -3.088695e-002,
    1.962576e-001,
    1.593205e-001,
    // albedo 1, turbidity 5
    2.918936e-003,
    1.726267e-003,
    1.250792e-002,
    -3.337994e-002,
    1.973927e-001,
    1.577752e-001,
    // albedo 1, turbidity 6
    2.855489e-003,
    1.647214e-003,
    1.256484e-002,
    -3.387525e-002,
    1.965371e-001,
    1.571482e-001,
    // albedo 1, turbidity 7
    2.825443e-003,
    1.406555e-003,
    1.336433e-002,
    -3.675617e-002,
    1.982073e-001,
    1.535780e-001,
    // albedo 1, turbidity 8
    2.678428e-003,
    1.109106e-003,
    1.431453e-002,
    -4.011878e-002,
    1.979278e-001,
    1.510186e-001,
    // albedo 1, turbidity 9
    2.555750e-003,
    6.244779e-004,
    1.562522e-002,
    -4.466841e-002,
    1.968517e-001,
    1.462399e-001,
    // albedo 1, turbidity 10
    2.323920e-003,
    1.300657e-004,
    1.663828e-002,
    -4.826021e-002,
    1.889056e-001,
    1.427310e-001,
};

double dataset400[] =
{
    // albedo 0, turbidity 1
    -1.869600e+000,
    -9.575785e-001,
    -6.993871e+000,
    7.306207e+000,
    -3.240320e-002,
    3.834949e-001,
    4.369976e-005,
    2.254773e+000,
    5.025988e-001,
    -1.746138e+000,
    -1.001117e+000,
    -1.758295e+000,
    2.492931e+000,
    -6.202861e-002,
    4.442043e-001,
    -3.779550e-004,
    1.411622e+000,
    4.890101e-001,
    -1.536453e+000,
    -5.330479e-001,
    1.126830e+000,
    -2.452367e+000,
    -6.694842e-002,
    -2.983825e-002,
    2.320196e-003,
    5.488905e+000,
    5.403856e-001,
    -1.069780e+000,
    -5.815078e-001,
    8.612956e-001,
    1.301347e+000,
    -4.089489e-001,
    1.269432e+000,
    -9.018004e-003,
    -2.283572e+000,
    3.760374e-001,
    -1.060384e+000,
    -2.207518e-001,
    6.362691e-001,
    -5.757237e-001,
    4.275177e-001,
    8.443714e-002,
    2.082596e-002,
    3.125040e+000,
    7.891611e-001,
    -1.077246e+000,
    -2.993040e-001,
    8.167430e-001,
    2.203982e-001,
    -3.984213e+000,
    1.123699e+000,
    1.313138e-002,
    1.750491e+000,
    4.999653e-001,
    // albedo 0, turbidity 2
    -1.752499e+000,
    -9.053927e-001,
    -1.080943e+001,
    1.110516e+001,
    -2.092090e-002,
    3.348109e-001,
    -8.432141e-006,
    2.326824e+000,
    9.000500e-001,
    -1.888565e+000,
    -1.067725e+000,
    1.491851e+000,
    -7.934014e-001,
    -4.853718e-002,
    5.346693e-001,
    9.170370e-005,
    1.397595e+000,
    -3.635730e-001,
    -1.471013e+000,
    -5.497976e-001,
    -4.310423e-001,
    -8.787275e-001,
    -9.206447e-002,
    -1.490862e-001,
    -4.078054e-005,
    5.442983e+000,
    1.757010e+000,
    -1.061905e+000,
    -5.429222e-001,
    1.412232e+000,
    8.460977e-001,
    -2.973654e-001,
    1.357299e+000,
    -5.347332e-003,
    -2.444304e+000,
    -3.363016e-002,
    -1.071200e+000,
    -2.263246e-001,
    3.639469e-001,
    -6.109244e-001,
    -2.484665e-001,
    -7.097027e-002,
    4.735641e-002,
    3.445733e+000,
    8.486491e-001,
    -1.081645e+000,
    -3.128264e-001,
    8.436471e-001,
    3.884148e-001,
    -5.004662e+000,
    1.137000e+000,
    1.500838e-002,
    1.585647e+000,
    5.832608e-001,
    // albedo 0, turbidity 3
    -1.774187e+000,
    -9.327599e-001,
    -9.130103e+000,
    9.413272e+000,
    -2.448089e-002,
    3.487996e-001,
    -3.033497e-006,
    2.291071e+000,
    6.408360e-001,
    -1.849342e+000,
    -1.038735e+000,
    2.863013e+000,
    -2.260302e+000,
    -5.040252e-002,
    4.583723e-001,
    1.008690e-002,
    1.502617e+000,
    7.223351e-002,
    -1.624679e+000,
    -7.257060e-001,
    -1.493033e+000,
    5.658415e-001,
    -2.079847e-001,
    -4.651180e-002,
    -3.701743e-002,
    4.858534e+000,
    1.342775e+000,
    -8.692395e-001,
    -3.025565e-001,
    1.630221e+000,
    -4.624355e-002,
    8.408669e-002,
    1.091981e+000,
    6.506253e-002,
    -1.403006e+000,
    2.076066e-001,
    -1.169258e+000,
    -3.711802e-001,
    3.440155e-001,
    -1.044556e-001,
    -3.304858e+000,
    1.185883e-001,
    1.489352e-002,
    2.642598e+000,
    8.151882e-001,
    -1.058391e+000,
    -2.657785e-001,
    6.984363e-001,
    9.737578e-002,
    -1.903943e+000,
    8.963329e-001,
    6.480860e-002,
    2.034024e+000,
    5.870424e-001,
    // albedo 0, turbidity 4
    -1.898858e+000,
    -1.031814e+000,
    -9.726056e+000,
    1.000989e+001,
    -2.125268e-002,
    3.569897e-001,
    -2.706653e-006,
    2.147646e+000,
    5.982401e-001,
    -2.136007e+000,
    -1.206456e+000,
    3.801172e+000,
    -3.254852e+000,
    -4.516490e-002,
    4.001123e-001,
    2.151890e-002,
    1.481457e+000,
    1.444904e-001,
    -1.355343e+000,
    -6.736369e-001,
    -2.052620e+000,
    1.298239e+000,
    -1.986869e-001,
    6.321488e-002,
    -6.792635e-002,
    4.482593e+000,
    1.322565e+000,
    -9.063816e-001,
    -1.873797e-001,
    1.559544e+000,
    -2.631298e-001,
    5.988684e-002,
    9.375378e-001,
    9.681349e-002,
    -6.480890e-001,
    2.362949e-001,
    -1.170470e+000,
    -3.968082e-001,
    2.266604e-001,
    -2.018118e-001,
    -3.768512e+000,
    9.706445e-002,
    6.046660e-002,
    2.723200e+000,
    7.968878e-001,
    -1.085813e+000,
    -3.519543e-001,
    7.537557e-001,
    3.003522e-001,
    -1.811803e+000,
    7.945754e-001,
    5.293207e-002,
    1.335214e+000,
    6.385980e-001,
    // albedo 0, turbidity 5
    -1.743240e+000,
    -9.391727e-001,
    -8.905876e+000,
    9.139326e+000,
    -2.333803e-002,
    3.093783e-001,
    -2.051734e-006,
    2.320564e+000,
    5.474845e-001,
    -2.624196e+000,
    -1.516703e+000,
    5.053093e+000,
    -4.599198e+000,
    -4.248730e-002,
    4.820250e-001,
    1.829762e-002,
    1.216991e+000,
    2.739806e-001,
    -1.040612e+000,
    -6.103044e-001,
    -3.190021e+000,
    3.216574e+000,
    -3.285978e-001,
    -1.982489e-001,
    -5.367025e-002,
    3.984414e+000,
    1.158312e+000,
    -9.537244e-001,
    -6.895800e-003,
    1.788307e+000,
    -2.659655e+000,
    6.473584e-001,
    1.333544e+000,
    5.529579e-002,
    8.049825e-001,
    4.930209e-001,
    -1.163791e+000,
    -5.095388e-001,
    1.215079e-001,
    3.427998e+000,
    -9.243257e+000,
    -5.059496e-001,
    1.412681e-001,
    1.829389e+000,
    5.544610e-001,
    -1.118058e+000,
    -3.706501e-001,
    6.885180e-001,
    -1.596776e-003,
    -3.279613e+000,
    1.068229e+000,
    3.010797e-002,
    1.479756e+000,
    7.483765e-001,
    // albedo 0, turbidity 6
    -1.811701e+000,
    -1.002650e+000,
    -9.194183e+000,
    9.469966e+000,
    -2.224886e-002,
    3.237441e-001,
    -2.632967e-006,
    2.168879e+000,
    5.952956e-001,
    -2.746180e+000,
    -1.592055e+000,
    4.225172e+000,
    -3.929912e+000,
    -3.866297e-002,
    3.982440e-001,
    3.812089e-002,
    1.390284e+000,
    1.922369e-001,
    -9.558770e-001,
    -6.401790e-001,
    -2.117905e+000,
    2.293799e+000,
    -2.226591e-001,
    6.151477e-002,
    -1.223358e-001,
    3.475975e+000,
    1.124575e+000,
    -9.065351e-001,
    1.443765e-001,
    7.871576e-001,
    -1.631026e+000,
    1.537369e-001,
    8.353048e-001,
    1.849704e-001,
    1.650615e+000,
    4.473559e-001,
    -1.180081e+000,
    -5.441674e-001,
    3.963103e-001,
    1.375519e+000,
    -4.882926e+000,
    -9.391794e-004,
    6.455569e-002,
    1.774670e+000,
    6.989373e-001,
    -1.128755e+000,
    -3.892532e-001,
    5.327884e-001,
    1.825253e+000,
    -2.335719e+000,
    5.863162e-001,
    5.535626e-002,
    1.452293e+000,
    6.920090e-001,
    // albedo 0, turbidity 7
    -2.042064e+000,
    -1.144943e+000,
    -5.152625e+000,
    5.384535e+000,
    -3.519943e-002,
    3.025845e-001,
    -2.994849e-006,
    2.113418e+000,
    6.000255e-001,
    -2.700541e+000,
    -1.485611e+000,
    2.159154e+000,
    -2.188608e+000,
    -5.879735e-002,
    3.921779e-001,
    5.020849e-002,
    1.869923e+000,
    2.118398e-001,
    -1.187417e+000,
    -1.102630e+000,
    -9.404690e-001,
    2.427532e+000,
    -2.948903e-001,
    -3.437257e-002,
    -1.636446e-001,
    1.894926e+000,
    1.001327e+000,
    -5.639857e-001,
    7.170770e-001,
    -1.146502e-001,
    -3.487513e+000,
    -7.711076e-001,
    1.046031e+000,
    2.606854e-001,
    3.873520e+000,
    5.637980e-001,
    -1.363103e+000,
    -8.396317e-001,
    5.750351e-001,
    4.317766e+000,
    -2.364722e+000,
    -4.135433e-001,
    2.669162e-002,
    5.768700e-001,
    6.649078e-001,
    -1.102449e+000,
    -3.685043e-001,
    4.622549e-001,
    -2.018634e-003,
    -3.947538e+000,
    8.449276e-001,
    8.837036e-002,
    1.601304e+000,
    7.026980e-001,
    // albedo 0, turbidity 8
    -2.314053e+000,
    -1.314766e+000,
    -7.125646e+000,
    7.357344e+000,
    -2.585710e-002,
    2.863908e-001,
    -2.425744e-006,
    2.039404e+000,
    5.594003e-001,
    -2.630411e+000,
    -1.404258e+000,
    3.675058e+000,
    -3.804226e+000,
    -4.249037e-002,
    3.486414e-001,
    5.675141e-002,
    1.944935e+000,
    2.880711e-001,
    -1.884599e+000,
    -1.657069e+000,
    -1.731916e+000,
    3.034605e+000,
    -1.746846e-001,
    -1.559184e-002,
    -1.600465e-001,
    1.915108e+000,
    9.460232e-001,
    6.351036e-002,
    1.061776e+000,
    1.195544e-002,
    -3.018584e+000,
    -5.618808e-001,
    1.008146e+000,
    2.013783e-001,
    3.212273e+000,
    6.523624e-001,
    -1.672505e+000,
    -9.752710e-001,
    5.282860e-001,
    3.776331e+000,
    -4.325128e+000,
    -4.384279e-001,
    1.352387e-001,
    8.847662e-001,
    5.717158e-001,
    -1.007695e+000,
    -3.840375e-001,
    3.463543e-001,
    2.848366e+000,
    -2.105699e+000,
    4.636429e-001,
    2.800131e-002,
    1.306056e+000,
    7.618236e-001,
    // albedo 0, turbidity 9
    -2.865406e+000,
    -1.637174e+000,
    -7.429613e+000,
    7.592861e+000,
    -2.196505e-002,
    2.800873e-001,
    -3.908530e-006,
    1.962505e+000,
    5.891464e-001,
    -3.196334e+000,
    -1.512711e+000,
    3.947880e+000,
    -4.029796e+000,
    -3.699620e-002,
    1.461452e-001,
    5.921432e-002,
    1.806132e+000,
    2.331816e-001,
    -2.335492e+000,
    -2.353032e+000,
    -1.764665e+000,
    2.841986e+000,
    -7.331326e-002,
    4.537047e-001,
    -1.668000e-001,
    2.156269e+000,
    9.812486e-001,
    3.278911e-001,
    1.315177e+000,
    -1.438189e-001,
    -2.859630e+000,
    -8.436262e-001,
    2.645711e-001,
    2.154409e-001,
    2.264493e+000,
    5.975203e-001,
    -1.738015e+000,
    -1.091057e+000,
    5.425696e-001,
    4.650166e+000,
    -3.975190e+000,
    2.066035e-001,
    1.017332e-001,
    9.321625e-001,
    6.517783e-001,
    -1.006457e+000,
    -4.243112e-001,
    1.934952e-001,
    2.795030e+000,
    -1.680697e+000,
    -9.428375e-002,
    7.158314e-002,
    1.082383e+000,
    7.234775e-001,
    // albedo 0, turbidity 10
    -4.195701e+000,
    -2.171135e+000,
    -5.278016e+000,
    5.393085e+000,
    -2.419182e-002,
    2.050075e-001,
    -3.797795e-006,
    1.853402e+000,
    6.912927e-001,
    -4.119053e+000,
    -1.648023e+000,
    2.332552e+000,
    -2.173813e+000,
    -6.442977e-002,
    2.188945e-001,
    3.548565e-002,
    1.792598e+000,
    4.162082e-002,
    -4.016823e+000,
    -3.599323e+000,
    -6.179057e-001,
    6.454998e-001,
    -9.913704e-002,
    2.770986e-001,
    -9.265471e-002,
    2.227501e+000,
    1.179216e+000,
    1.066227e+000,
    1.392783e+000,
    -9.653695e-001,
    -5.471637e-001,
    -8.500569e-001,
    4.678476e-001,
    8.760324e-002,
    1.564314e+000,
    4.885251e-001,
    -1.855594e+000,
    -1.029300e+000,
    8.521013e-001,
    3.975027e+000,
    -3.806819e+000,
    -2.044703e-002,
    1.757298e-001,
    7.790123e-001,
    6.918921e-001,
    -1.014961e+000,
    -6.014045e-001,
    1.926619e-002,
    2.357335e+000,
    -1.312911e+000,
    -8.783609e-002,
    7.739369e-002,
    7.356770e-001,
    7.042591e-001,
    // albedo 1, turbidity 1
    -1.467874e+000,
    -7.636581e-001,
    -7.251111e+000,
    7.726558e+000,
    -2.759341e-002,
    3.527534e-001,
    5.340629e-005,
    2.007747e+000,
    5.447487e-001,
    -1.863242e+000,
    -1.048209e+000,
    -1.580541e+000,
    2.558030e+000,
    -5.622126e-002,
    3.053960e-001,
    -4.657733e-004,
    9.956390e-001,
    3.409087e-001,
    -1.384101e+000,
    -5.553588e-001,
    1.191974e+000,
    -2.157512e+000,
    -3.567589e-002,
    1.020018e-001,
    2.940191e-003,
    4.555372e+000,
    8.736043e-001,
    -9.828878e-001,
    -4.220161e-001,
    1.184916e+000,
    9.230716e-001,
    -4.062756e-001,
    1.064980e+000,
    -1.060088e-002,
    -1.764815e+000,
    2.932808e-001,
    -1.057001e+000,
    -2.727017e-001,
    1.000018e+000,
    -3.108668e-001,
    6.848382e-001,
    -1.682596e-001,
    2.301218e-002,
    2.075821e+000,
    7.647327e-001,
    -1.058165e+000,
    -2.436130e-001,
    1.074414e+000,
    8.554434e-002,
    -3.846431e+000,
    7.595465e-001,
    9.729528e-006,
    1.915942e+000,
    4.999612e-001,
    // albedo 1, turbidity 2
    -1.610179e+000,
    -8.336019e-001,
    -1.443356e+001,
    1.492556e+001,
    -1.381931e-002,
    2.902743e-001,
    -7.665717e-006,
    1.981513e+000,
    9.000423e-001,
    -2.004083e+000,
    -1.148388e+000,
    3.747156e+000,
    -2.808560e+000,
    -3.298677e-002,
    4.224754e-001,
    4.166438e-004,
    8.792110e-001,
    -2.321793e-001,
    -1.178554e+000,
    -5.064839e-001,
    -1.117126e+000,
    2.815740e-001,
    -7.068438e-002,
    -3.031589e-002,
    -3.468069e-003,
    4.539093e+000,
    1.385612e+000,
    -1.091191e+000,
    -4.200919e-001,
    1.826508e+000,
    7.131992e-002,
    -1.883417e-001,
    1.061437e+000,
    1.311913e-002,
    -1.972550e+000,
    2.511246e-001,
    -9.987232e-001,
    -2.073656e-001,
    7.443384e-001,
    -7.245157e-002,
    -5.588818e-001,
    -1.364188e-001,
    2.023795e-002,
    2.829822e+000,
    7.230021e-001,
    -1.075477e+000,
    -2.556973e-001,
    1.051690e+000,
    3.075960e-002,
    -1.895492e+000,
    6.408333e-001,
    2.109454e-002,
    1.891240e+000,
    5.652527e-001,
    // albedo 1, turbidity 3
    -1.531711e+000,
    -8.266123e-001,
    -9.324763e+000,
    9.811491e+000,
    -1.988560e-002,
    3.404598e-001,
    -2.068369e-006,
    1.869307e+000,
    5.860842e-001,
    -2.113444e+000,
    -1.209106e+000,
    3.526508e+000,
    -2.628730e+000,
    -4.634065e-002,
    3.182739e-001,
    9.500212e-003,
    1.004871e+000,
    2.109968e-001,
    -1.196720e+000,
    -5.485073e-001,
    -1.667136e+000,
    9.920197e-001,
    -1.622954e-001,
    6.951315e-002,
    -3.482877e-002,
    4.214632e+000,
    1.108967e+000,
    -1.003096e+000,
    -3.200944e-001,
    2.042427e+000,
    -4.417822e-001,
    -1.404599e-001,
    9.288535e-001,
    6.077264e-002,
    -1.386737e+000,
    4.557129e-001,
    -1.061048e+000,
    -2.908451e-001,
    6.390633e-001,
    1.406786e-001,
    -1.834706e+000,
    -1.432145e-001,
    1.914080e-002,
    2.284516e+000,
    5.965839e-001,
    -1.054623e+000,
    -2.267971e-001,
    1.028491e+000,
    -3.197518e-003,
    -1.705329e+000,
    6.747358e-001,
    2.072713e-002,
    2.140509e+000,
    7.205824e-001,
    // albedo 1, turbidity 4
    -1.610001e+000,
    -8.622601e-001,
    -1.060181e+001,
    1.106133e+001,
    -1.648296e-002,
    2.590559e-001,
    -1.904522e-006,
    1.930415e+000,
    6.006964e-001,
    -2.308577e+000,
    -1.440194e+000,
    2.937335e+000,
    -2.093599e+000,
    -3.430217e-002,
    3.427774e-001,
    2.590705e-002,
    5.673750e-001,
    1.250422e-001,
    -9.441254e-001,
    -3.064812e-001,
    -8.895068e-001,
    2.815271e-001,
    -8.036228e-002,
    1.867017e-001,
    -7.809247e-002,
    4.774631e+000,
    1.391904e+000,
    -1.214397e+000,
    -5.423074e-001,
    1.361001e+000,
    1.782273e-001,
    -3.648675e-001,
    7.181838e-001,
    1.135547e-001,
    -1.935982e+000,
    1.820361e-001,
    -9.377631e-001,
    -1.533211e-001,
    8.439993e-001,
    -3.893771e-001,
    -2.564779e-001,
    -6.742272e-002,
    2.255856e-002,
    2.780601e+000,
    7.972008e-001,
    -1.101428e+000,
    -3.069552e-001,
    9.687591e-001,
    4.500576e-001,
    -4.912444e+000,
    5.398387e-001,
    3.638172e-002,
    1.582999e+000,
    6.425950e-001,
    // albedo 1, turbidity 5
    -1.687541e+000,
    -9.378170e-001,
    -8.475686e+000,
    8.929279e+000,
    -2.132746e-002,
    2.917650e-001,
    -2.177239e-006,
    1.863407e+000,
    5.908179e-001,
    -2.278432e+000,
    -1.387936e+000,
    5.425292e+000,
    -4.725025e+000,
    -3.892912e-002,
    4.084727e-001,
    1.842665e-002,
    8.461986e-001,
    1.673366e-001,
    -1.302702e+000,
    -7.200083e-001,
    -3.084331e+000,
    3.191487e+000,
    -3.222828e-001,
    -1.493849e-001,
    -5.641672e-002,
    3.624218e+000,
    1.256086e+000,
    -7.886965e-001,
    -3.966453e-002,
    2.110076e+000,
    -2.232935e+000,
    7.269719e-001,
    1.163410e+000,
    7.133744e-002,
    -1.660119e-001,
    4.329084e-001,
    -1.157760e+000,
    -4.084596e-001,
    5.689088e-001,
    2.379590e+000,
    -9.687743e+000,
    -5.598487e-001,
    9.191895e-002,
    1.923047e+000,
    5.802927e-001,
    -1.047250e+000,
    -2.873072e-001,
    1.046858e+000,
    6.890046e-001,
    -2.947892e+000,
    7.245997e-001,
    1.125227e-002,
    1.352625e+000,
    7.193979e-001,
    // albedo 1, turbidity 6
    -1.643764e+000,
    -9.086683e-001,
    -8.750078e+000,
    9.165653e+000,
    -2.025728e-002,
    2.737848e-001,
    -2.240987e-006,
    1.943471e+000,
    5.731722e-001,
    -2.473069e+000,
    -1.505194e+000,
    5.448737e+000,
    -4.863726e+000,
    -3.662439e-002,
    1.938729e-001,
    4.741355e-002,
    8.586572e-001,
    2.284408e-001,
    -1.232599e+000,
    -7.896777e-001,
    -3.056911e+000,
    3.546334e+000,
    -1.948820e-001,
    3.344216e-001,
    -1.376967e-001,
    3.029469e+000,
    1.120573e+000,
    -6.095289e-001,
    2.745468e-001,
    1.809782e+000,
    -2.593032e+000,
    -1.710009e-002,
    5.537278e-001,
    1.935506e-001,
    1.259882e+000,
    4.970103e-001,
    -1.324655e+000,
    -6.255071e-001,
    6.240868e-001,
    2.021182e+000,
    -5.876050e+000,
    -1.507819e-001,
    3.301250e-002,
    1.142019e+000,
    5.986671e-001,
    -9.888131e-001,
    -2.584852e-001,
    1.052160e+000,
    7.264224e-001,
    -2.563426e+000,
    5.494058e-001,
    1.821983e-002,
    1.277896e+000,
    7.557967e-001,
    // albedo 1, turbidity 7
    -2.100689e+000,
    -1.204431e+000,
    -7.573121e+000,
    8.039632e+000,
    -2.300526e-002,
    2.839214e-001,
    -2.346958e-006,
    1.678847e+000,
    5.536303e-001,
    -2.610610e+000,
    -1.587799e+000,
    5.460928e+000,
    -5.158708e+000,
    -4.505650e-002,
    3.876929e-001,
    3.852459e-002,
    1.172854e+000,
    3.104745e-001,
    -8.340903e-001,
    -7.487965e-001,
    -3.154774e+000,
    4.600448e+000,
    -1.818975e-001,
    -1.871764e-001,
    -1.222094e-001,
    2.067197e+000,
    8.802127e-001,
    -9.180308e-001,
    3.752197e-001,
    1.471125e+000,
    -4.691789e+000,
    -5.128294e-001,
    1.164707e+000,
    1.831224e-001,
    2.900937e+000,
    7.718397e-001,
    -1.126819e+000,
    -6.652330e-001,
    7.386065e-001,
    5.362044e+000,
    -6.196453e+000,
    -7.280092e-001,
    6.312604e-002,
    2.874666e-001,
    4.225580e-001,
    -1.091610e+000,
    -3.433417e-001,
    1.042206e+000,
    1.075776e-001,
    -4.443940e+000,
    7.469895e-001,
    3.166247e-002,
    1.019495e+000,
    7.523771e-001,
    // albedo 1, turbidity 8
    -2.234623e+000,
    -1.310221e+000,
    -8.525764e+000,
    8.932373e+000,
    -1.814945e-002,
    2.615153e-001,
    -2.992344e-006,
    1.672403e+000,
    5.897681e-001,
    -2.566352e+000,
    -1.472664e+000,
    5.894182e+000,
    -5.619094e+000,
    -3.204346e-002,
    2.993298e-001,
    4.281047e-002,
    1.303481e+000,
    2.453403e-001,
    -1.577477e+000,
    -1.491725e+000,
    -3.065840e+000,
    4.446634e+000,
    -1.689128e-001,
    9.559287e-002,
    -1.384724e-001,
    1.778589e+000,
    9.159045e-001,
    -2.747774e-001,
    8.787060e-001,
    1.071723e+000,
    -4.169230e+000,
    -3.029966e-001,
    6.326611e-001,
    2.145395e-001,
    2.611218e+000,
    7.082708e-001,
    -1.433045e+000,
    -8.939972e-001,
    8.538090e-001,
    4.481475e+000,
    -5.978961e+000,
    -1.608369e-001,
    5.335732e-002,
    3.510751e-001,
    5.421327e-001,
    -9.961738e-001,
    -3.023960e-001,
    9.152994e-001,
    2.936173e+000,
    -2.311060e+000,
    1.216642e-001,
    2.844950e-002,
    9.492671e-001,
    6.929460e-001,
    // albedo 1, turbidity 9
    -2.428587e+000,
    -1.538689e+000,
    -9.076712e+000,
    9.464050e+000,
    -1.503392e-002,
    2.373401e-001,
    -2.770103e-006,
    1.537508e+000,
    5.959289e-001,
    -3.240872e+000,
    -1.646067e+000,
    6.091797e+000,
    -5.738481e+000,
    -3.098072e-002,
    2.698026e-001,
    3.864212e-002,
    1.286514e+000,
    2.461153e-001,
    -1.970987e+000,
    -2.124015e+000,
    -2.894000e+000,
    3.858260e+000,
    -1.449222e-001,
    1.903898e-001,
    -1.194017e-001,
    1.882566e+000,
    8.764452e-001,
    3.562238e-002,
    1.092427e+000,
    6.291668e-001,
    -3.337396e+000,
    -2.817141e-001,
    4.799828e-001,
    1.674350e-001,
    1.943489e+000,
    7.728749e-001,
    -1.501790e+000,
    -9.408520e-001,
    1.000954e+000,
    4.599103e+000,
    -5.295662e+000,
    -1.111397e-001,
    1.040124e-001,
    3.185557e-001,
    4.959400e-001,
    -9.859417e-001,
    -3.827367e-001,
    8.040930e-001,
    2.980678e+000,
    -2.015582e+000,
    -8.947514e-003,
    1.696367e-002,
    6.489501e-001,
    7.555598e-001,
    // albedo 1, turbidity 10
    -3.758956e+000,
    -2.159015e+000,
    -7.207163e+000,
    7.516659e+000,
    -1.643521e-002,
    2.465725e-001,
    -4.045068e-006,
    1.471688e+000,
    6.687943e-001,
    -4.635664e+000,
    -1.766046e+000,
    4.282669e+000,
    -4.058908e+000,
    -2.908998e-002,
    1.202684e-001,
    3.167305e-002,
    1.450927e+000,
    8.171815e-002,
    -3.458011e+000,
    -3.657280e+000,
    -1.484743e+000,
    2.264533e+000,
    -1.033120e-001,
    4.282323e-001,
    -8.387881e-002,
    1.687334e+000,
    1.130604e+000,
    9.673527e-001,
    1.500425e+000,
    -3.604932e-001,
    -2.050346e+000,
    -3.778381e-001,
    2.416298e-001,
    8.439313e-002,
    1.458583e+000,
    5.816071e-001,
    -1.808078e+000,
    -1.089975e+000,
    1.291838e+000,
    5.144631e+000,
    -5.047822e+000,
    4.301183e-002,
    1.426941e-001,
    1.187472e-001,
    6.145551e-001,
    -8.399253e-001,
    -3.832885e-001,
    6.306417e-001,
    2.179775e+000,
    -1.492762e+000,
    -1.682763e-001,
    4.109851e-002,
    4.221724e-001,
    7.086504e-001,
};

double datasetRad400[] =
{
    // albedo 0, turbidity 1
    5.767645e-003,
    1.219302e-002,
    -2.188467e-002,
    8.262275e-002,
    1.719839e-001,
    1.233791e-001,
    // albedo 0, turbidity 2
    5.661981e-003,
    1.258489e-002,
    -2.324339e-002,
    8.372421e-002,
    1.730981e-001,
    1.255797e-001,
    // albedo 0, turbidity 3
    5.644031e-003,
    1.248986e-002,
    -2.287316e-002,
    7.999388e-002,
    1.815345e-001,
    1.252983e-001,
    // albedo 0, turbidity 4
    5.479152e-003,
    1.215496e-002,
    -2.122586e-002,
    7.189527e-002,
    1.962517e-001,
    1.245648e-001,
    // albedo 0, turbidity 5
    5.385972e-003,
    1.187505e-002,
    -2.025911e-002,
    6.602510e-002,
    2.067312e-001,
    1.264910e-001,
    // albedo 0, turbidity 6
    5.319970e-003,
    1.160513e-002,
    -1.904232e-002,
    6.030292e-002,
    2.158311e-001,
    1.261204e-001,
    // albedo 0, turbidity 7
    5.179289e-003,
    1.125842e-002,
    -1.708641e-002,
    5.111365e-002,
    2.285030e-001,
    1.278260e-001,
    // albedo 0, turbidity 8
    4.994685e-003,
    1.025385e-002,
    -1.254777e-002,
    3.429945e-002,
    2.490310e-001,
    1.302691e-001,
    // albedo 0, turbidity 9
    4.759538e-003,
    8.205142e-003,
    -3.246300e-003,
    3.909938e-003,
    2.819549e-001,
    1.322430e-001,
    // albedo 0, turbidity 10
    4.412341e-003,
    4.910210e-003,
    1.040886e-002,
    -3.627125e-002,
    3.147182e-001,
    1.409331e-001,
    // albedo 1, turbidity 1
    7.016633e-003,
    9.796846e-003,
    -9.823849e-004,
    2.324224e-002,
    3.035010e-001,
    2.573850e-001,
    // albedo 1, turbidity 2
    6.984411e-003,
    9.584282e-003,
    -5.945671e-004,
    2.061312e-002,
    3.090019e-001,
    2.547364e-001,
    // albedo 1, turbidity 3
    6.865141e-003,
    9.540856e-003,
    -3.311701e-004,
    1.726495e-002,
    3.147099e-001,
    2.539552e-001,
    // albedo 1, turbidity 4
    6.701191e-003,
    9.352606e-003,
    3.392916e-004,
    1.159886e-002,
    3.228446e-001,
    2.530111e-001,
    // albedo 1, turbidity 5
    6.513679e-003,
    8.873317e-003,
    2.339520e-003,
    2.817964e-003,
    3.341256e-001,
    2.496316e-001,
    // albedo 1, turbidity 6
    6.405833e-003,
    8.466409e-003,
    3.661909e-003,
    -3.045984e-003,
    3.414328e-001,
    2.464327e-001,
    // albedo 1, turbidity 7
    6.220899e-003,
    7.997469e-003,
    5.957591e-003,
    -1.302863e-002,
    3.523355e-001,
    2.418785e-001,
    // albedo 1, turbidity 8
    5.912801e-003,
    6.826679e-003,
    1.008544e-002,
    -2.771812e-002,
    3.640405e-001,
    2.386599e-001,
    // albedo 1, turbidity 9
    5.550967e-003,
    5.157051e-003,
    1.661696e-002,
    -5.072656e-002,
    3.807009e-001,
    2.315489e-001,
    // albedo 1, turbidity 10
    5.011118e-003,
    2.636752e-003,
    2.499879e-002,
    -7.576617e-002,
    3.828189e-001,
    2.328116e-001,
};

double dataset440[] =
{
    // albedo 0, turbidity 1
    -1.397312e+000,
    -5.327311e-001,
    -5.456059e+000,
    5.777674e+000,
    -5.111575e-002,
    4.730804e-001,
    7.375500e-003,
    3.032806e+000,
    5.181890e-001,
    -1.561639e+000,
    -7.024946e-001,
    -2.140322e+000,
    2.841761e+000,
    -8.846023e-002,
    5.529005e-001,
    6.219344e-003,
    2.004212e+000,
    3.701256e-001,
    -1.047473e+000,
    -1.152734e-001,
    2.275873e+000,
    -3.020347e+000,
    -1.739218e-001,
    2.250142e-001,
    -2.731776e-002,
    6.659723e+000,
    1.067495e+000,
    -1.298483e+000,
    -5.788209e-001,
    4.906412e-001,
    1.522576e+000,
    -5.650061e-001,
    1.544707e+000,
    4.638003e-002,
    -3.742019e+000,
    2.485397e-001,
    -9.485899e-001,
    -7.383610e-002,
    1.039247e+000,
    -4.744931e-001,
    -1.822357e-001,
    2.284415e-001,
    -4.796962e-002,
    4.363935e+000,
    8.217971e-001,
    -1.099082e+000,
    -2.001688e-001,
    7.365077e-001,
    1.068489e-001,
    -5.005434e+000,
    1.508145e+000,
    8.181497e-002,
    3.226865e+000,
    4.999418e-001,
    // albedo 0, turbidity 2
    -1.416143e+000,
    -5.515006e-001,
    -7.045898e+000,
    7.448161e+000,
    -4.504075e-002,
    5.055437e-001,
    -1.378949e-006,
    2.955475e+000,
    6.184716e-001,
    -1.698183e+000,
    -8.272914e-001,
    9.984388e-001,
    -2.511235e-001,
    -9.262675e-002,
    5.681534e-001,
    5.377123e-003,
    1.631048e+000,
    1.137691e-001,
    -9.234085e-001,
    -2.165404e-002,
    6.483039e-002,
    -8.535145e-001,
    -2.497457e-001,
    1.695057e-001,
    -3.410225e-002,
    6.726925e+000,
    1.331197e+000,
    -1.265077e+000,
    -5.034231e-001,
    1.196547e+000,
    3.666463e-001,
    -3.960044e-001,
    1.404008e+000,
    1.129300e-001,
    -2.644439e+000,
    1.103356e-001,
    -1.008210e+000,
    -1.455232e-001,
    7.347739e-001,
    2.462433e-002,
    -2.534587e+000,
    3.088590e-001,
    -6.687136e-002,
    3.786007e+000,
    9.578369e-001,
    -1.076840e+000,
    -1.851501e-001,
    7.341818e-001,
    -2.658571e-003,
    -5.001762e+000,
    1.275390e+000,
    1.277410e-001,
    3.223315e+000,
    5.147659e-001,
    // albedo 0, turbidity 3
    -1.449526e+000,
    -5.738159e-001,
    -8.976383e+000,
    9.275142e+000,
    -3.157845e-002,
    5.011970e-001,
    -1.218363e-006,
    3.001006e+000,
    5.662190e-001,
    -1.748840e+000,
    -9.338946e-001,
    5.557460e-002,
    9.451626e-001,
    -6.929558e-002,
    5.458365e-001,
    5.505399e-003,
    8.818793e-001,
    2.135274e-001,
    -8.369988e-001,
    1.127967e-001,
    8.846958e-001,
    -2.467908e+000,
    -8.394011e-002,
    1.684067e-001,
    -3.352743e-002,
    7.957386e+000,
    1.297777e+000,
    -1.284515e+000,
    -5.332365e-001,
    5.511261e-001,
    1.702784e+000,
    -6.616281e-001,
    1.349449e+000,
    1.269152e-001,
    -3.247373e+000,
    2.115827e-001,
    -9.889637e-001,
    -9.962819e-002,
    6.096776e-001,
    -8.472749e-001,
    7.672924e-001,
    7.425160e-002,
    2.113714e-002,
    4.990637e+000,
    8.274585e-001,
    -1.093910e+000,
    -2.211349e-001,
    6.959659e-001,
    3.423174e-001,
    -5.004213e+000,
    1.347201e+000,
    1.198192e-001,
    2.547517e+000,
    6.329489e-001,
    // albedo 0, turbidity 4
    -1.394462e+000,
    -5.287733e-001,
    -8.095187e+000,
    8.076613e+000,
    -1.275227e-002,
    1.916790e-001,
    4.741296e-002,
    3.145140e+000,
    5.071760e-001,
    -2.234192e+000,
    -1.437079e+000,
    -5.734544e-001,
    1.248687e+000,
    -4.136344e-002,
    7.671749e-001,
    -1.273584e-002,
    4.751894e-001,
    4.116995e-001,
    -4.063889e-001,
    4.920785e-001,
    3.865520e-001,
    2.254008e-001,
    -1.618861e-001,
    1.950875e-001,
    -8.622479e-002,
    3.836900e+000,
    1.108189e+000,
    -1.366924e+000,
    -4.557853e-001,
    -6.731417e-001,
    -3.011452e-001,
    2.413069e-001,
    1.404821e+000,
    1.920278e-001,
    6.394529e+000,
    4.219713e-001,
    -9.128947e-001,
    1.980978e-002,
    5.119874e-001,
    8.027541e-002,
    -3.680159e+000,
    6.597416e-001,
    3.853339e-002,
    3.969131e+000,
    8.351942e-001,
    -1.162856e+000,
    -3.606511e-001,
    7.055795e-001,
    -2.702137e-003,
    4.777294e-001,
    -7.722331e-001,
    3.446509e-001,
    1.186834e+000,
    5.118539e-001,
    // albedo 0, turbidity 5
    -1.563353e+000,
    -6.916347e-001,
    -4.154766e+001,
    4.181703e+001,
    -5.673370e-003,
    4.344900e-001,
    1.839829e-003,
    2.669278e+000,
    5.021266e-001,
    -1.948172e+000,
    -1.080669e+000,
    1.082552e+001,
    -1.034262e+001,
    -1.196421e-002,
    3.895739e-001,
    5.621831e-002,
    1.347130e+000,
    4.561106e-001,
    -9.155219e-001,
    -1.456265e-001,
    -2.177275e+000,
    2.079788e+000,
    -2.154465e-002,
    7.743816e-001,
    -2.181642e-001,
    4.897704e+000,
    1.035464e+000,
    -1.010898e+000,
    -4.425431e-002,
    3.067880e-001,
    -6.899235e-001,
    -1.891895e-001,
    3.015686e-001,
    4.236422e-001,
    1.901582e+000,
    3.916662e-001,
    -1.159005e+000,
    -4.048136e-001,
    5.385745e-001,
    3.423651e-001,
    1.474365e-001,
    3.516065e-001,
    2.564260e-003,
    1.815518e+000,
    7.634079e-001,
    -1.081675e+000,
    -2.556981e-001,
    6.544471e-001,
    4.093649e-001,
    -3.215201e+000,
    9.116400e-001,
    1.406660e-001,
    1.869407e+000,
    6.968119e-001,
    // albedo 0, turbidity 6
    -1.561484e+000,
    -7.153039e-001,
    -1.623772e+001,
    1.650713e+001,
    -1.394913e-002,
    4.467465e-001,
    9.613464e-004,
    2.564429e+000,
    5.363746e-001,
    -2.308050e+000,
    -1.314851e+000,
    -1.484346e+000,
    1.928705e+000,
    -2.164130e-002,
    2.817711e-001,
    7.177671e-002,
    1.146387e+000,
    3.025595e-001,
    -4.886429e-001,
    8.279799e-002,
    2.432876e+000,
    -2.276257e+000,
    -4.799742e-002,
    9.362010e-001,
    -2.753669e-001,
    4.784291e+000,
    1.180593e+000,
    -1.306115e+000,
    -1.759650e-001,
    -1.392008e+000,
    3.119302e-001,
    -2.268673e-001,
    8.336951e-002,
    5.250725e-001,
    2.534962e+000,
    2.800244e-001,
    -1.016608e+000,
    -3.429911e-001,
    5.659470e-001,
    9.044333e-001,
    7.387499e-002,
    4.267609e-001,
    -4.165623e-002,
    1.452779e+000,
    8.409560e-001,
    -1.127637e+000,
    -2.854231e-001,
    4.933964e-001,
    -3.379287e-003,
    -1.181893e+000,
    8.164171e-001,
    1.910509e-001,
    1.979338e+000,
    6.658885e-001,
    // albedo 0, turbidity 7
    -1.675310e+000,
    -8.020443e-001,
    -1.136130e+001,
    1.159861e+001,
    -1.871156e-002,
    4.151400e-001,
    -1.940992e-006,
    2.486322e+000,
    5.256426e-001,
    -2.071301e+000,
    -1.175325e+000,
    1.789426e+000,
    -1.455233e+000,
    -2.855906e-002,
    3.218745e-001,
    7.776969e-002,
    1.431615e+000,
    3.478887e-001,
    -1.093503e+000,
    -4.120496e-001,
    -8.598647e-002,
    4.564844e-001,
    -1.231980e-001,
    7.992132e-001,
    -2.910745e-001,
    3.881502e+000,
    1.064658e+000,
    -7.736128e-001,
    2.385498e-001,
    -7.867818e-001,
    -6.009723e-001,
    -1.808566e-001,
    -8.796429e-003,
    5.412620e-001,
    2.991552e+000,
    4.008143e-001,
    -1.259083e+000,
    -5.300975e-001,
    5.418031e-001,
    1.150966e+000,
    -7.553821e-001,
    5.991000e-001,
    -2.344718e-003,
    1.097939e+000,
    7.756612e-001,
    -1.094148e+000,
    -3.178958e-001,
    4.126954e-001,
    3.591106e-001,
    -1.415744e+000,
    3.908399e-001,
    1.806147e-001,
    1.584959e+000,
    6.862009e-001,
    // albedo 0, turbidity 8
    -1.815485e+000,
    -9.306778e-001,
    -1.249527e+001,
    1.271288e+001,
    -1.497209e-002,
    3.576353e-001,
    -2.464284e-006,
    2.326460e+000,
    5.655414e-001,
    -2.225570e+000,
    -1.213627e+000,
    6.082472e+000,
    -5.907562e+000,
    -2.446452e-002,
    2.113558e-001,
    7.708802e-002,
    1.647556e+000,
    2.416155e-001,
    -1.439532e+000,
    -8.666475e-001,
    -2.734807e+000,
    3.355265e+000,
    -1.311068e-001,
    1.048703e+000,
    -2.887025e-001,
    3.419973e+000,
    1.146322e+000,
    -5.599890e-001,
    4.437236e-001,
    1.582320e-001,
    -2.000110e+000,
    -2.859304e-001,
    -5.600631e-001,
    5.382793e-001,
    1.986387e+000,
    3.455121e-001,
    -1.319304e+000,
    -6.466246e-001,
    5.684685e-001,
    2.050330e+000,
    -2.796053e+000,
    1.001659e+000,
    -1.161356e-002,
    9.737235e-001,
    8.101246e-001,
    -1.097281e+000,
    -3.336023e-001,
    1.781708e-001,
    1.733079e+000,
    -1.378806e+000,
    -1.870394e-001,
    1.997578e-001,
    1.456148e+000,
    6.791796e-001,
    // albedo 0, turbidity 9
    -2.208666e+000,
    -1.219745e+000,
    -7.548669e+000,
    7.680830e+000,
    -2.012473e-002,
    3.627866e-001,
    -2.906182e-006,
    2.147138e+000,
    6.340095e-001,
    -1.967348e+000,
    -9.528057e-001,
    4.171590e+000,
    -4.002838e+000,
    -5.074552e-002,
    1.581866e-001,
    5.920106e-002,
    1.981564e+000,
    1.023257e-001,
    -3.150304e+000,
    -2.193706e+000,
    -2.016165e+000,
    2.374337e+000,
    -6.793058e-002,
    9.623811e-001,
    -2.195022e-001,
    2.736885e+000,
    1.252161e+000,
    4.737094e-001,
    1.067875e+000,
    -1.003861e-001,
    -1.566752e+000,
    -1.217264e+000,
    -4.270598e-001,
    3.968055e-001,
    1.234108e+000,
    3.105789e-001,
    -1.706975e+000,
    -9.607442e-001,
    7.140098e-001,
    3.981202e+000,
    -3.521433e+000,
    6.308820e-001,
    5.140937e-002,
    7.435120e-001,
    8.074305e-001,
    -1.012042e+000,
    -3.372525e-001,
    2.589450e-002,
    1.768224e+000,
    -1.059990e+000,
    -1.299077e-001,
    1.790337e-001,
    1.091012e+000,
    6.873854e-001,
    // albedo 0, turbidity 10
    -2.912541e+000,
    -1.677524e+000,
    -3.843452e+000,
    3.954207e+000,
    -3.414327e-002,
    2.945890e-001,
    -4.245832e-006,
    1.934337e+000,
    7.258748e-001,
    -1.567383e+000,
    -8.279686e-001,
    1.690940e+000,
    -1.413268e+000,
    -1.216792e-001,
    7.332798e-002,
    4.862765e-002,
    2.034766e+000,
    -5.041561e-002,
    -6.058613e+000,
    -3.509207e+000,
    -6.312870e-001,
    -4.558316e-002,
    6.168891e-002,
    8.153413e-001,
    -1.686845e-001,
    2.670227e+000,
    1.362906e+000,
    1.347177e+000,
    9.821888e-001,
    -9.242155e-001,
    5.851576e-001,
    -1.897421e+000,
    -2.729487e-002,
    2.866724e-001,
    7.306238e-001,
    2.792136e-001,
    -1.810783e+000,
    -1.027512e+000,
    1.216071e+000,
    5.270108e+000,
    -3.887149e+000,
    6.193256e-002,
    2.774610e-002,
    1.484756e-001,
    8.033249e-001,
    -9.801965e-001,
    -3.375841e-001,
    -3.004804e-001,
    1.385754e+000,
    -6.834540e-001,
    5.827734e-002,
    2.268309e-001,
    1.028696e+000,
    6.797371e-001,
    // albedo 1, turbidity 1
    -1.345260e+000,
    -5.085528e-001,
    -6.052009e+000,
    6.604590e+000,
    -4.300752e-002,
    4.745234e-001,
    6.591457e-003,
    2.595142e+000,
    5.013653e-001,
    -1.573525e+000,
    -7.133524e-001,
    -1.671346e+000,
    2.693205e+000,
    -7.828763e-002,
    2.915699e-001,
    1.795879e-002,
    1.469445e+000,
    4.927472e-001,
    -1.013665e+000,
    -1.731419e-001,
    2.043423e+000,
    -2.919634e+000,
    -1.020807e-001,
    5.467619e-001,
    -4.041481e-002,
    5.853992e+000,
    5.272064e-001,
    -1.173191e+000,
    -3.964683e-001,
    1.097258e+000,
    1.509973e+000,
    -5.675641e-001,
    9.815927e-001,
    6.962319e-002,
    -3.358210e+000,
    4.263117e-001,
    -1.003507e+000,
    -1.124908e-001,
    1.030642e+000,
    -5.357088e-001,
    6.114201e-001,
    1.628414e-001,
    -5.701497e-002,
    4.541126e+000,
    8.084996e-001,
    -1.071959e+000,
    -1.567262e-001,
    9.923029e-001,
    1.457160e-001,
    -4.742907e+000,
    7.280970e-001,
    6.770360e-002,
    3.919300e+000,
    4.999529e-001,
    // albedo 1, turbidity 2
    -1.399982e+000,
    -5.538549e-001,
    -6.983148e+000,
    7.513966e+000,
    -3.358417e-002,
    3.667027e-001,
    1.158837e-002,
    2.499680e+000,
    5.598537e-001,
    -1.602839e+000,
    -7.835806e-001,
    1.200264e+000,
    -1.454290e-001,
    -7.431927e-002,
    5.374263e-001,
    9.505505e-004,
    1.096167e+000,
    2.185838e-001,
    -9.587294e-001,
    -6.134134e-002,
    2.234030e-001,
    -8.115395e-001,
    -2.344054e-001,
    2.018782e-001,
    -4.192332e-002,
    6.331499e+000,
    1.353587e+000,
    -1.166832e+000,
    -4.057833e-001,
    1.461335e+000,
    3.165401e-001,
    -3.245858e-001,
    1.199323e+000,
    1.100274e-001,
    -2.727373e+000,
    5.329788e-002,
    -1.023178e+000,
    -1.351631e-001,
    9.944251e-001,
    2.103341e-002,
    -2.460318e+000,
    5.136074e-003,
    -5.267951e-002,
    4.097235e+000,
    9.388837e-001,
    -1.071426e+000,
    -1.726491e-001,
    1.048949e+000,
    -2.624840e-003,
    -4.993124e+000,
    6.621513e-001,
    7.801931e-002,
    3.227750e+000,
    5.363265e-001,
    // albedo 1, turbidity 3
    -1.362723e+000,
    -5.257224e-001,
    -1.325130e+001,
    1.374641e+001,
    -1.971887e-002,
    4.480379e-001,
    -9.588735e-007,
    2.679516e+000,
    5.628531e-001,
    -1.824466e+000,
    -9.877790e-001,
    4.631069e+000,
    -3.630521e+000,
    -4.340325e-002,
    3.913450e-001,
    3.415899e-002,
    4.746800e-001,
    2.022772e-001,
    -6.435267e-001,
    1.629762e-001,
    -1.452097e+000,
    8.028761e-001,
    -9.611017e-002,
    4.267105e-001,
    -1.023573e-001,
    6.652106e+000,
    1.406057e+000,
    -1.400277e+000,
    -5.150235e-001,
    1.752017e+000,
    -1.699743e-001,
    -3.411643e-001,
    8.465596e-001,
    2.127075e-001,
    -2.235971e+000,
    4.728189e-002,
    -9.044866e-001,
    -7.979493e-002,
    8.298122e-001,
    -5.604698e-002,
    -1.433761e+000,
    1.011757e-001,
    -7.175544e-002,
    4.243075e+000,
    9.588179e-001,
    -1.115618e+000,
    -2.148000e-001,
    1.109081e+000,
    2.661209e-001,
    -5.008111e+000,
    6.333048e-001,
    9.274718e-002,
    2.494529e+000,
    5.890657e-001,
    // albedo 1, turbidity 4
    -1.389611e+000,
    -5.579886e-001,
    -1.045229e+001,
    1.092342e+001,
    -2.282772e-002,
    4.054079e-001,
    2.781558e-003,
    2.578484e+000,
    5.372706e-001,
    -1.893851e+000,
    -1.116122e+000,
    2.111553e+000,
    -8.775468e-001,
    -5.640158e-002,
    5.399894e-001,
    1.929352e-002,
    -5.585557e-002,
    2.870402e-001,
    -7.015617e-001,
    1.884526e-001,
    -1.660273e-001,
    -8.785899e-001,
    -5.471987e-002,
    1.787856e-001,
    -9.958870e-002,
    7.207213e+000,
    1.277933e+000,
    -1.279075e+000,
    -4.794032e-001,
    9.037342e-001,
    6.225399e-001,
    -6.592270e-001,
    9.474313e-001,
    2.524811e-001,
    -2.485658e+000,
    2.050401e-001,
    -9.744212e-001,
    -9.899254e-002,
    9.474600e-001,
    -2.536639e-001,
    5.390432e-001,
    -8.465488e-002,
    -3.140532e-002,
    4.512343e+000,
    8.530654e-001,
    -1.093264e+000,
    -2.115594e-001,
    9.876876e-001,
    7.531309e-002,
    -5.003648e+000,
    6.719560e-001,
    1.111699e-001,
    2.412349e+000,
    6.482966e-001,
    // albedo 1, turbidity 5
    -1.410458e+000,
    -5.905263e-001,
    -4.146328e+001,
    4.190254e+001,
    -5.607421e-003,
    4.437719e-001,
    -1.948391e-006,
    2.496743e+000,
    5.031933e-001,
    -1.817258e+000,
    -9.848495e-001,
    1.089217e+001,
    -1.028029e+001,
    -1.221684e-002,
    3.317008e-001,
    5.060062e-002,
    1.198443e+000,
    4.449482e-001,
    -8.920534e-001,
    -8.835804e-002,
    -2.111594e+000,
    2.083599e+000,
    -1.507800e-002,
    6.993567e-001,
    -1.987686e-001,
    4.793539e+000,
    1.072586e+000,
    -1.048633e+000,
    -1.110825e-001,
    5.438710e-001,
    -6.707296e-001,
    -1.825365e-001,
    2.307221e-001,
    4.056218e-001,
    1.886912e+000,
    3.579576e-001,
    -1.094223e+000,
    -3.084727e-001,
    9.739595e-001,
    3.972140e-001,
    1.511647e-001,
    2.788218e-001,
    -6.279180e-002,
    1.866444e+000,
    7.995203e-001,
    -1.078162e+000,
    -2.176197e-001,
    1.088756e+000,
    4.329413e-001,
    -3.209490e+000,
    8.364785e-001,
    7.689785e-002,
    1.943182e+000,
    7.150615e-001,
    // albedo 1, turbidity 6
    -1.455846e+000,
    -6.322333e-001,
    -1.618289e+001,
    1.656258e+001,
    -1.280603e-002,
    4.130359e-001,
    -9.061644e-007,
    2.461391e+000,
    5.315915e-001,
    -2.222251e+000,
    -1.233356e+000,
    -1.454954e+000,
    1.957432e+000,
    -1.730555e-002,
    2.418496e-001,
    7.240262e-002,
    1.061939e+000,
    3.148474e-001,
    -4.536196e-001,
    1.457295e-001,
    2.483934e+000,
    -2.244550e+000,
    -4.593767e-002,
    8.967621e-001,
    -2.712877e-001,
    4.732142e+000,
    1.188839e+000,
    -1.277343e+000,
    -2.046024e-001,
    -1.229720e+000,
    3.977256e-001,
    -2.209195e-001,
    6.033235e-002,
    5.267707e-001,
    2.536445e+000,
    2.759606e-001,
    -1.029833e+000,
    -2.979843e-001,
    8.742883e-001,
    1.037710e+000,
    1.350257e-001,
    4.066094e-001,
    -1.376375e-001,
    1.500753e+000,
    8.676699e-001,
    -1.095935e+000,
    -2.211775e-001,
    9.320585e-001,
    8.955212e-002,
    -1.113388e+000,
    7.909911e-001,
    1.393848e-001,
    2.057146e+000,
    6.699739e-001,
    // albedo 1, turbidity 7
    -1.571831e+000,
    -7.466353e-001,
    -1.226063e+001,
    1.265995e+001,
    -1.514083e-002,
    3.639653e-001,
    -2.504287e-006,
    2.204454e+000,
    5.468861e-001,
    -2.235398e+000,
    -1.371434e+000,
    1.787996e+000,
    -1.073965e+000,
    -2.503530e-002,
    2.143584e-001,
    7.703453e-002,
    5.207181e-001,
    2.714312e-001,
    -6.944677e-001,
    -7.243136e-002,
    -6.193104e-001,
    9.567440e-001,
    -6.317194e-002,
    8.881508e-001,
    -2.783301e-001,
    4.224532e+000,
    1.192802e+000,
    -1.133391e+000,
    -9.811942e-002,
    2.312721e-001,
    -1.100585e+000,
    -3.655097e-001,
    2.268787e-003,
    5.074358e-001,
    1.512457e+000,
    3.165593e-001,
    -1.057051e+000,
    -3.424797e-001,
    9.536822e-001,
    1.034064e+000,
    6.413292e-001,
    1.165363e-001,
    -4.248128e-002,
    1.592803e+000,
    7.875911e-001,
    -1.096695e+000,
    -2.745143e-001,
    1.077920e+000,
    -8.435082e-004,
    -3.715956e+000,
    5.197900e-001,
    1.171467e-001,
    1.236912e+000,
    6.915287e-001,
    // albedo 1, turbidity 8
    -1.711623e+000,
    -9.023881e-001,
    -9.799257e+000,
    1.022040e+001,
    -1.708447e-002,
    3.309925e-001,
    -3.241111e-006,
    1.932295e+000,
    5.844205e-001,
    -2.351937e+000,
    -1.340391e+000,
    6.329976e+000,
    -6.054139e+000,
    -2.843868e-002,
    2.298301e-001,
    7.698142e-002,
    1.109800e+000,
    1.863187e-001,
    -1.141314e+000,
    -6.670322e-001,
    -3.262632e+000,
    4.551521e+000,
    -8.614941e-002,
    8.058038e-001,
    -2.791051e-001,
    3.084281e+000,
    1.236638e+000,
    -7.950557e-001,
    2.489854e-001,
    9.966347e-001,
    -3.391737e+000,
    -7.235716e-001,
    -2.155609e-001,
    5.126659e-001,
    1.452322e+000,
    2.882812e-001,
    -1.182289e+000,
    -5.192524e-001,
    9.672941e-001,
    3.091448e+000,
    -4.193043e+000,
    4.051469e-001,
    -5.708309e-002,
    9.386723e-001,
    8.208828e-001,
    -1.080579e+000,
    -2.918654e-001,
    9.499317e-001,
    2.856082e+000,
    -2.256007e+000,
    1.377750e-002,
    1.012914e-001,
    9.716489e-001,
    6.832750e-001,
    // albedo 1, turbidity 9
    -1.964781e+000,
    -1.162652e+000,
    -6.074737e+000,
    6.497797e+000,
    -2.595660e-002,
    3.222936e-001,
    -3.220871e-006,
    1.685891e+000,
    6.501551e-001,
    -2.352213e+000,
    -1.199539e+000,
    4.248376e+000,
    -3.876965e+000,
    -6.837923e-002,
    1.764412e-001,
    5.514810e-002,
    1.442736e+000,
    6.979575e-002,
    -2.560247e+000,
    -1.883591e+000,
    -1.916723e+000,
    2.598994e+000,
    -2.372381e-002,
    8.442578e-001,
    -2.063113e-001,
    2.359942e+000,
    1.287838e+000,
    7.281064e-002,
    7.835433e-001,
    1.380748e-001,
    -2.065580e+000,
    -1.696648e+000,
    -4.575316e-001,
    3.840004e-001,
    9.397056e-001,
    3.103904e-001,
    -1.444446e+000,
    -7.662151e-001,
    1.364103e+000,
    4.930232e+000,
    -4.455564e+000,
    6.735458e-001,
    -4.052978e-003,
    3.194173e-001,
    7.842959e-001,
    -1.039666e+000,
    -3.171617e-001,
    7.295920e-001,
    2.813846e+000,
    -1.561230e+000,
    -4.128303e-001,
    1.004149e-001,
    6.653613e-001,
    6.980277e-001,
    // albedo 1, turbidity 10
    -2.999915e+000,
    -1.721740e+000,
    -4.796494e+000,
    5.021888e+000,
    -2.163250e-002,
    3.309183e-001,
    -4.051804e-006,
    1.645464e+000,
    7.145890e-001,
    -1.673162e+000,
    -1.056666e+000,
    3.209766e+000,
    -2.559187e+000,
    -7.456364e-002,
    6.215063e-002,
    4.469425e-002,
    1.242757e+000,
    -1.580590e-002,
    -5.775475e+000,
    -3.239700e+000,
    -1.356432e+000,
    1.099950e+000,
    -9.497509e-002,
    7.121875e-001,
    -1.656838e-001,
    2.553396e+000,
    1.286227e+000,
    1.241869e+000,
    6.671222e-001,
    -4.156007e-001,
    -8.167921e-001,
    -1.037816e+000,
    5.950065e-002,
    3.114868e-001,
    6.414114e-001,
    3.677503e-001,
    -1.580126e+000,
    -7.852349e-001,
    1.749569e+000,
    5.987990e+000,
    -5.075133e+000,
    -4.693815e-002,
    -5.106759e-002,
    -9.755925e-001,
    7.440092e-001,
    -9.732917e-001,
    -1.939297e-001,
    2.709367e-001,
    1.352990e+000,
    -9.040352e-001,
    5.181217e-003,
    2.302437e-001,
    1.506500e+000,
    6.840186e-001,
};

double datasetRad440[] =
{
    // albedo 0, turbidity 1
    9.406889e-003,
    1.954373e-002,
    -4.018205e-002,
    1.740051e-001,
    1.351020e-001,
    1.365376e-001,
    // albedo 0, turbidity 2
    9.206049e-003,
    2.042313e-002,
    -4.377380e-002,
    1.787089e-001,
    1.388614e-001,
    1.384128e-001,
    // albedo 0, turbidity 3
    9.050889e-003,
    2.086396e-002,
    -4.652916e-002,
    1.794829e-001,
    1.524222e-001,
    1.376563e-001,
    // albedo 0, turbidity 4
    8.656343e-003,
    2.210653e-002,
    -5.212791e-002,
    1.836315e-001,
    1.663040e-001,
    1.419649e-001,
    // albedo 0, turbidity 5
    8.355466e-003,
    2.244975e-002,
    -5.393078e-002,
    1.788056e-001,
    1.868417e-001,
    1.445069e-001,
    // albedo 0, turbidity 6
    8.187585e-003,
    2.235434e-002,
    -5.291187e-002,
    1.693688e-001,
    2.073941e-001,
    1.424517e-001,
    // albedo 0, turbidity 7
    7.909229e-003,
    2.199365e-002,
    -5.165975e-002,
    1.577725e-001,
    2.297489e-001,
    1.468516e-001,
    // albedo 0, turbidity 8
    7.580566e-003,
    2.048421e-002,
    -4.471863e-002,
    1.277026e-001,
    2.737620e-001,
    1.497600e-001,
    // albedo 0, turbidity 9
    7.101943e-003,
    1.675094e-002,
    -2.761544e-002,
    7.078506e-002,
    3.397147e-001,
    1.557184e-001,
    // albedo 0, turbidity 10
    6.525444e-003,
    1.090411e-002,
    -1.995302e-003,
    -8.176097e-003,
    4.124321e-001,
    1.714881e-001,
    // albedo 1, turbidity 1
    1.111702e-002,
    1.783998e-002,
    -1.949635e-002,
    1.124970e-001,
    2.993330e-001,
    2.864943e-001,
    // albedo 1, turbidity 2
    1.099681e-002,
    1.809609e-002,
    -2.099087e-002,
    1.131858e-001,
    3.057413e-001,
    2.866962e-001,
    // albedo 1, turbidity 3
    1.070017e-002,
    1.818573e-002,
    -2.159895e-002,
    1.084494e-001,
    3.229180e-001,
    2.835407e-001,
    // albedo 1, turbidity 4
    1.032234e-002,
    1.871074e-002,
    -2.469404e-002,
    1.069731e-001,
    3.380450e-001,
    2.864479e-001,
    // albedo 1, turbidity 5
    9.893912e-003,
    1.844953e-002,
    -2.358500e-002,
    9.439551e-002,
    3.642566e-001,
    2.829554e-001,
    // albedo 1, turbidity 6
    9.650400e-003,
    1.877062e-002,
    -2.542361e-002,
    9.189004e-002,
    3.720610e-001,
    2.856265e-001,
    // albedo 1, turbidity 7
    9.322628e-003,
    1.810055e-002,
    -2.246559e-002,
    7.543314e-002,
    3.958251e-001,
    2.842134e-001,
    // albedo 1, turbidity 8
    8.842659e-003,
    1.604245e-002,
    -1.397353e-002,
    4.233011e-002,
    4.358270e-001,
    2.789888e-001,
    // albedo 1, turbidity 9
    8.169168e-003,
    1.265551e-002,
    4.076399e-004,
    -7.877623e-003,
    4.830048e-001,
    2.768485e-001,
    // albedo 1, turbidity 10
    7.383449e-003,
    7.340131e-003,
    2.094279e-002,
    -7.138907e-002,
    5.217098e-001,
    2.803810e-001,
};

double dataset480[] =
{
    // albedo 0, turbidity 1
    -1.255072e+000,
    -3.501170e-001,
    -5.952795e+000,
    6.529723e+000,
    -6.362962e-002,
    6.436422e-001,
    7.745270e-003,
    3.657426e+000,
    5.329375e-001,
    -1.344988e+000,
    -4.365880e-001,
    -1.750961e+000,
    2.262943e+000,
    -1.049983e-001,
    3.754288e-001,
    5.298712e-002,
    3.402851e+000,
    3.874229e-001,
    -1.073402e+000,
    -1.395260e-001,
    2.839003e+000,
    -2.827315e+000,
    -1.882090e-001,
    1.054349e+000,
    -8.976330e-002,
    5.604794e+000,
    6.740510e-001,
    -1.183711e+000,
    -4.011868e-001,
    7.358740e-001,
    1.479436e+000,
    -7.268596e-001,
    1.133998e+000,
    1.205942e-001,
    -4.232970e+000,
    1.060586e+000,
    -1.018668e+000,
    -8.561816e-002,
    1.030241e+000,
    -4.461392e-001,
    3.940284e-001,
    1.220382e+000,
    -1.391238e-001,
    5.771847e+000,
    5.627180e-001,
    -1.080081e+000,
    -1.746769e-001,
    1.174843e+000,
    9.389450e-002,
    -4.893194e+000,
    1.162505e+000,
    1.563406e-001,
    2.606800e+000,
    4.999990e-001,
    // albedo 0, turbidity 2
    -1.268430e+000,
    -3.752425e-001,
    -8.504068e+000,
    9.021017e+000,
    -4.092613e-002,
    6.553965e-001,
    8.607147e-003,
    3.444138e+000,
    5.600385e-001,
    -1.459780e+000,
    -5.882818e-001,
    1.800729e+000,
    -9.674514e-001,
    -8.308819e-002,
    4.453337e-001,
    4.086836e-002,
    1.853978e+000,
    2.818975e-001,
    -8.680288e-001,
    1.148721e-001,
    3.161508e-001,
    -1.524870e+000,
    -1.921031e-001,
    6.496299e-001,
    4.422347e-004,
    8.241268e+000,
    9.821338e-001,
    -1.277439e+000,
    -4.550135e-001,
    1.088681e+000,
    1.552370e+000,
    -6.184442e-001,
    1.386667e+000,
    1.035135e-001,
    -3.331179e+000,
    5.236122e-001,
    -9.964896e-001,
    -9.832891e-002,
    9.746026e-001,
    -9.125638e-001,
    -7.457170e-001,
    9.111352e-001,
    -7.027011e-002,
    4.669829e+000,
    7.455938e-001,
    -1.083449e+000,
    -1.686372e-001,
    1.003727e+000,
    4.085513e-001,
    -4.725304e+000,
    1.112591e+000,
    1.855240e-001,
    3.038195e+000,
    5.969305e-001,
    // albedo 0, turbidity 3
    -1.290677e+000,
    -3.901158e-001,
    -9.520695e+000,
    9.828711e+000,
    -3.154131e-002,
    5.939314e-001,
    2.686840e-002,
    3.612397e+000,
    5.140176e-001,
    -1.535002e+000,
    -6.667464e-001,
    2.735758e-002,
    9.423936e-001,
    -8.287240e-002,
    6.775029e-001,
    4.575744e-003,
    1.432097e+000,
    3.872415e-001,
    -7.903104e-001,
    1.563438e-001,
    -2.022567e-001,
    -1.026670e+000,
    9.063977e-003,
    3.942033e-001,
    -1.241980e-002,
    7.980026e+000,
    1.066191e+000,
    -1.278947e+000,
    -3.694875e-001,
    8.111792e-001,
    4.993027e-001,
    -1.096772e+000,
    1.008837e+000,
    2.920972e-001,
    -7.314209e-001,
    3.179440e-001,
    -1.006667e+000,
    -1.519095e-001,
    8.774664e-001,
    -1.909283e-001,
    3.756189e+000,
    9.311862e-001,
    -9.327427e-002,
    3.499747e+000,
    8.574583e-001,
    -1.086931e+000,
    -1.774734e-001,
    8.989024e-001,
    5.536469e-002,
    -3.474034e+000,
    9.736834e-001,
    2.325787e-001,
    2.809427e+000,
    6.246481e-001,
    // albedo 0, turbidity 4
    -1.346571e+000,
    -4.451276e-001,
    -2.373159e+001,
    2.408962e+001,
    -1.225268e-002,
    5.720568e-001,
    1.636363e-002,
    3.288957e+000,
    5.104502e-001,
    -1.607315e+000,
    -7.416360e-001,
    -5.233286e-001,
    1.169215e+000,
    -2.350907e-002,
    4.942922e-001,
    3.544231e-002,
    1.659598e+000,
    3.959771e-001,
    -8.259129e-001,
    9.305732e-002,
    4.864320e+000,
    -5.585537e+000,
    -4.428624e-002,
    7.540493e-001,
    -1.060506e-001,
    6.548781e+000,
    1.138009e+000,
    -1.204471e+000,
    -2.620580e-001,
    -2.637261e+000,
    3.057335e+000,
    -1.226916e-001,
    5.657925e-001,
    4.446409e-001,
    1.136957e+000,
    2.881385e-001,
    -1.035718e+000,
    -2.116415e-001,
    1.288642e+000,
    -3.834162e-001,
    -9.488050e-002,
    7.404996e-001,
    -6.538922e-002,
    2.336877e+000,
    8.612030e-001,
    -1.087946e+000,
    -1.841898e-001,
    4.491757e-001,
    1.691479e-001,
    1.022577e-001,
    9.202996e-001,
    2.926112e-001,
    2.844475e+000,
    6.452620e-001,
    // albedo 0, turbidity 5
    -1.381782e+000,
    -4.914069e-001,
    -4.813999e+001,
    4.837634e+001,
    -5.296025e-003,
    5.571609e-001,
    1.649034e-002,
    3.203385e+000,
    5.048069e-001,
    -1.776157e+000,
    -9.226583e-001,
    1.389662e+001,
    -1.292490e+001,
    -1.480095e-002,
    5.073308e-001,
    4.585849e-002,
    7.385206e-001,
    4.280887e-001,
    -8.381948e-001,
    1.229315e-001,
    -3.370527e+000,
    1.825510e+000,
    -9.728251e-003,
    8.572929e-001,
    -1.855299e-001,
    7.471741e+000,
    1.133190e+000,
    -1.125194e+000,
    -2.647028e-001,
    6.942391e-001,
    1.389102e+000,
    -2.216447e-001,
    1.356485e-001,
    5.812792e-001,
    -5.073865e-001,
    2.675490e-001,
    -1.095144e+000,
    -2.442208e-001,
    4.787687e-001,
    -2.707940e+000,
    6.129627e-001,
    7.213058e-001,
    -6.034254e-002,
    2.798703e+000,
    8.787214e-001,
    -1.062019e+000,
    -1.765309e-001,
    5.423897e-001,
    3.783099e+000,
    -5.007038e+000,
    7.376299e-001,
    3.034085e-001,
    2.733411e+000,
    6.555070e-001,
    // albedo 0, turbidity 6
    -1.390263e+000,
    -5.185474e-001,
    -1.630741e+001,
    1.654109e+001,
    -1.499201e-002,
    5.661787e-001,
    1.452544e-002,
    3.046179e+000,
    5.026700e-001,
    -1.935801e+000,
    -9.953289e-001,
    -1.483271e+000,
    1.913745e+000,
    -2.518160e-002,
    4.593343e-001,
    4.285617e-002,
    1.448437e+000,
    4.509310e-001,
    -7.547378e-001,
    2.590987e-002,
    2.480507e+000,
    -2.271835e+000,
    -5.259620e-002,
    9.001709e-001,
    -2.024986e-001,
    4.958191e+000,
    1.036940e+000,
    -1.157324e+000,
    -1.198742e-001,
    -1.440574e+000,
    3.070751e-001,
    -1.807577e-001,
    4.059237e-002,
    6.210184e-001,
    2.425946e+000,
    3.828327e-001,
    -1.065566e+000,
    -3.139616e-001,
    5.715306e-001,
    8.053761e-001,
    1.396364e-001,
    4.009778e-001,
    5.681033e-003,
    1.354013e+000,
    7.861375e-001,
    -1.095972e+000,
    -2.178745e-001,
    4.681537e-001,
    1.235458e-001,
    -1.084613e+000,
    1.006455e+000,
    2.754677e-001,
    2.239616e+000,
    6.954839e-001,
    // albedo 0, turbidity 7
    -1.453150e+000,
    -5.790574e-001,
    -1.243832e+001,
    1.263425e+001,
    -1.892784e-002,
    4.979177e-001,
    1.035899e-002,
    2.982682e+000,
    5.056256e-001,
    -1.925518e+000,
    -1.010928e+000,
    1.513827e+000,
    -9.219873e-001,
    -3.776925e-002,
    4.692652e-001,
    4.083023e-002,
    1.303495e+000,
    4.245150e-001,
    -1.134311e+000,
    -2.754710e-001,
    -2.443212e-001,
    3.845396e-002,
    -1.074645e-001,
    1.066657e+000,
    -2.324557e-001,
    4.996897e+000,
    1.052268e+000,
    -8.094396e-001,
    1.096826e-001,
    -5.117072e-001,
    -1.915992e-001,
    -1.991693e-001,
    -5.943341e-001,
    6.791986e-001,
    1.332014e+000,
    3.606306e-001,
    -1.227889e+000,
    -4.522793e-001,
    5.338266e-002,
    1.074118e+000,
    8.733709e-002,
    1.005448e+000,
    -1.725176e-002,
    1.326110e+000,
    8.063751e-001,
    -1.065450e+000,
    -2.160134e-001,
    3.413994e-001,
    4.950303e-001,
    -1.077199e+000,
    3.654185e-001,
    3.125819e-001,
    1.998536e+000,
    6.865917e-001,
    // albedo 0, turbidity 8
    -1.594869e+000,
    -7.366760e-001,
    -1.252117e+001,
    1.275030e+001,
    -1.697659e-002,
    4.892543e-001,
    2.831848e-003,
    2.542039e+000,
    5.457358e-001,
    -1.980952e+000,
    -9.910920e-001,
    6.178699e+000,
    -5.888582e+000,
    -3.099336e-002,
    3.859266e-001,
    4.511764e-002,
    1.839601e+000,
    2.791527e-001,
    -1.766081e+000,
    -8.995150e-001,
    -2.712687e+000,
    3.263201e+000,
    -1.840688e-001,
    1.305410e+000,
    -2.675879e-001,
    3.647246e+000,
    1.168203e+000,
    -3.742071e-001,
    4.678023e-001,
    6.371403e-002,
    -2.016941e+000,
    -2.723239e-001,
    -1.446876e+000,
    7.533604e-001,
    1.131760e+000,
    2.537537e-001,
    -1.380378e+000,
    -6.406403e-001,
    7.018678e-001,
    2.032023e+000,
    -2.393487e+000,
    1.930827e+000,
    -1.260608e-001,
    7.634327e-001,
    8.870918e-001,
    -1.088465e+000,
    -2.971190e-001,
    1.411657e-001,
    1.879601e+000,
    -1.310304e+000,
    -7.045740e-001,
    3.313185e-001,
    1.264266e+000,
    6.534482e-001,
    // albedo 0, turbidity 9
    -2.229949e+000,
    -1.153733e+000,
    -7.505783e+000,
    7.718722e+000,
    -2.407129e-002,
    4.175820e-001,
    4.559186e-005,
    2.157318e+000,
    6.337774e-001,
    -1.995509e+000,
    -8.778717e-001,
    4.191031e+000,
    -3.968507e+000,
    -5.176872e-002,
    1.960357e-001,
    3.755797e-002,
    1.975436e+000,
    1.077053e-001,
    -3.174785e+000,
    -2.105130e+000,
    -2.062230e+000,
    2.391786e+000,
    -4.217147e-002,
    9.727297e-001,
    -1.540078e-001,
    2.691773e+000,
    1.235189e+000,
    4.882832e-001,
    1.097365e+000,
    -1.866214e-001,
    -1.567231e+000,
    -1.216396e+000,
    -4.391280e-001,
    4.541998e-001,
    1.167636e+000,
    3.003642e-001,
    -1.709118e+000,
    -9.374505e-001,
    6.559000e-001,
    3.977860e+000,
    -3.525762e+000,
    6.202828e-001,
    7.863257e-002,
    6.882512e-001,
    8.161696e-001,
    -9.999977e-001,
    -2.777886e-001,
    9.586687e-003,
    1.766813e+000,
    -1.065121e+000,
    -1.325963e-001,
    2.512239e-001,
    1.055043e+000,
    6.874661e-001,
    // albedo 0, turbidity 10
    -2.932652e+000,
    -1.609416e+000,
    -3.825171e+000,
    3.969752e+000,
    -3.638195e-002,
    3.557402e-001,
    -4.379735e-006,
    1.927804e+000,
    7.278380e-001,
    -1.591732e+000,
    -7.579896e-001,
    1.711976e+000,
    -1.369988e+000,
    -1.107557e-001,
    1.237841e-001,
    1.548121e-002,
    2.024749e+000,
    -4.315379e-002,
    -6.085760e+000,
    -3.429651e+000,
    -6.780006e-001,
    -1.902709e-002,
    6.566034e-002,
    8.329946e-001,
    -1.012845e-001,
    2.617589e+000,
    1.342663e+000,
    1.335204e+000,
    1.035931e+000,
    -1.008915e+000,
    5.915758e-001,
    -1.907371e+000,
    -3.568938e-002,
    3.295382e-001,
    6.546480e-001,
    2.435447e-001,
    -1.800155e+000,
    -1.010684e+000,
    1.160290e+000,
    5.269190e+000,
    -3.895543e+000,
    5.274946e-002,
    3.971324e-002,
    8.769492e-002,
    8.252336e-001,
    -9.843476e-001,
    -3.014031e-001,
    -3.167912e-001,
    1.384556e+000,
    -6.881572e-001,
    5.617519e-002,
    2.805263e-001,
    9.930291e-001,
    6.783964e-001,
    // albedo 1, turbidity 1
    -1.257325e+000,
    -3.441598e-001,
    -5.951667e+000,
    6.530618e+000,
    -5.773033e-002,
    6.437990e-001,
    8.453838e-003,
    3.657343e+000,
    5.329715e-001,
    -1.346061e+000,
    -4.331978e-001,
    -1.749638e+000,
    2.263845e+000,
    -1.013807e-001,
    3.755084e-001,
    5.287214e-002,
    3.402954e+000,
    3.874047e-001,
    -1.073983e+000,
    -1.372222e-001,
    2.840388e+000,
    -2.826616e+000,
    -1.866609e-001,
    1.054193e+000,
    -8.989038e-002,
    5.604984e+000,
    6.739811e-001,
    -1.184707e+000,
    -3.992543e-001,
    7.374377e-001,
    1.479838e+000,
    -7.263903e-001,
    1.133619e+000,
    1.199206e-001,
    -4.232702e+000,
    1.060412e+000,
    -1.021623e+000,
    -8.422241e-002,
    1.032293e+000,
    -4.460168e-001,
    3.941239e-001,
    1.219939e+000,
    -1.420884e-001,
    5.772239e+000,
    5.623142e-001,
    -1.087791e+000,
    -1.754873e-001,
    1.178006e+000,
    9.386850e-002,
    -4.893184e+000,
    1.162164e+000,
    1.535543e-001,
    2.607460e+000,
    4.997706e-001,
    // albedo 1, turbidity 2
    -1.251295e+000,
    -3.651612e-001,
    -9.950987e+000,
    1.058444e+001,
    -3.065334e-002,
    5.979560e-001,
    1.817303e-002,
    3.132460e+000,
    5.458738e-001,
    -1.374134e+000,
    -5.079738e-001,
    2.333109e+000,
    -1.251359e+000,
    -7.802080e-002,
    3.182768e-001,
    3.746599e-002,
    1.963940e+000,
    2.733180e-001,
    -9.862389e-001,
    -2.441831e-002,
    2.657376e-001,
    -1.054016e+000,
    -8.576871e-002,
    7.356127e-001,
    -4.711349e-002,
    6.677884e+000,
    1.206629e+000,
    -1.140461e+000,
    -3.212487e-001,
    1.547332e+000,
    9.031281e-001,
    -8.421239e-001,
    1.166595e+000,
    1.643076e-001,
    -2.534096e+000,
    1.884034e-001,
    -1.049493e+000,
    -1.256523e-001,
    1.205849e+000,
    -3.649526e-001,
    8.075413e-001,
    3.421308e-001,
    -1.173508e-001,
    4.535809e+000,
    9.497555e-001,
    -1.063961e+000,
    -1.336751e-001,
    1.173271e+000,
    1.016777e-001,
    -4.093576e+000,
    4.559998e-001,
    1.519017e-001,
    4.153208e+000,
    5.324846e-001,
    // albedo 1, turbidity 3
    -1.271751e+000,
    -3.837936e-001,
    -1.052025e+001,
    1.102826e+001,
    -2.411879e-002,
    5.019991e-001,
    3.094786e-002,
    3.138107e+000,
    5.059631e-001,
    -1.472034e+000,
    -6.259760e-001,
    -5.356154e-001,
    1.713500e+000,
    -6.089970e-002,
    4.750716e-001,
    6.622428e-003,
    1.224931e+000,
    4.198087e-001,
    -8.587401e-001,
    1.099859e-001,
    3.258521e-001,
    -1.301658e+000,
    -4.452458e-002,
    6.461336e-001,
    -2.947489e-002,
    7.603712e+000,
    1.091511e+000,
    -1.221875e+000,
    -3.659269e-001,
    9.953072e-001,
    8.481237e-001,
    -5.952235e-001,
    1.016442e+000,
    2.259940e-001,
    -1.925411e+000,
    3.654292e-001,
    -1.008105e+000,
    -1.136472e-001,
    1.248935e+000,
    -3.865165e-001,
    1.714619e+000,
    -1.216223e-001,
    -2.436842e-002,
    4.227455e+000,
    7.030495e-001,
    -1.082262e+000,
    -1.513279e-001,
    1.052383e+000,
    2.125686e-001,
    -5.028093e-001,
    8.694047e-001,
    1.099128e-001,
    3.634467e+000,
    7.206727e-001,
    // albedo 1, turbidity 4
    -1.310438e+000,
    -4.332417e-001,
    -2.812457e+001,
    2.859054e+001,
    -7.241887e-003,
    4.123186e-001,
    2.839263e-002,
    2.866138e+000,
    5.063521e-001,
    -1.598864e+000,
    -7.787419e-001,
    4.189377e+000,
    -3.122921e+000,
    -1.896105e-002,
    6.071985e-001,
    1.999660e-002,
    7.039076e-001,
    4.125456e-001,
    -7.834866e-001,
    1.890740e-001,
    1.102853e+000,
    -1.842558e+000,
    -3.985000e-002,
    6.423282e-001,
    -1.131231e-001,
    7.222493e+000,
    1.177285e+000,
    -1.244910e+000,
    -3.668018e-001,
    -2.083168e-001,
    1.051092e+000,
    -1.483362e-001,
    4.066210e-001,
    4.623360e-001,
    -1.971682e-001,
    2.178890e-001,
    -1.010078e+000,
    -1.593623e-001,
    1.747411e+000,
    -6.961852e-002,
    -1.503091e-001,
    5.439839e-001,
    -1.874287e-001,
    2.074758e+000,
    9.133302e-001,
    -1.086611e+000,
    -1.529597e-001,
    4.548984e-001,
    2.836062e-001,
    4.168066e-001,
    3.953841e-001,
    2.451427e-001,
    3.799065e+000,
    6.288711e-001,
    // albedo 1, turbidity 5
    -1.338369e+000,
    -4.683873e-001,
    -3.858110e+001,
    3.898823e+001,
    -5.111812e-003,
    4.638476e-001,
    2.389163e-002,
    2.774207e+000,
    5.242274e-001,
    -1.785780e+000,
    -9.773633e-001,
    6.470331e+000,
    -5.147348e+000,
    -1.593592e-002,
    4.175720e-001,
    2.497956e-002,
    7.090702e-002,
    3.252744e-001,
    -6.972735e-001,
    2.786524e-001,
    4.011350e-003,
    -1.686706e+000,
    -4.966516e-003,
    8.368703e-001,
    -1.225606e-001,
    7.731542e+000,
    1.267577e+000,
    -1.307129e+000,
    -4.728119e-001,
    2.639424e-002,
    2.633155e+000,
    -2.357439e-001,
    1.263362e-001,
    4.765765e-001,
    -2.025027e+000,
    1.705113e-001,
    -9.583414e-001,
    -7.928834e-002,
    1.447497e+000,
    -2.797571e+000,
    8.553597e-001,
    4.842942e-001,
    -7.727878e-002,
    3.765006e+000,
    9.191738e-001,
    -1.114040e+000,
    -2.132678e-001,
    1.030931e+000,
    2.871507e+000,
    -5.013319e+000,
    2.699945e-001,
    1.819978e-001,
    2.239642e+000,
    6.539653e-001,
    // albedo 1, turbidity 6
    -1.393024e+000,
    -5.200008e-001,
    -1.941271e+001,
    1.986171e+001,
    -1.212818e-002,
    5.019138e-001,
    7.897163e-003,
    2.696459e+000,
    5.258316e-001,
    -1.831466e+000,
    -1.018106e+000,
    3.204932e+000,
    -2.139369e+000,
    -2.441969e-002,
    3.191029e-001,
    5.563321e-002,
    1.320760e-001,
    3.265220e-001,
    -7.994553e-001,
    1.337239e-001,
    -1.563712e+000,
    7.392042e-001,
    -3.136373e-002,
    1.008208e+000,
    -1.988762e-001,
    6.626579e+000,
    1.223213e+000,
    -1.159543e+000,
    -2.836180e-001,
    1.057464e+000,
    -3.647533e-001,
    -2.513115e-001,
    -1.995636e-001,
    5.943224e-001,
    -4.865436e-001,
    2.279895e-001,
    -1.044528e+000,
    -2.152538e-001,
    1.023157e+000,
    5.599579e-002,
    6.321805e-001,
    5.155639e-001,
    -1.111252e-001,
    2.282270e+000,
    8.647371e-001,
    -1.092518e+000,
    -1.865821e-001,
    1.057856e+000,
    3.491427e-001,
    -2.631526e+000,
    3.584288e-001,
    2.191649e-001,
    2.389704e+000,
    6.765946e-001,
    // albedo 1, turbidity 7
    -1.384989e+000,
    -5.305700e-001,
    -1.459855e+001,
    1.497673e+001,
    -1.471976e-002,
    4.569028e-001,
    5.419006e-003,
    2.735360e+000,
    5.389891e-001,
    -2.086660e+000,
    -1.234696e+000,
    2.053196e+000,
    -1.257012e+000,
    -2.129117e-002,
    1.990309e-001,
    8.511032e-002,
    -1.312659e-001,
    2.800139e-001,
    -7.309069e-001,
    1.413931e-001,
    -1.773938e-001,
    2.938820e-001,
    -4.933601e-002,
    1.496853e+000,
    -3.213358e-001,
    6.305852e+000,
    1.298086e+000,
    -1.203529e+000,
    -3.216432e-001,
    -1.458970e-001,
    -5.598789e-001,
    -2.934068e-001,
    -1.206192e+000,
    7.793654e-001,
    -9.223710e-001,
    1.229360e-001,
    -1.002538e+000,
    -1.984480e-001,
    1.233954e+000,
    8.779171e-001,
    3.133737e-001,
    1.311239e+000,
    -2.132532e-001,
    2.223702e+000,
    9.461065e-001,
    -1.123572e+000,
    -2.342682e-001,
    9.679089e-001,
    -1.017991e-003,
    -1.960819e+000,
    -1.153680e-001,
    2.843114e-001,
    1.779831e+000,
    6.400916e-001,
    // albedo 1, turbidity 8
    -1.537393e+000,
    -6.924151e-001,
    -1.239252e+001,
    1.285585e+001,
    -1.666284e-002,
    4.429862e-001,
    2.398230e-003,
    2.210714e+000,
    5.509453e-001,
    -1.817841e+000,
    -9.662082e-001,
    6.281905e+000,
    -5.778709e+000,
    -3.131226e-002,
    3.074609e-001,
    4.530074e-002,
    1.409838e+000,
    2.538213e-001,
    -1.790530e+000,
    -8.332867e-001,
    -2.605975e+000,
    3.383959e+000,
    -1.685493e-001,
    1.307568e+000,
    -2.569465e-001,
    3.272862e+000,
    1.247743e+000,
    -3.808658e-001,
    3.525732e-001,
    3.897535e-001,
    -2.085715e+000,
    -1.845614e-001,
    -1.470598e+000,
    7.033938e-001,
    8.475130e-001,
    1.758974e-001,
    -1.374360e+000,
    -5.517879e-001,
    1.276626e+000,
    1.821209e+000,
    -2.480880e+000,
    1.866494e+000,
    -1.649246e-001,
    6.333864e-001,
    9.339444e-001,
    -1.024167e+000,
    -2.097189e-001,
    8.424991e-001,
    1.767689e+000,
    -1.312031e+000,
    -8.191386e-001,
    2.156968e-001,
    1.201032e+000,
    6.593457e-001,
    // albedo 1, turbidity 9
    -2.190652e+000,
    -1.106580e+000,
    -7.466636e+000,
    7.752518e+000,
    -2.263662e-002,
    4.154878e-001,
    -1.646586e-006,
    2.076563e+000,
    6.322611e-001,
    -1.972368e+000,
    -8.108244e-001,
    4.233742e+000,
    -3.927321e+000,
    -5.152609e-002,
    2.005285e-001,
    2.985984e-002,
    1.903602e+000,
    1.099985e-001,
    -3.148093e+000,
    -2.033135e+000,
    -2.019650e+000,
    2.409779e+000,
    -1.255187e-002,
    9.697956e-001,
    -1.538080e-001,
    2.617071e+000,
    1.234755e+000,
    5.592882e-001,
    1.073057e+000,
    -2.763735e-002,
    -1.563728e+000,
    -1.191791e+000,
    -4.331798e-001,
    4.622361e-001,
    1.142664e+000,
    2.988891e-001,
    -1.706427e+000,
    -8.516236e-001,
    1.014996e+000,
    3.980336e+000,
    -3.487485e+000,
    6.331985e-001,
    -1.818380e-002,
    7.352340e-001,
    8.452629e-001,
    -1.006197e+000,
    -1.932306e-001,
    5.337019e-001,
    1.797637e+000,
    -9.474717e-001,
    -1.353274e-001,
    2.049954e-001,
    1.156100e+000,
    6.894153e-001,
    // albedo 1, turbidity 10
    -2.473813e+000,
    -1.478132e+000,
    -3.492210e+000,
    3.805303e+000,
    -3.251673e-002,
    3.621052e-001,
    -6.447770e-006,
    1.596383e+000,
    8.551930e-001,
    -1.494464e+000,
    -7.635918e-001,
    2.071212e+000,
    -1.536108e+000,
    -1.369345e-001,
    1.287259e-001,
    2.147844e-002,
    1.753080e+000,
    -2.246103e-001,
    -6.305007e+000,
    -3.323156e+000,
    -7.099379e-001,
    1.686111e-001,
    1.080881e-001,
    8.729732e-001,
    -1.291207e-001,
    2.282989e+000,
    1.475588e+000,
    1.325532e+000,
    5.765517e-001,
    -7.011257e-001,
    7.720216e-001,
    -2.013560e+000,
    -1.990572e-001,
    3.922685e-001,
    9.898769e-003,
    1.789360e-001,
    -1.590406e+000,
    -7.529646e-001,
    1.930414e+000,
    5.169169e+000,
    -4.221403e+000,
    4.614858e-002,
    -9.527005e-002,
    -7.894472e-001,
    8.458063e-001,
    -1.005785e+000,
    -2.286223e-001,
    3.330253e-001,
    1.438452e+000,
    -7.701349e-001,
    2.780764e-002,
    2.630698e-001,
    8.329894e-001,
    6.747408e-001,
};

double datasetRad480[] =
{
    // albedo 0, turbidity 1
    1.367487e-002,
    1.998477e-002,
    -2.747378e-002,
    2.012913e-001,
    1.065803e-001,
    1.249226e-001,
    // albedo 0, turbidity 2
    1.319623e-002,
    2.233282e-002,
    -3.838862e-002,
    2.216885e-001,
    1.032539e-001,
    1.308019e-001,
    // albedo 0, turbidity 3
    1.265118e-002,
    2.391819e-002,
    -4.721677e-002,
    2.352182e-001,
    1.174476e-001,
    1.303906e-001,
    // albedo 0, turbidity 4
    1.204726e-002,
    2.745130e-002,
    -6.437791e-002,
    2.605947e-001,
    1.298129e-001,
    1.378516e-001,
    // albedo 0, turbidity 5
    1.125691e-002,
    3.031033e-002,
    -7.856070e-002,
    2.797308e-001,
    1.411425e-001,
    1.486601e-001,
    // albedo 0, turbidity 6
    1.087451e-002,
    3.134174e-002,
    -8.308676e-002,
    2.793109e-001,
    1.610134e-001,
    1.502290e-001,
    // albedo 0, turbidity 7
    1.035757e-002,
    3.176437e-002,
    -8.486370e-002,
    2.674373e-001,
    1.974534e-001,
    1.533206e-001,
    // albedo 0, turbidity 8
    9.649434e-003,
    3.087937e-002,
    -8.067259e-002,
    2.353243e-001,
    2.553337e-001,
    1.608814e-001,
    // albedo 0, turbidity 9
    8.869346e-003,
    2.627497e-002,
    -5.891488e-002,
    1.570602e-001,
    3.504762e-001,
    1.724148e-001,
    // albedo 0, turbidity 10
    8.105360e-003,
    1.756907e-002,
    -2.001928e-002,
    3.536541e-002,
    4.692392e-001,
    1.926373e-001,
    // albedo 1, turbidity 1
    1.531497e-002,
    2.090118e-002,
    -1.665041e-002,
    1.626765e-001,
    2.602854e-001,
    2.739350e-001,
    // albedo 1, turbidity 2
    1.500055e-002,
    2.258405e-002,
    -2.517423e-002,
    1.780058e-001,
    2.604774e-001,
    2.803331e-001,
    // albedo 1, turbidity 3
    1.435727e-002,
    2.473634e-002,
    -3.651251e-002,
    1.966627e-001,
    2.645889e-001,
    2.894029e-001,
    // albedo 1, turbidity 4
    1.368791e-002,
    2.602874e-002,
    -4.462666e-002,
    2.008996e-001,
    2.978971e-001,
    2.872899e-001,
    // albedo 1, turbidity 5
    1.298035e-002,
    2.709110e-002,
    -5.084570e-002,
    2.010066e-001,
    3.257828e-001,
    2.917322e-001,
    // albedo 1, turbidity 6
    1.267531e-002,
    2.752851e-002,
    -5.364450e-002,
    1.962715e-001,
    3.472458e-001,
    2.928354e-001,
    // albedo 1, turbidity 7
    1.200196e-002,
    2.782022e-002,
    -5.449978e-002,
    1.818445e-001,
    3.795420e-001,
    2.974612e-001,
    // albedo 1, turbidity 8
    1.115769e-002,
    2.603247e-002,
    -4.606362e-002,
    1.383509e-001,
    4.427481e-001,
    2.969281e-001,
    // albedo 1, turbidity 9
    1.034375e-002,
    2.111036e-002,
    -2.502615e-002,
    6.215948e-002,
    5.253192e-001,
    2.999927e-001,
    // albedo 1, turbidity 10
    9.270257e-003,
    1.252950e-002,
    1.085115e-002,
    -5.004679e-002,
    6.169243e-001,
    3.053035e-001,
};

double dataset520[] =
{
    // albedo 0, turbidity 1
    -1.171338e+000,
    -2.379456e-001,
    -6.515446e+000,
    7.133235e+000,
    -5.382867e-002,
    6.889982e-001,
    4.250983e-002,
    4.471437e+000,
    5.087463e-001,
    -1.193029e+000,
    -2.445141e-001,
    -4.311723e-001,
    1.019354e+000,
    -1.281643e-001,
    7.837279e-001,
    2.609613e-002,
    5.965800e+000,
    4.381607e-001,
    -1.165299e+000,
    -2.503239e-001,
    3.829843e+000,
    -2.234083e+000,
    -4.693988e-001,
    1.045109e+000,
    -6.241707e-002,
    2.623310e-001,
    7.500398e-001,
    -1.077288e+000,
    -2.659342e-001,
    -7.565678e-002,
    1.145086e+000,
    -2.316655e-002,
    1.564941e+000,
    9.375322e-002,
    -7.476929e-001,
    6.076913e-001,
    -1.075530e+000,
    -1.232648e-001,
    1.877081e+000,
    -1.186427e-001,
    -2.748628e+000,
    1.249377e+000,
    -1.085780e-001,
    3.838331e+000,
    8.601227e-001,
    -1.067002e+000,
    -1.572453e-001,
    1.350156e+000,
    3.140948e-003,
    -3.277283e+000,
    1.488404e+000,
    1.127058e-001,
    2.655730e+000,
    4.999138e-001,
    // albedo 0, turbidity 2
    -1.175145e+000,
    -2.454528e-001,
    -8.173280e+000,
    8.622722e+000,
    -3.895019e-002,
    6.739096e-001,
    6.622835e-002,
    4.450872e+000,
    5.061382e-001,
    -1.226543e+000,
    -2.979950e-001,
    3.102814e+000,
    -2.662701e+000,
    -1.012309e-001,
    5.142095e-001,
    4.939276e-002,
    5.007851e+000,
    4.179865e-001,
    -1.075743e+000,
    -1.267529e-001,
    1.017884e-001,
    4.839556e-001,
    -4.025119e-001,
    1.120466e+000,
    -5.059103e-002,
    3.601070e+000,
    1.104232e+000,
    -1.104008e+000,
    -2.079352e-001,
    1.094572e+000,
    1.147058e+000,
    -1.516726e-001,
    1.526097e+000,
    1.922554e-001,
    4.060614e-001,
    2.975787e-001,
    -1.080135e+000,
    -1.942481e-001,
    1.409056e+000,
    -3.800384e+000,
    -7.125701e+000,
    9.731220e-001,
    -7.312793e-002,
    2.377810e+000,
    9.223131e-001,
    -1.066280e+000,
    -1.421591e-001,
    1.272936e+000,
    7.891881e+000,
    -3.626975e+000,
    1.294678e+000,
    1.331475e-001,
    2.986127e+000,
    5.316962e-001,
    // albedo 0, turbidity 3
    -1.210057e+000,
    -2.827640e-001,
    -5.179186e+000,
    5.514430e+000,
    -5.638504e-002,
    6.656727e-001,
    5.417868e-002,
    4.216550e+000,
    5.495231e-001,
    -1.311087e+000,
    -3.921139e-001,
    1.436554e+000,
    -7.051260e-001,
    -1.462714e-001,
    2.604620e-001,
    5.771570e-002,
    3.493766e+000,
    5.041164e-001,
    -9.705912e-001,
    -4.316197e-002,
    5.357225e-001,
    -1.399982e+000,
    -3.407923e-001,
    1.585242e+000,
    -6.423039e-002,
    5.338193e+000,
    9.835385e-001,
    -1.177697e+000,
    -1.893604e-001,
    -5.207247e-002,
    4.572666e+000,
    -5.523178e-001,
    2.677765e-001,
    3.872768e-001,
    1.978123e+000,
    4.095974e-001,
    -1.029420e+000,
    -2.105096e-001,
    1.657176e+000,
    -1.028655e+001,
    -7.725428e+000,
    1.707122e+000,
    -7.681108e-002,
    1.074660e+000,
    8.312794e-001,
    -1.082084e+000,
    -1.321893e-001,
    8.487219e-001,
    1.858290e+001,
    -3.172656e+000,
    6.915801e-001,
    1.905927e-001,
    3.901473e+000,
    6.144141e-001,
    // albedo 0, turbidity 4
    -1.259854e+000,
    -3.329630e-001,
    -2.270176e+000,
    2.357599e+000,
    -9.019414e-002,
    5.779792e-001,
    7.706039e-002,
    3.971905e+000,
    4.999172e-001,
    -1.413220e+000,
    -5.430979e-001,
    -1.715627e-001,
    1.151561e+000,
    -2.318489e-001,
    2.791441e-001,
    1.306646e-002,
    1.794583e+000,
    6.167457e-001,
    -9.926840e-001,
    2.303697e-002,
    7.306051e-001,
    -2.124879e+000,
    -2.221853e-001,
    1.635982e+000,
    -8.684297e-002,
    7.621636e+000,
    9.443863e-001,
    -1.113409e+000,
    -2.409045e-001,
    -1.979662e-001,
    5.089736e+000,
    -2.071840e+000,
    -6.954891e-001,
    5.966469e-001,
    -1.346819e+000,
    3.752080e-001,
    -1.055595e+000,
    -1.703680e-001,
    1.089771e+000,
    -1.041463e+001,
    -4.687545e+000,
    2.149733e+000,
    -1.118987e-001,
    3.558810e+000,
    8.741214e-001,
    -1.070779e+000,
    -1.445161e-001,
    6.385947e-001,
    1.695445e+001,
    -3.724275e+000,
    -3.465499e-002,
    3.645376e-001,
    3.232410e+000,
    6.285788e-001,
    // albedo 0, turbidity 5
    -1.297812e+000,
    -3.805039e-001,
    -1.474455e+000,
    1.558382e+000,
    -1.292485e-001,
    5.206238e-001,
    7.166147e-002,
    3.651150e+000,
    4.998781e-001,
    -1.680599e+000,
    -8.036751e-001,
    8.267015e-001,
    -2.109200e-001,
    -4.326451e-001,
    3.843930e-001,
    5.207142e-002,
    6.938520e-001,
    4.752346e-001,
    -8.467684e-001,
    1.620743e-001,
    -5.520307e-001,
    8.293798e-001,
    8.728132e-001,
    9.075147e-001,
    -1.734859e-001,
    7.815672e+000,
    1.126843e+000,
    -1.182658e+000,
    -3.290773e-001,
    1.442907e-001,
    -1.705529e+000,
    -1.186174e+001,
    -1.903040e-001,
    7.826049e-001,
    -1.497409e+000,
    2.238945e-001,
    -1.032316e+000,
    -1.590425e-001,
    9.289968e-001,
    1.217091e+001,
    1.274690e+000,
    1.400296e+000,
    -3.047612e-001,
    2.805729e+000,
    9.198989e-001,
    -1.073060e+000,
    -1.623303e-001,
    3.798836e-001,
    2.223272e+000,
    -4.660805e+000,
    -1.172357e-001,
    5.306455e-001,
    3.105520e+000,
    6.420864e-001,
    // albedo 0, turbidity 6
    -1.374072e+000,
    -4.453408e-001,
    -1.081601e+000,
    1.104314e+000,
    -1.730612e-001,
    5.074812e-001,
    5.784588e-002,
    3.488150e+000,
    5.037112e-001,
    -1.704606e+000,
    -8.629255e-001,
    -3.905040e-001,
    2.152742e+000,
    -6.716606e-001,
    5.638527e-001,
    -5.967161e-003,
    4.886292e-001,
    4.385432e-001,
    -9.651511e-001,
    1.186522e-001,
    3.421397e-001,
    -4.626814e+000,
    9.716770e-001,
    7.579588e-001,
    -1.064476e-002,
    8.154392e+000,
    1.103676e+000,
    -1.067172e+000,
    -3.214506e-001,
    -3.934660e-001,
    9.254630e+000,
    -3.599603e+000,
    -1.624031e-001,
    5.478446e-001,
    -2.781628e+000,
    2.905848e-001,
    -1.063218e+000,
    -1.412572e-001,
    8.153795e-001,
    -1.467486e+001,
    -2.020170e+000,
    1.094685e+000,
    7.786265e-002,
    3.719129e+000,
    8.826899e-001,
    -1.070058e+000,
    -1.684172e-001,
    2.225147e-001,
    2.345795e+001,
    -4.342429e+000,
    -4.661816e-002,
    3.545794e-001,
    3.051769e+000,
    6.567686e-001,
    // albedo 0, turbidity 7
    -1.397244e+000,
    -4.874379e-001,
    -2.217129e+000,
    2.415780e+000,
    -1.039290e-001,
    5.444596e-001,
    2.296795e-002,
    3.242776e+000,
    5.575920e-001,
    -1.943117e+000,
    -1.042293e+000,
    1.936194e+000,
    -7.807718e-001,
    -4.753317e-001,
    6.351817e-001,
    3.357824e-002,
    3.221570e-001,
    2.277390e-001,
    -1.007469e+000,
    4.283560e-002,
    -1.830583e+000,
    -1.613949e-001,
    5.103059e-001,
    1.830881e-001,
    -6.111472e-002,
    7.698471e+000,
    1.322151e+000,
    -9.885823e-001,
    -2.796329e-001,
    9.017585e-001,
    9.500529e-001,
    -8.751757e+000,
    5.198673e-001,
    6.111910e-001,
    -3.165369e+000,
    1.193651e-001,
    -1.105054e+000,
    -1.835801e-001,
    2.099263e-001,
    3.626436e+000,
    4.241807e-001,
    2.861915e-002,
    -3.245808e-002,
    3.560209e+000,
    9.581069e-001,
    -1.061783e+000,
    -1.955111e-001,
    3.405765e-001,
    1.682185e+001,
    -4.868111e+000,
    3.591669e-001,
    3.518670e-001,
    2.163473e+000,
    6.425305e-001,
    // albedo 0, turbidity 8
    -1.452178e+000,
    -5.662818e-001,
    -1.492883e+000,
    1.742373e+000,
    -1.894966e-001,
    6.129524e-001,
    2.370115e-006,
    3.042560e+000,
    7.988979e-001,
    -2.146318e+000,
    -1.176122e+000,
    1.480664e+000,
    1.846814e-001,
    -9.003192e-001,
    2.819986e-001,
    -6.858291e-003,
    5.447940e-001,
    -2.109028e-001,
    -1.465359e+000,
    -3.055025e-001,
    -1.747423e+000,
    -2.538335e+000,
    6.082904e-001,
    6.523133e-001,
    1.426957e-001,
    6.921276e+000,
    1.637843e+000,
    -7.135462e-001,
    -2.351046e-001,
    1.111445e+000,
    2.259275e+000,
    -7.853810e+000,
    -3.006083e-001,
    3.100486e-001,
    -4.047366e+000,
    -3.732308e-002,
    -1.188030e+000,
    -2.177467e-001,
    8.022451e-002,
    8.746107e+000,
    -6.824017e-001,
    5.968181e-001,
    7.024883e-002,
    3.164998e+000,
    9.909158e-001,
    -1.038065e+000,
    -1.989059e-001,
    1.630845e-001,
    1.261969e+001,
    -4.006594e+000,
    -3.213161e-001,
    3.948313e-001,
    2.040063e+000,
    6.364874e-001,
    // albedo 0, turbidity 9
    -1.789980e+000,
    -8.450140e-001,
    -2.591234e+000,
    2.769295e+000,
    -8.338896e-002,
    5.620741e-001,
    -8.271253e-006,
    2.531602e+000,
    9.001159e-001,
    -1.468080e+000,
    -7.426812e-001,
    2.369441e+000,
    -1.635443e+000,
    -3.560365e-001,
    2.130482e-001,
    -2.124886e-003,
    1.863478e+000,
    -3.426455e-001,
    -3.911974e+000,
    -1.873182e+000,
    -2.428294e+000,
    1.019786e+000,
    2.178584e-001,
    9.599962e-001,
    3.763471e-002,
    4.121844e+000,
    1.708236e+000,
    5.986629e-001,
    4.160930e-001,
    1.499968e+000,
    -4.234635e+000,
    -7.153272e+000,
    -8.777277e-001,
    4.276508e-001,
    -2.268730e+000,
    -9.278595e-002,
    -1.581111e+000,
    -5.414559e-001,
    3.449756e-002,
    2.095624e+001,
    -1.717086e+000,
    6.913385e-001,
    -1.227380e-001,
    1.401315e+000,
    9.723511e-001,
    -9.931334e-001,
    -2.191364e-001,
    1.647201e-001,
    2.954460e+000,
    -2.889774e+000,
    -4.261816e-001,
    4.166838e-001,
    1.370273e+000,
    6.561021e-001,
    // albedo 0, turbidity 10
    -2.368520e+000,
    -1.245557e+000,
    -3.473878e+000,
    3.511922e+000,
    -4.076311e-002,
    4.228576e-001,
    -8.136079e-006,
    2.268992e+000,
    9.001266e-001,
    -1.498984e+000,
    -9.483364e-001,
    2.970418e+000,
    -2.003511e+000,
    -3.005171e-001,
    3.242320e-001,
    6.724107e-003,
    1.693927e+000,
    -2.648941e-001,
    -6.258071e+000,
    -2.616781e+000,
    -3.186408e+000,
    -3.570416e-002,
    5.972101e-001,
    5.638927e-001,
    -8.227073e-002,
    3.805214e+000,
    1.486701e+000,
    7.183470e-001,
    -1.332710e-001,
    1.495243e+000,
    3.859652e+000,
    -5.605361e+000,
    3.808435e-001,
    4.998100e-001,
    -1.207866e+000,
    1.082917e-001,
    -1.422091e+000,
    -5.984032e-001,
    2.297508e-001,
    1.726780e+000,
    -6.684454e-001,
    -1.024912e+000,
    -1.967199e-001,
    -3.214571e-001,
    8.922300e-001,
    -1.018798e+000,
    -2.003211e-001,
    5.344788e-002,
    1.474717e+001,
    -4.025558e+000,
    9.010150e-001,
    3.605184e-001,
    1.504726e+000,
    6.720300e-001,
    // albedo 1, turbidity 1
    -1.150179e+000,
    -2.233430e-001,
    -6.725138e+000,
    7.601675e+000,
    -6.176639e-002,
    7.963802e-001,
    2.476816e-002,
    4.311811e+000,
    5.070506e-001,
    -1.184017e+000,
    -2.330060e-001,
    1.903877e-001,
    4.425206e-001,
    -1.173330e-001,
    2.459899e-001,
    6.799957e-002,
    5.710763e+000,
    4.639162e-001,
    -1.129855e+000,
    -2.313999e-001,
    3.299978e+000,
    -1.861830e+000,
    -3.626476e-001,
    1.858194e+000,
    -9.845844e-002,
    6.523143e-001,
    6.278178e-001,
    -1.090030e+000,
    -2.445577e-001,
    4.546659e-001,
    9.848860e-001,
    -4.044981e-001,
    3.532740e-001,
    1.409977e-001,
    -7.724273e-001,
    2.901711e-001,
    -1.048192e+000,
    -1.048720e-001,
    2.079951e+000,
    -7.519850e-002,
    -1.451911e+000,
    1.354243e+000,
    -1.508252e-001,
    4.159135e+000,
    8.685415e-001,
    -1.081709e+000,
    -1.496534e-001,
    1.433416e+000,
    -8.415186e-005,
    -3.147387e+000,
    6.964893e-002,
    1.345400e-001,
    3.372381e+000,
    5.369835e-001,
    // albedo 1, turbidity 2
    -1.163329e+000,
    -2.341078e-001,
    -8.084459e+000,
    8.765664e+000,
    -4.227908e-002,
    6.476384e-001,
    5.575993e-002,
    4.291594e+000,
    5.023286e-001,
    -1.234281e+000,
    -3.038288e-001,
    3.304120e+000,
    -2.565467e+000,
    -1.080261e-001,
    5.183037e-001,
    2.633070e-002,
    4.459108e+000,
    4.526356e-001,
    -1.015235e+000,
    -1.003890e-001,
    2.834337e-001,
    4.230399e-001,
    -4.060874e-001,
    1.119918e+000,
    -2.357803e-002,
    3.215664e+000,
    1.089777e+000,
    -1.171497e+000,
    -2.465867e-001,
    1.219344e+000,
    1.184120e+000,
    -6.451707e-002,
    1.087554e+000,
    1.687897e-001,
    4.111776e-001,
    2.471485e-001,
    -1.010262e+000,
    -1.337460e-001,
    1.953577e+000,
    -3.761183e+000,
    -7.089300e+000,
    5.963565e-001,
    -8.297304e-002,
    2.741114e+000,
    9.771003e-001,
    -1.102719e+000,
    -1.647974e-001,
    1.510508e+000,
    7.573412e+000,
    -3.431528e+000,
    3.953995e-001,
    6.793657e-002,
    2.744717e+000,
    5.018037e-001,
    // albedo 1, turbidity 3
    -1.186728e+000,
    -2.648685e-001,
    -7.540497e+000,
    8.152868e+000,
    -4.363040e-002,
    6.836829e-001,
    3.221451e-002,
    4.013046e+000,
    6.004295e-001,
    -1.302626e+000,
    -3.904258e-001,
    3.431819e+000,
    -2.975541e+000,
    -7.666020e-002,
    2.464561e-002,
    1.054528e-001,
    3.161765e+000,
    3.544185e-001,
    -9.615438e-001,
    -4.842098e-002,
    -4.756207e-001,
    9.408081e-001,
    -3.108222e-001,
    1.708814e+000,
    -1.241215e-001,
    4.416567e+000,
    1.207369e+000,
    -1.178731e+000,
    -1.824314e-001,
    8.266664e-001,
    1.001614e+000,
    3.024332e-001,
    3.291998e-002,
    4.178949e-001,
    2.532397e+000,
    2.014902e-001,
    -1.018913e+000,
    -2.016682e-001,
    2.132865e+000,
    -3.323938e+000,
    -8.751654e+000,
    1.240780e+000,
    -1.801214e-001,
    6.145479e-001,
    9.457932e-001,
    -1.101603e+000,
    -1.521834e-001,
    1.348807e+000,
    5.640453e+000,
    -2.695953e+000,
    -7.496627e-002,
    1.719606e-001,
    3.175091e+000,
    5.968939e-001,
    // albedo 1, turbidity 4
    -1.229694e+000,
    -3.167126e-001,
    -3.548352e+000,
    3.846155e+000,
    -5.028022e-002,
    5.061677e-001,
    7.498335e-002,
    3.626295e+000,
    4.999424e-001,
    -1.436439e+000,
    -5.562909e-001,
    8.010070e-001,
    3.290243e-001,
    -1.385772e-001,
    4.556269e-002,
    2.571935e-002,
    1.623385e+000,
    5.222220e-001,
    -8.876360e-001,
    5.717281e-002,
    4.713905e-001,
    -1.668970e+000,
    -3.199243e-001,
    2.050582e+000,
    -7.783980e-002,
    6.117601e+000,
    1.070445e+000,
    -1.235363e+000,
    -2.778190e-001,
    1.577638e-001,
    3.982457e+000,
    -2.266885e-002,
    -1.411004e+000,
    5.570462e-001,
    1.740426e-001,
    2.747952e-001,
    -9.785264e-001,
    -1.458813e-001,
    1.996989e+000,
    -7.517409e+000,
    -6.602487e+000,
    2.387711e+000,
    -1.996484e-001,
    2.112759e+000,
    9.289256e-001,
    -1.117781e+000,
    -1.699302e-001,
    1.214480e+000,
    1.141083e+001,
    -3.253445e+000,
    -8.156284e-001,
    2.248021e-001,
    2.860500e+000,
    6.151694e-001,
    // albedo 1, turbidity 5
    -1.290523e+000,
    -3.813116e-001,
    -6.728796e-001,
    1.007366e+000,
    -2.068030e-001,
    4.422499e-001,
    6.016254e-002,
    3.218056e+000,
    5.068822e-001,
    -1.614452e+000,
    -7.953309e-001,
    5.977485e-001,
    1.056365e+000,
    -8.402403e-001,
    3.713919e-001,
    3.164720e-002,
    -2.526630e-001,
    4.072481e-001,
    -8.377211e-001,
    2.276878e-001,
    -3.232539e-001,
    -2.390300e+000,
    2.127070e+000,
    7.169058e-001,
    -4.032313e-002,
    9.072383e+000,
    1.188019e+000,
    -1.226600e+000,
    -4.426177e-001,
    6.370202e-001,
    3.846913e+000,
    -1.128719e+001,
    3.667721e-002,
    5.000027e-001,
    -4.192432e+000,
    2.376054e-001,
    -9.852235e-001,
    -5.890324e-002,
    1.529937e+000,
    4.301220e+000,
    -1.839775e+000,
    8.993504e-001,
    -1.040866e-001,
    4.636528e+000,
    8.466710e-001,
    -1.118112e+000,
    -2.040213e-001,
    1.203227e+000,
    7.252102e+000,
    -4.515955e+000,
    -2.398231e-001,
    2.375855e-001,
    1.923160e+000,
    6.645269e-001,
    // albedo 1, turbidity 6
    -1.330626e+000,
    -4.272516e-001,
    -1.317682e+000,
    1.650847e+000,
    -1.192771e-001,
    4.904191e-001,
    4.074827e-002,
    3.015846e+000,
    5.271835e-001,
    -1.711989e+000,
    -8.644776e-001,
    4.057135e-001,
    9.037139e-001,
    -3.100084e-001,
    6.317697e-002,
    1.065625e-001,
    9.226240e-002,
    3.022474e-001,
    -8.465894e-001,
    1.652715e-001,
    -2.532361e-001,
    -2.422693e+000,
    3.144841e-001,
    1.839347e+000,
    -2.818162e-001,
    7.856667e+000,
    1.387977e+000,
    -1.192114e+000,
    -3.830569e-001,
    5.124751e-001,
    7.280034e+000,
    -2.610477e+000,
    -1.832768e+000,
    9.101904e-001,
    -3.349116e+000,
    -7.313079e-002,
    -1.011026e+000,
    -1.061217e-001,
    1.357854e+000,
    -1.496195e+001,
    -2.180975e+000,
    2.484329e+000,
    -3.239225e-001,
    3.899425e+000,
    1.179264e+000,
    -1.106228e+000,
    -1.927917e-001,
    1.179701e+000,
    2.379834e+001,
    -4.870211e+000,
    -1.290713e+000,
    2.854422e-001,
    2.078973e+000,
    5.128625e-001,
    // albedo 1, turbidity 7
    -1.342815e+000,
    -4.571984e-001,
    -1.803521e+000,
    2.229578e+000,
    -1.196587e-001,
    5.694038e-001,
    1.194687e-002,
    2.950110e+000,
    5.961719e-001,
    -1.937297e+000,
    -1.078823e+000,
    2.178495e+000,
    -1.251900e+000,
    -3.577875e-001,
    2.553915e-001,
    8.081142e-002,
    -4.723152e-001,
    1.174551e-001,
    -9.292675e-001,
    1.125551e-001,
    -1.708569e+000,
    1.832840e+000,
    5.150525e-001,
    9.287322e-001,
    -1.746780e-001,
    7.793815e+000,
    1.498832e+000,
    -1.058850e+000,
    -3.495292e-001,
    1.135259e+000,
    -4.069374e+000,
    -9.727412e+000,
    -7.670653e-001,
    7.550431e-001,
    -4.105064e+000,
    -5.149354e-002,
    -1.079472e+000,
    -1.399984e-001,
    1.058148e+000,
    1.392667e+001,
    -6.245343e-001,
    1.192083e+000,
    -2.578858e-001,
    4.030723e+000,
    1.025069e+000,
    -1.093159e+000,
    -2.150433e-001,
    1.210946e+000,
    3.349246e+000,
    -4.030345e+000,
    -5.362971e-001,
    2.886842e-001,
    1.192375e+000,
    6.363049e-001,
    // albedo 1, turbidity 8
    -1.408172e+000,
    -5.491538e-001,
    -1.360219e+000,
    1.738150e+000,
    -1.505117e-001,
    6.030014e-001,
    -6.866289e-006,
    2.656101e+000,
    9.001849e-001,
    -2.171702e+000,
    -1.231851e+000,
    1.860400e+000,
    3.613146e-002,
    -7.300078e-001,
    1.974371e-001,
    -5.351202e-003,
    -1.443434e-001,
    -3.779605e-001,
    -1.284657e+000,
    -1.935945e-001,
    -1.494185e+000,
    -2.070689e+000,
    2.974020e-001,
    8.048383e-001,
    1.097715e-001,
    6.907960e+000,
    1.819367e+000,
    -8.288598e-001,
    -3.374917e-001,
    1.029011e+000,
    1.347088e+000,
    -7.655126e+000,
    -8.232335e-001,
    3.722934e-001,
    -4.847675e+000,
    -1.864913e-001,
    -1.146031e+000,
    -1.480097e-001,
    1.051391e+000,
    8.396865e+000,
    -1.407010e+000,
    1.240651e+000,
    -3.942068e-002,
    3.291458e+000,
    1.060212e+000,
    -1.069599e+000,
    -2.047532e-001,
    9.437765e-001,
    1.189879e+001,
    -4.026750e+000,
    -9.372092e-001,
    2.463501e-001,
    1.782902e+000,
    6.235027e-001,
    // albedo 1, turbidity 9
    -1.793508e+000,
    -8.986075e-001,
    -2.346395e+000,
    2.775625e+000,
    -7.052213e-002,
    5.349215e-001,
    -7.457456e-006,
    1.901248e+000,
    9.001358e-001,
    -1.629402e+000,
    -8.273410e-001,
    2.270930e+000,
    -1.125114e+000,
    -3.562854e-001,
    1.948044e-001,
    1.703882e-003,
    1.426305e+000,
    -3.737234e-001,
    -3.443431e+000,
    -1.686429e+000,
    -1.515036e+000,
    -6.941862e-001,
    4.976814e-001,
    1.144483e+000,
    -4.277285e-002,
    3.662107e+000,
    1.819972e+000,
    3.138150e-001,
    2.426714e-001,
    7.717995e-001,
    2.759520e+000,
    -7.216077e+000,
    -1.389093e+000,
    5.332838e-001,
    -2.316313e+000,
    -2.636593e-001,
    -1.449802e+000,
    -4.017798e-001,
    1.133688e+000,
    2.114337e+000,
    6.227965e-002,
    1.378688e+000,
    -1.759313e-001,
    9.446579e-001,
    1.165017e+000,
    -1.049420e+000,
    -2.614006e-001,
    9.473363e-001,
    1.531288e+001,
    -4.714989e+000,
    -8.992715e-001,
    2.423509e-001,
    9.148027e-001,
    5.650972e-001,
    // albedo 1, turbidity 10
    -2.382332e+000,
    -1.290760e+000,
    -3.316114e+000,
    3.587059e+000,
    -3.748522e-002,
    4.468493e-001,
    -7.212198e-006,
    1.789208e+000,
    9.001267e-001,
    -1.333339e+000,
    -9.355999e-001,
    3.281313e+000,
    -2.263103e+000,
    -2.499164e-001,
    1.591742e-001,
    8.117981e-003,
    1.345396e+000,
    -2.689053e-001,
    -6.612658e+000,
    -2.809230e+000,
    -2.744061e+000,
    1.005261e+000,
    4.216309e-001,
    1.055067e+000,
    -9.021558e-002,
    2.940833e+000,
    1.495270e+000,
    1.251113e+000,
    5.915517e-002,
    1.142846e+000,
    -2.807371e-001,
    -5.335452e+000,
    -6.967012e-001,
    5.129558e-001,
    -5.264483e-001,
    1.137786e-001,
    -1.517768e+000,
    -5.807447e-001,
    1.179477e+000,
    1.252252e+001,
    -2.305973e+000,
    2.184822e-001,
    -3.092917e-001,
    -1.524373e+000,
    8.724218e-001,
    -1.037889e+000,
    -2.065780e-001,
    6.479897e-001,
    4.786848e-002,
    -2.348244e+000,
    -3.053490e-002,
    4.059549e-001,
    1.313102e+000,
    6.713422e-001,
};

double datasetRad520[] =
{
    // albedo 0, turbidity 1
    1.459826e-002,
    1.539451e-002,
    -1.848659e-003,
    1.563602e-001,
    6.773320e-002,
    9.272923e-002,
    // albedo 0, turbidity 2
    1.433599e-002,
    1.641988e-002,
    -1.010719e-002,
    1.752844e-001,
    7.101618e-002,
    9.423920e-002,
    // albedo 0, turbidity 3
    1.361165e-002,
    2.045058e-002,
    -3.003054e-002,
    2.142268e-001,
    6.624853e-002,
    1.021088e-001,
    // albedo 0, turbidity 4
    1.263245e-002,
    2.450953e-002,
    -5.278634e-002,
    2.554090e-001,
    7.442617e-002,
    1.093243e-001,
    // albedo 0, turbidity 5
    1.161553e-002,
    2.837614e-002,
    -7.218472e-002,
    2.860706e-001,
    8.559036e-002,
    1.183292e-001,
    // albedo 0, turbidity 6
    1.106384e-002,
    3.079241e-002,
    -8.377247e-002,
    3.007502e-001,
    9.584072e-002,
    1.242989e-001,
    // albedo 0, turbidity 7
    1.036501e-002,
    3.253539e-002,
    -9.274680e-002,
    3.036297e-001,
    1.249370e-001,
    1.307019e-001,
    // albedo 0, turbidity 8
    9.469294e-003,
    3.287197e-002,
    -9.329500e-002,
    2.773078e-001,
    1.866053e-001,
    1.366498e-001,
    // albedo 0, turbidity 9
    8.599754e-003,
    2.901873e-002,
    -7.532574e-002,
    2.032418e-001,
    2.837623e-001,
    1.499765e-001,
    // albedo 0, turbidity 10
    7.760808e-003,
    1.977285e-002,
    -3.328752e-002,
    7.084295e-002,
    4.155148e-001,
    1.708600e-001,
    // albedo 1, turbidity 1
    1.597952e-002,
    1.790201e-002,
    -1.839686e-003,
    1.470389e-001,
    1.698205e-001,
    2.119268e-001,
    // albedo 1, turbidity 2
    1.553599e-002,
    1.969270e-002,
    -1.173079e-002,
    1.677871e-001,
    1.714108e-001,
    2.173300e-001,
    // albedo 1, turbidity 3
    1.489601e-002,
    2.206336e-002,
    -2.576017e-002,
    1.949160e-001,
    1.781909e-001,
    2.236776e-001,
    // albedo 1, turbidity 4
    1.384558e-002,
    2.528945e-002,
    -4.419483e-002,
    2.249469e-001,
    1.968802e-001,
    2.312108e-001,
    // albedo 1, turbidity 5
    1.299228e-002,
    2.767429e-002,
    -5.793193e-002,
    2.409692e-001,
    2.215448e-001,
    2.384850e-001,
    // albedo 1, turbidity 6
    1.245635e-002,
    2.874175e-002,
    -6.384005e-002,
    2.429023e-001,
    2.428387e-001,
    2.418906e-001,
    // albedo 1, turbidity 7
    1.170787e-002,
    3.001101e-002,
    -6.977107e-002,
    2.368382e-001,
    2.775809e-001,
    2.482129e-001,
    // albedo 1, turbidity 8
    1.081211e-002,
    2.854760e-002,
    -6.360294e-002,
    1.948047e-001,
    3.501631e-001,
    2.490269e-001,
    // albedo 1, turbidity 9
    9.903541e-003,
    2.416012e-002,
    -4.342521e-002,
    1.140965e-001,
    4.468771e-001,
    2.561579e-001,
    // albedo 1, turbidity 10
    8.793464e-003,
    1.518177e-002,
    -4.699154e-003,
    -9.107614e-003,
    5.554550e-001,
    2.692918e-001,
};

double dataset560[] =
{
    // albedo 0, turbidity 1
    -1.121223e+000,
    -1.710187e-001,
    -1.383038e+001,
    1.475343e+001,
    -3.137953e-002,
    1.035662e+000,
    4.060064e-002,
    5.222551e+000,
    5.001051e-001,
    -1.172565e+000,
    -1.880874e-001,
    7.283594e+000,
    -5.774643e+000,
    -9.051333e-002,
    9.108126e-001,
    -1.565410e-002,
    6.194404e+000,
    4.688599e-001,
    -1.124108e+000,
    -3.082835e-001,
    -2.179926e-001,
    1.330167e+000,
    -4.502254e-001,
    1.470140e+000,
    4.202392e-004,
    -4.724308e+000,
    1.134678e+000,
    -1.079809e+000,
    -9.226814e-002,
    1.465364e+000,
    1.348856e+000,
    4.357794e-001,
    1.771543e+000,
    8.121383e-003,
    6.057395e+000,
    2.462141e-001,
    -1.086667e+000,
    -2.709889e-001,
    2.249152e+000,
    -3.177505e+000,
    -7.138130e+000,
    1.112553e+000,
    -9.718434e-003,
    -2.392239e+000,
    9.352768e-001,
    -1.071154e+000,
    -1.272150e-001,
    1.644374e+000,
    4.326598e+000,
    -2.244682e+000,
    1.611051e+000,
    7.835546e-003,
    3.213282e+000,
    6.580432e-001,
    // albedo 0, turbidity 2
    -1.133883e+000,
    -1.835049e-001,
    -1.232301e+001,
    1.307796e+001,
    -3.760123e-002,
    1.051162e+000,
    3.392954e-002,
    5.319376e+000,
    6.501601e-001,
    -1.116119e+000,
    -1.457114e-001,
    5.436576e+000,
    -5.114276e+000,
    -7.178414e-002,
    2.658168e-001,
    1.603756e-001,
    7.619379e+000,
    3.112698e-001,
    -1.215552e+000,
    -3.391607e-001,
    4.502377e-001,
    1.281602e+000,
    -4.095778e-001,
    2.374058e+000,
    -1.988430e-001,
    -3.809377e+000,
    1.254846e+000,
    -9.657094e-001,
    3.858547e-002,
    3.324554e-001,
    1.541740e+000,
    6.029572e-001,
    2.346414e-001,
    3.902458e-001,
    7.263050e+000,
    1.353991e-001,
    -1.152042e+000,
    -3.155103e-001,
    2.163244e+000,
    -5.230832e+000,
    -7.443608e+000,
    2.247834e+000,
    -1.632216e-001,
    -1.725315e+000,
    1.034709e+000,
    -1.051862e+000,
    -1.310458e-001,
    1.554942e+000,
    1.063510e+001,
    -3.558989e+000,
    6.764257e-001,
    1.428912e-001,
    2.541641e+000,
    5.000389e-001,
    // albedo 0, turbidity 3
    -1.156925e+000,
    -2.104634e-001,
    -1.793090e+001,
    1.817524e+001,
    -1.225514e-002,
    6.518753e-001,
    1.085708e-001,
    4.947239e+000,
    5.635117e-001,
    -1.183783e+000,
    -2.187288e-001,
    5.860654e+000,
    -5.643960e+000,
    -4.453459e-002,
    6.724995e-001,
    1.698133e-002,
    6.742131e+000,
    6.353553e-001,
    -1.143101e+000,
    -2.644541e-001,
    9.354577e-001,
    9.256854e-001,
    -1.074845e-001,
    1.663131e+000,
    4.998918e-002,
    -2.049721e+000,
    8.150826e-001,
    -1.021102e+000,
    2.478746e-002,
    -1.367363e+000,
    -9.011684e-002,
    -5.001730e-001,
    4.316685e-002,
    3.952231e-001,
    8.084754e+000,
    5.380131e-001,
    -1.101145e+000,
    -2.731481e-001,
    2.483816e+000,
    3.581780e-001,
    4.249615e-001,
    2.284087e+000,
    -5.836688e-002,
    -1.651434e+000,
    7.685430e-001,
    -1.073863e+000,
    -1.705854e-001,
    1.169673e+000,
    -2.183705e-003,
    -5.007439e+000,
    2.318154e-001,
    2.738714e-001,
    2.187327e+000,
    6.676882e-001,
    // albedo 0, turbidity 4
    -1.207581e+000,
    -2.653224e-001,
    -9.004497e+000,
    8.985720e+000,
    -9.024461e-003,
    4.273132e-001,
    1.378091e-001,
    4.307648e+000,
    5.309421e-001,
    -1.278614e+000,
    -3.516334e-001,
    2.489304e+000,
    -1.840089e+000,
    -6.293646e-002,
    8.426903e-001,
    -7.266949e-002,
    4.434869e+000,
    7.077739e-001,
    -1.150333e+000,
    -2.033123e-001,
    8.150312e-001,
    -7.926382e-001,
    -3.230951e-001,
    1.291679e+000,
    1.822329e-001,
    1.619133e+000,
    7.522432e-001,
    -1.002248e+000,
    -3.092969e-002,
    -1.092273e+000,
    2.820671e+000,
    4.504455e-001,
    -5.121048e-001,
    4.229688e-001,
    4.037073e+000,
    5.843543e-001,
    -1.087962e+000,
    -2.434172e-001,
    1.817322e+000,
    -6.031774e+000,
    -4.873903e+000,
    2.094606e+000,
    1.184743e-001,
    2.293346e-001,
    7.283940e-001,
    -1.072272e+000,
    -1.614715e-001,
    8.337136e-001,
    1.086866e+001,
    -3.373042e+000,
    2.260332e-002,
    2.622468e-001,
    2.470766e+000,
    7.078601e-001,
    // albedo 0, turbidity 5
    -1.263850e+000,
    -3.278851e-001,
    -5.336400e+000,
    5.102832e+000,
    2.070020e-003,
    3.605369e-001,
    1.633426e-001,
    3.790121e+000,
    4.999503e-001,
    -1.507623e+000,
    -6.465694e-001,
    -2.983753e+000,
    4.212027e+000,
    -5.868795e-002,
    3.852488e-001,
    -7.222995e-002,
    1.042808e+000,
    6.632120e-001,
    -1.041397e+000,
    6.326589e-002,
    3.860471e+000,
    -5.579882e+000,
    -1.730201e-001,
    2.303753e+000,
    6.102393e-002,
    7.287763e+000,
    8.916057e-001,
    -1.049861e+000,
    -2.836044e-001,
    -2.302537e+000,
    6.724969e+000,
    4.373598e-001,
    -2.422514e+000,
    6.952438e-001,
    -2.633600e+000,
    4.070954e-001,
    -1.054117e+000,
    -1.206625e-001,
    1.764625e+000,
    -9.467716e+000,
    -3.436987e+000,
    3.394707e+000,
    -8.149683e-002,
    3.485918e+000,
    8.515716e-001,
    -1.072517e+000,
    -1.574135e-001,
    2.214599e-001,
    1.331766e+001,
    -3.915381e+000,
    -1.229973e+000,
    6.267275e-001,
    2.923262e+000,
    6.516824e-001,
    // albedo 0, turbidity 6
    -1.293503e+000,
    -3.676147e-001,
    -1.323095e+001,
    1.301713e+001,
    -3.471894e-004,
    3.957986e-001,
    1.317480e-001,
    3.616827e+000,
    4.998510e-001,
    -1.757697e+000,
    -8.202513e-001,
    2.560133e+000,
    -1.337734e+000,
    -3.413795e-002,
    5.633043e-001,
    -4.355758e-002,
    7.324869e-001,
    5.728008e-001,
    -8.814599e-001,
    9.828960e-002,
    -2.701428e-001,
    -1.298657e+000,
    -6.721423e-002,
    1.581675e+000,
    4.095024e-002,
    6.548913e+000,
    9.726866e-001,
    -1.125663e+000,
    -2.625873e-001,
    -2.797592e-001,
    2.848739e+000,
    -3.363778e-002,
    -1.672768e+000,
    7.349952e-001,
    -1.708628e+000,
    3.557813e-001,
    -1.044841e+000,
    -1.712889e-001,
    7.091708e-001,
    -4.275119e+000,
    -7.565130e-001,
    2.483873e+000,
    -7.781321e-002,
    2.667776e+000,
    8.709126e-001,
    -1.067360e+000,
    -1.543712e-001,
    3.884866e-001,
    6.915851e+000,
    -4.250734e+000,
    -6.525729e-001,
    6.368377e-001,
    2.671865e+000,
    6.566986e-001,
    // albedo 0, turbidity 7
    -1.360356e+000,
    -4.336026e-001,
    -1.442967e+001,
    1.428579e+001,
    -3.990325e-003,
    4.600126e-001,
    1.023159e-001,
    3.367805e+000,
    4.999150e-001,
    -2.054147e+000,
    -1.064745e+000,
    -7.857491e-001,
    2.214734e+000,
    -3.764113e-002,
    8.504761e-001,
    -4.222958e-002,
    1.091377e-001,
    4.732161e-001,
    -8.953952e-001,
    1.048085e-001,
    1.481293e+000,
    -4.223012e+000,
    -4.164160e-002,
    5.999023e-001,
    6.310005e-002,
    7.156883e+000,
    1.066682e+000,
    -1.030251e+000,
    -2.777709e-001,
    -8.361086e-001,
    5.611154e+000,
    1.861240e-001,
    -5.823197e-001,
    6.716210e-001,
    -3.269717e+000,
    2.922029e-001,
    -1.095631e+000,
    -1.966849e-001,
    6.300566e-001,
    -7.129591e+000,
    -7.351951e-001,
    1.400340e+000,
    -6.997516e-003,
    2.879018e+000,
    8.879337e-001,
    -1.052935e+000,
    -1.551958e-001,
    2.334578e-001,
    1.040948e+001,
    -4.426381e+000,
    -3.477323e-001,
    6.257070e-001,
    2.451148e+000,
    6.570737e-001,
    // albedo 0, turbidity 8
    -1.382656e+000,
    -4.830539e-001,
    -1.107403e+001,
    1.127854e+001,
    -2.723641e-002,
    8.478005e-001,
    2.907652e-003,
    3.290364e+000,
    7.398950e-001,
    -2.230895e+000,
    -1.163446e+000,
    -1.001991e+001,
    1.125340e+001,
    -3.233871e-002,
    3.041577e-001,
    3.870458e-003,
    3.463879e-001,
    -8.829082e-002,
    -1.489234e+000,
    -3.402035e-001,
    2.948409e+000,
    -8.098077e+000,
    9.078299e-002,
    -3.179835e-001,
    4.730321e-001,
    6.765707e+000,
    1.440217e+000,
    -6.206234e-001,
    -1.701007e-001,
    -7.346357e-002,
    9.350033e+000,
    1.548964e-001,
    1.313206e+000,
    -1.479143e-001,
    -5.119165e+000,
    1.854277e-001,
    -1.226372e+000,
    -2.128299e-001,
    -1.643093e-001,
    -9.382334e+000,
    -4.857784e-001,
    -1.374948e-001,
    5.877245e-001,
    3.862307e+000,
    8.700125e-001,
    -1.030598e+000,
    -1.931668e-001,
    3.691403e-001,
    1.066393e+001,
    -4.244968e+000,
    -5.872571e-002,
    4.193140e-001,
    1.461878e+000,
    6.699478e-001,
    // albedo 0, turbidity 9
    -1.606656e+000,
    -7.140209e-001,
    -1.149565e+001,
    1.168427e+001,
    -2.245577e-002,
    7.718953e-001,
    -8.349882e-006,
    2.654449e+000,
    9.001224e-001,
    -2.100494e+000,
    -1.013602e+000,
    -1.638934e+001,
    1.729185e+001,
    -1.580924e-002,
    5.038208e-002,
    -1.628735e-002,
    1.762584e+000,
    -3.121794e-001,
    -3.228292e+000,
    -1.459508e+000,
    7.424519e+000,
    -1.194272e+001,
    4.931054e-002,
    6.493074e-001,
    3.590561e-001,
    4.068321e+000,
    1.613039e+000,
    1.278814e-001,
    4.010913e-002,
    -2.185675e+000,
    1.164548e+001,
    2.706306e-002,
    1.632886e-001,
    -1.090111e-002,
    -3.342580e+000,
    1.916992e-002,
    -1.400278e+000,
    -2.825658e-001,
    4.168149e-001,
    -1.195909e+001,
    -1.122968e-002,
    1.863328e-001,
    4.263033e-001,
    2.270053e+000,
    9.748449e-001,
    -1.017511e+000,
    -2.884028e-001,
    3.544996e-001,
    1.535118e+001,
    -5.009184e+000,
    1.511064e-001,
    2.916578e-001,
    7.889658e-001,
    6.294910e-001,
    // albedo 0, turbidity 10
    -2.031136e+000,
    -1.076357e+000,
    -8.660773e+000,
    8.800317e+000,
    -2.370842e-002,
    5.736027e-001,
    -8.441313e-006,
    2.248669e+000,
    9.001280e-001,
    -1.270967e+000,
    -7.828844e-001,
    -1.198232e+001,
    1.262753e+001,
    -1.509989e-002,
    1.663438e-001,
    2.440939e-004,
    2.068640e+000,
    -2.521574e-001,
    -6.600872e+000,
    -2.689874e+000,
    6.453928e+000,
    -9.592747e+000,
    -3.551170e-002,
    1.325662e+000,
    -1.894375e-002,
    3.506163e+000,
    1.469724e+000,
    7.961323e-001,
    -1.989144e-001,
    -2.685238e+000,
    1.034230e+001,
    2.076702e-001,
    -7.692350e-001,
    6.184894e-001,
    -1.969413e+000,
    3.842922e-002,
    -1.459073e+000,
    -4.964034e-001,
    1.060127e+000,
    -1.277712e+001,
    -9.634553e-001,
    5.610879e-001,
    -2.034286e-001,
    3.525910e-001,
    1.003048e+000,
    -1.021565e+000,
    -2.553022e-001,
    6.367571e-002,
    2.028825e+001,
    -4.623219e+000,
    -2.400428e-002,
    4.251423e-001,
    9.640897e-001,
    6.080298e-001,
    // albedo 1, turbidity 1
    -1.121224e+000,
    -1.710171e-001,
    -1.383038e+001,
    1.475343e+001,
    -3.137812e-002,
    1.035662e+000,
    4.060006e-002,
    5.222551e+000,
    5.001051e-001,
    -1.172565e+000,
    -1.880857e-001,
    7.283595e+000,
    -5.774643e+000,
    -9.051285e-002,
    9.108124e-001,
    -1.565627e-002,
    6.194404e+000,
    4.688599e-001,
    -1.124109e+000,
    -3.082816e-001,
    -2.179926e-001,
    1.330167e+000,
    -4.502252e-001,
    1.470140e+000,
    4.158616e-004,
    -4.724308e+000,
    1.134678e+000,
    -1.079810e+000,
    -9.226583e-002,
    1.465364e+000,
    1.348856e+000,
    4.357794e-001,
    1.771543e+000,
    8.115381e-003,
    6.057395e+000,
    2.462140e-001,
    -1.086668e+000,
    -2.709863e-001,
    2.249153e+000,
    -3.177505e+000,
    -7.138130e+000,
    1.112553e+000,
    -9.724210e-003,
    -2.392239e+000,
    9.352768e-001,
    -1.071158e+000,
    -1.272123e-001,
    1.644374e+000,
    4.326598e+000,
    -2.244682e+000,
    1.611051e+000,
    7.831866e-003,
    3.213282e+000,
    6.580432e-001,
    // albedo 1, turbidity 2
    -1.125449e+000,
    -1.733403e-001,
    -1.228038e+001,
    1.311695e+001,
    -3.541409e-002,
    1.005494e+000,
    4.147852e-002,
    5.316886e+000,
    6.051699e-001,
    -1.101273e+000,
    -1.422106e-001,
    5.484715e+000,
    -5.089835e+000,
    -6.655928e-002,
    2.076815e-001,
    1.633101e-001,
    7.624535e+000,
    3.044941e-001,
    -1.213425e+000,
    -3.085010e-001,
    5.550585e-001,
    1.302798e+000,
    -3.946488e-001,
    2.285152e+000,
    -1.925101e-001,
    -3.790065e+000,
    1.263207e+000,
    -9.610579e-001,
    9.458093e-003,
    5.293256e-001,
    1.553214e+000,
    6.053752e-001,
    1.172267e-001,
    3.674690e-001,
    7.305350e+000,
    1.509544e-001,
    -1.119731e+000,
    -2.765693e-001,
    2.433951e+000,
    -5.229810e+000,
    -7.449777e+000,
    2.123304e+000,
    -2.242917e-001,
    -1.669115e+000,
    1.041008e+000,
    -1.094324e+000,
    -1.418743e-001,
    1.836224e+000,
    1.063054e+001,
    -3.561209e+000,
    5.916534e-001,
    9.296571e-002,
    2.600060e+000,
    4.999316e-001,
    // albedo 1, turbidity 3
    -1.155818e+000,
    -2.162981e-001,
    -2.560068e+001,
    2.636088e+001,
    -1.382944e-002,
    8.101983e-001,
    4.709210e-002,
    4.301909e+000,
    6.416958e-001,
    -1.171460e+000,
    -1.866443e-001,
    8.497645e+000,
    -8.396229e+000,
    -3.345417e-002,
    2.960022e-001,
    7.985279e-002,
    7.420544e+000,
    5.552152e-001,
    -1.114385e+000,
    -2.963805e-001,
    5.955009e-002,
    2.320529e+000,
    -7.649266e-002,
    2.277940e+000,
    -5.942479e-002,
    -4.040964e+000,
    9.588558e-001,
    -1.070647e+000,
    4.194546e-002,
    -5.701942e-001,
    -1.001278e+000,
    -3.389615e-001,
    -8.559533e-001,
    5.070784e-001,
    9.805560e+000,
    3.529747e-001,
    -1.057912e+000,
    -2.733753e-001,
    3.080618e+000,
    7.477366e-001,
    3.484876e-001,
    2.214994e+000,
    -2.597625e-001,
    -2.842961e+000,
    9.178917e-001,
    -1.105636e+000,
    -1.815423e-001,
    1.651373e+000,
    -2.553941e-003,
    -5.008441e+000,
    -6.378055e-001,
    2.370503e-001,
    1.890656e+000,
    6.018255e-001,
    // albedo 1, turbidity 4
    -1.194221e+000,
    -2.570801e-001,
    -8.919095e+000,
    9.380192e+000,
    -2.650470e-002,
    6.233645e-001,
    6.663964e-002,
    4.027438e+000,
    6.125383e-001,
    -1.308216e+000,
    -3.781794e-001,
    2.369107e+000,
    -1.977066e+000,
    -4.079773e-002,
    1.443960e-001,
    8.206719e-002,
    3.465933e+000,
    5.442867e-001,
    -1.048459e+000,
    -1.617720e-001,
    1.015136e+000,
    -2.989579e-001,
    -2.764989e-001,
    2.427990e+000,
    -1.147612e-001,
    1.522921e+000,
    1.041410e+000,
    -1.105796e+000,
    -4.826962e-002,
    -8.419705e-001,
    3.285981e+000,
    7.975109e-001,
    -1.954456e+000,
    7.424696e-001,
    4.604902e+000,
    2.602059e-001,
    -1.033856e+000,
    -2.507382e-001,
    2.882633e+000,
    -8.250912e+000,
    -6.878129e+000,
    2.948966e+000,
    -2.850302e-001,
    -8.253849e-001,
    9.844934e-001,
    -1.125219e+000,
    -1.879003e-001,
    1.474838e+000,
    1.453266e+001,
    -3.271910e+000,
    -1.231579e+000,
    2.397524e-001,
    1.654932e+000,
    5.625696e-001,
    // albedo 1, turbidity 5
    -1.246640e+000,
    -3.202274e-001,
    -6.355032e+000,
    6.364143e+000,
    9.028376e-004,
    3.146975e-001,
    1.550718e-001,
    3.413749e+000,
    4.999065e-001,
    -1.477471e+000,
    -5.819223e-001,
    1.329471e+000,
    -2.694229e-001,
    -4.575905e-002,
    5.087866e-001,
    -6.857139e-002,
    1.810092e+000,
    6.318693e-001,
    -1.046136e+000,
    -6.763679e-002,
    6.725076e-001,
    -1.036786e+000,
    -3.192799e-001,
    1.724205e+000,
    6.468388e-002,
    3.953855e+000,
    9.417528e-001,
    -1.033910e+000,
    -1.295544e-001,
    -4.551294e-001,
    2.659205e+000,
    8.887235e-001,
    -1.733153e+000,
    6.540117e-001,
    8.046523e-001,
    3.597443e-001,
    -1.094530e+000,
    -2.282012e-001,
    2.298267e+000,
    -5.184881e+000,
    -6.122309e+000,
    2.590799e+000,
    -1.618707e-001,
    1.116033e+000,
    8.867666e-001,
    -1.095556e+000,
    -1.807112e-001,
    1.406193e+000,
    8.120385e+000,
    -3.058239e+000,
    -1.121150e+000,
    2.933606e-001,
    1.488339e+000,
    6.374827e-001,
    // albedo 1, turbidity 6
    -1.270123e+000,
    -3.552595e-001,
    -8.975893e+000,
    9.110080e+000,
    -3.388207e-003,
    3.559109e-001,
    1.201097e-001,
    3.109904e+000,
    4.998957e-001,
    -1.663376e+000,
    -7.846840e-001,
    6.951405e-001,
    3.139107e-001,
    -2.448004e-002,
    3.572505e-001,
    1.453572e-002,
    6.307761e-001,
    5.142914e-001,
    -9.518772e-001,
    7.764573e-002,
    1.247094e+000,
    -2.224855e+000,
    -1.195310e-001,
    1.709581e+000,
    -8.836329e-002,
    5.688916e+000,
    1.113629e+000,
    -1.087154e+000,
    -2.665646e-001,
    -8.624251e-001,
    4.536060e+000,
    4.180650e-001,
    -1.629798e+000,
    8.479560e-001,
    -1.293696e+000,
    1.869693e-001,
    -1.064826e+000,
    -1.599892e-001,
    2.285337e+000,
    -8.584887e+000,
    -3.074560e+000,
    2.139459e+000,
    -2.592372e-001,
    1.937577e+000,
    9.957954e-001,
    -1.099622e+000,
    -1.849797e-001,
    1.193609e+000,
    1.416481e+001,
    -5.009527e+000,
    -8.592493e-001,
    3.485606e-001,
    1.884203e+000,
    6.097274e-001,
    // albedo 1, turbidity 7
    -1.344841e+000,
    -4.339942e-001,
    -9.193112e+000,
    9.385864e+000,
    -9.742818e-003,
    4.812040e-001,
    7.690647e-002,
    2.843801e+000,
    5.228047e-001,
    -1.975928e+000,
    -1.042040e+000,
    9.695714e-001,
    3.718000e-001,
    -3.334078e-002,
    1.333620e-001,
    8.180282e-002,
    -1.652429e-001,
    3.267010e-001,
    -8.651864e-001,
    1.288722e-001,
    6.811456e-001,
    -3.282787e+000,
    -9.074685e-002,
    1.894059e+000,
    -1.849744e-001,
    6.610614e+000,
    1.322978e+000,
    -1.103780e+000,
    -3.279618e-001,
    -4.193802e-001,
    7.331165e+000,
    6.529659e-001,
    -2.227297e+000,
    9.625482e-001,
    -3.348971e+000,
    -7.261722e-003,
    -1.055963e+000,
    -1.527328e-001,
    1.786114e+000,
    -1.367578e+001,
    -3.450729e+000,
    2.641691e+000,
    -3.229222e-001,
    2.800131e+000,
    1.129409e+000,
    -1.111541e+000,
    -2.123518e-001,
    1.286159e+000,
    2.297563e+001,
    -4.591526e+000,
    -1.374672e+000,
    3.462811e-001,
    1.071127e+000,
    5.498514e-001,
    // albedo 1, turbidity 8
    -1.387544e+000,
    -4.964558e-001,
    -9.744778e+000,
    1.014533e+001,
    -2.463089e-002,
    7.188705e-001,
    3.919951e-003,
    2.760792e+000,
    7.369418e-001,
    -2.206536e+000,
    -1.191342e+000,
    -2.244384e+000,
    3.629413e+000,
    -3.601610e-002,
    7.725349e-002,
    5.357588e-002,
    -2.692147e-001,
    -1.142476e-001,
    -1.358286e+000,
    -2.268740e-001,
    9.805731e-001,
    -5.163195e+000,
    -8.589000e-003,
    7.697565e-001,
    2.198750e-001,
    7.029301e+000,
    1.567170e+000,
    -7.167767e-001,
    -2.969978e-001,
    2.300987e-001,
    7.956088e+000,
    6.339728e-001,
    -6.195374e-001,
    2.502844e-001,
    -6.307569e+000,
    -2.208822e-002,
    -1.210525e+000,
    -1.245541e-001,
    9.742409e-001,
    -9.705683e+000,
    -1.658899e+000,
    1.365829e+000,
    2.003500e-001,
    4.400174e+000,
    1.042345e+000,
    -1.061524e+000,
    -2.323500e-001,
    1.284880e+000,
    1.294836e+001,
    -5.011732e+000,
    -9.141086e-001,
    2.723804e-001,
    6.225528e-001,
    6.030977e-001,
    // albedo 1, turbidity 9
    -1.548946e+000,
    -6.802676e-001,
    -1.274231e+001,
    1.312954e+001,
    -1.834225e-002,
    7.051580e-001,
    -8.330446e-006,
    2.320435e+000,
    9.001244e-001,
    -1.867128e+000,
    -9.670210e-001,
    -6.847422e+000,
    7.952765e+000,
    -1.985986e-002,
    1.690548e-002,
    -1.176902e-002,
    8.988469e-001,
    -3.242269e-001,
    -3.470633e+000,
    -1.555121e+000,
    2.684966e+000,
    -5.964736e+000,
    -5.524158e-003,
    1.187089e+000,
    2.552534e-001,
    4.394076e+000,
    1.656399e+000,
    4.095837e-001,
    1.440005e-001,
    -5.602190e-001,
    7.110869e+000,
    2.313366e-001,
    -1.373206e+000,
    1.973962e-001,
    -4.112998e+000,
    -5.877027e-002,
    -1.540633e+000,
    -3.264234e-001,
    1.072405e+000,
    -7.205546e+000,
    -5.125251e-001,
    2.009905e+000,
    1.531985e-001,
    2.113439e+000,
    1.042547e+000,
    -1.013330e+000,
    -2.663837e-001,
    1.168934e+000,
    9.315778e+000,
    -4.320502e+000,
    -1.303393e+000,
    2.825872e-001,
    2.365015e-001,
    5.993344e-001,
    // albedo 1, turbidity 10
    -2.055426e+000,
    -1.093229e+000,
    -3.487182e+000,
    3.753855e+000,
    -4.639837e-002,
    5.797714e-001,
    -8.056992e-006,
    1.916262e+000,
    9.001298e-001,
    -1.643864e+000,
    -9.676934e-001,
    -1.147133e+001,
    1.253880e+001,
    2.347351e-002,
    -1.602964e-002,
    4.481579e-003,
    1.373645e+000,
    -2.884929e-001,
    -6.156336e+000,
    -2.568735e+000,
    6.499533e+000,
    -9.136753e+000,
    -1.751599e-001,
    1.876960e+000,
    -7.959051e-002,
    3.074951e+000,
    1.579874e+000,
    7.378485e-001,
    -2.614544e-001,
    -2.861777e+000,
    9.518947e+000,
    5.033808e-001,
    -1.844722e+000,
    6.855962e-001,
    -1.497263e+000,
    -9.081643e-002,
    -1.341940e+000,
    -3.847183e-001,
    2.045437e+000,
    -1.179073e+001,
    -1.532773e+000,
    1.639939e+000,
    -2.668175e-001,
    -8.401827e-001,
    1.083722e+000,
    -1.086126e+000,
    -2.811402e-001,
    7.554239e-001,
    1.862181e+001,
    -4.343385e+000,
    -8.611011e-001,
    3.146558e-001,
    7.022438e-001,
    5.872694e-001,
};

double datasetRad560[] =
{
    // albedo 0, turbidity 1
    1.518543e-002,
    1.176421e-002,
    1.736355e-002,
    1.085640e-001,
    4.928107e-002,
    6.789277e-002,
    // albedo 0, turbidity 2
    1.482072e-002,
    1.335627e-002,
    7.685462e-003,
    1.336625e-001,
    4.842644e-002,
    7.083679e-002,
    // albedo 0, turbidity 3
    1.406436e-002,
    1.604888e-002,
    -9.000273e-003,
    1.735923e-001,
    4.526955e-002,
    7.742648e-002,
    // albedo 0, turbidity 4
    1.296165e-002,
    2.074811e-002,
    -3.672731e-002,
    2.310227e-001,
    4.272776e-002,
    8.807197e-002,
    // albedo 0, turbidity 5
    1.185836e-002,
    2.557920e-002,
    -6.240734e-002,
    2.766326e-001,
    4.714655e-002,
    9.809189e-002,
    // albedo 0, turbidity 6
    1.107469e-002,
    2.825097e-002,
    -7.618392e-002,
    2.978619e-001,
    5.429803e-002,
    1.044545e-001,
    // albedo 0, turbidity 7
    1.030435e-002,
    3.060206e-002,
    -8.858708e-002,
    3.072427e-001,
    8.473378e-002,
    1.077059e-001,
    // albedo 0, turbidity 8
    9.197751e-003,
    3.269422e-002,
    -9.785581e-002,
    2.997964e-001,
    1.328366e-001,
    1.192367e-001,
    // albedo 0, turbidity 9
    8.191103e-003,
    3.038883e-002,
    -8.623921e-002,
    2.362785e-001,
    2.259917e-001,
    1.331360e-001,
    // albedo 0, turbidity 10
    7.275920e-003,
    2.128876e-002,
    -4.464890e-002,
    1.022425e-001,
    3.640615e-001,
    1.521652e-001,
    // albedo 1, turbidity 1
    1.623600e-002,
    1.386631e-002,
    1.790676e-002,
    9.999420e-002,
    1.334051e-001,
    1.524062e-001,
    // albedo 1, turbidity 2
    1.580346e-002,
    1.594123e-002,
    5.795411e-003,
    1.311774e-001,
    1.256680e-001,
    1.627637e-001,
    // albedo 1, turbidity 3
    1.508292e-002,
    1.888592e-002,
    -1.186753e-002,
    1.719109e-001,
    1.235706e-001,
    1.739866e-001,
    // albedo 1, turbidity 4
    1.385430e-002,
    2.238574e-002,
    -3.390048e-002,
    2.155912e-001,
    1.366535e-001,
    1.840316e-001,
    // albedo 1, turbidity 5
    1.289448e-002,
    2.572803e-002,
    -5.406854e-002,
    2.481650e-001,
    1.539663e-001,
    1.943329e-001,
    // albedo 1, turbidity 6
    1.229427e-002,
    2.715903e-002,
    -6.212273e-002,
    2.543339e-001,
    1.780617e-001,
    1.961306e-001,
    // albedo 1, turbidity 7
    1.142362e-002,
    2.928317e-002,
    -7.246911e-002,
    2.573202e-001,
    2.123595e-001,
    2.030761e-001,
    // albedo 1, turbidity 8
    1.030850e-002,
    2.979460e-002,
    -7.568370e-002,
    2.359473e-001,
    2.693691e-001,
    2.158786e-001,
    // albedo 1, turbidity 9
    9.256414e-003,
    2.622384e-002,
    -5.910990e-002,
    1.602850e-001,
    3.679614e-001,
    2.281095e-001,
    // albedo 1, turbidity 10
    8.220083e-003,
    1.701079e-002,
    -1.768254e-002,
    2.593519e-002,
    4.977242e-001,
    2.394514e-001,
};

double dataset600[] =
{
    // albedo 0, turbidity 1
    -1.120756e+000,
    -1.756050e-001,
    -3.557732e+000,
    5.117996e+000,
    -1.042966e-001,
    1.269364e+000,
    1.318863e-002,
    3.718263e+000,
    5.393663e-001,
    -1.170564e+000,
    -1.845108e-001,
    1.081952e+000,
    1.330153e+000,
    -2.486698e-001,
    7.864551e-001,
    3.710973e-003,
    4.567181e+000,
    4.998408e-001,
    -1.036563e+000,
    -2.605284e-001,
    3.803752e+000,
    -3.585400e+000,
    -9.070196e-001,
    2.380958e+000,
    -1.320680e-002,
    -4.210738e+000,
    1.085121e+000,
    -1.193752e+000,
    -1.236757e-001,
    -2.036484e-001,
    4.137855e+000,
    1.566414e+000,
    8.510547e-001,
    1.653213e-002,
    5.488784e+000,
    2.335910e-001,
    -9.950781e-001,
    -2.103974e-001,
    2.992004e+000,
    -4.050491e+000,
    -6.354208e+000,
    2.250652e+000,
    -1.548511e-002,
    -1.876535e+000,
    9.733518e-001,
    -1.106820e+000,
    -1.804412e-001,
    1.960315e+000,
    3.667064e+000,
    -2.460232e+000,
    9.553453e-001,
    1.238019e-002,
    1.307691e+000,
    5.564710e-001,
    // albedo 0, turbidity 2
    -1.112834e+000,
    -1.534956e-001,
    -4.968015e+000,
    6.079068e+000,
    -8.917942e-002,
    1.167545e+000,
    5.945633e-002,
    5.295468e+000,
    6.272123e-001,
    -1.160910e+000,
    -1.640745e-001,
    7.416807e-001,
    -2.894668e-001,
    -8.983936e-002,
    3.778575e-002,
    2.133300e-001,
    6.390765e+000,
    3.592393e-001,
    -1.054872e+000,
    -2.642844e-001,
    4.375802e+000,
    -1.434824e+000,
    -7.521504e-001,
    3.669027e+000,
    -2.992879e-001,
    -5.159653e+000,
    1.284643e+000,
    -1.147542e+000,
    1.011446e-002,
    -2.308529e+000,
    1.587994e+000,
    1.226957e+000,
    -1.328837e+000,
    5.996235e-001,
    1.004278e+001,
    5.212352e-002,
    -1.023945e+000,
    -2.867193e-001,
    3.733660e+000,
    -2.572157e+000,
    -7.749675e+000,
    3.927326e+000,
    -3.230666e-001,
    -4.260418e+000,
    1.091761e+000,
    -1.100815e+000,
    -1.590204e-001,
    1.413330e+000,
    6.546557e+000,
    -2.407235e+000,
    -2.678587e-001,
    2.367155e-001,
    2.242596e+000,
    5.273419e-001,
    // albedo 0, turbidity 3
    -1.137271e+000,
    -1.838447e-001,
    -2.268731e+000,
    3.013967e+000,
    -1.471213e-001,
    9.047947e-001,
    8.086373e-002,
    4.834215e+000,
    6.545047e-001,
    -1.136415e+000,
    -1.536696e-001,
    -1.821062e+000,
    1.756804e+000,
    -9.313635e-002,
    2.208938e-001,
    2.021774e-001,
    7.289664e+000,
    4.997813e-001,
    -1.173214e+000,
    -3.202233e-001,
    4.868221e+000,
    -2.485467e+000,
    -7.693969e-001,
    3.027854e+000,
    -1.745243e-001,
    -4.896365e+000,
    1.014186e+000,
    -1.021346e+000,
    7.262425e-002,
    -2.940205e+000,
    3.357462e+000,
    1.150486e+000,
    -1.710207e+000,
    7.381637e-001,
    9.857427e+000,
    3.036725e-001,
    -1.082107e+000,
    -2.721172e-001,
    3.071962e+000,
    -7.058088e+000,
    -5.103538e+000,
    3.852302e+000,
    -2.281911e-001,
    -2.565665e+000,
    9.669584e-001,
    -1.076296e+000,
    -1.655466e-001,
    1.323765e+000,
    1.496892e+001,
    -3.773928e+000,
    -5.211752e-001,
    2.583009e-001,
    1.797906e+000,
    5.888323e-001,
    // albedo 0, turbidity 4
    -1.180432e+000,
    -2.327942e-001,
    -7.152650e-001,
    1.078120e+000,
    -2.935788e-001,
    6.977295e-001,
    1.118530e-001,
    4.270574e+000,
    6.241267e-001,
    -1.260549e+000,
    -2.865438e-001,
    -2.736770e+000,
    2.720969e+000,
    1.291231e-001,
    4.072562e-001,
    4.510932e-002,
    5.412464e+000,
    6.781695e-001,
    -1.119712e+000,
    -2.521160e-001,
    4.860527e+000,
    -1.950603e+000,
    -1.598805e+000,
    2.556718e+000,
    2.462723e-002,
    -2.059404e+000,
    8.000995e-001,
    -1.056386e+000,
    2.018258e-002,
    -3.728955e+000,
    1.022270e+000,
    1.722210e+000,
    -2.691554e+000,
    8.329883e-001,
    6.982450e+000,
    4.746778e-001,
    -1.044811e+000,
    -2.531291e-001,
    3.102204e+000,
    -3.662632e+000,
    -5.609358e+000,
    4.574385e+000,
    -2.173600e-001,
    -1.646110e+000,
    8.593305e-001,
    -1.090027e+000,
    -1.699462e-001,
    7.118896e-001,
    1.287572e+001,
    -2.747429e+000,
    -1.706223e+000,
    4.483382e-001,
    2.029605e+000,
    6.366599e-001,
    // albedo 0, turbidity 5
    -1.232266e+000,
    -2.905676e-001,
    -4.158347e-001,
    5.285264e-001,
    -3.064312e-001,
    5.569478e-001,
    1.195289e-001,
    3.788091e+000,
    5.970680e-001,
    -1.451205e+000,
    -5.169964e-001,
    -2.018331e-001,
    1.499655e+000,
    -1.575963e+000,
    2.761459e-001,
    5.184923e-002,
    2.301119e+000,
    6.177771e-001,
    -1.059832e+000,
    -7.658003e-002,
    6.456894e-001,
    -4.398594e+000,
    5.369604e+000,
    2.121235e+000,
    3.210869e-002,
    3.542794e+000,
    9.114953e-001,
    -1.040966e+000,
    -1.269405e-001,
    -3.751056e-001,
    1.229395e+001,
    -1.977090e+001,
    -2.458488e+000,
    7.711932e-001,
    8.079227e-001,
    3.865305e-001,
    -1.061923e+000,
    -1.981907e-001,
    1.089854e+000,
    -3.414507e+000,
    8.032592e+000,
    3.459965e+000,
    -1.253984e-001,
    1.188198e+000,
    8.639277e-001,
    -1.070607e+000,
    -1.627049e-001,
    7.012071e-001,
    2.138780e+000,
    -5.006595e+000,
    -1.096698e+000,
    6.658771e-001,
    1.999430e+000,
    6.557122e-001,
    // albedo 0, turbidity 6
    -1.280090e+000,
    -3.357179e-001,
    -9.337154e-002,
    -5.075553e-003,
    -3.096112e+000,
    4.001499e-001,
    1.489818e-001,
    3.515349e+000,
    5.571477e-001,
    -1.648190e+000,
    -7.024227e-001,
    -2.925797e-002,
    1.658094e+000,
    4.229924e+000,
    3.502683e-001,
    3.180108e-002,
    1.430955e+000,
    5.739552e-001,
    -9.589189e-001,
    2.559557e-002,
    2.192186e-001,
    -5.276316e+000,
    -4.153922e+000,
    1.855574e+000,
    3.052317e-002,
    4.323694e+000,
    9.839497e-001,
    -1.076589e+000,
    -1.936109e-001,
    -4.162615e-001,
    1.202609e+001,
    -9.327314e+000,
    -2.326508e+000,
    7.983253e-001,
    2.100845e-001,
    3.135170e-001,
    -1.049437e+000,
    -1.694738e-001,
    1.062110e+000,
    5.575299e+000,
    4.846701e-001,
    3.089474e+000,
    -1.584214e-001,
    1.369457e+000,
    8.995377e-001,
    -1.069986e+000,
    -1.830827e-001,
    5.006422e-001,
    -3.063835e-003,
    -2.768514e+000,
    -1.258027e+000,
    6.679955e-001,
    1.840288e+000,
    6.498676e-001,
    // albedo 0, turbidity 7
    -1.328971e+000,
    -3.853230e-001,
    -2.343098e-001,
    -6.505414e-003,
    -4.859294e+000,
    3.752993e-001,
    1.670718e-001,
    3.474961e+000,
    4.998573e-001,
    -2.023062e+000,
    -1.023840e+000,
    4.308501e-001,
    1.473146e+000,
    6.112105e+000,
    5.767265e-001,
    -3.107377e-002,
    7.748759e-002,
    5.016978e-001,
    -8.575747e-001,
    1.580212e-001,
    -7.365004e-001,
    -4.007773e+000,
    -4.051657e+000,
    8.889282e-001,
    1.978413e-001,
    6.282132e+000,
    1.063928e+000,
    -1.073428e+000,
    -3.228761e-001,
    4.793085e-001,
    5.455778e+000,
    -7.830559e+000,
    -9.794478e-001,
    5.370543e-001,
    -3.022750e+000,
    2.818600e-001,
    -1.057120e+000,
    -1.266841e-001,
    4.555368e-001,
    1.201278e+001,
    -9.293773e-001,
    1.439595e+000,
    3.262182e-002,
    2.890364e+000,
    8.821540e-001,
    -1.060079e+000,
    -1.816680e-001,
    3.541107e-001,
    -2.642196e-003,
    -2.588317e+000,
    -5.640010e-001,
    6.643994e-001,
    1.673077e+000,
    6.658333e-001,
    // albedo 0, turbidity 8
    -1.395409e+000,
    -4.658947e-001,
    -4.370597e-001,
    1.342039e+000,
    -1.108674e+000,
    6.439316e-001,
    1.355229e-002,
    3.241153e+000,
    6.696079e-001,
    -2.418167e+000,
    -1.266061e+000,
    3.287382e-001,
    -1.486721e+000,
    -6.770180e-001,
    2.439008e-001,
    1.703788e-001,
    1.664559e-002,
    -6.330217e-003,
    -1.221212e+000,
    -1.072571e-001,
    -1.655914e+000,
    2.659047e+000,
    6.830770e+000,
    4.984792e-001,
    2.538158e-001,
    6.500660e+000,
    1.486576e+000,
    -7.182331e-001,
    -2.519055e-001,
    1.641261e+000,
    -5.500375e+000,
    -1.253143e+001,
    -1.542672e-001,
    1.741161e-001,
    -4.907497e+000,
    7.968864e-002,
    -1.207117e+000,
    -1.635739e-001,
    -3.256308e-001,
    1.409033e+001,
    1.107883e+000,
    7.217342e-001,
    3.158860e-001,
    3.537550e+000,
    9.389751e-001,
    -1.015927e+000,
    -1.890895e-001,
    4.180376e-001,
    9.528535e+000,
    -4.073979e+000,
    -8.713087e-001,
    4.899379e-001,
    1.277831e+000,
    6.519818e-001,
    // albedo 0, turbidity 9
    -1.551242e+000,
    -6.400568e-001,
    -3.673011e-001,
    1.623228e+000,
    -1.482572e+000,
    5.625944e-001,
    -1.130924e-005,
    2.792007e+000,
    9.000924e-001,
    -1.971409e+000,
    -9.004995e-001,
    -2.337582e-001,
    -1.511905e+000,
    6.645432e-002,
    6.149087e-001,
    -3.184094e-002,
    2.026210e+000,
    -2.799058e-001,
    -3.464015e+000,
    -1.604654e+000,
    -1.514516e+000,
    2.768075e+000,
    4.084166e+000,
    -4.287171e-001,
    7.112107e-001,
    2.896460e+000,
    1.502031e+000,
    4.069978e-001,
    2.775394e-001,
    1.525761e+000,
    -5.264056e+000,
    -7.108445e+000,
    1.134996e+000,
    -4.122625e-001,
    -2.558151e+000,
    2.009854e-001,
    -1.504217e+000,
    -3.618442e-001,
    -2.305374e-001,
    1.434481e+001,
    -1.713254e+000,
    -5.670708e-001,
    5.206848e-001,
    1.704009e+000,
    8.447497e-001,
    -9.753124e-001,
    -2.080868e-001,
    2.450141e-001,
    -3.535206e-003,
    -2.121317e+000,
    -1.425634e-001,
    4.670084e-001,
    1.027875e+000,
    6.735543e-001,
    // albedo 0, turbidity 10
    -2.027207e+000,
    -1.003600e+000,
    -3.813114e-001,
    9.357907e-001,
    -1.031886e+000,
    5.523389e-001,
    -8.883940e-006,
    2.339379e+000,
    9.001659e-001,
    -1.506235e+000,
    -7.795241e-001,
    -4.313309e-001,
    9.124054e-001,
    -7.484352e-001,
    -8.417756e-002,
    -1.426561e-002,
    2.571178e+000,
    -2.504298e-001,
    -6.482777e+000,
    -2.700075e+000,
    -1.556622e+000,
    -2.978497e+000,
    4.623255e+000,
    1.953868e+000,
    3.113178e-001,
    2.311303e+000,
    1.451021e+000,
    9.357272e-001,
    -1.066566e-001,
    1.476763e+000,
    6.889797e+000,
    -1.038036e+001,
    -2.094856e+000,
    1.330069e-001,
    -1.446404e+000,
    1.121890e-001,
    -1.398229e+000,
    -3.167573e-001,
    -1.276866e-001,
    1.239440e+000,
    1.816678e+000,
    1.586775e+000,
    8.043533e-002,
    3.219192e-001,
    9.200620e-001,
    -1.070734e+000,
    -3.636167e-001,
    2.426490e-001,
    8.282765e+000,
    -3.588710e+000,
    -9.105402e-001,
    3.760276e-001,
    5.756358e-001,
    6.508161e-001,
    // albedo 1, turbidity 1
    -1.120757e+000,
    -1.756034e-001,
    -3.557732e+000,
    5.117996e+000,
    -1.042960e-001,
    1.269364e+000,
    1.318834e-002,
    3.718263e+000,
    5.393663e-001,
    -1.170565e+000,
    -1.845093e-001,
    1.081952e+000,
    1.330153e+000,
    -2.486697e-001,
    7.864550e-001,
    3.709405e-003,
    4.567181e+000,
    4.998408e-001,
    -1.036564e+000,
    -2.605265e-001,
    3.803752e+000,
    -3.585400e+000,
    -9.070196e-001,
    2.380958e+000,
    -1.320996e-002,
    -4.210738e+000,
    1.085121e+000,
    -1.193753e+000,
    -1.236733e-001,
    -2.036483e-001,
    4.137855e+000,
    1.566414e+000,
    8.510543e-001,
    1.652749e-002,
    5.488784e+000,
    2.335910e-001,
    -9.950796e-001,
    -2.103948e-001,
    2.992004e+000,
    -4.050491e+000,
    -6.354208e+000,
    2.250652e+000,
    -1.548996e-002,
    -1.876535e+000,
    9.733518e-001,
    -1.106823e+000,
    -1.804388e-001,
    1.960315e+000,
    3.667064e+000,
    -2.460232e+000,
    9.553451e-001,
    1.237721e-002,
    1.307692e+000,
    5.564710e-001,
    // albedo 1, turbidity 2
    -1.113356e+000,
    -1.560185e-001,
    -7.788803e+000,
    8.963658e+000,
    -5.322872e-002,
    1.116670e+000,
    7.024842e-002,
    4.886694e+000,
    5.931909e-001,
    -1.134232e+000,
    -1.667475e-001,
    4.176259e+000,
    -3.242194e+000,
    -7.889230e-002,
    8.254326e-002,
    1.400333e-001,
    5.395289e+000,
    4.862375e-001,
    -1.105040e+000,
    -2.389195e-001,
    9.866260e-001,
    1.271557e+000,
    -6.066849e-001,
    3.599900e+000,
    -1.681445e-001,
    -2.812867e+000,
    1.053791e+000,
    -1.078302e+000,
    -2.258635e-002,
    7.407482e-001,
    1.805864e-001,
    9.070580e-001,
    -1.720820e+000,
    4.256187e-001,
    6.982502e+000,
    3.350778e-001,
    -1.070883e+000,
    -2.752054e-001,
    2.937203e+000,
    -2.246366e+000,
    -9.847865e+000,
    3.104714e+000,
    -2.573859e-001,
    -2.816401e+000,
    8.478900e-001,
    -1.090880e+000,
    -1.453755e-001,
    2.046382e+000,
    5.595795e+000,
    -2.809181e+000,
    -9.239576e-001,
    1.783176e-001,
    2.051350e+000,
    5.815062e-001,
    // albedo 1, turbidity 3
    -1.136641e+000,
    -1.825277e-001,
    -3.464338e+000,
    4.413974e+000,
    -1.123917e-001,
    1.009115e+000,
    5.542918e-002,
    4.702599e+000,
    6.799974e-001,
    -1.146478e+000,
    -1.593833e-001,
    -9.055790e-001,
    8.991902e-001,
    -4.711416e-002,
    -3.813573e-001,
    2.290428e-001,
    6.961903e+000,
    4.206011e-001,
    -1.136317e+000,
    -3.103198e-001,
    4.219694e+000,
    -2.031887e+000,
    -7.184952e-001,
    3.795646e+000,
    -1.650547e-001,
    -5.402471e+000,
    1.118561e+000,
    -1.044973e+000,
    7.826651e-002,
    -2.043684e+000,
    3.410720e+000,
    1.974969e+000,
    -2.736513e+000,
    6.828176e-001,
    1.049084e+001,
    1.894241e-001,
    -1.076125e+000,
    -2.930526e-001,
    3.722784e+000,
    -7.364061e+000,
    -7.399428e+000,
    4.034307e+000,
    -3.489831e-001,
    -3.438955e+000,
    1.077145e+000,
    -1.100551e+000,
    -1.533449e-001,
    1.767589e+000,
    1.479022e+001,
    -2.910058e+000,
    -1.732923e+000,
    2.193598e-001,
    1.880974e+000,
    4.999331e-001,
    // albedo 1, turbidity 4
    -1.175282e+000,
    -2.274651e-001,
    -8.788053e-001,
    1.446934e+000,
    -2.568124e-001,
    7.201567e-001,
    1.054963e-001,
    4.149007e+000,
    6.084060e-001,
    -1.224868e+000,
    -2.528005e-001,
    -2.861303e+000,
    3.033667e+000,
    1.405049e-001,
    2.481768e-001,
    6.435189e-002,
    5.409907e+000,
    6.372238e-001,
    -1.144647e+000,
    -3.063749e-001,
    4.347579e+000,
    -2.473291e+000,
    -1.180139e+000,
    2.550631e+000,
    3.833967e-002,
    -3.231444e+000,
    8.737219e-001,
    -1.028428e+000,
    8.888974e-002,
    -2.431225e+000,
    2.811511e+000,
    2.400771e+000,
    -2.380403e+000,
    7.114868e-001,
    8.190106e+000,
    4.166861e-001,
    -1.076730e+000,
    -3.129260e-001,
    3.582560e+000,
    -5.902417e+000,
    -6.959342e+000,
    3.528030e+000,
    -2.613596e-001,
    -2.993803e+000,
    8.934226e-001,
    -1.107957e+000,
    -1.728652e-001,
    1.679540e+000,
    1.238391e+001,
    -2.945620e+000,
    -1.568811e+000,
    2.418421e-001,
    1.360652e+000,
    6.182405e-001,
    // albedo 1, turbidity 5
    -1.215034e+000,
    -2.755459e-001,
    -1.477751e-001,
    4.448730e-001,
    -4.027817e-001,
    4.787013e-001,
    1.200617e-001,
    3.613995e+000,
    5.999756e-001,
    -1.443500e+000,
    -5.194350e-001,
    1.588243e-001,
    1.429114e+000,
    -2.310655e+000,
    3.033213e-001,
    2.308566e-002,
    1.894189e+000,
    6.066576e-001,
    -1.051421e+000,
    -9.990731e-002,
    5.187710e-001,
    -3.890856e+000,
    7.794599e+000,
    1.810628e+000,
    6.532073e-002,
    2.564480e+000,
    9.334916e-001,
    -1.034548e+000,
    -6.777012e-002,
    -2.587520e-002,
    1.062675e+001,
    -2.266196e+001,
    -2.002081e+000,
    7.508804e-001,
    2.022771e+000,
    3.517577e-001,
    -1.090576e+000,
    -2.542157e-001,
    2.213560e+000,
    -3.563890e+000,
    9.180955e+000,
    2.780121e+000,
    -2.656654e-001,
    -5.012514e-002,
    8.968751e-001,
    -1.104356e+000,
    -1.955634e-001,
    1.782217e+000,
    1.085584e+000,
    -5.011522e+000,
    -1.075140e+000,
    3.828238e-001,
    6.133363e-001,
    6.448312e-001,
    // albedo 1, turbidity 6
    -1.261147e+000,
    -3.271435e-001,
    1.136430e-001,
    -3.464762e-003,
    -3.025565e+000,
    3.660675e-001,
    1.337332e-001,
    3.190374e+000,
    5.655627e-001,
    -1.611753e+000,
    -6.914768e-001,
    2.911405e-001,
    1.806475e+000,
    2.823240e+000,
    3.320241e-001,
    2.606391e-002,
    9.946717e-001,
    5.581393e-001,
    -9.491151e-001,
    9.848038e-003,
    2.711804e-001,
    -5.319331e+000,
    1.135835e-001,
    1.669815e+000,
    3.604115e-002,
    3.506230e+000,
    1.008650e+000,
    -1.109597e+000,
    -1.650703e-001,
    -3.529912e-001,
    1.209251e+001,
    -1.435008e+001,
    -2.085063e+000,
    7.955493e-001,
    1.240407e+000,
    2.856509e-001,
    -1.035803e+000,
    -1.963707e-001,
    2.407913e+000,
    -1.564693e+000,
    4.483717e+000,
    2.795295e+000,
    -2.799711e-001,
    6.851892e-002,
    9.312311e-001,
    -1.132687e+000,
    -2.383551e-001,
    1.590132e+000,
    1.025733e+000,
    -4.837236e+000,
    -1.334195e+000,
    4.022060e-001,
    4.281273e-001,
    6.334802e-001,
    // albedo 1, turbidity 7
    -1.310240e+000,
    -3.819813e-001,
    2.469845e-002,
    -7.043983e-003,
    -5.009925e+000,
    3.560980e-001,
    1.582176e-001,
    2.966421e+000,
    4.998910e-001,
    -1.993638e+000,
    -1.029241e+000,
    7.780588e-001,
    1.080741e+000,
    7.179598e+000,
    2.478857e-001,
    1.935012e-002,
    -3.434240e-001,
    4.813586e-001,
    -8.209344e-001,
    1.728853e-001,
    -7.045676e-001,
    -3.384688e+000,
    -4.855111e+000,
    1.661563e+000,
    4.252574e-002,
    5.701648e+000,
    1.110774e+000,
    -1.130678e+000,
    -3.273624e-001,
    5.555549e-001,
    5.800793e+000,
    -8.817085e+000,
    -2.344445e+000,
    7.532869e-001,
    -2.418368e+000,
    2.201826e-001,
    -1.032417e+000,
    -1.335568e-001,
    1.707051e+000,
    8.168228e+000,
    -5.151972e-003,
    2.785504e+000,
    -2.123703e-001,
    1.770173e+000,
    9.064082e-001,
    -1.125604e+000,
    -2.328530e-001,
    1.537245e+000,
    4.347312e+000,
    -4.368526e+000,
    -1.527321e+000,
    3.574251e-001,
    5.982159e-001,
    6.705880e-001,
    // albedo 1, turbidity 8
    -1.381743e+000,
    -4.607543e-001,
    -2.754732e-001,
    9.134243e-001,
    -7.581174e-001,
    6.220814e-001,
    2.353878e-002,
    2.891536e+000,
    6.426078e-001,
    -2.362341e+000,
    -1.306326e+000,
    6.909936e-001,
    -7.196658e-001,
    -4.501812e-001,
    -5.219928e-002,
    2.111683e-001,
    -9.499603e-001,
    3.301774e-002,
    -1.218829e+000,
    -6.834768e-002,
    -1.241760e+000,
    1.122890e+000,
    5.750762e+000,
    1.231058e+000,
    6.884716e-003,
    6.801032e+000,
    1.512485e+000,
    -6.781560e-001,
    -2.446588e-001,
    1.302166e+000,
    -2.334650e+000,
    -1.218960e+001,
    -1.257952e+000,
    5.387955e-001,
    -5.559859e+000,
    -1.209718e-002,
    -1.270037e+000,
    -1.870204e-001,
    9.650201e-001,
    9.976613e+000,
    1.444014e+000,
    1.523442e+000,
    -2.753646e-002,
    3.415790e+000,
    1.017645e+000,
    -1.046712e+000,
    -2.173979e-001,
    1.473981e+000,
    4.368847e+000,
    -4.642506e+000,
    -1.049951e+000,
    3.511771e-001,
    2.379457e-001,
    6.307946e-001,
    // albedo 1, turbidity 9
    -1.532302e+000,
    -6.390752e-001,
    -1.369123e-001,
    1.480171e+000,
    -1.313391e+000,
    5.210118e-001,
    -1.053608e-005,
    2.352090e+000,
    9.000581e-001,
    -2.042866e+000,
    -1.015386e+000,
    1.750126e-001,
    -9.921800e-001,
    -9.449241e-002,
    4.791921e-001,
    -2.744712e-002,
    9.337925e-001,
    -2.902902e-001,
    -3.413474e+000,
    -1.485380e+000,
    -1.301300e+000,
    1.266203e+000,
    3.869657e+000,
    -1.405606e-002,
    6.109944e-001,
    3.883967e+000,
    1.540321e+000,
    5.838664e-001,
    2.370098e-001,
    1.420200e+000,
    -1.803001e+000,
    -6.672775e+000,
    2.866921e-001,
    -2.599250e-001,
    -4.162164e+000,
    1.296901e-001,
    -1.654226e+000,
    -3.296843e-001,
    6.245723e-001,
    7.899655e+000,
    -1.079857e+000,
    3.145485e-001,
    4.085894e-001,
    2.258895e+000,
    9.071309e-001,
    -9.748612e-001,
    -2.545963e-001,
    1.374064e+000,
    -2.816107e-003,
    -2.589259e+000,
    -5.960628e-001,
    2.656787e-001,
    -1.458520e-001,
    6.529731e-001,
    // albedo 1, turbidity 10
    -1.944006e+000,
    -9.776516e-001,
    -2.425412e-001,
    8.187180e-001,
    -6.620102e-001,
    5.676187e-001,
    -7.857556e-006,
    1.944153e+000,
    9.001463e-001,
    -1.294455e+000,
    -7.294996e-001,
    -1.718682e-002,
    1.261264e+000,
    -1.170104e+000,
    -2.029198e-001,
    -1.306023e-002,
    1.821821e+000,
    -2.533820e-001,
    -6.849943e+000,
    -2.937611e+000,
    -1.107710e+000,
    -3.923478e+000,
    5.018293e+000,
    2.040419e+000,
    2.845113e-001,
    2.080902e+000,
    1.460328e+000,
    1.445166e+000,
    1.641979e-001,
    9.591325e-001,
    8.676572e+000,
    -1.098801e+001,
    -2.274573e+000,
    1.340040e-001,
    -1.166380e+000,
    1.014270e-001,
    -1.596800e+000,
    -4.130457e-001,
    9.250919e-001,
    -1.406592e+000,
    2.474727e+000,
    1.748285e+000,
    9.929937e-002,
    -6.705073e-001,
    9.210646e-001,
    -1.035617e+000,
    -3.537996e-001,
    1.073337e+000,
    6.090616e+000,
    -3.710420e+000,
    -9.390485e-001,
    2.233788e-001,
    -3.213961e-004,
    6.545784e-001,
};

double datasetRad600[] =
{
    // albedo 0, turbidity 1
    1.605147e-002,
    1.028116e-002,
    2.949675e-002,
    7.265851e-002,
    4.608279e-002,
    5.069475e-002,
    // albedo 0, turbidity 2
    1.569474e-002,
    1.190744e-002,
    1.996322e-002,
    1.044303e-001,
    3.746120e-002,
    5.764085e-002,
    // albedo 0, turbidity 3
    1.507252e-002,
    1.350309e-002,
    7.291417e-003,
    1.433035e-001,
    3.625213e-002,
    6.291384e-002,
    // albedo 0, turbidity 4
    1.383183e-002,
    1.670171e-002,
    -1.576321e-002,
    1.993796e-001,
    3.837478e-002,
    7.063028e-002,
    // albedo 0, turbidity 5
    1.253723e-002,
    2.261520e-002,
    -4.847485e-002,
    2.646653e-001,
    2.855366e-002,
    8.568437e-002,
    // albedo 0, turbidity 6
    1.179552e-002,
    2.546904e-002,
    -6.503150e-002,
    2.924065e-001,
    3.516626e-002,
    9.101182e-002,
    // albedo 0, turbidity 7
    1.070809e-002,
    3.005971e-002,
    -8.793572e-002,
    3.255182e-001,
    4.780714e-002,
    1.014896e-001,
    // albedo 0, turbidity 8
    9.466972e-003,
    3.330913e-002,
    -1.028545e-001,
    3.284098e-001,
    9.602966e-002,
    1.103224e-001,
    // albedo 0, turbidity 9
    8.190696e-003,
    3.248675e-002,
    -9.882934e-002,
    2.798409e-001,
    1.829752e-001,
    1.263322e-001,
    // albedo 0, turbidity 10
    7.225549e-003,
    2.433471e-002,
    -6.029571e-002,
    1.468935e-001,
    3.282492e-001,
    1.441367e-001,
    // albedo 1, turbidity 1
    1.676204e-002,
    1.269480e-002,
    2.674342e-002,
    7.380770e-002,
    1.072658e-001,
    1.211512e-001,
    // albedo 1, turbidity 2
    1.649305e-002,
    1.445974e-002,
    1.662432e-002,
    1.056364e-001,
    1.002831e-001,
    1.317330e-001,
    // albedo 1, turbidity 3
    1.577677e-002,
    1.637005e-002,
    2.821156e-003,
    1.465189e-001,
    9.971575e-002,
    1.424798e-001,
    // albedo 1, turbidity 4
    1.469049e-002,
    1.969668e-002,
    -2.105278e-002,
    2.024104e-001,
    1.062768e-001,
    1.557134e-001,
    // albedo 1, turbidity 5
    1.339480e-002,
    2.402713e-002,
    -4.671234e-002,
    2.518382e-001,
    1.135974e-001,
    1.711111e-001,
    // albedo 1, turbidity 6
    1.274349e-002,
    2.648472e-002,
    -6.068209e-002,
    2.720113e-001,
    1.285128e-001,
    1.776298e-001,
    // albedo 1, turbidity 7
    1.165402e-002,
    2.958682e-002,
    -7.746524e-002,
    2.912132e-001,
    1.536569e-001,
    1.896419e-001,
    // albedo 1, turbidity 8
    1.048769e-002,
    3.115400e-002,
    -8.550235e-002,
    2.769964e-001,
    2.173505e-001,
    1.991057e-001,
    // albedo 1, turbidity 9
    9.312926e-003,
    2.881725e-002,
    -7.387358e-002,
    2.079818e-001,
    3.221838e-001,
    2.120657e-001,
    // albedo 1, turbidity 10
    8.151793e-003,
    1.998414e-002,
    -3.316224e-002,
    6.957927e-002,
    4.654511e-001,
    2.260782e-001,
};

double dataset640[] =
{
    // albedo 0, turbidity 1
    -1.113346e+000,
    -1.715076e-001,
    -2.657094e+000,
    4.632520e+000,
    -1.092310e-001,
    1.421516e+000,
    3.230348e-003,
    2.697889e+000,
    6.262031e-001,
    -1.193355e+000,
    -2.074379e-001,
    1.431777e+000,
    8.245570e-001,
    -1.936967e-001,
    9.392137e-001,
    1.972523e-002,
    3.001209e+000,
    4.415825e-001,
    -9.337792e-001,
    -2.037239e-001,
    3.943675e+000,
    -2.487730e+000,
    -9.876315e-001,
    2.772411e+000,
    -4.919462e-002,
    -4.176827e+000,
    1.026227e+000,
    -1.297623e+000,
    -1.296758e-001,
    -3.144502e-001,
    2.454199e+000,
    2.433614e+000,
    5.298928e-001,
    7.814939e-002,
    6.564581e+000,
    5.587597e-001,
    -9.325270e-001,
    -1.997966e-001,
    3.363315e+000,
    -1.887198e+000,
    -8.905212e+000,
    2.808597e+000,
    -9.537165e-002,
    -3.059702e+000,
    5.403718e-001,
    -1.125650e+000,
    -1.904795e-001,
    2.099998e+000,
    1.251930e+000,
    -1.899312e+000,
    5.255919e-001,
    9.848260e-002,
    9.627433e-001,
    6.251236e-001,
    // albedo 0, turbidity 2
    -1.104956e+000,
    -1.372068e-001,
    -2.996624e+000,
    4.260021e+000,
    -1.263137e-001,
    1.327775e+000,
    7.595887e-002,
    5.301229e+000,
    6.478109e-001,
    -1.158426e+000,
    -1.921879e-001,
    3.371987e-001,
    8.543727e-001,
    -1.195421e-001,
    2.178871e-001,
    1.573997e-001,
    3.059646e+000,
    5.355391e-001,
    -1.012076e+000,
    -1.456275e-001,
    3.857821e+000,
    -1.137640e+000,
    -7.400821e-001,
    4.132381e+000,
    -2.101470e-001,
    -1.704290e-001,
    1.094519e+000,
    -1.200085e+000,
    -9.008631e-002,
    -1.764929e+000,
    4.584027e-001,
    8.033799e-001,
    -1.730728e+000,
    5.892683e-001,
    6.438112e+000,
    2.141131e-001,
    -9.836248e-001,
    -1.983419e-001,
    3.519957e+000,
    -9.777763e-001,
    -5.727911e+000,
    4.397457e+000,
    -2.864495e-001,
    -2.511187e+000,
    9.881415e-001,
    -1.111842e+000,
    -1.992363e-001,
    1.746814e+000,
    5.036170e+000,
    -2.993753e+000,
    -5.348114e-001,
    2.332738e-001,
    8.970344e-001,
    5.806194e-001,
    // albedo 0, turbidity 3
    -1.120087e+000,
    -1.577355e-001,
    -1.165606e+000,
    1.782016e+000,
    -1.771264e-001,
    8.928578e-001,
    1.613110e-001,
    4.975693e+000,
    6.258796e-001,
    -1.182069e+000,
    -2.047357e-001,
    -4.041517e-001,
    1.732659e+000,
    -4.322749e-001,
    6.549554e-001,
    5.392767e-002,
    4.838218e+000,
    6.441461e-001,
    -1.071518e+000,
    -2.057500e-001,
    2.808685e+000,
    -1.990080e+000,
    -8.491815e-001,
    2.193915e+000,
    2.411077e-001,
    -3.251587e+000,
    7.470978e-001,
    -1.113379e+000,
    -6.708322e-003,
    -2.181109e+000,
    2.107674e+000,
    2.216970e+000,
    -6.233552e-001,
    3.558080e-001,
    9.251876e+000,
    6.319555e-001,
    -1.026698e+000,
    -2.260748e-001,
    3.031659e+000,
    -1.615765e+000,
    -1.323341e+000,
    2.835147e+000,
    1.186568e-001,
    -3.366247e+000,
    6.850407e-001,
    -1.088223e+000,
    -1.817555e-001,
    1.435855e+000,
    1.845164e+000,
    -3.488539e+000,
    2.554837e-001,
    2.144895e-001,
    1.558895e+000,
    7.315398e-001,
    // albedo 0, turbidity 4
    -1.164089e+000,
    -2.003003e-001,
    -2.998423e-001,
    2.713689e-001,
    -1.828861e-001,
    5.800779e-001,
    1.968402e-001,
    4.650130e+000,
    6.156174e-001,
    -1.209796e+000,
    -2.733887e-001,
    -9.360003e-001,
    2.769100e+000,
    -1.870929e+000,
    7.049322e-001,
    -8.477045e-002,
    4.120960e+000,
    7.444509e-001,
    -1.232839e+000,
    -2.622151e-001,
    2.857050e+000,
    -2.866256e+000,
    3.128232e+000,
    1.897877e+000,
    4.581244e-001,
    -2.112943e+000,
    6.384882e-001,
    -9.291113e-001,
    4.110508e-002,
    -2.235781e+000,
    2.969741e+000,
    -9.758544e+000,
    -1.941571e+000,
    3.426656e-001,
    6.907158e+000,
    6.945892e-001,
    -1.103614e+000,
    -2.279953e-001,
    2.314490e+000,
    -6.307971e-001,
    3.369674e+000,
    3.787928e+000,
    2.456513e-001,
    -1.776073e+000,
    6.864316e-001,
    -1.072160e+000,
    -1.984678e-001,
    1.092192e+000,
    8.472734e-001,
    -3.126637e+000,
    -1.076607e+000,
    3.908469e-001,
    1.205671e+000,
    7.035925e-001,
    // albedo 0, turbidity 5
    -1.222416e+000,
    -2.654298e-001,
    -1.149975e-001,
    -6.277756e-003,
    -1.369463e+000,
    4.402179e-001,
    1.881320e-001,
    3.896722e+000,
    6.037946e-001,
    -1.407746e+000,
    -4.603243e-001,
    -3.071475e-001,
    2.937390e+000,
    -9.164938e-001,
    6.696693e-001,
    -6.608327e-002,
    2.444782e+000,
    6.905594e-001,
    -1.120454e+000,
    -1.466269e-001,
    7.829076e-001,
    -7.009271e+000,
    5.364470e+000,
    1.294280e+000,
    4.109552e-001,
    1.525889e+000,
    7.709564e-001,
    -9.792886e-001,
    -4.325464e-002,
    -4.059461e-001,
    1.522559e+001,
    -1.867598e+001,
    -1.169367e+000,
    3.589556e-001,
    2.368951e+000,
    5.526839e-001,
    -1.091118e+000,
    -2.286983e-001,
    9.896666e-001,
    -6.655971e+000,
    8.168041e+000,
    1.923773e+000,
    3.116805e-001,
    1.852611e-001,
    7.524175e-001,
    -1.053081e+000,
    -1.598496e-001,
    9.684194e-001,
    3.620674e+000,
    -5.015769e+000,
    8.125082e-002,
    4.669502e-001,
    1.415221e+000,
    7.044272e-001,
    // albedo 0, turbidity 6
    -1.267172e+000,
    -3.101221e-001,
    -8.556526e-002,
    -3.602153e-003,
    -4.988229e+000,
    4.099753e-001,
    1.555248e-001,
    3.585489e+000,
    6.128833e-001,
    -1.613116e+000,
    -6.560485e-001,
    9.250270e-002,
    2.119268e+000,
    8.031058e+000,
    4.019483e-001,
    4.526662e-002,
    1.362051e+000,
    5.999628e-001,
    -1.012405e+000,
    -2.251592e-002,
    2.836289e-001,
    -7.904006e+000,
    -9.544755e+000,
    1.754891e+000,
    1.283266e-001,
    3.042478e+000,
    9.234755e-001,
    -1.022835e+000,
    -1.361070e-001,
    -4.207218e-001,
    1.947050e+001,
    -5.511234e+000,
    -2.417169e+000,
    7.837822e-001,
    8.288902e-001,
    3.509734e-001,
    -1.068370e+000,
    -1.806143e-001,
    1.059217e+000,
    7.087518e-001,
    -1.671865e+000,
    3.098645e+000,
    -9.859822e-002,
    9.336021e-001,
    8.929147e-001,
    -1.065467e+000,
    -1.928982e-001,
    6.159162e-001,
    -4.157538e-003,
    -9.397621e-001,
    -1.193139e+000,
    6.979501e-001,
    1.118894e+000,
    6.467115e-001,
    // albedo 0, turbidity 7
    -1.345697e+000,
    -3.906019e-001,
    -1.921159e-001,
    -7.410201e-003,
    -4.683006e+000,
    4.591917e-001,
    1.919817e-001,
    3.158844e+000,
    5.319014e-001,
    -2.096314e+000,
    -1.056514e+000,
    7.665515e-001,
    1.602483e+000,
    6.290779e+000,
    4.693208e-001,
    -6.258855e-002,
    -3.745685e-001,
    5.853677e-001,
    -7.573573e-001,
    2.265213e-001,
    -1.283398e+000,
    -4.696984e+000,
    -4.261986e+000,
    1.197826e+000,
    3.444468e-001,
    6.004387e+000,
    9.413954e-001,
    -1.140929e+000,
    -3.489820e-001,
    1.095429e+000,
    7.531589e+000,
    -8.153320e+000,
    -1.722207e+000,
    4.427477e-001,
    -3.072440e+000,
    3.874398e-001,
    -1.009003e+000,
    -9.087616e-002,
    4.181128e-002,
    1.154023e+001,
    -5.092155e-001,
    2.166116e+000,
    1.620893e-001,
    2.824826e+000,
    8.289491e-001,
    -1.080842e+000,
    -2.166745e-001,
    6.939662e-001,
    -2.316636e-003,
    -2.616711e+000,
    -1.012238e+000,
    6.132021e-001,
    7.579828e-001,
    6.813755e-001,
    // albedo 0, turbidity 8
    -1.394668e+000,
    -4.508268e-001,
    -2.615024e-001,
    -7.412740e-003,
    -4.811648e+000,
    4.235635e-001,
    1.627041e-001,
    3.134174e+000,
    5.225016e-001,
    -2.715734e+000,
    -1.409574e+000,
    6.485110e-001,
    6.307101e-001,
    8.120123e+000,
    3.677567e-001,
    6.430919e-002,
    -3.729191e-001,
    3.463130e-001,
    -8.973624e-001,
    2.859206e-002,
    -1.610007e+000,
    -1.483136e+000,
    -5.613288e+000,
    7.093329e-001,
    2.936945e-001,
    5.541210e+000,
    1.143952e+000,
    -8.450858e-001,
    -1.969825e-001,
    1.399585e+000,
    1.418708e-001,
    -4.532026e+000,
    -7.432040e-001,
    3.410858e-001,
    -3.386293e+000,
    2.885614e-001,
    -1.180533e+000,
    -2.469972e-001,
    -2.694505e-002,
    1.635998e+001,
    -2.378676e+000,
    9.477733e-001,
    1.105776e-001,
    1.954485e+000,
    8.559872e-001,
    -1.022908e+000,
    -1.650807e-001,
    3.812483e-001,
    -2.139201e-003,
    -2.300711e+000,
    -5.917998e-001,
    6.793527e-001,
    1.248273e+000,
    6.747565e-001,
    // albedo 0, turbidity 9
    -1.557922e+000,
    -6.294681e-001,
    -2.355549e-001,
    -8.743568e-003,
    -5.017111e+000,
    4.034446e-001,
    1.005643e-001,
    2.735289e+000,
    5.667004e-001,
    -3.061673e+000,
    -1.398157e+000,
    1.597008e-001,
    1.066059e+000,
    8.207018e+000,
    4.785780e-001,
    4.629487e-002,
    1.324020e+000,
    2.540204e-001,
    -2.371583e+000,
    -1.100187e+000,
    -1.279309e+000,
    -3.340819e+000,
    -6.556706e+000,
    2.636750e-001,
    4.298705e-001,
    2.649782e+000,
    1.060950e+000,
    -5.315727e-002,
    2.306821e-001,
    1.091037e+000,
    5.297610e+000,
    -2.412315e+000,
    -7.083157e-002,
    7.256586e-002,
    -1.330891e+000,
    4.168205e-001,
    -1.375983e+000,
    -4.677570e-001,
    2.271650e-001,
    8.771601e+000,
    -2.511780e+000,
    1.487082e-001,
    8.542210e-002,
    5.509707e-003,
    7.821447e-001,
    -1.006483e+000,
    -1.435513e-001,
    5.802646e-002,
    -3.181899e-003,
    -2.010861e+000,
    -1.746922e-001,
    7.487809e-001,
    1.623209e+000,
    6.848148e-001,
    // albedo 0, turbidity 10
    -1.919035e+000,
    -9.396362e-001,
    -3.059418e-001,
    1.542398e+000,
    -1.488273e+000,
    5.133825e-001,
    -7.992185e-006,
    2.276361e+000,
    8.334381e-001,
    -2.470138e+000,
    -1.108577e+000,
    -5.521438e-001,
    -9.047033e-001,
    6.905739e-001,
    3.774300e-001,
    -2.801883e-002,
    2.413470e+000,
    -8.986266e-002,
    -5.532450e+000,
    -2.346497e+000,
    -1.734654e+000,
    1.461689e+000,
    1.765938e+000,
    4.969811e-001,
    6.205943e-001,
    2.112232e+000,
    1.159488e+000,
    4.159150e-001,
    -2.306809e-001,
    1.540502e+000,
    -1.006923e+000,
    -5.275092e+000,
    -2.776202e-002,
    -1.632884e-001,
    -1.467491e+000,
    4.177919e-001,
    -1.248112e+000,
    -3.080519e-001,
    -1.229235e-001,
    8.972757e+000,
    -1.532948e+000,
    -8.283794e-002,
    1.561573e-001,
    1.856113e-001,
    7.696948e-001,
    -1.054499e+000,
    -2.660558e-001,
    1.307025e-001,
    -2.167883e-003,
    -1.531056e+000,
    1.525856e-001,
    5.356892e-001,
    7.181428e-001,
    6.837654e-001,
    // albedo 1, turbidity 1
    -1.113347e+000,
    -1.715068e-001,
    -2.657094e+000,
    4.632520e+000,
    -1.092308e-001,
    1.421516e+000,
    3.229759e-003,
    2.697889e+000,
    6.262031e-001,
    -1.193355e+000,
    -2.074367e-001,
    1.431777e+000,
    8.245569e-001,
    -1.936966e-001,
    9.392136e-001,
    1.972263e-002,
    3.001209e+000,
    4.415825e-001,
    -9.337795e-001,
    -2.037221e-001,
    3.943675e+000,
    -2.487730e+000,
    -9.876315e-001,
    2.772410e+000,
    -4.919872e-002,
    -4.176827e+000,
    1.026227e+000,
    -1.297624e+000,
    -1.296733e-001,
    -3.144502e-001,
    2.454199e+000,
    2.433614e+000,
    5.298925e-001,
    7.814503e-002,
    6.564581e+000,
    5.587597e-001,
    -9.325285e-001,
    -1.997939e-001,
    3.363316e+000,
    -1.887198e+000,
    -8.905212e+000,
    2.808596e+000,
    -9.537523e-002,
    -3.059702e+000,
    5.403717e-001,
    -1.125653e+000,
    -1.904767e-001,
    2.099998e+000,
    1.251930e+000,
    -1.899312e+000,
    5.255917e-001,
    9.848033e-002,
    9.627434e-001,
    6.251233e-001,
    // albedo 1, turbidity 2
    -1.115892e+000,
    -1.571450e-001,
    -5.361081e+000,
    6.833528e+000,
    -6.891479e-002,
    1.309709e+000,
    6.046362e-002,
    3.972373e+000,
    6.651606e-001,
    -1.147479e+000,
    -1.855896e-001,
    2.239259e+000,
    -5.937930e-001,
    -1.005125e-001,
    2.773971e-001,
    1.337105e-001,
    3.136906e+000,
    5.194230e-001,
    -1.030450e+000,
    -1.533626e-001,
    2.268967e+000,
    -4.886576e-001,
    -6.336865e-001,
    3.911080e+000,
    -1.602643e-001,
    1.513730e-001,
    1.130153e+000,
    -1.159297e+000,
    -5.818314e-002,
    -1.488690e-001,
    1.358829e+000,
    1.208889e+000,
    -1.827456e+000,
    4.867277e-001,
    6.185880e+000,
    1.951064e-001,
    -1.023581e+000,
    -2.517540e-001,
    3.635148e+000,
    -2.375150e+000,
    -9.409992e+000,
    3.209554e+000,
    -3.006489e-001,
    -3.235953e+000,
    9.969505e-001,
    -1.102864e+000,
    -1.644399e-001,
    2.160645e+000,
    5.685422e+000,
    -2.867248e+000,
    -1.020916e+000,
    2.064591e-001,
    1.192668e+000,
    5.029621e-001,
    // albedo 1, turbidity 3
    -1.120417e+000,
    -1.543428e-001,
    -2.173869e+000,
    2.965267e+000,
    -1.062190e-001,
    8.112859e-001,
    1.448682e-001,
    4.993622e+000,
    6.373394e-001,
    -1.168618e+000,
    -1.948508e-001,
    -6.247560e-001,
    2.203402e+000,
    -2.724794e-001,
    8.364691e-001,
    5.608377e-002,
    4.262497e+000,
    6.310098e-001,
    -1.080229e+000,
    -2.282841e-001,
    2.194035e+000,
    -1.203336e+000,
    -3.861545e-001,
    2.234045e+000,
    1.553866e-001,
    -3.266039e+000,
    8.246847e-001,
    -1.101698e+000,
    2.182410e-002,
    -1.179116e+000,
    8.533844e-001,
    8.777171e-001,
    -1.222988e+000,
    5.021882e-001,
    9.364642e+000,
    4.790363e-001,
    -1.047144e+000,
    -2.539571e-001,
    3.684827e+000,
    9.827861e-002,
    -2.297266e-001,
    3.038327e+000,
    -2.609445e-001,
    -3.685112e+000,
    8.596057e-001,
    -1.103227e+000,
    -1.861499e-001,
    2.098952e+000,
    1.030900e-001,
    -4.268311e+000,
    -1.120060e+000,
    2.879792e-001,
    7.160893e-001,
    6.213207e-001,
    // albedo 1, turbidity 4
    -1.155288e+000,
    -2.006105e-001,
    -5.822630e-002,
    3.970794e-001,
    -2.828885e-001,
    5.093569e-001,
    1.631119e-001,
    4.152479e+000,
    6.357376e-001,
    -1.241627e+000,
    -2.673712e-001,
    -6.444494e-001,
    2.257014e+000,
    -1.630843e+000,
    5.967071e-001,
    9.888683e-003,
    4.308732e+000,
    6.751366e-001,
    -1.136812e+000,
    -2.811418e-001,
    2.220215e+000,
    -1.535870e+000,
    2.354743e+000,
    2.041362e+000,
    2.387976e-001,
    -3.453756e+000,
    7.672245e-001,
    -1.028322e+000,
    9.134962e-002,
    -1.151053e+000,
    6.511620e-001,
    -5.683098e+000,
    -2.001006e+000,
    6.430642e-001,
    8.523367e+000,
    5.422240e-001,
    -1.076830e+000,
    -3.101207e-001,
    3.052794e+000,
    3.177593e-001,
    3.054756e+000,
    3.386727e+000,
    -2.312489e-001,
    -3.908802e+000,
    7.978614e-001,
    -1.107083e+000,
    -1.880372e-001,
    2.001810e+000,
    -3.352202e-003,
    -1.526356e+000,
    -1.480550e+000,
    3.486524e-001,
    7.220325e-001,
    6.581821e-001,
    // albedo 1, turbidity 5
    -1.214879e+000,
    -2.719222e-001,
    2.247747e-001,
    1.509740e-002,
    -5.438281e-001,
    3.728351e-001,
    1.749880e-001,
    3.132220e+000,
    6.001432e-001,
    -1.424202e+000,
    -4.768943e-001,
    -6.396040e-001,
    2.060101e+000,
    -1.113780e+000,
    6.993089e-001,
    -2.098291e-002,
    2.504826e+000,
    6.757213e-001,
    -1.048548e+000,
    -1.173837e-001,
    1.885902e+000,
    -3.700301e+000,
    4.667326e+000,
    1.344798e+000,
    2.140261e-001,
    1.525414e-001,
    8.450168e-001,
    -1.056271e+000,
    -5.272364e-002,
    -1.391708e+000,
    9.711492e+000,
    -1.742761e+001,
    -1.677628e+000,
    6.906304e-001,
    4.107662e+000,
    4.268005e-001,
    -1.072328e+000,
    -2.450563e-001,
    3.125155e+000,
    -2.470389e+000,
    6.794968e+000,
    2.678049e+000,
    -2.092059e-001,
    -1.651858e+000,
    8.708740e-001,
    -1.107628e+000,
    -2.089585e-001,
    1.799168e+000,
    4.621596e-001,
    -5.008181e+000,
    -1.121127e+000,
    3.917217e-001,
    2.703209e-001,
    6.449597e-001,
    // albedo 1, turbidity 6
    -1.249741e+000,
    -3.073987e-001,
    1.398829e-001,
    -2.878563e-003,
    -5.008845e+000,
    4.535605e-001,
    1.447766e-001,
    3.091173e+000,
    6.138128e-001,
    -1.577209e+000,
    -6.213162e-001,
    2.895282e-001,
    1.670732e+000,
    8.708786e+000,
    2.480283e-001,
    7.326386e-002,
    1.395638e+000,
    5.814691e-001,
    -1.015394e+000,
    -9.306378e-002,
    4.870291e-001,
    -6.558243e+000,
    -1.073347e+001,
    1.842159e+000,
    2.135043e-002,
    1.655269e+000,
    9.750505e-001,
    -1.030222e+000,
    -3.712071e-002,
    -4.565649e-001,
    1.827249e+001,
    -4.505703e+000,
    -2.635230e+000,
    9.447498e-001,
    2.450865e+000,
    2.757082e-001,
    -1.086063e+000,
    -2.709359e-001,
    2.527868e+000,
    -1.786375e+000,
    -2.329338e+000,
    3.367729e+000,
    -4.201670e-001,
    -9.372873e-001,
    9.570917e-001,
    -1.113156e+000,
    -2.162986e-001,
    1.815038e+000,
    1.036606e-001,
    -1.106537e+000,
    -1.657558e+000,
    4.923976e-001,
    -1.768985e-002,
    6.218745e-001,
    // albedo 1, turbidity 7
    -1.345662e+000,
    -4.038158e-001,
    1.601105e-001,
    -6.892546e-003,
    -5.010308e+000,
    3.903794e-001,
    1.543535e-001,
    2.538245e+000,
    5.555141e-001,
    -1.998866e+000,
    -9.786972e-001,
    5.763250e-001,
    1.007104e+000,
    8.983795e+000,
    3.752110e-001,
    7.375525e-002,
    1.792659e-001,
    4.969463e-001,
    -7.854213e-001,
    1.186171e-001,
    -1.925047e-001,
    -3.567464e+000,
    -8.901606e+000,
    1.181923e+000,
    4.049067e-002,
    3.603602e+000,
    1.081550e+000,
    -1.113558e+000,
    -1.964692e-001,
    -6.175963e-002,
    7.345047e+000,
    -5.293662e+000,
    -1.720046e+000,
    8.863695e-001,
    -1.699694e-001,
    2.184709e-001,
    -1.077319e+000,
    -2.429937e-001,
    2.226652e+000,
    8.082352e+000,
    -5.647382e-001,
    2.187018e+000,
    -3.571678e-001,
    -2.370890e-001,
    9.528157e-001,
    -1.101702e+000,
    -2.020333e-001,
    1.637670e+000,
    5.276716e-001,
    -4.006007e+000,
    -1.066501e+000,
    4.548015e-001,
    4.055769e-001,
    6.485706e-001,
    // albedo 1, turbidity 8
    -1.411469e+000,
    -4.870956e-001,
    1.017578e-001,
    -8.806763e-003,
    -5.014847e+000,
    4.306981e-001,
    1.278033e-001,
    2.361142e+000,
    5.472925e-001,
    -2.735007e+000,
    -1.453253e+000,
    5.783189e-001,
    5.673243e-001,
    9.968637e+000,
    2.236397e-001,
    1.860109e-001,
    -3.781953e-001,
    2.505082e-001,
    -7.371503e-001,
    1.290592e-001,
    -5.349577e-001,
    -1.885854e+000,
    -8.623054e+000,
    1.078614e+000,
    -5.694996e-002,
    4.526279e+000,
    1.347569e+000,
    -9.678370e-001,
    -2.562830e-001,
    2.961987e-001,
    2.461144e+000,
    -4.753928e+000,
    -1.657373e+000,
    8.388825e-001,
    -2.440974e+000,
    1.816225e-002,
    -1.148918e+000,
    -2.271366e-001,
    1.817890e+000,
    1.097345e+001,
    -1.126160e+000,
    1.993895e+000,
    -2.870862e-001,
    7.269217e-001,
    1.032783e+000,
    -1.090291e+000,
    -2.315314e-001,
    1.491197e+000,
    9.632479e+000,
    -4.323932e+000,
    -1.326631e+000,
    3.604933e-001,
    1.905995e-001,
    6.312241e-001,
    // albedo 1, turbidity 9
    -1.552618e+000,
    -6.336918e-001,
    4.605315e-002,
    -8.452985e-003,
    -4.979015e+000,
    3.484674e-001,
    8.791637e-002,
    2.297399e+000,
    5.705230e-001,
    -2.770597e+000,
    -1.302036e+000,
    3.421676e-001,
    1.220769e+000,
    7.584372e+000,
    4.050789e-001,
    4.478808e-002,
    9.435710e-001,
    2.393878e-001,
    -2.631791e+000,
    -1.247576e+000,
    -8.423940e-001,
    -3.955998e+000,
    -5.341100e+000,
    6.385142e-001,
    3.872948e-001,
    2.279807e+000,
    1.101259e+000,
    1.875824e-001,
    3.564184e-001,
    7.973268e-001,
    7.159160e+000,
    -3.857340e+000,
    -9.227702e-001,
    8.283793e-002,
    -1.444145e+000,
    3.654244e-001,
    -1.489693e+000,
    -4.947623e-001,
    1.253918e+000,
    3.949282e+000,
    -1.320903e+000,
    1.088652e+000,
    1.489763e-001,
    -3.855853e-001,
    8.130960e-001,
    -1.042349e+000,
    -2.134514e-001,
    1.289359e+000,
    -3.129206e-003,
    -2.385397e+000,
    -7.642278e-001,
    3.772293e-001,
    3.683001e-001,
    6.811674e-001,
    // albedo 1, turbidity 10
    -1.924886e+000,
    -9.354584e-001,
    -1.879067e-001,
    1.267892e+000,
    -1.174622e+000,
    5.570232e-001,
    -1.060836e-005,
    2.002481e+000,
    9.001398e-001,
    -1.556107e+000,
    -8.200410e-001,
    -1.065249e-001,
    -3.241942e-001,
    1.552504e-001,
    7.662815e-002,
    -2.568474e-002,
    1.738474e+000,
    -2.100942e-001,
    -7.169297e+000,
    -2.972878e+000,
    -1.324108e+000,
    7.276378e-003,
    2.638975e+000,
    1.186150e+000,
    5.695709e-001,
    2.027718e+000,
    1.328077e+000,
    1.889259e+000,
    2.600110e-001,
    1.309033e+000,
    1.187864e+000,
    -6.905754e+000,
    -1.163025e+000,
    -1.642758e-001,
    -1.774036e+000,
    2.566466e-001,
    -1.816439e+000,
    -3.601966e-001,
    6.367922e-001,
    6.798160e+000,
    -6.431562e-001,
    9.014269e-001,
    2.490693e-001,
    -6.685128e-003,
    8.542883e-001,
    -9.684886e-001,
    -3.866519e-001,
    1.268224e+000,
    -4.187273e-003,
    -1.833316e+000,
    -4.626197e-001,
    2.263859e-001,
    -5.583963e-001,
    6.650112e-001,
};

double datasetRad640[] =
{
    // albedo 0, turbidity 1
    1.479989e-002,
    9.575884e-003,
    2.973854e-002,
    4.822245e-002,
    3.622965e-002,
    3.714381e-002,
    // albedo 0, turbidity 2
    1.494233e-002,
    1.021187e-002,
    2.574697e-002,
    7.232352e-002,
    3.290719e-002,
    4.167409e-002,
    // albedo 0, turbidity 3
    1.434641e-002,
    1.147574e-002,
    1.506677e-002,
    1.142492e-001,
    2.532042e-002,
    4.995278e-002,
    // albedo 0, turbidity 4
    1.326292e-002,
    1.444403e-002,
    -7.612369e-003,
    1.768500e-001,
    1.846871e-002,
    6.093428e-002,
    // albedo 0, turbidity 5
    1.210064e-002,
    1.800376e-002,
    -3.160469e-002,
    2.285807e-001,
    2.227077e-002,
    6.824549e-002,
    // albedo 0, turbidity 6
    1.130890e-002,
    2.150486e-002,
    -5.124749e-002,
    2.648020e-001,
    2.123060e-002,
    7.588774e-002,
    // albedo 0, turbidity 7
    1.023130e-002,
    2.633945e-002,
    -7.626006e-002,
    3.042057e-001,
    3.007536e-002,
    8.597681e-002,
    // albedo 0, turbidity 8
    8.913856e-003,
    3.088076e-002,
    -9.896179e-002,
    3.274618e-001,
    6.060024e-002,
    9.959796e-002,
    // albedo 0, turbidity 9
    7.548425e-003,
    3.088764e-002,
    -9.837988e-002,
    2.862874e-001,
    1.450480e-001,
    1.121877e-001,
    // albedo 0, turbidity 10
    6.525594e-003,
    2.429771e-002,
    -6.656565e-002,
    1.679199e-001,
    2.792664e-001,
    1.313366e-001,
    // albedo 1, turbidity 1
    1.534297e-002,
    1.199131e-002,
    2.491229e-002,
    5.492441e-002,
    7.679650e-002,
    9.300994e-002,
    // albedo 1, turbidity 2
    1.542409e-002,
    1.237811e-002,
    2.235351e-002,
    7.606092e-002,
    7.888526e-002,
    9.886009e-002,
    // albedo 1, turbidity 3
    1.501351e-002,
    1.379279e-002,
    1.162514e-002,
    1.159528e-001,
    7.784537e-002,
    1.097624e-001,
    // albedo 1, turbidity 4
    1.398757e-002,
    1.622679e-002,
    -9.033929e-003,
    1.740587e-001,
    8.042195e-002,
    1.246928e-001,
    // albedo 1, turbidity 5
    1.276036e-002,
    2.055104e-002,
    -3.597123e-002,
    2.310287e-001,
    8.109251e-002,
    1.421324e-001,
    // albedo 1, turbidity 6
    1.198617e-002,
    2.326685e-002,
    -5.243143e-002,
    2.599544e-001,
    8.840775e-002,
    1.517899e-001,
    // albedo 1, turbidity 7
    1.092344e-002,
    2.669375e-002,
    -7.074274e-002,
    2.830300e-001,
    1.143047e-001,
    1.610563e-001,
    // albedo 1, turbidity 8
    9.699402e-003,
    2.953350e-002,
    -8.582613e-002,
    2.867195e-001,
    1.638123e-001,
    1.760228e-001,
    // albedo 1, turbidity 9
    8.432894e-003,
    2.784449e-002,
    -7.740437e-002,
    2.250221e-001,
    2.667103e-001,
    1.889583e-001,
    // albedo 1, turbidity 10
    7.395069e-003,
    2.031820e-002,
    -4.154554e-002,
    9.577204e-002,
    4.084819e-001,
    2.043633e-001,
};

double dataset680[] =
{
    // albedo 0, turbidity 1
    -1.112655e+000,
    -1.844098e-001,
    -3.170582e+000,
    5.334685e+000,
    -6.690891e-002,
    1.561122e+000,
    -2.792088e-006,
    1.400688e+000,
    6.639418e-001,
    -1.138469e+000,
    -1.797086e-001,
    1.271179e+000,
    1.158372e+000,
    -1.687824e-001,
    1.414051e+000,
    4.258569e-003,
    2.135675e+000,
    5.322718e-001,
    -1.026337e+000,
    -1.861539e-001,
    2.119648e+000,
    -6.753200e-001,
    -1.972700e-001,
    2.384659e+000,
    -1.304972e-002,
    -1.804518e+000,
    1.207802e+000,
    -1.198321e+000,
    -1.585305e-001,
    1.339219e+000,
    5.796904e-001,
    -5.143433e-002,
    1.107455e+000,
    2.551349e-002,
    3.346946e+000,
    -3.387602e-002,
    -9.935091e-001,
    -1.747698e-001,
    2.816779e+000,
    -3.496148e-001,
    1.832218e+000,
    2.324658e+000,
    -3.408305e-002,
    -1.618451e+000,
    1.189512e+000,
    -1.092682e+000,
    -1.840784e-001,
    2.455887e+000,
    1.441429e-001,
    -4.002347e+000,
    1.186375e+000,
    3.634755e-002,
    3.070963e-001,
    5.512501e-001,
    // albedo 0, turbidity 2
    -1.104975e+000,
    -1.425541e-001,
    -1.889148e+000,
    3.408593e+000,
    -1.252648e-001,
    1.396095e+000,
    8.358812e-002,
    3.814297e+000,
    6.848154e-001,
    -1.131570e+000,
    -1.500053e-001,
    -1.048539e+000,
    3.133642e+000,
    -2.651219e-001,
    1.193999e+000,
    7.013543e-002,
    4.592749e+000,
    6.857750e-001,
    -1.030016e+000,
    -1.667752e-001,
    6.179600e+000,
    -5.163198e+000,
    -4.084328e-001,
    2.617798e+000,
    1.966627e-003,
    -2.417731e+000,
    8.402310e-001,
    -1.167563e+000,
    -3.644294e-002,
    -4.501893e+000,
    4.471663e+000,
    -5.377956e-001,
    4.971351e-002,
    4.621337e-001,
    1.014187e+001,
    4.411276e-001,
    -1.018402e+000,
    -2.068288e-001,
    4.710566e+000,
    -1.425858e+000,
    1.287815e-001,
    3.605281e+000,
    -2.164599e-001,
    -4.336932e+000,
    9.051639e-001,
    -1.078985e+000,
    -1.995548e-001,
    1.678948e+000,
    3.074167e-001,
    -1.642830e+000,
    -1.235470e-001,
    2.735898e-001,
    6.360197e-001,
    5.870665e-001,
    // albedo 0, turbidity 3
    -1.132881e+000,
    -1.676238e-001,
    -1.179974e+000,
    1.902080e+000,
    -7.980402e-002,
    8.946611e-001,
    1.939671e-001,
    3.793414e+000,
    6.357246e-001,
    -1.138356e+000,
    -1.681053e-001,
    1.548320e+000,
    -6.001024e-001,
    -4.138892e-001,
    2.586807e-001,
    2.126762e-001,
    4.742849e+000,
    5.910253e-001,
    -1.093982e+000,
    -1.847904e-001,
    1.234133e+000,
    -4.707125e-001,
    1.076579e+000,
    3.355751e+000,
    5.394600e-002,
    -2.314910e+000,
    8.900752e-001,
    -1.117812e+000,
    -6.182272e-002,
    -4.681118e-001,
    5.075227e+000,
    -1.561122e+001,
    -2.343845e+000,
    5.618788e-001,
    7.005713e+000,
    4.622191e-001,
    -1.013135e+000,
    -1.529086e-001,
    1.960772e+000,
    -3.022528e+000,
    8.938126e+000,
    4.411437e+000,
    3.156643e-002,
    -1.449180e+000,
    8.181914e-001,
    -1.087086e+000,
    -2.231900e-001,
    1.871061e+000,
    1.830836e+000,
    -4.397140e+000,
    -5.441402e-001,
    2.728682e-001,
    -5.607736e-002,
    6.741811e-001,
    // albedo 0, turbidity 4
    -1.176035e+000,
    -2.099056e-001,
    -8.221907e-001,
    1.520994e+000,
    -2.507738e-001,
    9.100863e-001,
    1.507234e-001,
    3.661138e+000,
    6.726424e-001,
    -1.140180e+000,
    -1.918480e-001,
    2.844393e-001,
    -3.842927e-001,
    -5.520764e-001,
    -1.868484e-001,
    2.247948e-001,
    5.381202e+000,
    6.059726e-001,
    -1.282085e+000,
    -3.059464e-001,
    1.619956e+000,
    -1.362117e+000,
    2.324649e+000,
    3.350678e+000,
    2.102082e-001,
    -4.028753e+000,
    8.172091e-001,
    -9.092985e-001,
    4.843416e-002,
    -1.076741e+000,
    8.143038e+000,
    -1.618418e+001,
    -3.681285e+000,
    5.217800e-001,
    7.307672e+000,
    5.312006e-001,
    -1.110248e+000,
    -2.047143e-001,
    1.565253e+000,
    -4.575474e+000,
    8.737741e+000,
    5.023419e+000,
    2.469230e-001,
    -1.716906e+000,
    7.856742e-001,
    -1.054900e+000,
    -2.018466e-001,
    1.352034e+000,
    2.656066e+000,
    -4.403444e+000,
    -1.479998e+000,
    3.939305e-001,
    6.455032e-001,
    6.775162e-001,
    // albedo 0, turbidity 5
    -1.237521e+000,
    -2.734963e-001,
    -4.554763e-001,
    3.417711e-001,
    2.054204e-001,
    3.954470e-001,
    2.366979e-001,
    3.239693e+000,
    6.083737e-001,
    -1.354583e+000,
    -4.251172e-001,
    -3.241668e-001,
    2.077967e+000,
    -1.910410e+000,
    8.755633e-001,
    -8.365829e-002,
    2.443727e+000,
    7.260119e-001,
    -1.152500e+000,
    -1.277879e-001,
    1.089367e+000,
    -4.497520e+000,
    5.636501e+000,
    1.249272e+000,
    5.829396e-001,
    9.198423e-001,
    7.039872e-001,
    -9.782313e-001,
    -8.253891e-002,
    -5.673470e-001,
    1.098032e+001,
    -1.689550e+001,
    -1.619205e+000,
    2.125660e-001,
    2.080566e+000,
    6.315535e-001,
    -1.064286e+000,
    -1.710957e-001,
    9.336921e-001,
    -5.525059e+000,
    8.053084e+000,
    2.664602e+000,
    4.815015e-001,
    4.884965e-001,
    7.093015e-001,
    -1.067798e+000,
    -1.817268e-001,
    1.095720e+000,
    3.551145e+000,
    -5.009504e+000,
    -4.802047e-001,
    4.854159e-001,
    8.021585e-001,
    7.133339e-001,
    // albedo 0, turbidity 6
    -1.251896e+000,
    -2.936510e-001,
    -3.090944e-002,
    -5.488869e-003,
    -6.577788e-001,
    4.577691e-001,
    1.780002e-001,
    3.335561e+000,
    6.394482e-001,
    -1.615603e+000,
    -6.405318e-001,
    -4.651954e-001,
    2.332689e+000,
    -1.893131e-001,
    3.391170e-001,
    3.495888e-002,
    1.058634e+000,
    6.310524e-001,
    -9.703572e-001,
    1.437971e-002,
    6.532383e-001,
    -6.450045e+000,
    4.026380e+000,
    2.198628e+000,
    2.684967e-001,
    2.873804e+000,
    8.626816e-001,
    -1.053437e+000,
    -1.577255e-001,
    -2.354526e-001,
    1.753047e+001,
    -1.802766e+001,
    -3.193379e+000,
    6.264380e-001,
    3.733714e-001,
    4.466776e-001,
    -1.051388e+000,
    -1.690749e-001,
    6.925698e-001,
    -7.450365e+000,
    7.747780e+000,
    3.681960e+000,
    1.688173e-001,
    9.054528e-001,
    8.229209e-001,
    -1.060369e+000,
    -1.751603e-001,
    8.678290e-001,
    5.136962e+000,
    -5.014566e+000,
    -1.283438e+000,
    6.547844e-001,
    9.420523e-001,
    6.738511e-001,
    // albedo 0, turbidity 7
    -1.358251e+000,
    -3.909003e-001,
    -7.590093e-002,
    -8.010253e-003,
    -2.417641e-001,
    5.031789e-001,
    1.882499e-001,
    2.807060e+000,
    5.884485e-001,
    -2.043506e+000,
    -9.923881e-001,
    -4.530797e-001,
    1.750575e+000,
    -4.362236e-001,
    2.997323e-001,
    2.328504e-002,
    1.626543e-001,
    5.806819e-001,
    -7.280672e-001,
    2.228069e-001,
    2.169765e-001,
    -3.681736e+000,
    4.308793e+000,
    1.308622e+000,
    3.451835e-001,
    4.037459e+000,
    9.113772e-001,
    -1.155299e+000,
    -3.079453e-001,
    -1.640569e-001,
    7.663297e+000,
    -1.327817e+001,
    -1.431157e+000,
    4.096359e-001,
    -9.185502e-001,
    4.578034e-001,
    -1.006427e+000,
    -1.250087e-001,
    7.477012e-001,
    2.612704e+000,
    2.531799e+000,
    1.565371e+000,
    3.452604e-001,
    9.129266e-001,
    7.684386e-001,
    -1.068759e+000,
    -1.729191e-001,
    5.265652e-001,
    7.074812e+000,
    -4.259958e+000,
    -4.833255e-001,
    6.043380e-001,
    1.489203e+000,
    7.089074e-001,
    // albedo 0, turbidity 8
    -1.398983e+000,
    -4.500153e-001,
    -5.189309e-001,
    1.546325e-001,
    4.187327e-001,
    2.811516e-001,
    2.379667e-001,
    2.801040e+000,
    5.198375e-001,
    -2.970455e+000,
    -1.529948e+000,
    1.094532e-001,
    7.382263e-001,
    -1.024683e+000,
    2.074091e-001,
    1.397605e-001,
    -6.743828e-001,
    3.496944e-001,
    -3.942086e-001,
    3.424842e-001,
    -1.253259e+000,
    -9.268654e-001,
    5.636065e+000,
    8.224289e-001,
    2.452235e-001,
    5.864258e+000,
    1.202820e+000,
    -1.181174e+000,
    -4.197175e-001,
    1.429102e+000,
    -7.894317e-003,
    -1.239152e+001,
    -5.753431e-001,
    3.552180e-001,
    -4.495555e+000,
    2.141883e-001,
    -1.060281e+000,
    -1.080598e-001,
    -3.276480e-001,
    1.369250e+001,
    1.504389e+000,
    6.401191e-001,
    2.437501e-001,
    3.212918e+000,
    9.172133e-001,
    -1.037564e+000,
    -2.018083e-001,
    6.250668e-001,
    -2.525843e-003,
    -3.269998e+000,
    -2.649814e-001,
    6.600589e-001,
    3.337508e-001,
    6.516131e-001,
    // albedo 0, turbidity 9
    -1.610481e+000,
    -6.353902e-001,
    -5.968977e-001,
    1.414037e+000,
    -7.941453e-001,
    7.888684e-001,
    2.209045e-002,
    2.615106e+000,
    6.870260e-001,
    -3.073343e+000,
    -1.365905e+000,
    -2.651943e-001,
    -1.685310e+000,
    4.755874e-001,
    -1.110669e-001,
    2.561961e-001,
    1.222045e+000,
    3.362780e-002,
    -2.207768e+000,
    -1.009608e+000,
    -1.329601e+000,
    3.393091e+000,
    3.419104e+000,
    -4.733375e-002,
    5.989185e-001,
    2.814641e+000,
    1.245189e+000,
    -1.981173e-002,
    2.018414e-001,
    1.457765e+000,
    -6.316169e+000,
    -6.640569e+000,
    7.150646e-001,
    -2.993748e-001,
    -2.703376e+000,
    3.218596e-001,
    -1.435873e+000,
    -3.390505e-001,
    -3.859047e-001,
    1.457464e+001,
    -1.121591e+000,
    -6.089868e-002,
    5.319220e-001,
    1.852395e+000,
    8.379521e-001,
    -9.812568e-001,
    -2.273751e-001,
    5.108069e-001,
    -3.735693e-003,
    -2.547988e+000,
    -4.492561e-001,
    5.069199e-001,
    2.977910e-001,
    6.639273e-001,
    // albedo 0, turbidity 10
    -2.056405e+000,
    -9.703512e-001,
    -3.731953e-001,
    2.052022e+000,
    -1.445283e+000,
    6.103743e-001,
    -9.389644e-006,
    2.198652e+000,
    8.567335e-001,
    -2.105651e+000,
    -8.924283e-001,
    -6.868702e-001,
    -1.665838e+000,
    4.795702e-001,
    5.228080e-001,
    -4.272483e-002,
    2.661317e+000,
    -1.154062e-001,
    -6.179767e+000,
    -2.651580e+000,
    -1.527652e+000,
    2.692054e+000,
    2.293427e+000,
    -1.005611e-001,
    9.545323e-001,
    1.367438e+000,
    1.169193e+000,
    1.240848e+000,
    1.126706e-001,
    1.620422e+000,
    -3.384604e+000,
    -5.545532e+000,
    4.928203e-001,
    -5.999585e-001,
    -1.407078e+000,
    4.193816e-001,
    -1.539149e+000,
    -2.081890e-001,
    -4.552234e-001,
    1.056410e+001,
    -1.048637e+000,
    -2.780921e-001,
    5.682296e-001,
    6.785092e-001,
    7.729892e-001,
    -1.036841e+000,
    -4.359099e-001,
    4.767834e-001,
    -3.794262e-003,
    -1.980492e+000,
    9.954067e-002,
    3.037557e-001,
    2.156592e-002,
    6.845201e-001,
    // albedo 1, turbidity 1
    -1.110980e+000,
    -1.799491e-001,
    -3.168600e+000,
    5.336662e+000,
    -6.318131e-002,
    1.559251e+000,
    3.204341e-003,
    1.401140e+000,
    6.638144e-001,
    -1.132332e+000,
    -1.786787e-001,
    1.272954e+000,
    1.160211e+000,
    -1.685885e-001,
    1.409550e+000,
    7.140682e-003,
    2.136473e+000,
    5.320908e-001,
    -1.015776e+000,
    -1.825058e-001,
    2.122848e+000,
    -6.725506e-001,
    -1.976294e-001,
    2.376807e+000,
    -1.859856e-002,
    -1.803033e+000,
    1.207528e+000,
    -1.189845e+000,
    -1.509036e-001,
    1.345709e+000,
    5.832609e-001,
    -5.130839e-002,
    1.097035e+000,
    2.686911e-002,
    3.349361e+000,
    -3.431297e-002,
    -1.000281e+000,
    -1.696328e-001,
    2.829408e+000,
    -3.466041e-001,
    1.832532e+000,
    2.314637e+000,
    -2.721994e-002,
    -1.614939e+000,
    1.188720e+000,
    -1.120411e+000,
    -1.974172e-001,
    2.474172e+000,
    1.453506e-001,
    -4.002206e+000,
    1.180333e+000,
    2.229171e-002,
    3.112615e-001,
    5.505539e-001,
    // albedo 1, turbidity 2
    -1.112667e+000,
    -1.574855e-001,
    -2.284814e+000,
    4.255050e+000,
    -1.386097e-001,
    1.459506e+000,
    4.508931e-002,
    2.944474e+000,
    7.339984e-001,
    -1.113577e+000,
    -1.331062e-001,
    -1.828757e+000,
    3.910596e+000,
    -2.095519e-001,
    1.159335e+000,
    9.311608e-002,
    4.517295e+000,
    6.365313e-001,
    -1.061651e+000,
    -2.007134e-001,
    5.907472e+000,
    -4.808769e+000,
    -2.120206e-001,
    2.727568e+000,
    -4.222666e-002,
    -2.599674e+000,
    9.265659e-001,
    -1.136633e+000,
    -4.281875e-003,
    -3.407541e+000,
    4.132332e+000,
    -3.866153e-001,
    -5.082717e-001,
    4.828348e-001,
    9.797167e+000,
    3.325034e-001,
    -1.027909e+000,
    -2.334388e-001,
    4.972147e+000,
    -1.499736e+000,
    9.598438e-002,
    2.744895e+000,
    -3.558702e-001,
    -4.288054e+000,
    1.000138e+000,
    -1.102843e+000,
    -1.875642e-001,
    2.087760e+000,
    3.692600e-001,
    -6.520835e-001,
    -9.598766e-001,
    2.984231e-001,
    4.045786e-001,
    5.091931e-001,
    // albedo 1, turbidity 3
    -1.117485e+000,
    -1.492968e-001,
    -2.639425e+000,
    3.672106e+000,
    -1.058342e-001,
    1.098101e+000,
    1.544782e-001,
    4.496691e+000,
    6.582312e-001,
    -1.123872e+000,
    -1.467158e-001,
    3.049045e+000,
    -2.607634e+000,
    -2.505495e-001,
    -8.310458e-002,
    3.333822e-001,
    4.631418e+000,
    5.120491e-001,
    -1.118262e+000,
    -2.462050e-001,
    -8.333919e-002,
    2.438788e+000,
    6.143236e-001,
    3.745903e+000,
    -2.043295e-001,
    -3.451983e+000,
    1.056003e+000,
    -1.095394e+000,
    2.009680e-002,
    8.468659e-001,
    1.230624e-002,
    -8.638525e+000,
    -2.989487e+000,
    8.735734e-001,
    8.533740e+000,
    2.548062e-001,
    -1.035035e+000,
    -2.296018e-001,
    2.722309e+000,
    1.849369e-001,
    3.440975e+000,
    4.372083e+000,
    -4.747494e-001,
    -2.984092e+000,
    1.009737e+000,
    -1.113497e+000,
    -1.931400e-001,
    2.288509e+000,
    4.973129e-002,
    -1.353292e-001,
    -1.587772e+000,
    4.073801e-001,
    -8.180513e-003,
    5.682569e-001,
    // albedo 1, turbidity 4
    -1.172242e+000,
    -2.084847e-001,
    -1.212027e+000,
    1.991627e+000,
    -1.403495e-001,
    7.684996e-001,
    1.582914e-001,
    3.407597e+000,
    6.659386e-001,
    -1.167834e+000,
    -2.117291e-001,
    1.196578e+000,
    -1.438719e+000,
    -3.137939e-001,
    -4.537552e-002,
    2.260096e-001,
    4.659389e+000,
    5.776369e-001,
    -1.222298e+000,
    -2.893306e-001,
    9.080116e-001,
    1.413518e+000,
    1.709237e+000,
    2.915962e+000,
    8.464584e-002,
    -3.867076e+000,
    9.110543e-001,
    -9.554071e-001,
    6.610246e-002,
    -3.323811e-001,
    2.702543e+000,
    -1.345592e+001,
    -3.119309e+000,
    7.740473e-001,
    7.452516e+000,
    3.929172e-001,
    -1.119763e+000,
    -2.579942e-001,
    2.830634e+000,
    -1.333418e+000,
    6.825773e+000,
    4.230596e+000,
    -2.654108e-001,
    -2.669457e+000,
    9.126183e-001,
    -1.084261e+000,
    -2.086570e-001,
    2.248616e+000,
    6.993871e-001,
    -2.391760e+000,
    -1.738827e+000,
    3.674794e-001,
    -5.324741e-001,
    6.183292e-001,
    // albedo 1, turbidity 5
    -1.226325e+000,
    -2.688667e-001,
    -1.462040e-001,
    4.749868e-001,
    -8.718681e-002,
    4.956704e-001,
    1.752427e-001,
    2.933911e+000,
    6.470198e-001,
    -1.359737e+000,
    -3.985716e-001,
    -1.570034e-001,
    1.277905e+000,
    -1.314322e+000,
    4.320873e-001,
    8.532731e-002,
    2.774395e+000,
    6.318556e-001,
    -1.088212e+000,
    -1.688766e-001,
    1.399098e+000,
    -3.254950e+000,
    4.733557e+000,
    2.079183e+000,
    1.907990e-001,
    -9.540048e-001,
    8.714774e-001,
    -1.034524e+000,
    -1.050729e-002,
    -8.054376e-001,
    1.166351e+001,
    -1.879498e+001,
    -3.021428e+000,
    7.755251e-001,
    4.516574e+000,
    4.092690e-001,
    -1.076150e+000,
    -2.551781e-001,
    2.797790e+000,
    -5.437950e+000,
    9.156159e+000,
    3.988462e+000,
    -2.324172e-001,
    -2.124766e+000,
    8.863276e-001,
    -1.103432e+000,
    -2.058047e-001,
    2.117130e+000,
    2.401558e+000,
    -5.015370e+000,
    -1.829480e+000,
    4.046378e-001,
    -2.078794e-001,
    6.449045e-001,
    // albedo 1, turbidity 6
    -1.263516e+000,
    -3.133966e-001,
    3.174560e-001,
    -4.989246e-003,
    -2.317630e+000,
    3.963746e-001,
    1.677262e-001,
    2.563898e+000,
    6.335899e-001,
    -1.577927e+000,
    -5.893907e-001,
    -2.991531e-001,
    1.783728e+000,
    3.693827e+000,
    5.704918e-001,
    6.768069e-002,
    2.215180e+000,
    6.196162e-001,
    -9.191335e-001,
    -4.529201e-002,
    1.577262e+000,
    -6.455191e+000,
    -4.020064e+000,
    1.309911e+000,
    1.373281e-001,
    -7.178508e-001,
    9.243738e-001,
    -1.144508e+000,
    -9.289247e-002,
    -1.606387e+000,
    2.061805e+001,
    -1.051527e+001,
    -2.077164e+000,
    8.328239e-001,
    4.729795e+000,
    3.298487e-001,
    -1.018834e+000,
    -2.186851e-001,
    3.321767e+000,
    -7.887012e+000,
    3.374834e+000,
    3.005232e+000,
    -2.515037e-001,
    -2.656610e+000,
    9.316017e-001,
    -1.125230e+000,
    -2.422532e-001,
    1.850916e+000,
    6.213105e+000,
    -5.017914e+000,
    -1.644457e+000,
    3.811828e-001,
    -1.772362e-001,
    6.297360e-001,
    // albedo 1, turbidity 7
    -1.365631e+000,
    -4.017085e-001,
    1.942501e-001,
    -7.073927e-003,
    -1.461125e-001,
    4.898017e-001,
    1.623346e-001,
    2.330174e+000,
    5.983242e-001,
    -1.957177e+000,
    -9.640834e-001,
    -2.217521e-001,
    1.316645e+000,
    -1.907085e-001,
    1.134191e-002,
    9.704476e-002,
    3.828565e-002,
    5.538419e-001,
    -7.832629e-001,
    1.949904e-001,
    6.232354e-001,
    -2.947737e+000,
    3.702377e+000,
    2.212239e+000,
    9.128296e-002,
    3.131504e+000,
    9.923939e-001,
    -1.121562e+000,
    -2.704893e-001,
    -5.161748e-001,
    8.115427e+000,
    -1.443497e+001,
    -3.292676e+000,
    8.232212e-001,
    -1.548451e-002,
    3.199244e-001,
    -1.059207e+000,
    -1.613941e-001,
    2.375866e+000,
    -9.517705e-002,
    4.514722e+000,
    3.755824e+000,
    -1.696953e-001,
    -2.539157e-001,
    8.992553e-001,
    -1.108877e+000,
    -2.404852e-001,
    1.830175e+000,
    2.808956e+000,
    -4.932362e+000,
    -2.042775e+000,
    4.168739e-001,
    -2.534590e-001,
    6.533212e-001,
    // albedo 1, turbidity 8
    -1.405398e+000,
    -4.540068e-001,
    -4.766512e-001,
    1.871207e-001,
    5.535070e-001,
    -4.467365e-002,
    2.846366e-001,
    2.443422e+000,
    5.035706e-001,
    -2.843953e+000,
    -1.562366e+000,
    8.527921e-001,
    5.991182e-001,
    -9.984088e-001,
    7.599314e-001,
    -2.025184e-002,
    -1.515050e+000,
    4.397429e-001,
    -5.156586e-001,
    3.789775e-001,
    -1.194407e+000,
    -7.591558e-001,
    4.515532e+000,
    4.795814e-001,
    3.163186e-001,
    5.993132e+000,
    1.096327e+000,
    -1.070353e+000,
    -4.037269e-001,
    1.108932e+000,
    1.269159e+000,
    -1.099135e+001,
    -1.049849e+000,
    4.644725e-001,
    -4.387074e+000,
    2.704008e-001,
    -1.136211e+000,
    -1.473182e-001,
    1.235769e+000,
    5.725364e+000,
    1.712036e+000,
    1.630777e+000,
    3.656685e-002,
    2.082798e+000,
    9.036801e-001,
    -1.083101e+000,
    -2.468910e-001,
    1.894919e+000,
    6.574012e+000,
    -4.949098e+000,
    -1.132033e+000,
    3.336584e-001,
    -7.321133e-001,
    6.606587e-001,
    // albedo 1, turbidity 9
    -1.609910e+000,
    -6.550380e-001,
    -5.773346e-001,
    1.426156e+000,
    -5.000686e-001,
    8.257866e-001,
    1.839148e-002,
    2.106656e+000,
    6.957214e-001,
    -3.047283e+000,
    -1.421592e+000,
    -4.003615e-001,
    -6.531692e-001,
    5.643821e-001,
    -2.693762e-001,
    2.295553e-001,
    5.533910e-001,
    2.751822e-002,
    -2.160824e+000,
    -9.212504e-001,
    -8.438420e-001,
    1.466021e+000,
    1.124686e+000,
    -6.848173e-002,
    6.224893e-001,
    3.137662e+000,
    1.224147e+000,
    1.444817e-002,
    1.418426e-001,
    7.055176e-001,
    -1.787432e+000,
    -1.625625e+000,
    7.638401e-001,
    -3.309940e-001,
    -3.414755e+000,
    3.580691e-001,
    -1.480512e+000,
    -3.141638e-001,
    1.193403e+000,
    6.152773e+000,
    -3.314867e+000,
    1.345353e-001,
    5.359935e-001,
    1.409582e+000,
    8.072343e-001,
    -1.016066e+000,
    -2.346375e-001,
    1.457587e+000,
    -2.761458e-003,
    -2.546952e+000,
    -6.058542e-001,
    3.134230e-001,
    -2.232281e-001,
    6.760089e-001,
    // albedo 1, turbidity 10
    -2.019395e+000,
    -9.550942e-001,
    -1.187885e-001,
    1.995372e+000,
    -1.604228e+000,
    4.995785e-001,
    -9.647137e-006,
    1.929333e+000,
    8.659254e-001,
    -2.071307e+000,
    -9.485438e-001,
    -3.817151e-001,
    -1.657017e+000,
    9.488626e-001,
    5.816145e-001,
    -3.856514e-002,
    1.677756e+000,
    -1.262572e-001,
    -6.388445e+000,
    -2.738739e+000,
    -9.872469e-001,
    2.450058e+000,
    1.075999e+000,
    2.305434e-002,
    8.598771e-001,
    1.853582e+000,
    1.180017e+000,
    1.742851e+000,
    2.950102e-001,
    1.015937e+000,
    -2.511194e+000,
    -3.829361e+000,
    -1.126698e-001,
    -4.564605e-001,
    -2.097128e+000,
    4.012648e-001,
    -1.845177e+000,
    -3.242819e-001,
    7.060963e-001,
    7.747868e+000,
    -1.721532e+000,
    6.057347e-001,
    4.266212e-001,
    3.153697e-001,
    7.958222e-001,
    -9.599955e-001,
    -3.732025e-001,
    1.381129e+000,
    -3.983023e-003,
    -1.941446e+000,
    -5.943490e-001,
    2.269207e-001,
    -7.249738e-001,
    6.710888e-001,
};

double datasetRad680[] =
{
    // albedo 0, turbidity 1
    1.320908e-002,
    9.179272e-003,
    2.540842e-002,
    3.413687e-002,
    2.736575e-002,
    2.799241e-002,
    // albedo 0, turbidity 2
    1.364418e-002,
    9.639315e-003,
    2.455688e-002,
    5.468867e-002,
    2.423200e-002,
    3.240293e-002,
    // albedo 0, turbidity 3
    1.356642e-002,
    9.864007e-003,
    2.017166e-002,
    8.738638e-002,
    2.138981e-002,
    3.828822e-002,
    // albedo 0, turbidity 4
    1.274664e-002,
    1.046958e-002,
    7.076299e-003,
    1.378101e-001,
    2.058352e-002,
    4.607358e-002,
    // albedo 0, turbidity 5
    1.151617e-002,
    1.429568e-002,
    -1.804673e-002,
    1.974118e-001,
    1.313176e-002,
    5.733295e-002,
    // albedo 0, turbidity 6
    1.089311e-002,
    1.719127e-002,
    -3.582843e-002,
    2.315641e-001,
    1.402940e-002,
    6.289477e-002,
    // albedo 0, turbidity 7
    9.705879e-003,
    2.218462e-002,
    -6.221073e-002,
    2.771148e-001,
    1.651339e-002,
    7.346287e-002,
    // albedo 0, turbidity 8
    8.356372e-003,
    2.724501e-002,
    -8.836051e-002,
    3.099528e-001,
    4.114206e-002,
    8.518889e-002,
    // albedo 0, turbidity 9
    7.026434e-003,
    2.944084e-002,
    -9.824183e-002,
    2.940735e-001,
    1.048477e-001,
    1.012199e-001,
    // albedo 0, turbidity 10
    5.935885e-003,
    2.429070e-002,
    -7.239967e-002,
    1.895904e-001,
    2.306596e-001,
    1.177261e-001,
    // albedo 1, turbidity 1
    1.370741e-002,
    1.011873e-002,
    2.499587e-002,
    3.362880e-002,
    6.416750e-002,
    6.673258e-002,
    // albedo 1, turbidity 2
    1.417558e-002,
    1.065771e-002,
    2.402602e-002,
    5.330606e-002,
    6.505571e-002,
    7.324558e-002,
    // albedo 1, turbidity 3
    1.406012e-002,
    1.182138e-002,
    1.636956e-002,
    9.161153e-002,
    6.031840e-002,
    8.638638e-002,
    // albedo 1, turbidity 4
    1.321071e-002,
    1.310944e-002,
    1.017467e-003,
    1.450040e-001,
    6.291618e-002,
    1.003625e-001,
    // albedo 1, turbidity 5
    1.194910e-002,
    1.687076e-002,
    -2.332212e-002,
    2.021394e-001,
    6.093196e-002,
    1.177929e-001,
    // albedo 1, turbidity 6
    1.126778e-002,
    1.905450e-002,
    -3.804088e-002,
    2.298767e-001,
    7.038318e-002,
    1.240367e-001,
    // albedo 1, turbidity 7
    1.025282e-002,
    2.337214e-002,
    -6.236283e-002,
    2.708195e-001,
    7.801793e-002,
    1.406577e-001,
    // albedo 1, turbidity 8
    9.018216e-003,
    2.718840e-002,
    -8.215497e-002,
    2.866465e-001,
    1.194106e-001,
    1.556975e-001,
    // albedo 1, turbidity 9
    7.747698e-003,
    2.701679e-002,
    -8.076599e-002,
    2.419548e-001,
    2.126954e-001,
    1.683085e-001,
    // albedo 1, turbidity 10
    6.701188e-003,
    2.085440e-002,
    -5.068221e-002,
    1.256935e-001,
    3.480598e-001,
    1.851691e-001,
};

double dataset720[] =
{
    // albedo 0, turbidity 1
    -1.110553e+000,
    -1.675726e-001,
    -2.349324e-001,
    2.433790e+000,
    -1.342878e-001,
    1.755516e+000,
    -1.879493e-006,
    1.509217e+000,
    7.216495e-001,
    -1.149960e+000,
    -2.418229e-001,
    2.341927e+000,
    1.486508e-001,
    -4.333388e-001,
    9.028740e-001,
    9.450710e-003,
    -3.134790e-001,
    5.923234e-001,
    -9.702430e-001,
    -5.384657e-002,
    3.025898e+000,
    -6.450284e-001,
    9.728166e-001,
    3.532967e+000,
    -2.429753e-002,
    1.343614e+000,
    1.067807e+000,
    -1.278773e+000,
    -2.072018e-001,
    -2.458359e-001,
    3.749133e-001,
    -9.580484e+000,
    3.066020e-001,
    4.056471e-002,
    4.343208e+000,
    1.865704e-001,
    -9.511618e-001,
    -1.674143e-001,
    4.195842e+000,
    -1.205785e-001,
    2.160133e+000,
    3.048813e+000,
    -4.826924e-002,
    -3.779096e+000,
    1.024834e+000,
    -1.095577e+000,
    -1.855865e-001,
    1.973593e+000,
    7.894097e-002,
    9.578182e-001,
    8.565674e-001,
    4.663966e-002,
    7.375811e-001,
    5.577192e-001,
    // albedo 0, turbidity 2
    -1.099352e+000,
    -1.338612e-001,
    -8.419373e-001,
    2.710346e+000,
    -2.241044e-001,
    1.645463e+000,
    7.621625e-002,
    3.548772e+000,
    7.268231e-001,
    -1.140694e+000,
    -1.723890e-001,
    1.413194e+000,
    3.429051e-001,
    -4.431396e-001,
    9.757402e-001,
    1.248306e-001,
    1.780103e+000,
    6.637254e-001,
    -9.861499e-001,
    -8.032931e-002,
    2.396682e+000,
    7.281382e-001,
    1.472495e-001,
    3.316479e+000,
    -1.028439e-001,
    3.729469e+000,
    9.059004e-001,
    -1.233397e+000,
    -9.896833e-002,
    -1.679568e+000,
    1.542653e+000,
    -9.977726e+000,
    -6.579124e-001,
    6.386315e-001,
    6.157752e+000,
    3.985939e-001,
    -9.438092e-001,
    -1.629239e-001,
    4.213446e+000,
    -3.419684e-001,
    2.110121e+000,
    3.552183e+000,
    -2.817116e-001,
    -3.323718e+000,
    8.785077e-001,
    -1.120794e+000,
    -2.121477e-001,
    1.326767e+000,
    2.317528e-001,
    5.648291e-001,
    4.155089e-001,
    3.048162e-001,
    3.186797e-001,
    6.285665e-001,
    // albedo 0, turbidity 3
    -1.117191e+000,
    -1.510453e-001,
    -3.511136e-001,
    1.706946e+000,
    -3.820460e-001,
    1.228101e+000,
    1.641555e-001,
    3.663544e+000,
    6.846104e-001,
    -1.130950e+000,
    -1.622534e-001,
    1.197076e+000,
    -1.342532e+000,
    6.608991e-002,
    -1.955817e-001,
    3.515286e-001,
    3.237403e+000,
    5.732364e-001,
    -1.103903e+000,
    -1.810472e-001,
    1.254237e+000,
    3.367565e+000,
    -1.746589e+000,
    4.464939e+000,
    -2.831757e-001,
    -2.424241e-001,
    9.961252e-001,
    -1.107818e+000,
    -2.407723e-002,
    -7.518594e-001,
    7.115830e+000,
    -1.603375e+001,
    -4.077248e+000,
    1.210904e+000,
    6.281392e+000,
    2.496837e-001,
    -1.012153e+000,
    -1.911658e-001,
    2.357463e+000,
    -2.392720e+000,
    7.080581e+000,
    6.002768e+000,
    -5.120158e-001,
    -2.039879e+000,
    1.008071e+000,
    -1.083766e+000,
    -1.889743e-001,
    1.669813e+000,
    1.205140e+000,
    -2.973102e+000,
    -1.420288e+000,
    5.838643e-001,
    1.338574e-001,
    5.902153e-001,
    // albedo 0, turbidity 4
    -1.176390e+000,
    -2.045914e-001,
    -1.035177e+000,
    1.521425e+000,
    -9.698257e-002,
    7.561111e-001,
    2.338582e-001,
    3.264500e+000,
    6.520267e-001,
    -1.132876e+000,
    -1.921539e-001,
    9.661015e-001,
    -2.470184e-001,
    -5.825797e-001,
    5.044517e-001,
    1.418233e-001,
    4.416172e+000,
    6.580570e-001,
    -1.296062e+000,
    -2.855719e-001,
    1.143329e+000,
    -1.640682e+000,
    1.921828e+000,
    1.625086e+000,
    5.248871e-001,
    -3.757434e+000,
    7.293814e-001,
    -9.026255e-001,
    2.670242e-002,
    -8.632572e-001,
    7.076787e+000,
    -1.407525e+001,
    -1.251814e+000,
    1.806495e-001,
    6.575978e+000,
    6.367149e-001,
    -1.103623e+000,
    -1.818983e-001,
    1.490037e+000,
    -3.276017e+000,
    6.936153e+000,
    2.689183e+000,
    5.705211e-001,
    -1.354153e+000,
    7.095230e-001,
    -1.049370e+000,
    -1.854814e-001,
    1.385509e+000,
    1.714977e+000,
    -3.205204e+000,
    -1.161420e-001,
    3.453320e-001,
    4.355508e-001,
    7.115006e-001,
    // albedo 0, turbidity 5
    -1.225291e+000,
    -2.574996e-001,
    -4.766919e-001,
    4.951357e-001,
    5.242961e-002,
    4.702062e-001,
    2.428653e-001,
    3.095075e+000,
    6.424221e-001,
    -1.318856e+000,
    -3.713082e-001,
    -4.987985e-001,
    2.026237e+000,
    -1.457426e+000,
    7.809557e-001,
    1.419197e-003,
    2.776845e+000,
    7.058454e-001,
    -1.168038e+000,
    -1.572586e-001,
    1.786834e+000,
    -4.594005e+000,
    4.780600e+000,
    1.639416e+000,
    5.324063e-001,
    -1.000719e+000,
    7.325083e-001,
    -9.862998e-001,
    -7.482649e-002,
    -1.332445e+000,
    1.329260e+001,
    -1.803019e+001,
    -2.669936e+000,
    3.591475e-001,
    3.852972e+000,
    5.714399e-001,
    -1.049025e+000,
    -1.404280e-001,
    1.342894e+000,
    -5.633938e+000,
    8.396123e+000,
    3.809869e+000,
    4.313231e-001,
    -5.373938e-001,
    7.693298e-001,
    -1.069033e+000,
    -2.091865e-001,
    1.088280e+000,
    3.125506e+000,
    -4.664580e+000,
    -1.191484e+000,
    5.195344e-001,
    3.961673e-001,
    6.817393e-001,
    // albedo 0, turbidity 6
    -1.267895e+000,
    -3.004228e-001,
    -5.149611e-001,
    4.302967e-001,
    1.504018e-001,
    3.700643e-001,
    2.354209e-001,
    2.887788e+000,
    6.298388e-001,
    -1.551925e+000,
    -5.917820e-001,
    -5.915642e-001,
    2.016019e+000,
    -1.252286e+000,
    8.651065e-001,
    7.721402e-003,
    1.148828e+000,
    6.589887e-001,
    -9.782795e-001,
    3.652455e-002,
    1.331304e+000,
    -4.804135e+000,
    5.130801e+000,
    1.052586e+000,
    4.439877e-001,
    2.100157e+000,
    8.308236e-001,
    -1.077598e+000,
    -2.015253e-001,
    -1.037818e+000,
    1.307045e+001,
    -1.715211e+001,
    -1.607252e+000,
    4.472382e-001,
    6.802371e-001,
    4.848934e-001,
    -1.025969e+000,
    -1.170376e-001,
    1.139546e+000,
    -3.374680e+000,
    6.330035e+000,
    2.199093e+000,
    3.928627e-001,
    8.428666e-001,
    7.960910e-001,
    -1.062382e+000,
    -1.881842e-001,
    8.863153e-001,
    4.266858e+000,
    -5.011692e+000,
    -4.086830e-001,
    5.889147e-001,
    5.341939e-001,
    6.866073e-001,
    // albedo 0, turbidity 7
    -1.352417e+000,
    -3.836953e-001,
    -5.951560e-001,
    4.053297e-001,
    2.468304e-001,
    2.565711e-001,
    2.321365e-001,
    2.512376e+000,
    6.089904e-001,
    -1.976438e+000,
    -9.152777e-001,
    -4.417666e-001,
    1.790189e+000,
    -1.085567e+000,
    4.562228e-001,
    2.133332e-002,
    4.989856e-001,
    6.257100e-001,
    -7.197412e-001,
    2.165210e-001,
    6.233215e-001,
    -3.960686e+000,
    4.694083e+000,
    2.062797e+000,
    3.121864e-001,
    2.942681e+000,
    8.846033e-001,
    -1.189984e+000,
    -3.151612e-001,
    -5.020073e-001,
    1.015136e+001,
    -1.483684e+001,
    -3.476730e+000,
    6.049863e-001,
    -1.941153e-001,
    4.281015e-001,
    -9.781383e-001,
    -8.764833e-002,
    8.290915e-001,
    1.086960e-001,
    4.467570e+000,
    3.905633e+000,
    1.975895e-001,
    6.964295e-001,
    8.333166e-001,
    -1.081242e+000,
    -2.051949e-001,
    6.056482e-001,
    5.219268e+000,
    -4.410608e+000,
    -1.963212e+000,
    7.277904e-001,
    8.509624e-001,
    6.689251e-001,
    // albedo 0, turbidity 8
    -1.443212e+000,
    -4.725757e-001,
    -9.477961e-001,
    2.671049e-001,
    6.163577e-001,
    -3.965036e-001,
    4.071134e-001,
    2.464218e+000,
    4.997820e-001,
    -3.021428e+000,
    -1.558459e+000,
    1.389763e-001,
    1.122031e+000,
    -1.014816e+000,
    1.265687e+000,
    -1.649604e-001,
    -6.627923e-001,
    5.494665e-001,
    -1.593477e-001,
    5.076305e-001,
    -7.283933e-001,
    -1.265076e+000,
    3.904153e+000,
    -8.196757e-002,
    6.585734e-001,
    4.998464e+000,
    9.330667e-001,
    -1.378374e+000,
    -5.064534e-001,
    7.231197e-001,
    1.385088e+000,
    -9.500118e+000,
    -4.806746e-001,
    1.067642e-001,
    -3.297209e+000,
    4.441955e-001,
    -9.436176e-001,
    -6.189764e-002,
    1.144482e-001,
    9.137694e+000,
    2.948867e-001,
    1.224655e+000,
    3.675148e-001,
    2.124090e+000,
    8.014519e-001,
    -1.078915e+000,
    -2.051854e-001,
    4.754209e-001,
    5.826389e-003,
    -2.498632e+000,
    -8.265078e-001,
    7.644670e-001,
    6.066256e-001,
    6.811963e-001,
    // albedo 0, turbidity 9
    -1.621711e+000,
    -6.425839e-001,
    -7.307813e-001,
    1.109519e+000,
    -4.107299e-001,
    7.789953e-001,
    7.764812e-002,
    2.335627e+000,
    6.230915e-001,
    -4.003597e+000,
    -1.736865e+000,
    -6.062450e-001,
    -7.370264e-001,
    7.002778e-001,
    -4.140325e-001,
    3.926087e-001,
    8.316399e-001,
    1.516341e-001,
    -7.696712e-001,
    -3.872306e-001,
    -1.159436e+000,
    1.660752e+000,
    2.031840e+000,
    -7.697685e-001,
    5.481684e-001,
    2.788249e+000,
    1.112977e+000,
    -8.506589e-001,
    -5.430791e-002,
    1.088719e+000,
    -2.513532e+000,
    -4.144477e+000,
    2.760914e+000,
    -3.011272e-001,
    -2.383556e+000,
    4.496070e-001,
    -1.150061e+000,
    -3.009215e-001,
    -9.176868e-002,
    8.996074e+000,
    -1.753862e+000,
    -2.428423e+000,
    5.764492e-001,
    1.218492e+000,
    7.552230e-001,
    -1.020853e+000,
    -1.499849e-001,
    3.437744e-001,
    -2.339597e-003,
    -2.646520e+000,
    1.378457e+000,
    6.708410e-001,
    9.149680e-001,
    6.961806e-001,
    // albedo 0, turbidity 10
    -1.982394e+000,
    -9.369621e-001,
    -3.767595e-001,
    2.514582e+000,
    -1.501415e+000,
    6.258952e-001,
    -5.260430e-006,
    2.100142e+000,
    7.824077e-001,
    -3.432415e+000,
    -1.264283e+000,
    -9.042363e-001,
    -2.930432e+000,
    8.249096e-001,
    7.244840e-001,
    3.055253e-002,
    2.527405e+000,
    -2.107031e-003,
    -4.333533e+000,
    -2.156157e+000,
    -8.341654e-001,
    5.048387e+000,
    1.803580e+000,
    -9.318434e-001,
    1.085401e+000,
    8.728330e-001,
    1.050061e+000,
    4.889224e-001,
    5.956721e-002,
    8.445388e-001,
    -7.479177e+000,
    -4.049292e+000,
    1.199966e+000,
    -7.060560e-001,
    -9.742353e-001,
    4.893674e-001,
    -1.347508e+000,
    -1.874523e-001,
    -5.063342e-002,
    1.299813e+001,
    -1.707387e+000,
    -4.076088e-001,
    6.119042e-001,
    3.717790e-001,
    7.662157e-001,
    -1.047037e+000,
    -3.743109e-001,
    3.452375e-001,
    -3.615559e-003,
    -2.169432e+000,
    -7.166880e-002,
    3.747046e-001,
    2.746126e-001,
    6.773818e-001,
    // albedo 1, turbidity 1
    -1.105396e+000,
    -1.663441e-001,
    -2.359634e-001,
    2.476496e+000,
    -1.329052e-001,
    1.715759e+000,
    2.103991e-003,
    1.421966e+000,
    6.270733e-001,
    -1.132480e+000,
    -2.330883e-001,
    2.273938e+000,
    2.422717e-001,
    -4.159883e-001,
    9.350714e-001,
    1.432347e-002,
    -4.176684e-001,
    4.664640e-001,
    -1.036155e+000,
    -9.432450e-002,
    3.117262e+000,
    -6.369808e-001,
    1.060389e+000,
    3.386481e+000,
    -4.605081e-002,
    1.248000e+000,
    9.701974e-001,
    -1.162485e+000,
    -1.382303e-001,
    1.544122e-001,
    3.716511e-001,
    -9.520209e+000,
    -2.739605e-001,
    8.489054e-002,
    4.371570e+000,
    7.694391e-002,
    -1.031787e+000,
    -2.165067e-001,
    4.446666e+000,
    -1.470711e-001,
    2.143436e+000,
    1.922123e+000,
    -9.589030e-002,
    -3.594664e+000,
    8.629249e-001,
    -1.081125e+000,
    -1.623953e-001,
    2.048137e+000,
    8.639386e-002,
    1.225845e+000,
    1.239255e-001,
    8.366038e-002,
    8.322625e-001,
    5.604708e-001,
    // albedo 1, turbidity 2
    -1.112606e+000,
    -1.514491e-001,
    -1.608942e+000,
    3.592344e+000,
    -1.616115e-001,
    1.593861e+000,
    5.488306e-002,
    2.854783e+000,
    7.519999e-001,
    -1.098630e+000,
    -1.410161e-001,
    2.155487e+000,
    -4.381610e-001,
    -3.635146e-001,
    1.313843e+000,
    1.201277e-001,
    2.469958e+000,
    6.481071e-001,
    -1.077575e+000,
    -1.275645e-001,
    1.418205e+000,
    2.057232e+000,
    -7.778503e-002,
    2.433840e+000,
    -7.094034e-002,
    3.347259e+000,
    9.344752e-001,
    -1.099714e+000,
    -4.474282e-002,
    -1.247041e-001,
    -1.578342e-001,
    -7.968895e+000,
    1.730912e-001,
    5.303765e-001,
    5.523179e+000,
    3.840340e-001,
    -1.061945e+000,
    -2.200148e-001,
    4.333103e+000,
    1.818948e-002,
    1.907751e+000,
    1.560633e+000,
    -3.182192e-001,
    -3.010282e+000,
    8.844351e-001,
    -1.087782e+000,
    -1.709041e-001,
    1.834683e+000,
    7.351214e-002,
    1.282669e+000,
    2.075884e-001,
    2.698971e-001,
    3.373859e-001,
    5.808336e-001,
    // albedo 1, turbidity 3
    -1.121417e+000,
    -1.551220e-001,
    -1.527123e+000,
    2.788105e+000,
    -1.477847e-001,
    1.152139e+000,
    1.742181e-001,
    3.473417e+000,
    6.737050e-001,
    -1.118910e+000,
    -1.496848e-001,
    2.736873e+000,
    -1.829596e+000,
    -3.411991e-001,
    1.177538e-001,
    2.960683e-001,
    3.273898e+000,
    5.743833e-001,
    -1.121145e+000,
    -1.980292e-001,
    -5.407002e-001,
    2.886807e+000,
    4.877852e-001,
    3.692424e+000,
    -1.104033e-001,
    -2.358878e-001,
    9.976295e-001,
    -1.078889e+000,
    -1.541161e-003,
    1.370650e+000,
    1.644450e+000,
    -1.425572e+001,
    -3.075430e+000,
    9.346385e-001,
    5.871863e+000,
    2.618026e-001,
    -1.053346e+000,
    -2.262166e-001,
    2.532003e+000,
    -8.720058e-001,
    7.667901e+000,
    4.357082e+000,
    -5.367969e-001,
    -2.073329e+000,
    1.023965e+000,
    -1.100093e+000,
    -1.810893e-001,
    2.566430e+000,
    4.757700e-001,
    -2.069684e+000,
    -1.585209e+000,
    4.693140e-001,
    -6.719615e-001,
    5.569453e-001,
    // albedo 1, turbidity 4
    -1.181528e+000,
    -2.151896e-001,
    -1.076470e+000,
    2.037517e+000,
    -1.683559e-001,
    8.780110e-001,
    1.782773e-001,
    2.768650e+000,
    6.743293e-001,
    -1.142132e+000,
    -1.825403e-001,
    1.320992e+000,
    -1.895472e+000,
    -2.160241e-001,
    -2.079637e-001,
    3.424953e-001,
    4.333355e+000,
    5.663420e-001,
    -1.225408e+000,
    -2.906477e-001,
    8.323962e-001,
    2.176300e+000,
    1.943859e+000,
    3.003671e+000,
    1.130255e-001,
    -4.449977e+000,
    8.867390e-001,
    -9.815988e-001,
    5.577004e-002,
    -4.240348e-001,
    1.488466e+000,
    -1.279361e+001,
    -3.110899e+000,
    7.360104e-001,
    7.937751e+000,
    4.474817e-001,
    -1.103439e+000,
    -2.481553e-001,
    3.045691e+000,
    -6.993993e-001,
    6.081464e+000,
    3.986228e+000,
    -1.616828e-001,
    -3.373973e+000,
    8.572294e-001,
    -1.081695e+000,
    -1.943361e-001,
    2.303236e+000,
    3.906537e-001,
    -1.498982e+000,
    -1.372140e+000,
    3.379214e-001,
    -4.953601e-001,
    6.521383e-001,
    // albedo 1, turbidity 5
    -1.235776e+000,
    -2.745978e-001,
    2.205316e-002,
    4.505193e-001,
    -1.569202e-001,
    5.065039e-001,
    2.016320e-001,
    2.449382e+000,
    6.535188e-001,
    -1.268478e+000,
    -3.078367e-001,
    -2.041769e-001,
    1.189583e+000,
    -1.311782e+000,
    4.724677e-001,
    1.025764e-001,
    3.300615e+000,
    6.689797e-001,
    -1.190389e+000,
    -2.597641e-001,
    1.377486e+000,
    -2.289003e+000,
    4.214767e+000,
    1.900318e+000,
    3.126604e-001,
    -2.537399e+000,
    7.980811e-001,
    -9.632300e-001,
    7.067379e-002,
    -6.690546e-001,
    9.507059e+000,
    -1.721426e+001,
    -2.850631e+000,
    6.931159e-001,
    5.722238e+000,
    4.856193e-001,
    -1.119689e+000,
    -3.019499e-001,
    2.657474e+000,
    -5.208105e+000,
    1.015200e+001,
    3.863887e+000,
    -1.603721e-001,
    -3.132328e+000,
    8.543154e-001,
    -1.078742e+000,
    -1.840880e-001,
    2.341448e+000,
    2.576821e+000,
    -5.011296e+000,
    -1.671996e+000,
    3.955131e-001,
    -4.700684e-001,
    6.516593e-001,
    // albedo 1, turbidity 6
    -1.263449e+000,
    -3.016185e-001,
    -1.680842e-001,
    4.791728e-001,
    -8.989862e-002,
    5.069014e-001,
    1.892810e-001,
    2.535339e+000,
    6.506411e-001,
    -1.544305e+000,
    -5.656222e-001,
    -2.084263e-001,
    1.312304e+000,
    -8.580598e-001,
    4.039133e-001,
    1.008588e-001,
    1.268784e+000,
    6.333075e-001,
    -9.436041e-001,
    -1.620107e-002,
    1.253874e+000,
    -3.499120e+000,
    4.452594e+000,
    1.870490e+000,
    1.524710e-001,
    8.031346e-001,
    8.930942e-001,
    -1.106718e+000,
    -1.102586e-001,
    -8.803979e-001,
    1.326904e+001,
    -1.878253e+001,
    -2.994671e+000,
    9.501205e-001,
    2.284893e+000,
    3.662824e-001,
    -1.048783e+000,
    -2.156089e-001,
    2.786728e+000,
    -4.862603e+000,
    8.438175e+000,
    3.683031e+000,
    -3.092444e-001,
    -1.293934e+000,
    9.110045e-001,
    -1.108140e+000,
    -2.156079e-001,
    2.181504e+000,
    2.124553e+000,
    -5.007442e+000,
    -1.711417e+000,
    4.904871e-001,
    -8.710312e-001,
    6.376965e-001,
    // albedo 1, turbidity 7
    -1.345282e+000,
    -3.856197e-001,
    -1.975094e-001,
    3.016919e-001,
    2.765844e-001,
    2.092275e-001,
    2.251325e-001,
    2.058589e+000,
    6.014266e-001,
    -1.907309e+000,
    -8.881952e-001,
    -4.827860e-001,
    1.495665e+000,
    -9.243173e-001,
    3.864061e-001,
    7.491538e-002,
    2.719526e-001,
    6.046039e-001,
    -7.540737e-001,
    1.800167e-001,
    1.174575e+000,
    -3.052295e+000,
    4.669060e+000,
    1.793876e+000,
    1.664066e-001,
    2.376187e+000,
    9.261122e-001,
    -1.165479e+000,
    -2.500464e-001,
    -9.603937e-001,
    8.919733e+000,
    -1.561899e+001,
    -2.850650e+000,
    8.368531e-001,
    3.404393e-001,
    3.694265e-001,
    -1.032259e+000,
    -1.593662e-001,
    2.621639e+000,
    -5.369281e-001,
    6.011517e+000,
    3.234312e+000,
    -1.842335e-001,
    -3.749684e-001,
    8.913063e-001,
    -1.119906e+000,
    -2.533313e-001,
    2.017975e+000,
    4.776492e-001,
    -5.005474e+000,
    -1.503414e+000,
    4.694448e-001,
    -1.039200e+000,
    6.438630e-001,
    // albedo 1, turbidity 8
    -1.457842e+000,
    -4.806585e-001,
    -6.807833e-001,
    2.682520e-001,
    5.586195e-001,
    -2.806536e-001,
    3.694491e-001,
    2.169304e+000,
    4.997873e-001,
    -2.906600e+000,
    -1.558470e+000,
    4.048869e-001,
    1.012321e+000,
    -8.709928e-001,
    9.025637e-001,
    -9.171486e-002,
    -1.279805e+000,
    5.327924e-001,
    -2.500868e-001,
    5.175467e-001,
    -4.366020e-001,
    -1.156645e+000,
    3.657335e+000,
    4.092973e-001,
    4.611188e-001,
    4.971048e+000,
    9.789196e-001,
    -1.282240e+000,
    -4.792753e-001,
    3.824491e-001,
    2.061672e+000,
    -9.474747e+000,
    -1.080446e+000,
    3.852100e-001,
    -3.234591e+000,
    3.696703e-001,
    -1.046065e+000,
    -1.097023e-001,
    1.672284e+000,
    4.799701e+000,
    1.286403e+000,
    1.712569e+000,
    1.099301e-001,
    1.214451e+000,
    8.572886e-001,
    -1.104124e+000,
    -2.576744e-001,
    1.919030e+000,
    -1.296687e-003,
    -3.500874e+000,
    -1.048831e+000,
    3.929400e-001,
    -9.229794e-001,
    6.687909e-001,
    // albedo 1, turbidity 9
    -1.658918e+000,
    -6.637256e-001,
    -1.162850e+000,
    1.829549e+000,
    -2.525065e-001,
    8.624803e-001,
    5.214746e-002,
    1.977784e+000,
    6.455044e-001,
    -3.553256e+000,
    -1.639022e+000,
    -8.821743e-001,
    -2.660037e-001,
    5.168738e-001,
    -8.582770e-001,
    4.110780e-001,
    1.034123e-001,
    1.039852e-001,
    -1.299367e+000,
    -4.890457e-001,
    -5.595307e-001,
    1.129115e+000,
    5.445041e-001,
    5.361314e-001,
    4.579589e-001,
    3.385708e+000,
    1.184267e+000,
    -4.366852e-001,
    -2.303554e-002,
    5.417530e-001,
    -9.106900e-001,
    -4.398484e-001,
    3.178252e-001,
    -2.132156e-001,
    -3.682761e+000,
    3.754470e-001,
    -1.334075e+000,
    -2.466639e-001,
    1.293237e+000,
    4.685982e+000,
    -4.032879e+000,
    4.666293e-001,
    5.337822e-001,
    1.603290e+000,
    8.067400e-001,
    -1.052460e+000,
    -2.501759e-001,
    1.601487e+000,
    1.713504e+000,
    -2.810006e+000,
    -8.042597e-001,
    3.216101e-001,
    -5.944876e-001,
    6.740783e-001,
    // albedo 1, turbidity 10
    -1.974746e+000,
    -9.111910e-001,
    -2.159155e-001,
    2.437415e+000,
    -1.592257e+000,
    6.133797e-001,
    -6.243023e-006,
    1.960399e+000,
    7.806415e-001,
    -2.677119e+000,
    -1.100702e+000,
    -6.847246e-001,
    -2.820855e+000,
    1.577837e+000,
    6.243833e-001,
    2.218481e-002,
    1.568717e+000,
    2.327673e-002,
    -5.323827e+000,
    -2.461050e+000,
    -3.941307e-001,
    4.908417e+000,
    -1.657232e-001,
    -9.501763e-001,
    1.063520e+000,
    1.455622e+000,
    9.781890e-001,
    1.325000e+000,
    3.538115e-001,
    1.783573e-001,
    -6.903650e+000,
    -8.079921e-001,
    1.215973e+000,
    -6.852540e-001,
    -1.735835e+000,
    5.744662e-001,
    -1.741196e+000,
    -3.448017e-001,
    1.242377e+000,
    1.098613e+001,
    -3.386782e+000,
    -3.128683e-001,
    5.792848e-001,
    1.364330e-002,
    7.112763e-001,
    -9.762671e-001,
    -3.368355e-001,
    1.374728e+000,
    -3.312353e-003,
    -2.576919e+000,
    -1.778015e-001,
    2.024288e-001,
    -6.128666e-001,
    6.917938e-001,
};

double datasetRad720[] =
{
    // albedo 0, turbidity 1
    1.130152e-002,
    8.671843e-003,
    2.004792e-002,
    2.515879e-002,
    2.020140e-002,
    2.117353e-002,
    // albedo 0, turbidity 2
    1.224368e-002,
    8.839480e-003,
    2.189489e-002,
    4.083873e-002,
    1.919064e-002,
    2.455945e-002,
    // albedo 0, turbidity 3
    1.252249e-002,
    8.009335e-003,
    2.371432e-002,
    6.397292e-002,
    2.042384e-002,
    2.862112e-002,
    // albedo 0, turbidity 4
    1.180325e-002,
    8.958479e-003,
    1.183940e-002,
    1.148189e-001,
    1.354571e-002,
    3.848691e-002,
    // albedo 0, turbidity 5
    1.085725e-002,
    1.134459e-002,
    -7.554548e-003,
    1.671603e-001,
    8.431212e-003,
    4.772824e-002,
    // albedo 0, turbidity 6
    1.014547e-002,
    1.403737e-002,
    -2.479898e-002,
    2.032831e-001,
    5.127749e-003,
    5.409735e-002,
    // albedo 0, turbidity 7
    9.143208e-003,
    1.825961e-002,
    -4.902126e-002,
    2.473204e-001,
    7.992708e-003,
    6.238918e-002,
    // albedo 0, turbidity 8
    7.784746e-003,
    2.352715e-002,
    -7.647231e-002,
    2.868914e-001,
    2.581232e-002,
    7.345921e-002,
    // albedo 0, turbidity 9
    6.425568e-003,
    2.680506e-002,
    -9.216963e-002,
    2.866525e-001,
    7.712816e-002,
    8.877708e-002,
    // albedo 0, turbidity 10
    5.348459e-003,
    2.347534e-002,
    -7.499904e-002,
    2.035369e-001,
    1.874982e-001,
    1.045961e-001,
    // albedo 1, turbidity 1
    1.168435e-002,
    9.445039e-003,
    1.950520e-002,
    2.563333e-002,
    4.729214e-002,
    5.096829e-002,
    // albedo 1, turbidity 2
    1.252521e-002,
    1.012940e-002,
    2.002302e-002,
    4.276714e-002,
    4.778275e-002,
    5.748908e-002,
    // albedo 1, turbidity 3
    1.285682e-002,
    9.705956e-003,
    2.018767e-002,
    6.797612e-002,
    5.181662e-002,
    6.548541e-002,
    // albedo 1, turbidity 4
    1.218970e-002,
    1.070161e-002,
    8.436124e-003,
    1.177409e-001,
    5.124773e-002,
    8.069723e-002,
    // albedo 1, turbidity 5
    1.129406e-002,
    1.339498e-002,
    -1.193989e-002,
    1.709051e-001,
    5.001995e-002,
    9.558448e-002,
    // albedo 1, turbidity 6
    1.056724e-002,
    1.570995e-002,
    -2.759057e-002,
    2.030760e-001,
    5.311962e-002,
    1.037882e-001,
    // albedo 1, turbidity 7
    9.594077e-003,
    1.966415e-002,
    -5.024827e-002,
    2.432607e-001,
    6.172355e-002,
    1.169276e-001,
    // albedo 1, turbidity 8
    8.348105e-003,
    2.415281e-002,
    -7.475064e-002,
    2.748209e-001,
    8.753187e-002,
    1.356651e-001,
    // albedo 1, turbidity 9
    7.106169e-003,
    2.513833e-002,
    -7.928946e-002,
    2.463668e-001,
    1.685984e-001,
    1.485820e-001,
    // albedo 1, turbidity 10
    6.031610e-003,
    2.016534e-002,
    -5.448075e-002,
    1.436689e-001,
    2.971830e-001,
    1.639884e-001,
};

double* datasets[] =
{
    dataset320,
    dataset360,
    dataset400,
    dataset440,
    dataset480,
    dataset520,
    dataset560,
    dataset600,
    dataset640,
    dataset680,
    dataset720
};

double* datasetsRad[] =
{
    datasetRad320,
    datasetRad360,
    datasetRad400,
    datasetRad440,
    datasetRad480,
    datasetRad520,
    datasetRad560,
    datasetRad600,
    datasetRad640,
    datasetRad680,
    datasetRad720
};

double datasetXYZ1[] =
{
    // albedo 0, turbidity 1
    -1.117110e+000,
    -1.886977e-001,
    -8.530128e+000,
    9.951687e+000,
    -4.725064e-002,
    1.125737e+000,
    1.712676e-002,
    3.532765e+000,
    5.173998e-001,
    -1.163355e+000,
    -1.992353e-001,
    3.082410e+000,
    -1.669706e+000,
    -1.049522e-001,
    6.937205e-001,
    5.249454e-002,
    4.357580e+000,
    3.768004e-001,
    -1.051188e+000,
    -2.753244e-001,
    2.085388e+000,
    -1.800141e-001,
    -2.964819e-001,
    2.168163e+000,
    -1.250388e-001,
    -3.231367e+000,
    1.010908e+000,
    -1.138018e+000,
    -1.749534e-001,
    5.256126e-001,
    1.700718e-001,
    -3.990030e-001,
    4.624688e-001,
    1.852445e-001,
    4.395925e+000,
    6.390240e-001,
    -1.026689e+000,
    -2.103637e-001,
    2.306699e+000,
    2.389051e-002,
    -3.500049e-001,
    2.090102e+000,
    -2.176284e-001,
    -7.671467e-001,
    4.706333e-001,
    -1.084411e+000,
    -1.600364e-001,
    1.156985e+000,
    1.549753e-002,
    1.869213e+000,
    7.586320e-001,
    2.253033e-001,
    2.713131e+000,
    5.032221e-001,
    // albedo 0, turbidity 2
    -1.113849e+000,
    -1.706374e-001,
    -5.330528e+000,
    6.334901e+000,
    -7.559627e-002,
    1.023591e+000,
    5.023815e-002,
    4.776665e+000,
    6.289327e-001,
    -1.129298e+000,
    -1.601074e-001,
    1.666328e+000,
    -1.114406e+000,
    -1.400874e-001,
    3.348053e-001,
    1.613600e-001,
    6.322929e+000,
    3.875943e-001,
    -1.108202e+000,
    -2.832673e-001,
    2.281668e+000,
    -1.024359e-001,
    -4.560374e-001,
    2.364049e+000,
    -1.579936e-001,
    -3.703204e+000,
    1.150091e+000,
    -1.061041e+000,
    -2.604365e-002,
    -6.324973e-001,
    1.086752e-001,
    -5.823469e-001,
    1.939444e-001,
    3.302034e-001,
    8.022398e+000,
    2.575325e-001,
    -1.075983e+000,
    -2.661876e-001,
    2.400318e+000,
    7.077761e-003,
    -1.168161e+000,
    1.890928e+000,
    -1.295923e-001,
    -1.699872e+000,
    8.942046e-001,
    -1.067522e+000,
    -1.565908e-001,
    1.162220e+000,
    3.840104e-003,
    2.523981e+000,
    9.052453e-001,
    1.820224e-001,
    2.668389e+000,
    5.992541e-001,
    // albedo 0, turbidity 3
    -1.126479e+000,
    -1.851028e-001,
    -2.864366e+000,
    3.399195e+000,
    -1.026625e-001,
    7.618753e-001,
    9.814771e-002,
    4.911916e+000,
    6.154648e-001,
    -1.152433e+000,
    -1.964568e-001,
    4.880946e-001,
    -4.754054e-002,
    -2.242667e-001,
    5.468924e-001,
    7.656109e-002,
    6.000180e+000,
    5.926910e-001,
    -1.134945e+000,
    -2.715305e-001,
    2.193198e+000,
    -1.937991e-001,
    -9.965509e-001,
    1.602421e+000,
    5.585103e-002,
    -2.323870e+000,
    8.435027e-001,
    -1.010203e+000,
    2.928092e-002,
    -1.366168e+000,
    1.153606e-001,
    5.648928e-001,
    3.266289e-001,
    3.202228e-001,
    8.560481e+000,
    5.440889e-001,
    -1.097707e+000,
    -2.723333e-001,
    2.215217e+000,
    -1.609526e-004,
    -1.004171e+001,
    1.550473e+000,
    3.310688e-002,
    -1.352681e+000,
    7.322595e-001,
    -1.058912e+000,
    -1.601683e-001,
    1.078282e+000,
    2.993807e-005,
    4.307151e+000,
    8.188027e-001,
    2.067024e-001,
    2.517392e+000,
    6.861903e-001,
    // albedo 0, turbidity 4
    -1.181764e+000,
    -2.474484e-001,
    -1.246200e+000,
    1.550315e+000,
    -1.634446e-001,
    6.506827e-001,
    9.378324e-002,
    4.151444e+000,
    6.241404e-001,
    -1.240714e+000,
    -3.181485e-001,
    1.917314e-001,
    5.746187e-001,
    -7.311025e-001,
    4.621459e-001,
    3.119258e-002,
    4.219868e+000,
    6.555999e-001,
    -1.122342e+000,
    -2.012540e-001,
    1.166312e+000,
    -1.268075e+000,
    7.139106e-001,
    1.247484e+000,
    1.132050e-001,
    8.774022e-001,
    8.082093e-001,
    -1.017672e+000,
    -3.573195e-002,
    -9.682933e-001,
    6.405088e+000,
    -1.172151e+001,
    -2.782906e-001,
    4.319009e-001,
    4.930671e+000,
    5.217636e-001,
    -1.072165e+000,
    -2.286657e-001,
    1.598072e+000,
    -2.529638e-001,
    1.019343e+000,
    1.772926e+000,
    2.302509e-002,
    4.404589e-001,
    7.752613e-001,
    -1.069826e+000,
    -1.720906e-001,
    8.125597e-001,
    -6.820962e-004,
    -2.434397e+000,
    1.799917e-001,
    3.700983e-001,
    2.360241e+000,
    6.732911e-001,
    // albedo 0, turbidity 5
    -1.228738e+000,
    -3.036185e-001,
    -3.526738e-001,
    4.390717e-001,
    -3.564502e-001,
    4.747889e-001,
    1.095377e-001,
    3.715367e+000,
    5.956741e-001,
    -1.421564e+000,
    -5.410507e-001,
    -3.371365e-001,
    1.902298e+000,
    -1.661602e+000,
    4.867249e-001,
    1.321513e-002,
    1.849050e+000,
    6.324863e-001,
    -1.062221e+000,
    -4.627871e-002,
    5.915220e-001,
    -4.096772e+000,
    5.064702e+000,
    1.241854e+000,
    7.701544e-002,
    4.772779e+000,
    8.932334e-001,
    -1.018441e+000,
    -1.586239e-001,
    -4.209658e-001,
    9.539244e+000,
    -1.745560e+001,
    -8.297278e-001,
    5.799218e-001,
    4.274605e-001,
    4.186732e-001,
    -1.078592e+000,
    -1.951789e-001,
    1.028585e+000,
    1.137636e+000,
    4.416707e+000,
    1.663807e+000,
    -2.842450e-002,
    2.140685e+000,
    8.180460e-001,
    -1.054646e+000,
    -1.499606e-001,
    5.111922e-001,
    1.241495e+000,
    -4.840806e+000,
    4.432091e-002,
    5.211282e-001,
    2.768477e+000,
    6.726383e-001,
    // albedo 0, turbidity 6
    -1.262846e+000,
    -3.416713e-001,
    -1.399779e-001,
    -4.028052e-003,
    -1.083218e+000,
    3.522023e-001,
    1.397764e-001,
    3.531444e+000,
    5.475740e-001,
    -1.653434e+000,
    -7.504768e-001,
    -8.174682e-002,
    1.754589e+000,
    -3.111121e-001,
    4.765620e-001,
    -1.754277e-002,
    8.953154e-001,
    5.980268e-001,
    -8.992136e-001,
    8.298393e-002,
    -5.730534e-002,
    -3.352709e+000,
    2.748151e+000,
    1.282876e+000,
    9.434944e-002,
    5.607731e+000,
    9.476430e-001,
    -1.115891e+000,
    -2.472937e-001,
    -4.411451e-002,
    6.335622e+000,
    -1.323700e+001,
    -1.117530e+000,
    5.939642e-001,
    -5.286681e-001,
    3.785553e-001,
    -1.035771e+000,
    -1.610573e-001,
    6.760480e-001,
    6.439868e+000,
    1.798706e+000,
    1.656299e+000,
    -3.901280e-002,
    2.531724e+000,
    8.396789e-001,
    -1.061186e+000,
    -1.587457e-001,
    3.824204e-001,
    -1.478971e-003,
    -3.637527e+000,
    -1.593153e-001,
    5.743545e-001,
    2.714126e+000,
    6.696384e-001,
    // albedo 0, turbidity 7
    -1.334348e+000,
    -4.116969e-001,
    -2.232259e-001,
    -6.599848e-003,
    -1.979605e+000,
    3.460671e-001,
    1.477926e-001,
    3.341321e+000,
    4.998239e-001,
    -1.961683e+000,
    -1.034931e+000,
    4.304264e-001,
    1.828825e+000,
    3.793796e-001,
    5.838299e-001,
    -5.308793e-002,
    -1.978204e-001,
    4.932856e-001,
    -8.464803e-001,
    1.866266e-001,
    -1.095613e+000,
    -3.969847e+000,
    3.195541e+000,
    7.141150e-001,
    2.277183e-001,
    7.345782e+000,
    1.063866e+000,
    -1.091796e+000,
    -3.671388e-001,
    9.452280e-001,
    4.836395e+000,
    -1.188403e+001,
    -4.803766e-001,
    3.617785e-001,
    -3.760591e+000,
    3.146842e-001,
    -1.044357e+000,
    -1.082384e-001,
    7.543161e-003,
    9.471644e+000,
    2.276706e-001,
    8.583580e-001,
    1.519749e-001,
    4.128944e+000,
    8.452057e-001,
    -1.058322e+000,
    -1.809853e-001,
    3.477035e-001,
    7.784850e-003,
    -2.717592e+000,
    -6.934331e-002,
    5.504960e-001,
    2.024776e+000,
    6.754827e-001,
    // albedo 0, turbidity 8
    -1.392196e+000,
    -4.853729e-001,
    -4.253578e-001,
    1.244254e+000,
    -1.042038e+000,
    5.639825e-001,
    1.146086e-002,
    3.160225e+000,
    6.611979e-001,
    -2.333014e+000,
    -1.272768e+000,
    4.218749e-001,
    -7.873016e-001,
    -1.223312e+000,
    3.061333e-001,
    1.361868e-001,
    -8.350580e-002,
    1.268146e-002,
    -1.175044e+000,
    -8.174775e-002,
    -1.816892e+000,
    7.250475e-001,
    7.259529e+000,
    3.741057e-001,
    2.188179e-001,
    6.884669e+000,
    1.461422e+000,
    -7.737210e-001,
    -2.884721e-001,
    1.772935e+000,
    -1.209013e+000,
    -1.260728e+001,
    2.011139e-001,
    1.625510e-001,
    -4.831754e+000,
    1.008834e-001,
    -1.185671e+000,
    -1.636590e-001,
    -4.913527e-001,
    6.803007e+000,
    1.543796e+000,
    2.133660e-001,
    3.194918e-001,
    3.954876e+000,
    9.281338e-001,
    -1.018400e+000,
    -1.922808e-001,
    4.086088e-001,
    1.249495e+001,
    -4.394593e+000,
    -3.102551e-001,
    3.814179e-001,
    1.567551e+000,
    6.542399e-001,
    // albedo 0, turbidity 9
    -1.572152e+000,
    -6.777545e-001,
    -3.775486e-001,
    1.351900e+000,
    -1.221331e+000,
    5.196851e-001,
    -1.033250e-005,
    2.699234e+000,
    8.999977e-001,
    -2.020038e+000,
    -9.958414e-001,
    -6.761381e-002,
    -3.885281e-001,
    -8.385924e-001,
    5.094696e-001,
    -2.562169e-002,
    1.634037e+000,
    -2.894016e-001,
    -3.219102e+000,
    -1.458156e+000,
    -1.583373e+000,
    -2.465794e-001,
    5.503321e+000,
    -1.532509e-001,
    5.714550e-001,
    3.682619e+000,
    1.534762e+000,
    2.883773e-001,
    1.760342e-001,
    1.577877e+000,
    1.211477e+000,
    -9.091579e+000,
    8.143782e-001,
    -2.981243e-001,
    -2.852121e+000,
    1.493723e-001,
    -1.479340e+000,
    -3.307438e-001,
    -3.860842e-001,
    2.956574e+000,
    6.869448e-001,
    -3.484410e-001,
    5.278314e-001,
    2.183976e+000,
    8.785970e-001,
    -9.831260e-001,
    -2.458424e-001,
    3.579689e-001,
    1.064304e+001,
    -3.893366e+000,
    -1.909644e-001,
    2.638383e-001,
    1.025810e+000,
    6.679692e-001,
    // albedo 0, turbidity 10
    -1.960024e+000,
    -1.014011e+000,
    -4.829351e-001,
    8.915058e-001,
    -7.009229e-001,
    5.304907e-001,
    -8.595758e-006,
    2.302571e+000,
    9.001514e-001,
    -1.701366e+000,
    -9.489213e-001,
    -1.256732e-001,
    9.601218e-001,
    -1.188723e+000,
    -5.110063e-002,
    -1.071200e-002,
    2.000881e+000,
    -2.450755e-001,
    -6.060110e+000,
    -2.529032e+000,
    -1.694825e+000,
    -2.726360e+000,
    4.540271e+000,
    1.618493e+000,
    2.319395e-001,
    3.128856e+000,
    1.431975e+000,
    7.469620e-001,
    -1.665042e-001,
    1.368942e+000,
    6.261086e+000,
    -9.280186e+000,
    -1.448688e+000,
    1.829857e-001,
    -1.689902e+000,
    1.463262e-001,
    -1.370309e+000,
    -3.680319e-001,
    -5.286215e-002,
    -1.421766e-001,
    1.295714e+000,
    1.011746e+000,
    4.639675e-002,
    4.853838e-001,
    8.995415e-001,
    -1.057359e+000,
    -3.226718e-001,
    1.934981e-001,
    9.952990e+000,
    -3.688414e+000,
    -5.425285e-001,
    3.519873e-001,
    8.071330e-001,
    6.558989e-001,
    // albedo 1, turbidity 1
    -1.115546e+000,
    -1.901540e-001,
    -1.330679e+001,
    1.480853e+001,
    -2.902755e-002,
    1.041269e+000,
    2.216642e-002,
    3.242935e+000,
    5.098736e-001,
    -1.135925e+000,
    -1.731383e-001,
    5.511589e+000,
    -3.916563e+000,
    -7.470919e-002,
    7.452889e-001,
    4.380458e-002,
    4.675311e+000,
    4.529233e-001,
    -1.074792e+000,
    -2.967287e-001,
    9.329445e-001,
    8.475009e-001,
    -2.230118e-001,
    2.009173e+000,
    -1.058166e-001,
    -3.636596e+000,
    6.333535e-001,
    -1.105844e+000,
    -1.302998e-001,
    1.030273e+000,
    3.186748e-002,
    -2.907639e-001,
    3.532941e-001,
    1.527822e-001,
    4.977443e+000,
    5.301924e-001,
    -1.035699e+000,
    -1.923216e-001,
    2.429709e+000,
    1.157312e-001,
    -7.082193e-001,
    1.166865e+000,
    -1.751309e-001,
    -2.559761e-001,
    4.841644e-001,
    -1.086411e+000,
    -1.640908e-001,
    1.332773e+000,
    2.499941e-002,
    1.648943e+000,
    2.125027e-001,
    1.743729e-001,
    2.467368e+000,
    5.035620e-001,
    // albedo 1, turbidity 2
    -1.114572e+000,
    -1.776122e-001,
    -7.197291e+000,
    8.311406e+000,
    -4.929854e-002,
    9.337293e-001,
    5.850848e-002,
    4.159854e+000,
    5.996272e-001,
    -1.119860e+000,
    -1.554458e-001,
    1.500683e+000,
    -7.321523e-001,
    -9.186599e-002,
    3.828885e-001,
    1.305778e-001,
    6.133864e+000,
    4.302989e-001,
    -1.111266e+000,
    -2.842354e-001,
    2.483494e+000,
    -3.030351e-001,
    -3.442878e-001,
    2.221163e+000,
    -1.180557e-001,
    -3.933585e+000,
    1.086953e+000,
    -1.047700e+000,
    -1.780754e-002,
    -3.633681e-001,
    1.315990e-001,
    5.053053e-002,
    3.136004e-002,
    2.855648e-001,
    8.336594e+000,
    3.139212e-001,
    -1.079476e+000,
    -2.627123e-001,
    2.998210e+000,
    3.681693e-002,
    -1.171443e+000,
    1.221984e+000,
    -1.583031e-001,
    -2.117424e+000,
    8.646351e-001,
    -1.073079e+000,
    -1.539020e-001,
    1.292630e+000,
    1.484184e-002,
    2.164423e+000,
    1.451962e-001,
    1.549698e-001,
    2.647209e+000,
    5.707980e-001,
    // albedo 1, turbidity 3
    -1.131212e+000,
    -1.940739e-001,
    -4.754457e+000,
    5.687135e+000,
    -7.749415e-002,
    8.803637e-001,
    4.976630e-002,
    4.313029e+000,
    6.763509e-001,
    -1.150868e+000,
    -1.841088e-001,
    1.509319e+000,
    -1.504445e+000,
    -1.155798e-001,
    -1.496653e-003,
    1.638603e-001,
    6.237297e+000,
    4.515163e-001,
    -1.091750e+000,
    -2.635102e-001,
    1.555520e+000,
    1.262327e+000,
    -3.767901e-001,
    2.483078e+000,
    -7.594110e-002,
    -3.040623e+000,
    1.055827e+000,
    -1.063790e+000,
    7.091950e-003,
    -3.862395e-001,
    -1.575656e+000,
    -7.885669e-001,
    -9.188117e-001,
    4.637420e-001,
    8.591443e+000,
    3.016922e-001,
    -1.064242e+000,
    -2.575463e-001,
    2.572325e+000,
    1.275520e+000,
    -1.124627e+000,
    1.953762e+000,
    -2.142889e-001,
    -1.582420e+000,
    9.248708e-001,
    -1.083943e+000,
    -1.690011e-001,
    1.645984e+000,
    -1.596014e-003,
    -5.006213e+000,
    -3.348285e-001,
    2.026158e-001,
    2.023957e+000,
    6.063043e-001,
    // albedo 1, turbidity 4
    -1.169662e+000,
    -2.396919e-001,
    -2.224971e+000,
    2.808556e+000,
    -1.044209e-001,
    6.360932e-001,
    8.167338e-002,
    3.868389e+000,
    6.277945e-001,
    -1.218263e+000,
    -2.844801e-001,
    9.161275e-001,
    -7.154387e-001,
    -2.182690e-001,
    3.551728e-001,
    6.900070e-002,
    4.620690e+000,
    6.028025e-001,
    -1.125687e+000,
    -2.631559e-001,
    9.303026e-001,
    1.163365e+000,
    -8.171804e-001,
    1.600486e+000,
    2.569319e-002,
    -1.336058e+000,
    9.117388e-001,
    -1.011027e+000,
    3.803163e-002,
    -4.751331e-001,
    2.824341e-001,
    -3.674054e-001,
    -8.853567e-001,
    5.357389e-001,
    7.138210e+000,
    4.219210e-001,
    -1.091358e+000,
    -2.861155e-001,
    2.471507e+000,
    -5.310653e-002,
    -1.335876e+001,
    1.885600e+000,
    -1.515195e-001,
    -1.452121e+000,
    8.422067e-001,
    -1.085150e+000,
    -1.823031e-001,
    1.547540e+000,
    -6.087268e-004,
    1.988805e+000,
    -4.493615e-001,
    2.400213e-001,
    1.672762e+000,
    6.417813e-001,
    // albedo 1, turbidity 5
    -1.209120e+000,
    -2.917418e-001,
    -7.599492e-002,
    5.509383e-001,
    -6.090107e-001,
    4.411559e-001,
    8.785356e-002,
    3.390293e+000,
    6.154437e-001,
    -1.423585e+000,
    -5.433904e-001,
    7.062585e-002,
    1.546712e+000,
    -2.031293e+000,
    3.304308e-001,
    5.065144e-002,
    1.658761e+000,
    5.727964e-001,
    -1.014753e+000,
    -4.907604e-002,
    4.822113e-001,
    -4.348427e+000,
    6.815202e+000,
    1.360554e+000,
    7.720917e-003,
    3.627797e+000,
    9.838846e-001,
    -1.059529e+000,
    -1.390850e-001,
    -9.523143e-003,
    1.149147e+001,
    -2.042301e+001,
    -1.132501e+000,
    6.511831e-001,
    1.408719e+000,
    3.169969e-001,
    -1.070161e+000,
    -2.150866e-001,
    1.958408e+000,
    -2.629102e+000,
    4.387658e+000,
    1.826024e+000,
    -1.989975e-001,
    1.180131e+000,
    8.853364e-001,
    -1.092416e+000,
    -1.875493e-001,
    1.456830e+000,
    3.643610e-001,
    -3.383295e+000,
    -4.909221e-001,
    3.235157e-001,
    1.416786e+000,
    6.490304e-001,
    // albedo 1, turbidity 6
    -1.250606e+000,
    -3.417167e-001,
    2.609347e-002,
    2.916256e-001,
    -5.663950e-001,
    4.057884e-001,
    9.306476e-002,
    3.020759e+000,
    5.868551e-001,
    -1.581075e+000,
    -7.129360e-001,
    1.057159e-001,
    1.310238e+000,
    -1.483391e+000,
    3.128195e-001,
    5.844719e-002,
    8.362464e-001,
    5.340745e-001,
    -9.445616e-001,
    3.828551e-002,
    2.342750e-001,
    -3.264987e+000,
    6.215689e+000,
    1.421621e+000,
    -3.960402e-002,
    4.485903e+000,
    1.041401e+000,
    -1.090041e+000,
    -2.044630e-001,
    -6.198970e-002,
    7.993561e+000,
    -1.863912e+001,
    -1.469543e+000,
    7.371616e-001,
    3.426232e-001,
    2.729653e-001,
    -1.051727e+000,
    -1.871950e-001,
    1.906304e+000,
    4.415643e-001,
    5.463951e+000,
    2.000052e+000,
    -2.364389e-001,
    1.492786e+000,
    9.132301e-001,
    -1.101923e+000,
    -2.013346e-001,
    1.336038e+000,
    -1.732640e-003,
    -5.008926e+000,
    -7.345655e-001,
    3.675739e-001,
    1.361212e+000,
    6.425515e-001,
    // albedo 1, turbidity 7
    -1.322955e+000,
    -4.157821e-001,
    7.374637e-002,
    -7.215981e-003,
    -4.341370e+000,
    2.967273e-001,
    1.335468e-001,
    2.786861e+000,
    5.041326e-001,
    -1.905525e+000,
    -1.026133e+000,
    7.208529e-001,
    1.635622e+000,
    5.371775e+000,
    3.218040e-001,
    3.138909e-002,
    -3.775875e-001,
    4.314917e-001,
    -8.333499e-001,
    1.894502e-001,
    -7.312286e-001,
    -5.341566e+000,
    -3.353392e+000,
    1.210172e+000,
    2.049840e-002,
    6.284378e+000,
    1.181394e+000,
    -1.114353e+000,
    -3.608748e-001,
    6.826462e-001,
    1.120914e+001,
    -9.197966e+000,
    -1.439691e+000,
    6.317850e-001,
    -2.843292e+000,
    1.572562e-001,
    -1.048614e+000,
    -1.237563e-001,
    1.368859e+000,
    -2.593585e+000,
    8.525405e-001,
    1.854694e+000,
    -1.305988e-001,
    2.879614e+000,
    9.641736e-001,
    -1.096474e+000,
    -2.076007e-001,
    1.299523e+000,
    1.048926e+001,
    -5.010562e+000,
    -9.130276e-001,
    2.991672e-001,
    1.320527e+000,
    6.360343e-001,
    // albedo 1, turbidity 8
    -1.385001e+000,
    -4.947621e-001,
    -1.781523e-001,
    9.039341e-001,
    -8.092924e-001,
    5.328024e-001,
    1.750043e-002,
    2.643656e+000,
    6.491608e-001,
    -2.348711e+000,
    -1.348853e+000,
    7.525765e-001,
    -5.274939e-001,
    -9.536148e-001,
    6.949699e-002,
    1.768581e-001,
    -8.206184e-001,
    1.790864e-002,
    -1.049098e+000,
    2.469139e-002,
    -1.256914e+000,
    4.588219e-001,
    6.256964e+000,
    1.043069e+000,
    -8.960005e-003,
    6.911280e+000,
    1.533370e+000,
    -8.382545e-001,
    -3.461625e-001,
    1.318294e+000,
    -8.402857e-001,
    -1.244871e+001,
    -9.902163e-001,
    5.021354e-001,
    -5.345035e+000,
    -2.955005e-002,
    -1.185841e+000,
    -1.440584e-001,
    8.172708e-001,
    6.487970e+000,
    1.312650e+000,
    1.256657e+000,
    -1.838750e-002,
    3.768616e+000,
    1.023812e+000,
    -1.052497e+000,
    -2.099624e-001,
    1.265525e+000,
    9.561834e+000,
    -4.761341e+000,
    -8.451009e-001,
    2.782780e-001,
    9.410635e-001,
    6.259912e-001,
    // albedo 1, turbidity 9
    -1.545617e+000,
    -6.847012e-001,
    -8.986729e-002,
    1.257249e+000,
    -1.182992e+000,
    4.749918e-001,
    -9.982071e-006,
    2.176688e+000,
    9.000734e-001,
    -2.068126e+000,
    -1.078801e+000,
    2.826009e-001,
    -2.763807e-001,
    -7.026131e-001,
    4.125783e-001,
    -2.197093e-002,
    7.991923e-001,
    -2.941266e-001,
    -3.094338e+000,
    -1.370773e+000,
    -1.293897e+000,
    -5.152595e-001,
    4.769522e+000,
    1.682016e-001,
    4.880760e-001,
    4.141076e+000,
    1.553788e+000,
    3.634903e-001,
    1.576858e-001,
    1.379980e+000,
    1.847508e+000,
    -7.884272e+000,
    7.181303e-002,
    -1.599674e-001,
    -3.940529e+000,
    1.072707e-001,
    -1.567768e+000,
    -3.147592e-001,
    5.476064e-001,
    1.630360e+000,
    6.131979e-001,
    4.697129e-001,
    3.686719e-001,
    2.384867e+000,
    9.242304e-001,
    -9.827709e-001,
    -2.587556e-001,
    1.265595e+000,
    5.525824e+000,
    -3.926958e+000,
    -6.341009e-001,
    1.896607e-001,
    1.888764e-001,
    6.460038e-001,
    // albedo 1, turbidity 10
    -2.003847e+000,
    -1.079373e+000,
    -1.541605e-001,
    7.599445e-001,
    -6.879182e-001,
    5.068993e-001,
    -7.955054e-006,
    1.757070e+000,
    9.001343e-001,
    -1.693333e+000,
    -9.246340e-001,
    1.517173e-001,
    1.089523e+000,
    -1.321234e+000,
    -1.363809e-001,
    -9.245475e-003,
    1.544016e+000,
    -2.446727e-001,
    -6.014908e+000,
    -2.689284e+000,
    -1.151164e+000,
    -3.081593e+000,
    4.787615e+000,
    1.795532e+000,
    1.988540e-001,
    2.478428e+000,
    1.431517e+000,
    1.028164e+000,
    6.853538e-002,
    8.738582e-001,
    6.599936e+000,
    -9.872997e+000,
    -1.887984e+000,
    2.151620e-001,
    -1.090509e+000,
    1.455418e-001,
    -1.487024e+000,
    -4.680150e-001,
    9.821133e-001,
    4.598253e-002,
    1.648193e+000,
    1.457380e+000,
    4.487323e-003,
    -7.672642e-001,
    8.944728e-001,
    -1.035269e+000,
    -2.777345e-001,
    9.006146e-001,
    5.388761e+000,
    -3.468543e+000,
    -7.882484e-001,
    2.724403e-001,
    5.348662e-001,
    6.597854e-001,
};

double datasetXYZRad1[] =
{
    // albedo 0, turbidity 1
    1.560219e+000,
    1.417388e+000,
    1.206927e+000,
    1.091949e+001,
    5.931416e+000,
    7.304788e+000,
    // albedo 0, turbidity 2
    1.533049e+000,
    1.560532e+000,
    3.685059e-001,
    1.355040e+001,
    5.543711e+000,
    7.792189e+000,
    // albedo 0, turbidity 3
    1.471043e+000,
    1.746088e+000,
    -9.299697e-001,
    1.720362e+001,
    5.473384e+000,
    8.336416e+000,
    // albedo 0, turbidity 4
    1.355991e+000,
    2.109348e+000,
    -3.295855e+000,
    2.264843e+001,
    5.454607e+000,
    9.304656e+000,
    // albedo 0, turbidity 5
    1.244963e+000,
    2.547533e+000,
    -5.841485e+000,
    2.756879e+001,
    5.576104e+000,
    1.043287e+001,
    // albedo 0, turbidity 6
    1.175532e+000,
    2.784634e+000,
    -7.212225e+000,
    2.975347e+001,
    6.472980e+000,
    1.092331e+001,
    // albedo 0, turbidity 7
    1.082973e+000,
    3.118094e+000,
    -8.934293e+000,
    3.186879e+001,
    8.473885e+000,
    1.174019e+001,
    // albedo 0, turbidity 8
    9.692500e-001,
    3.349574e+000,
    -1.003810e+001,
    3.147654e+001,
    1.338931e+001,
    1.272547e+001,
    // albedo 0, turbidity 9
    8.547044e-001,
    3.151538e+000,
    -9.095567e+000,
    2.554995e+001,
    2.273219e+001,
    1.410398e+001,
    // albedo 0, turbidity 10
    7.580340e-001,
    2.311153e+000,
    -5.170814e+000,
    1.229669e+001,
    3.686529e+001,
    1.598882e+001,
    // albedo 1, turbidity 1
    1.664273e+000,
    1.574468e+000,
    1.422078e+000,
    9.768247e+000,
    1.447338e+001,
    1.644988e+001,
    // albedo 1, turbidity 2
    1.638295e+000,
    1.719586e+000,
    5.786675e-001,
    1.239846e+001,
    1.415419e+001,
    1.728605e+001,
    // albedo 1, turbidity 3
    1.572623e+000,
    1.921559e+000,
    -7.714802e-001,
    1.609246e+001,
    1.420954e+001,
    1.825908e+001,
    // albedo 1, turbidity 4
    1.468395e+000,
    2.211970e+000,
    -2.845869e+000,
    2.075027e+001,
    1.524822e+001,
    1.937622e+001,
    // albedo 1, turbidity 5
    1.355047e+000,
    2.556469e+000,
    -4.960920e+000,
    2.460237e+001,
    1.648360e+001,
    2.065648e+001,
    // albedo 1, turbidity 6
    1.291642e+000,
    2.742036e+000,
    -6.061967e+000,
    2.602002e+001,
    1.819144e+001,
    2.116712e+001,
    // albedo 1, turbidity 7
    1.194565e+000,
    2.972120e+000,
    -7.295779e+000,
    2.691805e+001,
    2.124880e+001,
    2.201819e+001,
    // albedo 1, turbidity 8
    1.083631e+000,
    3.047021e+000,
    -7.766096e+000,
    2.496261e+001,
    2.744264e+001,
    2.291875e+001,
    // albedo 1, turbidity 9
    9.707994e-001,
    2.736459e+000,
    -6.308284e+000,
    1.760860e+001,
    3.776291e+001,
    2.392150e+001,
    // albedo 1, turbidity 10
    8.574294e-001,
    1.865155e+000,
    -2.364707e+000,
    4.337793e+000,
    5.092831e+001,
    2.523432e+001,
};

double datasetXYZ2[] =
{
    // albedo 0, turbidity 1
    -1.129389e+000,
    -1.939566e-001,
    -7.340528e+000,
    8.503969e+000,
    -5.410571e-002,
    9.900808e-001,
    2.975034e-002,
    4.079174e+000,
    5.161440e-001,
    -1.151023e+000,
    -1.613665e-001,
    3.237530e+000,
    -2.065033e+000,
    -1.458923e-001,
    8.245948e-001,
    3.157058e-002,
    6.721103e+000,
    3.853611e-001,
    -1.134973e+000,
    -3.646711e-001,
    2.209469e+000,
    -5.061267e-001,
    -5.845681e-001,
    1.509470e+000,
    -7.132035e-002,
    -5.829985e+000,
    9.804977e-001,
    -1.079933e+000,
    -7.703755e-002,
    1.940080e-001,
    2.098860e+000,
    1.953573e-001,
    1.251566e+000,
    8.548282e-002,
    6.658381e+000,
    5.417463e-001,
    -1.072774e+000,
    -2.586304e-001,
    2.469893e+000,
    -3.243129e+000,
    -8.096472e+000,
    1.726860e+000,
    -7.613974e-002,
    -1.848909e+000,
    7.136562e-001,
    -1.074435e+000,
    -1.419997e-001,
    1.531452e+000,
    3.888301e+000,
    -2.606336e+000,
    1.135033e+000,
    5.677813e-002,
    2.920547e+000,
    4.999573e-001,
    // albedo 0, turbidity 2
    -1.127844e+000,
    -1.851940e-001,
    -6.496970e+000,
    7.351512e+000,
    -6.378118e-002,
    9.538867e-001,
    4.606584e-002,
    4.868063e+000,
    6.162679e-001,
    -1.115260e+000,
    -1.397513e-001,
    2.431157e+000,
    -2.163492e+000,
    -1.310508e-001,
    2.803611e-001,
    1.738991e-001,
    7.771611e+000,
    3.200278e-001,
    -1.182578e+000,
    -3.424004e-001,
    1.898804e+000,
    -5.220263e-002,
    -5.329862e-001,
    2.203174e+000,
    -2.055580e-001,
    -4.434634e+000,
    1.246274e+000,
    -1.006354e+000,
    2.315209e-002,
    -4.027887e-001,
    2.050743e+000,
    7.887711e-002,
    2.873354e-001,
    3.707022e-001,
    8.013765e+000,
    1.537057e-001,
    -1.117719e+000,
    -3.028545e-001,
    2.366872e+000,
    -4.886701e+000,
    -8.757176e+000,
    2.166185e+000,
    -1.535383e-001,
    -1.941920e+000,
    1.010739e+000,
    -1.060553e+000,
    -1.366728e-001,
    1.373356e+000,
    8.615003e+000,
    -3.296709e+000,
    6.869035e-001,
    1.585737e-001,
    2.814554e+000,
    4.999730e-001,
    // albedo 0, turbidity 3
    -1.145867e+000,
    -2.063556e-001,
    -3.371319e+000,
    3.919009e+000,
    -9.941245e-002,
    7.764122e-001,
    6.754442e-002,
    4.788862e+000,
    6.268586e-001,
    -1.173159e+000,
    -2.124279e-001,
    3.760574e-001,
    -1.429755e-001,
    -2.112016e-001,
    3.050346e-001,
    9.863832e-002,
    6.282397e+000,
    5.398708e-001,
    -1.128290e+000,
    -2.626391e-001,
    2.194667e+000,
    -7.709213e-001,
    -6.119947e-001,
    1.954771e+000,
    -2.763244e-002,
    -1.215069e+000,
    9.058582e-001,
    -1.042789e+000,
    1.238998e-002,
    -1.216846e+000,
    2.185858e+000,
    -7.108518e-001,
    -1.752108e-001,
    4.024815e-001,
    7.195042e+000,
    4.858527e-001,
    -1.083423e+000,
    -2.795407e-001,
    2.228564e+000,
    -5.703067e+000,
    -6.565509e+000,
    2.201619e+000,
    -2.378442e-002,
    -1.207242e+000,
    7.791741e-001,
    -1.072807e+000,
    -1.476271e-001,
    1.121297e+000,
    1.170727e+001,
    -3.212988e+000,
    4.039351e-001,
    1.653468e-001,
    2.764731e+000,
    6.679768e-001,
    // albedo 0, turbidity 4
    -1.202159e+000,
    -2.657168e-001,
    -1.549763e+000,
    1.766206e+000,
    -1.244191e-001,
    5.968593e-001,
    9.395497e-002,
    4.184606e+000,
    5.865789e-001,
    -1.259295e+000,
    -3.479955e-001,
    4.106920e-001,
    1.222788e-001,
    -5.466138e-001,
    4.838282e-001,
    1.818745e-002,
    3.942317e+000,
    6.565435e-001,
    -1.148463e+000,
    -1.925468e-001,
    7.987104e-001,
    1.437506e-002,
    4.490084e-001,
    1.123815e+000,
    4.520803e-002,
    2.359736e+000,
    8.262261e-001,
    -9.946770e-001,
    -3.981768e-002,
    -6.623977e-001,
    3.049177e+000,
    -1.194379e+001,
    -2.790911e-002,
    5.146937e-001,
    3.569354e+000,
    5.015922e-001,
    -1.096836e+000,
    -2.420734e-001,
    1.544823e+000,
    3.265699e+000,
    2.313965e+000,
    1.603865e+000,
    -6.142047e-002,
    7.729254e-001,
    7.882909e-001,
    -1.066210e+000,
    -1.621839e-001,
    8.492883e-001,
    -9.614625e-004,
    -4.901333e+000,
    2.691071e-001,
    3.989549e-001,
    2.377191e+000,
    6.746168e-001,
    // albedo 0, turbidity 5
    -1.249234e+000,
    -3.223196e-001,
    -4.169276e-001,
    4.152876e-001,
    -2.643735e-001,
    4.536281e-001,
    1.118540e-001,
    3.742993e+000,
    5.563962e-001,
    -1.477236e+000,
    -6.039504e-001,
    -3.709404e-001,
    1.653829e+000,
    -1.254746e+000,
    4.267709e-001,
    8.407758e-003,
    1.426889e+000,
    6.189487e-001,
    -1.036302e+000,
    6.408172e-003,
    6.626009e-001,
    -2.795223e+000,
    3.628035e+000,
    1.376912e+000,
    -4.052177e-003,
    6.124594e+000,
    9.367069e-001,
    -1.054947e+000,
    -2.220192e-001,
    -5.183406e-001,
    5.832565e+000,
    -1.517185e+001,
    -1.023768e+000,
    6.610279e-001,
    -9.604191e-001,
    3.746561e-001,
    -1.059770e+000,
    -1.598798e-001,
    1.156604e+000,
    5.504008e+000,
    2.639896e+000,
    2.027036e+000,
    -1.188595e-001,
    2.769441e+000,
    8.441893e-001,
    -1.066954e+000,
    -1.591820e-001,
    4.378077e-001,
    4.381013e-001,
    -4.529404e+000,
    -3.408609e-001,
    5.899488e-001,
    2.718708e+000,
    6.626288e-001,
    // albedo 0, turbidity 6
    -1.282503e+000,
    -3.597215e-001,
    -4.357374e-001,
    2.186205e-001,
    -7.695414e-003,
    3.723648e-001,
    1.450857e-001,
    3.598786e+000,
    4.999029e-001,
    -1.677513e+000,
    -7.819585e-001,
    -5.746455e-002,
    1.497760e+000,
    -1.880271e+000,
    5.052217e-001,
    -4.410172e-002,
    6.880726e-001,
    5.762759e-001,
    -9.242956e-001,
    9.859617e-002,
    -6.979734e-002,
    -2.075688e+000,
    4.886555e+000,
    1.209149e+000,
    9.103146e-002,
    6.883053e+000,
    9.858653e-001,
    -1.106027e+000,
    -2.889901e-001,
    2.899608e-002,
    1.943737e+000,
    -1.382068e+001,
    -9.837485e-001,
    5.661283e-001,
    -2.130701e+000,
    3.596144e-001,
    -1.039975e+000,
    -1.361197e-001,
    6.575193e-001,
    1.007420e+001,
    1.239456e+000,
    1.639587e+000,
    -2.223056e-002,
    3.340473e+000,
    8.370969e-001,
    -1.063465e+000,
    -1.585827e-001,
    3.407379e-001,
    3.733980e-004,
    -3.736030e+000,
    -2.444855e-001,
    5.995294e-001,
    2.745402e+000,
    6.736710e-001,
    // albedo 0, turbidity 7
    -1.349146e+000,
    -4.279173e-001,
    -3.704076e-001,
    2.506958e-001,
    -3.090182e-001,
    4.026405e-001,
    1.066844e-001,
    3.360500e+000,
    5.063380e-001,
    -1.962302e+000,
    -1.034138e+000,
    3.720971e-001,
    1.709286e+000,
    -2.876391e+000,
    5.817491e-001,
    -2.144313e-002,
    -1.154946e-001,
    4.127718e-001,
    -9.073025e-001,
    1.470722e-001,
    -9.982355e-001,
    -3.472502e+000,
    7.872135e+000,
    7.071651e-001,
    1.435213e-001,
    7.831410e+000,
    1.157172e+000,
    -1.061896e+000,
    -3.638982e-001,
    8.689320e-001,
    3.497746e+000,
    -1.574771e+001,
    -3.924407e-001,
    4.089772e-001,
    -4.301783e+000,
    2.484018e-001,
    -1.057736e+000,
    -1.116569e-001,
    8.461382e-002,
    8.836720e+000,
    2.163114e+000,
    8.161133e-001,
    1.530343e-001,
    4.203195e+000,
    8.662341e-001,
    -1.056789e+000,
    -1.754950e-001,
    3.150977e-001,
    3.924698e+000,
    -4.024640e+000,
    -1.180417e-001,
    5.296193e-001,
    2.177147e+000,
    6.739805e-001,
    // albedo 0, turbidity 8
    -1.385198e+000,
    -4.836120e-001,
    -4.313890e-001,
    1.432693e+000,
    -1.179648e+000,
    5.276279e-001,
    -1.494770e-006,
    3.271248e+000,
    7.005921e-001,
    -2.245239e+000,
    -1.222675e+000,
    4.339424e-001,
    -5.121342e-001,
    -1.735593e+000,
    3.949228e-001,
    6.677976e-002,
    3.651656e-002,
    -5.258807e-002,
    -1.373149e+000,
    -2.042790e-001,
    -1.870173e+000,
    -2.504224e-001,
    7.890205e+000,
    4.170309e-001,
    2.674580e-001,
    6.955648e+000,
    1.505182e+000,
    -6.867936e-001,
    -2.535060e-001,
    1.784041e+000,
    7.576183e-001,
    -1.277979e+001,
    1.386435e-001,
    9.434597e-002,
    -4.832575e+000,
    8.443270e-002,
    -1.210346e+000,
    -1.761386e-001,
    -4.413342e-001,
    4.129889e+000,
    1.724699e+000,
    2.910549e-001,
    3.630088e-001,
    3.738705e+000,
    9.291792e-001,
    -1.018380e+000,
    -1.941834e-001,
    3.741191e-001,
    1.266532e+001,
    -4.402753e+000,
    -3.598775e-001,
    3.763430e-001,
    1.626840e+000,
    6.556241e-001,
    // albedo 0, turbidity 9
    -1.626869e+000,
    -7.173907e-001,
    -3.798682e-001,
    1.120261e+000,
    -1.071099e+000,
    5.023299e-001,
    -9.709904e-006,
    2.674495e+000,
    9.001083e-001,
    -1.871428e+000,
    -9.394907e-001,
    5.099868e-002,
    2.683007e-001,
    -1.476551e+000,
    3.175986e-001,
    -1.744904e-002,
    1.644280e+000,
    -3.226946e-001,
    -3.455607e+000,
    -1.536630e+000,
    -1.667568e+000,
    -1.629088e+000,
    6.558569e+000,
    5.956033e-001,
    3.865626e-001,
    3.973896e+000,
    1.635164e+000,
    3.604461e-001,
    1.559113e-001,
    1.655168e+000,
    3.364643e+000,
    -1.102010e+001,
    -1.141010e-001,
    -8.472921e-002,
    -2.940627e+000,
    3.363953e-002,
    -1.498568e+000,
    -3.350259e-001,
    -3.755079e-001,
    1.957705e+000,
    1.786009e+000,
    2.160411e-001,
    3.926669e-001,
    2.026350e+000,
    9.400055e-001,
    -9.855412e-001,
    -2.599935e-001,
    3.604751e-001,
    1.028171e+001,
    -4.127248e+000,
    -3.178928e-001,
    2.879654e-001,
    9.738635e-001,
    6.525055e-001,
    // albedo 0, turbidity 10
    -2.070761e+000,
    -1.079568e+000,
    -4.867760e-001,
    7.547083e-001,
    -5.619234e-001,
    4.977983e-001,
    -8.168967e-006,
    2.277442e+000,
    9.001459e-001,
    -1.519884e+000,
    -9.169428e-001,
    -5.160114e-002,
    1.306753e+000,
    -1.539808e+000,
    -3.521859e-002,
    -4.698149e-003,
    1.873860e+000,
    -2.719534e-001,
    -6.289770e+000,
    -2.544356e+000,
    -1.694422e+000,
    -3.347202e+000,
    4.927859e+000,
    1.719878e+000,
    9.606137e-002,
    3.517215e+000,
    1.512846e+000,
    7.475531e-001,
    -2.498047e-001,
    1.291888e+000,
    7.342149e+000,
    -9.824865e+000,
    -1.509627e+000,
    3.335932e-001,
    -1.857758e+000,
    5.583567e-002,
    -1.366797e+000,
    -3.720487e-001,
    3.014721e-002,
    -1.183985e+000,
    1.553468e+000,
    9.345341e-001,
    -4.626046e-002,
    4.444562e-001,
    9.451878e-001,
    -1.060532e+000,
    -3.211716e-001,
    1.825216e-001,
    1.186482e+001,
    -4.013753e+000,
    -4.275148e-001,
    3.618482e-001,
    8.346593e-001,
    6.435607e-001,
    // albedo 1, turbidity 1
    -1.122560e+000,
    -1.867713e-001,
    -7.284839e+000,
    8.584450e+000,
    -5.693778e-002,
    9.362158e-001,
    2.692369e-002,
    4.068359e+000,
    5.234971e-001,
    -1.130342e+000,
    -1.488388e-001,
    3.264588e+000,
    -1.995509e+000,
    -1.492426e-001,
    8.369607e-001,
    2.727079e-002,
    6.712528e+000,
    3.740726e-001,
    -1.138364e+000,
    -3.507366e-001,
    2.261271e+000,
    -4.833015e-001,
    -5.773700e-001,
    1.440950e+000,
    -5.462160e-002,
    -5.808089e+000,
    9.179473e-001,
    -1.063928e+000,
    -7.696008e-002,
    4.268838e-001,
    2.112176e+000,
    1.856380e-001,
    8.503566e-001,
    5.720259e-002,
    6.757620e+000,
    5.023277e-001,
    -1.067939e+000,
    -2.346772e-001,
    2.747610e+000,
    -3.270356e+000,
    -8.113023e+000,
    9.806294e-001,
    -3.916641e-002,
    -1.702584e+000,
    6.846542e-001,
    -1.082536e+000,
    -1.425897e-001,
    1.709232e+000,
    3.831795e+000,
    -2.653753e+000,
    4.959827e-001,
    2.118680e-002,
    3.028188e+000,
    5.043978e-001,
    // albedo 1, turbidity 2
    -1.126269e+000,
    -1.875627e-001,
    -9.108643e+000,
    1.014640e+001,
    -4.391787e-002,
    9.090274e-001,
    4.449178e-002,
    4.391281e+000,
    6.028035e-001,
    -1.127496e+000,
    -1.551502e-001,
    4.715269e+000,
    -4.379706e+000,
    -8.269765e-002,
    2.489861e-001,
    1.442094e-001,
    7.069052e+000,
    3.598938e-001,
    -1.141170e+000,
    -3.140682e-001,
    5.179052e-001,
    2.132957e+000,
    -4.841001e-001,
    2.204568e+000,
    -1.760075e-001,
    -4.451259e+000,
    1.206523e+000,
    -1.035965e+000,
    6.293849e-003,
    5.659447e-001,
    -5.143621e-001,
    5.369244e-001,
    -8.195087e-002,
    3.528337e-001,
    8.424798e+000,
    1.750865e-001,
    -1.091627e+000,
    -2.796151e-001,
    2.659630e+000,
    -1.263693e+000,
    -9.717517e+000,
    1.627322e+000,
    -2.040828e-001,
    -2.264656e+000,
    9.772729e-001,
    -1.077412e+000,
    -1.442798e-001,
    1.678683e+000,
    3.126448e+000,
    -2.800886e+000,
    -2.424284e-001,
    1.570670e-001,
    2.718927e+000,
    5.158362e-001,
    // albedo 1, turbidity 3
    -1.144974e+000,
    -2.099744e-001,
    -5.495776e+000,
    6.366054e+000,
    -6.870550e-002,
    8.375907e-001,
    3.915810e-002,
    4.285339e+000,
    6.686360e-001,
    -1.169933e+000,
    -2.000701e-001,
    2.035938e+000,
    -1.969083e+000,
    -1.124870e-001,
    -2.451380e-002,
    1.383585e-001,
    6.409959e+000,
    4.453202e-001,
    -1.094758e+000,
    -2.678304e-001,
    1.331820e+000,
    6.915180e-001,
    -5.050226e-001,
    2.420188e+000,
    -8.964361e-002,
    -2.419538e+000,
    1.055946e+000,
    -1.080380e+000,
    1.651031e-002,
    -4.283098e-001,
    8.263739e-001,
    3.865362e-001,
    -9.542528e-001,
    4.636693e-001,
    8.320252e+000,
    3.107202e-001,
    -1.056127e+000,
    -2.819465e-001,
    2.856573e+000,
    -3.540458e+000,
    -9.089717e+000,
    2.203092e+000,
    -2.025230e-001,
    -2.321302e+000,
    9.257091e-001,
    -1.098518e+000,
    -1.574456e-001,
    1.550223e+000,
    7.247326e+000,
    -2.901181e+000,
    -5.886912e-001,
    1.804095e-001,
    2.505170e+000,
    5.684315e-001,
    // albedo 1, turbidity 4
    -1.183109e+000,
    -2.545544e-001,
    -2.007016e+000,
    2.549837e+000,
    -1.181365e-001,
    6.307762e-001,
    6.580570e-002,
    3.901844e+000,
    6.209908e-001,
    -1.264646e+000,
    -3.314989e-001,
    1.404638e-001,
    3.018635e-001,
    -2.400209e-001,
    1.473210e-001,
    7.015205e-002,
    4.097388e+000,
    5.769663e-001,
    -1.080296e+000,
    -2.146279e-001,
    1.456416e+000,
    -6.397176e-001,
    -4.732723e-001,
    2.088993e+000,
    -4.981959e-002,
    5.031867e-001,
    9.597067e-001,
    -1.079277e+000,
    -1.317100e-002,
    -7.351039e-001,
    3.197051e+000,
    -4.782960e-001,
    -1.517436e+000,
    6.177859e-001,
    5.445007e+000,
    3.623611e-001,
    -1.048198e+000,
    -2.707068e-001,
    2.675197e+000,
    -6.821649e+000,
    -8.965199e+000,
    2.515919e+000,
    -2.057744e-001,
    -1.046750e+000,
    9.024740e-001,
    -1.112957e+000,
    -1.803464e-001,
    1.458866e+000,
    9.898604e+000,
    -3.212633e+000,
    -8.572122e-001,
    2.424926e-001,
    1.869109e+000,
    5.925894e-001,
    // albedo 1, turbidity 5
    -1.233911e+000,
    -3.146973e-001,
    -7.281383e-002,
    4.316466e-001,
    -5.612729e-001,
    4.051976e-001,
    9.166449e-002,
    3.364808e+000,
    5.726157e-001,
    -1.434503e+000,
    -5.720637e-001,
    9.708922e-002,
    1.764743e+000,
    -2.161767e+000,
    3.475054e-001,
    2.199914e-002,
    1.410369e+000,
    5.718316e-001,
    -1.049991e+000,
    -3.671889e-002,
    3.433843e-001,
    -4.292256e+000,
    6.488567e+000,
    1.246639e+000,
    1.438294e-002,
    4.837743e+000,
    9.914827e-001,
    -1.046749e+000,
    -1.816887e-001,
    1.408762e-001,
    9.618559e+000,
    -1.887011e+001,
    -8.459841e-001,
    5.875286e-001,
    -1.275455e-001,
    3.291886e-001,
    -1.076040e+000,
    -1.847400e-001,
    1.912977e+000,
    -8.895945e-001,
    4.480658e+000,
    1.611137e+000,
    -1.536189e-001,
    2.026193e+000,
    8.712486e-001,
    -1.097129e+000,
    -1.943651e-001,
    1.441787e+000,
    4.887413e-002,
    -5.005112e+000,
    -4.563820e-001,
    3.151678e-001,
    1.346358e+000,
    6.583909e-001,
    // albedo 1, turbidity 6
    -1.265327e+000,
    -3.558025e-001,
    3.794720e-002,
    1.507919e-001,
    -5.946504e-001,
    3.536127e-001,
    1.108696e-001,
    3.072727e+000,
    5.254742e-001,
    -1.620677e+000,
    -7.559149e-001,
    2.340471e-001,
    1.500996e+000,
    -1.938936e+000,
    3.022603e-001,
    1.308512e-002,
    5.849504e-001,
    5.341793e-001,
    -9.462527e-001,
    6.249572e-002,
    -7.831884e-002,
    -3.136776e+000,
    6.576029e+000,
    1.414324e+000,
    -5.873308e-003,
    5.591848e+000,
    1.042876e+000,
    -1.096373e+000,
    -2.438470e-001,
    2.463790e-001,
    5.962756e+000,
    -1.711815e+001,
    -1.310686e+000,
    6.525864e-001,
    -8.812024e-001,
    3.009240e-001,
    -1.053443e+000,
    -1.716323e-001,
    1.772246e+000,
    2.388130e+000,
    3.807974e+000,
    1.813638e+000,
    -1.659431e-001,
    1.967205e+000,
    8.728817e-001,
    -1.102798e+000,
    -1.951265e-001,
    1.327027e+000,
    -9.401178e-004,
    -5.009856e+000,
    -6.317255e-001,
    3.412410e-001,
    1.571016e+000,
    6.673540e-001,
    // albedo 1, turbidity 7
    -1.330500e+000,
    -4.231150e-001,
    -1.068608e-001,
    2.827458e-001,
    -3.785045e-001,
    3.824141e-001,
    9.135970e-002,
    2.901457e+000,
    5.125766e-001,
    -1.940379e+000,
    -1.063034e+000,
    6.492231e-001,
    1.230275e+000,
    -2.130519e+000,
    2.967261e-001,
    4.821081e-002,
    -6.833103e-001,
    3.774557e-001,
    -8.573289e-001,
    2.025530e-001,
    -6.994157e-001,
    -2.968925e+000,
    7.007140e+000,
    1.329283e+000,
    -5.734825e-002,
    7.480587e+000,
    1.243321e+000,
    -1.102287e+000,
    -4.018524e-001,
    7.429609e-001,
    4.722333e+000,
    -1.687320e+001,
    -1.572524e+000,
    6.973253e-001,
    -4.261169e+000,
    1.216731e-001,
    -1.058291e+000,
    -1.027930e-001,
    1.309416e+000,
    4.592136e+000,
    3.085192e+000,
    1.981125e+000,
    -1.601726e-001,
    3.631630e+000,
    9.563230e-001,
    -1.094690e+000,
    -2.067862e-001,
    1.262464e+000,
    4.070348e+000,
    -5.013161e+000,
    -9.788824e-001,
    3.537491e-001,
    1.314169e+000,
    6.469688e-001,
    // albedo 1, turbidity 8
    -1.375612e+000,
    -4.889493e-001,
    -1.417166e-001,
    1.163520e+000,
    -1.116520e+000,
    4.928712e-001,
    1.956521e-003,
    2.763200e+000,
    6.804269e-001,
    -2.267519e+000,
    -1.298078e+000,
    7.745632e-001,
    -5.015223e-001,
    -1.660848e+000,
    1.535069e-001,
    1.130423e-001,
    -7.496776e-001,
    -4.053897e-002,
    -1.236031e+000,
    -9.187821e-002,
    -1.318944e+000,
    6.144653e-002,
    7.388305e+000,
    1.125592e+000,
    4.542271e-002,
    7.169982e+000,
    1.569703e+000,
    -7.519378e-001,
    -3.220611e-001,
    1.392428e+000,
    -2.589985e-001,
    -1.324473e+001,
    -1.152936e+000,
    4.288438e-001,
    -5.699267e+000,
    -4.067798e-002,
    -1.208346e+000,
    -1.425981e-001,
    7.765433e-001,
    6.205521e+000,
    1.702595e+000,
    1.400788e+000,
    2.468299e-002,
    3.893704e+000,
    1.020300e+000,
    -1.053478e+000,
    -2.168461e-001,
    1.250600e+000,
    7.643397e+000,
    -4.744042e+000,
    -9.141689e-001,
    2.850316e-001,
    9.029204e-001,
    6.292947e-001,
    // albedo 1, turbidity 9
    -1.620551e+000,
    -7.427323e-001,
    -5.210549e-002,
    9.933308e-001,
    -1.057605e+000,
    4.611509e-001,
    -9.349274e-006,
    2.089192e+000,
    9.001027e-001,
    -1.844891e+000,
    -9.760485e-001,
    3.543725e-001,
    4.728319e-001,
    -1.580756e+000,
    2.435915e-001,
    -1.409318e-002,
    9.580485e-001,
    -3.325452e-001,
    -3.430583e+000,
    -1.512541e+000,
    -1.245984e+000,
    -2.140067e+000,
    6.427399e+000,
    8.658413e-001,
    3.099217e-001,
    4.118940e+000,
    1.669744e+000,
    4.968310e-001,
    1.799726e-001,
    1.340183e+000,
    4.362702e+000,
    -1.082636e+001,
    -8.136586e-001,
    4.325070e-002,
    -3.656372e+000,
    -2.578467e-002,
    -1.602053e+000,
    -3.344753e-001,
    6.236579e-001,
    6.798366e-002,
    2.141459e+000,
    1.015415e+000,
    2.425099e-001,
    1.969374e+000,
    9.948113e-001,
    -9.807432e-001,
    -2.655611e-001,
    1.228374e+000,
    7.006715e+000,
    -4.377948e+000,
    -8.283411e-001,
    2.025140e-001,
    2.489349e-001,
    6.281313e-001,
    // albedo 1, turbidity 10
    -2.146238e+000,
    -1.161812e+000,
    -1.258356e-001,
    6.271576e-001,
    -6.195391e-001,
    4.771418e-001,
    -7.625158e-006,
    1.727906e+000,
    9.001364e-001,
    -1.439082e+000,
    -8.607455e-001,
    1.926785e-001,
    1.442685e+000,
    -1.820131e+000,
    -1.784270e-001,
    -3.523598e-003,
    1.525974e+000,
    -2.721515e-001,
    -6.424599e+000,
    -2.771926e+000,
    -1.105805e+000,
    -3.658963e+000,
    5.568575e+000,
    2.074430e+000,
    6.949185e-002,
    2.644104e+000,
    1.515459e+000,
    1.136723e+000,
    1.581086e-002,
    7.726540e-001,
    7.125165e+000,
    -1.089511e+001,
    -2.277514e+000,
    3.654301e-001,
    -1.069858e+000,
    4.674865e-002,
    -1.487427e+000,
    -4.592640e-001,
    1.080196e+000,
    8.969814e-001,
    1.738876e+000,
    1.745452e+000,
    -1.035616e-001,
    -8.710686e-001,
    9.434927e-001,
    -1.047963e+000,
    -2.890052e-001,
    8.548304e-001,
    5.870278e+000,
    -3.555375e+000,
    -9.745503e-001,
    2.978797e-001,
    5.572112e-001,
    6.470981e-001,
};

double datasetXYZRad2[] =
{
    // albedo 0, turbidity 1
    1.632341e+000,
    1.395230e+000,
    1.375634e+000,
    1.238193e+001,
    5.921102e+000,
    7.766508e+000,
    // albedo 0, turbidity 2
    1.597115e+000,
    1.554617e+000,
    3.932382e-001,
    1.505284e+001,
    5.725234e+000,
    8.158155e+000,
    // albedo 0, turbidity 3
    1.522034e+000,
    1.844545e+000,
    -1.322862e+000,
    1.918382e+001,
    5.440769e+000,
    8.837119e+000,
    // albedo 0, turbidity 4
    1.403048e+000,
    2.290852e+000,
    -4.013792e+000,
    2.485100e+001,
    5.521888e+000,
    9.845547e+000,
    // albedo 0, turbidity 5
    1.286364e+000,
    2.774498e+000,
    -6.648221e+000,
    2.964151e+001,
    5.923777e+000,
    1.097075e+001,
    // albedo 0, turbidity 6
    1.213544e+000,
    3.040195e+000,
    -8.092676e+000,
    3.186082e+001,
    6.789782e+000,
    1.158899e+001,
    // albedo 0, turbidity 7
    1.122622e+000,
    3.347465e+000,
    -9.649016e+000,
    3.343824e+001,
    9.347715e+000,
    1.231374e+001,
    // albedo 0, turbidity 8
    1.007356e+000,
    3.543858e+000,
    -1.053520e+001,
    3.239842e+001,
    1.483962e+001,
    1.331718e+001,
    // albedo 0, turbidity 9
    8.956642e-001,
    3.278700e+000,
    -9.254933e+000,
    2.557923e+001,
    2.489677e+001,
    1.476166e+001,
    // albedo 0, turbidity 10
    7.985143e-001,
    2.340404e+000,
    -4.928274e+000,
    1.141787e+001,
    3.961501e+001,
    1.682448e+001,
    // albedo 1, turbidity 1
    1.745162e+000,
    1.639467e+000,
    1.342721e+000,
    1.166033e+001,
    1.490124e+001,
    1.774031e+001,
    // albedo 1, turbidity 2
    1.708439e+000,
    1.819144e+000,
    2.834399e-001,
    1.448066e+001,
    1.459214e+001,
    1.858679e+001,
    // albedo 1, turbidity 3
    1.631720e+000,
    2.094799e+000,
    -1.378825e+000,
    1.843198e+001,
    1.463173e+001,
    1.962881e+001,
    // albedo 1, turbidity 4
    1.516536e+000,
    2.438729e+000,
    -3.624121e+000,
    2.298621e+001,
    1.599782e+001,
    2.070027e+001,
    // albedo 1, turbidity 5
    1.405863e+000,
    2.785191e+000,
    -5.705236e+000,
    2.645121e+001,
    1.768330e+001,
    2.191903e+001,
    // albedo 1, turbidity 6
    1.344052e+000,
    2.951807e+000,
    -6.683851e+000,
    2.744271e+001,
    1.985706e+001,
    2.229452e+001,
    // albedo 1, turbidity 7
    1.245827e+000,
    3.182923e+000,
    -7.822960e+000,
    2.791395e+001,
    2.327254e+001,
    2.315910e+001,
    // albedo 1, turbidity 8
    1.132305e+000,
    3.202593e+000,
    -8.008429e+000,
    2.521093e+001,
    3.000014e+001,
    2.405306e+001,
    // albedo 1, turbidity 9
    1.020330e+000,
    2.820556e+000,
    -6.238704e+000,
    1.709276e+001,
    4.077916e+001,
    2.509949e+001,
    // albedo 1, turbidity 10
    9.031570e-001,
    1.863917e+000,
    -1.955738e+000,
    3.032665e+000,
    5.434290e+001,
    2.641780e+001,
};

double datasetXYZ3[] =
{
    // albedo 0, turbidity 1
    -1.311923e+000,
    -4.420946e-001,
    -8.169430e+000,
    8.603081e+000,
    -3.656173e-002,
    5.334341e-001,
    1.131428e-002,
    3.148813e+000,
    4.999443e-001,
    -1.425900e+000,
    -5.483651e-001,
    -1.415015e+000,
    2.146783e+000,
    -8.043229e-002,
    5.425627e-001,
    9.975050e-003,
    2.644691e+000,
    5.134983e-001,
    -1.104434e+000,
    -1.941573e-001,
    2.512201e+000,
    -3.115798e+000,
    -1.126040e-001,
    4.367290e-001,
    -1.563563e-002,
    5.498792e+000,
    4.026744e-001,
    -1.192241e+000,
    -4.461159e-001,
    5.364368e-001,
    1.752711e+000,
    -5.840221e-001,
    1.448393e+000,
    4.104934e-002,
    -3.290029e+000,
    8.329424e-001,
    -1.005569e+000,
    -1.073407e-001,
    1.013678e+000,
    -6.227349e-001,
    7.051855e-001,
    5.083194e-001,
    -6.098026e-002,
    4.521398e+000,
    6.587452e-001,
    -1.074266e+000,
    -1.716883e-001,
    8.668954e-001,
    1.636593e-001,
    -5.004043e+000,
    1.451032e+000,
    9.994832e-002,
    3.366623e+000,
    4.999446e-001,
    // albedo 0, turbidity 2
    -1.331343e+000,
    -4.626388e-001,
    -6.307249e+000,
    6.768076e+000,
    -5.050102e-002,
    5.556632e-001,
    4.154711e-003,
    3.095473e+000,
    5.777587e-001,
    -1.575512e+000,
    -7.237757e-001,
    1.435045e-002,
    9.817771e-001,
    -1.102670e-001,
    5.136914e-001,
    1.589863e-002,
    1.458848e+000,
    2.110762e-001,
    -8.709774e-001,
    6.712326e-002,
    1.025874e+000,
    -2.367003e+000,
    -1.534892e-001,
    4.165219e-001,
    -1.389967e-002,
    7.473495e+000,
    1.183160e+000,
    -1.285041e+000,
    -5.168056e-001,
    8.647941e-001,
    1.697443e+000,
    -7.966946e-001,
    1.255600e+000,
    1.009472e-001,
    -3.547819e+000,
    2.685373e-001,
    -9.893325e-001,
    -9.358679e-002,
    7.784158e-001,
    -8.424513e-001,
    1.158590e-001,
    6.433025e-001,
    -6.673310e-002,
    4.900207e+000,
    8.903340e-001,
    -1.076705e+000,
    -1.803012e-001,
    8.244963e-001,
    3.308528e-001,
    -5.004284e+000,
    1.146369e+000,
    1.569428e-001,
    3.093433e+000,
    5.239688e-001,
    // albedo 0, turbidity 3
    -1.350290e+000,
    -4.790408e-001,
    -4.517876e+000,
    4.891294e+000,
    -6.725949e-002,
    5.455690e-001,
    6.149562e-003,
    3.152205e+000,
    5.394696e-001,
    -1.655424e+000,
    -8.204621e-001,
    6.088012e-001,
    2.904936e-001,
    -1.359413e-001,
    5.348056e-001,
    2.747504e-002,
    1.107356e+000,
    2.848418e-001,
    -7.534462e-001,
    1.666539e-001,
    2.663937e-001,
    -1.394722e+000,
    -2.957352e-001,
    1.222861e-001,
    -5.509974e-002,
    7.396669e+000,
    1.249948e+000,
    -1.306217e+000,
    -4.466262e-001,
    4.861216e-001,
    1.905652e+000,
    -4.342601e-001,
    1.573690e+000,
    1.905697e-001,
    -1.156639e+000,
    2.051970e-001,
    -9.929255e-001,
    -1.443531e-001,
    8.288373e-001,
    -2.899803e+000,
    -5.482674e+000,
    7.645404e-002,
    -5.262534e-003,
    3.757266e+000,
    8.915287e-001,
    -1.083320e+000,
    -1.914411e-001,
    7.360472e-001,
    4.352328e+000,
    -3.948345e+000,
    1.351812e+000,
    1.173133e-001,
    2.894404e+000,
    5.933533e-001,
    // albedo 0, turbidity 4
    -1.373359e+000,
    -5.100483e-001,
    -3.035920e+000,
    3.410141e+000,
    -9.475680e-002,
    4.972709e-001,
    8.474823e-003,
    3.014611e+000,
    5.101253e-001,
    -1.840089e+000,
    -9.808414e-001,
    6.389071e-001,
    1.670466e-001,
    -1.892240e-001,
    4.957643e-001,
    1.620440e-002,
    9.834855e-001,
    4.000785e-001,
    -6.545397e-001,
    1.777136e-001,
    -1.099117e-001,
    -1.847870e-001,
    -5.023871e-001,
    3.344301e-001,
    -6.844147e-002,
    6.283258e+000,
    1.105627e+000,
    -1.301323e+000,
    -3.176140e-001,
    6.899908e-002,
    -6.740028e-001,
    -2.433178e-001,
    9.532386e-001,
    2.651912e-001,
    1.379661e+000,
    3.871516e-001,
    -1.000550e+000,
    -2.368704e-001,
    8.775262e-001,
    2.465288e+000,
    -1.033745e+001,
    3.289527e-001,
    2.609158e-002,
    2.174201e+000,
    7.431234e-001,
    -1.106614e+000,
    -2.268137e-001,
    6.648954e-001,
    8.387987e-001,
    -1.988302e+000,
    9.933450e-001,
    1.593414e-001,
    2.348160e+000,
    6.769252e-001,
    // albedo 0, turbidity 5
    -1.451696e+000,
    -5.853583e-001,
    -2.497901e+000,
    2.827985e+000,
    -1.021331e-001,
    4.463691e-001,
    1.084608e-002,
    2.835558e+000,
    5.003869e-001,
    -1.883081e+000,
    -1.028176e+000,
    1.581680e+000,
    -1.304327e+000,
    -2.564236e-001,
    5.796271e-001,
    4.007285e-002,
    1.172596e+000,
    4.706046e-001,
    -8.035865e-001,
    1.421772e-002,
    -1.224161e+000,
    3.345479e+000,
    -7.813967e-002,
    -8.050640e-002,
    -1.982001e-001,
    5.280989e+000,
    1.054024e+000,
    -1.107224e+000,
    -1.301251e-001,
    4.867687e-001,
    -4.658775e+000,
    -8.328992e+000,
    1.361131e+000,
    4.849450e-001,
    2.170392e+000,
    3.667606e-001,
    -1.113334e+000,
    -3.526105e-001,
    5.749731e-001,
    9.773812e+000,
    -1.239127e+000,
    -3.277264e-001,
    -1.014342e-001,
    1.580013e+000,
    7.824388e-001,
    -1.071143e+000,
    -2.129741e-001,
    6.020045e-001,
    -1.748395e-003,
    -3.513440e+000,
    1.059400e+000,
    1.898121e-001,
    2.314911e+000,
    6.921088e-001,
    // albedo 0, turbidity 6
    -1.475703e+000,
    -6.237015e-001,
    -2.749410e+000,
    3.112425e+000,
    -9.831048e-002,
    4.894251e-001,
    1.521580e-003,
    2.715999e+000,
    5.201523e-001,
    -2.100321e+000,
    -1.174167e+000,
    1.818536e+000,
    -1.632282e+000,
    -2.256515e-001,
    5.442182e-001,
    4.667242e-002,
    1.098893e+000,
    3.542554e-001,
    -5.872691e-001,
    1.048408e-001,
    -1.322698e+000,
    3.855267e+000,
    -1.510738e-001,
    -7.510066e-002,
    -2.257035e-001,
    5.023763e+000,
    1.139194e+000,
    -1.255591e+000,
    -1.705970e-001,
    1.952178e-001,
    -6.471877e+000,
    -7.282488e+000,
    1.318755e+000,
    5.794824e-001,
    2.702002e+000,
    3.044574e-001,
    -1.036212e+000,
    -3.362857e-001,
    6.347813e-001,
    1.135449e+001,
    -8.304800e-001,
    -5.115048e-001,
    -1.538398e-001,
    1.193773e+000,
    8.388729e-001,
    -1.102778e+000,
    -2.400200e-001,
    4.563094e-001,
    -2.006959e-003,
    -3.545664e+000,
    1.049779e+000,
    2.181642e-001,
    2.309295e+000,
    6.821730e-001,
    // albedo 0, turbidity 7
    -1.547119e+000,
    -6.878769e-001,
    -3.474134e+000,
    3.780752e+000,
    -7.222916e-002,
    4.497653e-001,
    -9.942893e-007,
    2.658279e+000,
    5.166479e-001,
    -2.064688e+000,
    -1.170843e+000,
    2.387757e+000,
    -2.247282e+000,
    -1.621700e-001,
    5.119173e-001,
    5.916637e-002,
    1.132862e+000,
    3.723492e-001,
    -9.683933e-001,
    -2.163294e-001,
    -1.718709e+000,
    3.989236e+000,
    -7.429089e-002,
    2.326181e-001,
    -2.663329e-001,
    4.621950e+000,
    1.103966e+000,
    -8.971102e-001,
    8.407615e-002,
    3.351711e-001,
    -6.203079e+000,
    -6.058039e+000,
    6.643912e-001,
    6.099169e-001,
    2.266145e+000,
    3.435052e-001,
    -1.198605e+000,
    -4.520034e-001,
    4.406591e-001,
    1.111553e+001,
    -1.656558e+000,
    -9.574737e-002,
    -1.101472e-001,
    1.293671e+000,
    8.114554e-001,
    -1.082596e+000,
    -2.777275e-001,
    4.456148e-001,
    6.461220e-001,
    -2.896663e+000,
    5.483857e-001,
    2.030919e-001,
    1.751151e+000,
    6.915445e-001,
    // albedo 0, turbidity 8
    -1.699071e+000,
    -8.369651e-001,
    -4.302118e+000,
    4.563275e+000,
    -4.782656e-002,
    4.112071e-001,
    -1.875341e-006,
    2.391982e+000,
    5.671202e-001,
    -2.186280e+000,
    -1.202582e+000,
    3.096100e+000,
    -2.995395e+000,
    -1.161222e-001,
    3.090526e-001,
    6.630234e-002,
    1.424558e+000,
    2.245622e-001,
    -1.432669e+000,
    -7.176766e-001,
    -2.159943e+000,
    4.049232e+000,
    6.359410e-002,
    8.158442e-001,
    -2.893589e-001,
    3.921175e+000,
    1.227506e+000,
    -5.760128e-001,
    3.360415e-001,
    5.730331e-001,
    -6.006552e+000,
    -5.478045e+000,
    -3.053844e-001,
    6.440897e-001,
    1.475392e+000,
    2.409042e-001,
    -1.311586e+000,
    -5.935514e-001,
    3.333142e-001,
    1.074315e+001,
    -1.239073e+000,
    5.249596e-001,
    -1.483990e-001,
    8.988813e-001,
    8.815195e-001,
    -1.089623e+000,
    -3.240738e-001,
    3.666377e-001,
    1.614812e+000,
    -3.038524e+000,
    4.269864e-002,
    2.295652e-001,
    1.480116e+000,
    6.683401e-001,
    // albedo 0, turbidity 9
    -2.103629e+000,
    -1.133010e+000,
    -4.589880e+000,
    4.749434e+000,
    -3.514864e-002,
    3.944012e-001,
    -2.897919e-006,
    2.183138e+000,
    6.470902e-001,
    -1.636555e+000,
    -8.262274e-001,
    3.362066e+000,
    -3.091558e+000,
    -1.334489e-001,
    2.130859e-001,
    4.662434e-002,
    1.930316e+000,
    6.371465e-002,
    -3.513249e+000,
    -2.169761e+000,
    -2.449805e+000,
    2.997402e+000,
    2.290624e-001,
    8.841762e-001,
    -2.046039e-001,
    2.988609e+000,
    1.334562e+000,
    6.296566e-001,
    9.710056e-001,
    9.098177e-001,
    -4.074528e+000,
    -5.125432e+000,
    -2.817885e-001,
    4.510908e-001,
    7.468441e-001,
    2.175629e-001,
    -1.728975e+000,
    -8.958048e-001,
    1.420920e-001,
    1.148488e+001,
    -1.711523e+000,
    1.005741e-001,
    -4.183049e-002,
    5.930458e-001,
    8.551078e-001,
    -1.002974e+000,
    -3.191890e-001,
    3.081733e-001,
    6.950179e-001,
    -2.558217e+000,
    2.403600e-001,
    2.123061e-001,
    1.222185e+000,
    6.830278e-001,
    // albedo 0, turbidity 10
    -2.775910e+000,
    -1.580504e+000,
    -3.982741e+000,
    4.084312e+000,
    -3.032610e-002,
    3.048632e-001,
    -4.150864e-006,
    1.965490e+000,
    7.195224e-001,
    -1.130328e+000,
    -7.703243e-001,
    2.804163e+000,
    -2.462833e+000,
    -1.506538e-001,
    1.788338e-001,
    4.858783e-002,
    1.825632e+000,
    -3.406155e-002,
    -6.494695e+000,
    -3.312918e+000,
    -2.235912e+000,
    1.844379e+000,
    3.120145e-001,
    6.719815e-001,
    -1.968188e-001,
    3.151430e+000,
    1.340512e+000,
    1.262171e+000,
    6.332491e-001,
    6.622832e-001,
    -2.567448e+000,
    -4.326943e+000,
    2.382218e-001,
    4.141218e-001,
    1.625112e-001,
    2.557293e-001,
    -1.636032e+000,
    -8.632767e-001,
    3.636136e-001,
    1.177953e+001,
    -2.213858e+000,
    -5.976279e-001,
    -1.408629e-001,
    -4.620223e-002,
    8.275634e-001,
    -1.036198e+000,
    -3.066957e-001,
    6.700814e-002,
    -2.653253e-003,
    -2.225753e+000,
    6.332585e-001,
    3.173480e-001,
    1.299875e+000,
    6.757278e-001,
    // albedo 1, turbidity 1
    -1.278940e+000,
    -4.266174e-001,
    -1.228375e+001,
    1.294317e+001,
    -2.299609e-002,
    5.011313e-001,
    1.251976e-002,
    2.717326e+000,
    4.999423e-001,
    -1.453809e+000,
    -5.904580e-001,
    2.993357e+000,
    -2.029652e+000,
    -5.128942e-002,
    3.022675e-001,
    2.935432e-002,
    1.721866e+000,
    4.997052e-001,
    -1.021042e+000,
    -1.656393e-001,
    2.412666e-001,
    -7.836922e-001,
    -1.105161e-001,
    7.485671e-001,
    -4.512634e-002,
    5.672624e+000,
    5.093103e-001,
    -1.157132e+000,
    -3.643864e-001,
    1.765675e+000,
    8.816821e-001,
    -4.196220e-001,
    8.383708e-001,
    7.580612e-002,
    -3.962887e+000,
    4.265701e-001,
    -1.002671e+000,
    -7.839634e-002,
    8.355346e-001,
    -4.666433e-001,
    -5.509246e-001,
    4.467438e-001,
    -6.575067e-002,
    6.119253e+000,
    8.000380e-001,
    -1.078243e+000,
    -1.729199e-001,
    1.201144e+000,
    1.791157e-001,
    -5.003054e+000,
    5.360235e-001,
    7.971645e-002,
    3.045835e+000,
    4.999439e-001,
    // albedo 1, turbidity 2
    -1.315303e+000,
    -4.636986e-001,
    -8.466080e+000,
    9.044328e+000,
    -2.853529e-002,
    4.313188e-001,
    1.962432e-002,
    2.633336e+000,
    5.353835e-001,
    -1.479471e+000,
    -6.406954e-001,
    1.728219e+000,
    -5.302401e-001,
    -7.863244e-002,
    5.227959e-001,
    -4.586755e-003,
    1.379805e+000,
    3.264602e-001,
    -9.582215e-001,
    -6.313224e-002,
    4.854007e-001,
    -1.439365e+000,
    -1.342587e-001,
    2.842506e-001,
    8.612291e-003,
    6.390932e+000,
    1.026736e+000,
    -1.165762e+000,
    -3.814742e-001,
    1.421868e+000,
    1.154289e+000,
    -6.358385e-001,
    1.158881e+000,
    7.806966e-002,
    -3.714336e+000,
    3.794153e-001,
    -1.014932e+000,
    -8.036599e-002,
    8.742564e-001,
    -5.371503e-001,
    -2.856454e-001,
    3.015705e-001,
    -5.686869e-002,
    6.161772e+000,
    8.320741e-001,
    -1.071824e+000,
    -1.735566e-001,
    1.149012e+000,
    1.861431e-001,
    -5.002113e+000,
    3.922780e-001,
    1.190513e-001,
    2.923168e+000,
    5.122730e-001,
    // albedo 1, turbidity 3
    -1.325331e+000,
    -4.754813e-001,
    -6.033306e+000,
    6.615826e+000,
    -4.267738e-002,
    4.715527e-001,
    7.356658e-003,
    2.657604e+000,
    5.593516e-001,
    -1.624168e+000,
    -8.094413e-001,
    1.735621e+000,
    -6.349372e-001,
    -9.190028e-002,
    3.486032e-001,
    4.425003e-002,
    7.201142e-001,
    2.047539e-001,
    -7.257071e-001,
    1.644689e-001,
    -1.510487e-001,
    -8.475109e-001,
    -2.034120e-001,
    5.120845e-001,
    -1.002207e-001,
    6.856461e+000,
    1.437903e+000,
    -1.326388e+000,
    -4.608714e-001,
    1.225048e+000,
    1.574334e+000,
    -4.153937e-001,
    9.045299e-001,
    2.450295e-001,
    -1.920805e+000,
    -3.631514e-002,
    -9.472762e-001,
    -8.323122e-002,
    1.014659e+000,
    -2.622357e+000,
    -3.423191e+000,
    1.800171e-001,
    -9.037380e-002,
    4.505349e+000,
    1.094025e+000,
    -1.097733e+000,
    -1.963134e-001,
    1.161840e+000,
    3.934834e+000,
    -5.006972e+000,
    5.610079e-001,
    9.329206e-002,
    2.583319e+000,
    4.999523e-001,
    // albedo 1, turbidity 4
    -1.355403e+000,
    -5.136901e-001,
    -3.696899e+000,
    4.222481e+000,
    -5.704934e-002,
    3.973927e-001,
    1.259397e-002,
    2.530585e+000,
    5.263023e-001,
    -1.746849e+000,
    -9.649995e-001,
    8.656144e-001,
    3.641398e-001,
    -1.365494e-001,
    5.204632e-001,
    2.735494e-002,
    2.760030e-001,
    3.182992e-001,
    -6.762754e-001,
    2.386872e-001,
    8.193443e-002,
    -1.133049e+000,
    -2.511972e-001,
    2.780978e-001,
    -1.093057e-001,
    6.855664e+000,
    1.277554e+000,
    -1.307902e+000,
    -4.481797e-001,
    5.992967e-001,
    1.614591e+000,
    -6.953518e-001,
    8.016022e-001,
    3.345227e-001,
    -9.625139e-001,
    1.453430e-001,
    -9.701277e-001,
    -1.196233e-001,
    1.240762e+000,
    -2.503113e+000,
    -3.737611e+000,
    1.767628e-001,
    -8.451349e-002,
    3.450018e+000,
    9.516901e-001,
    -1.091208e+000,
    -1.919448e-001,
    9.970899e-001,
    3.547271e+000,
    -4.316127e+000,
    4.964828e-001,
    1.239080e-001,
    2.758200e+000,
    6.012727e-001,
    // albedo 1, turbidity 5
    -1.392042e+000,
    -5.575947e-001,
    -2.440232e+000,
    2.956014e+000,
    -8.986509e-002,
    4.636909e-001,
    4.420796e-003,
    2.450873e+000,
    5.570194e-001,
    -1.962890e+000,
    -1.140585e+000,
    1.099430e+000,
    -2.318459e-002,
    -1.972708e-001,
    2.739908e-001,
    5.533978e-002,
    1.887117e-001,
    2.177241e-001,
    -5.394115e-001,
    2.840382e-001,
    -3.843093e-001,
    -3.897694e-001,
    -1.672655e-001,
    6.238184e-001,
    -1.837388e-001,
    6.300017e+000,
    1.386991e+000,
    -1.390312e+000,
    -4.665212e-001,
    5.156231e-001,
    1.956683e+000,
    -2.214404e+000,
    2.844387e-001,
    4.497786e-001,
    -5.695916e-001,
    5.349458e-002,
    -9.144996e-001,
    -1.047427e-001,
    1.196243e+000,
    -4.722503e+000,
    -3.886737e+000,
    3.538877e-001,
    -7.877224e-002,
    3.277217e+000,
    1.016030e+000,
    -1.125369e+000,
    -2.452027e-001,
    1.056347e+000,
    8.161847e+000,
    -4.012722e+000,
    3.060583e-001,
    1.023547e-001,
    1.801131e+000,
    5.681416e-001,
    // albedo 1, turbidity 6
    -1.416290e+000,
    -5.883638e-001,
    -2.436976e+000,
    2.991610e+000,
    -9.136861e-002,
    4.307146e-001,
    -6.721427e-007,
    2.370332e+000,
    5.544841e-001,
    -2.037101e+000,
    -1.235817e+000,
    2.236703e+000,
    -1.594808e+000,
    -2.248579e-001,
    4.034530e-001,
    6.024653e-002,
    1.311279e-001,
    2.307834e-001,
    -6.097273e-001,
    2.191464e-001,
    -1.458366e+000,
    3.027007e+000,
    8.866025e-002,
    2.177533e-001,
    -2.295036e-001,
    5.607941e+000,
    1.339167e+000,
    -1.246069e+000,
    -3.226724e-001,
    8.352043e-001,
    -4.086373e+000,
    -7.338584e+000,
    7.432202e-001,
    5.382667e-001,
    7.277976e-001,
    1.397724e-001,
    -1.020494e+000,
    -2.266359e-001,
    1.087041e+000,
    7.243507e+000,
    -1.731288e+000,
    -2.102982e-001,
    -1.659150e-001,
    2.018953e+000,
    9.043156e-001,
    -1.082932e+000,
    -2.014105e-001,
    9.848057e-001,
    1.956538e+000,
    -3.938998e+000,
    5.549628e-001,
    1.497541e-001,
    2.283782e+000,
    6.539416e-001,
    // albedo 1, turbidity 7
    -1.455084e+000,
    -6.377470e-001,
    -3.055923e+000,
    3.530353e+000,
    -6.727751e-002,
    4.008162e-001,
    -7.809273e-007,
    2.336483e+000,
    5.628496e-001,
    -2.233617e+000,
    -1.384213e+000,
    2.849320e+000,
    -2.393827e+000,
    -1.520239e-001,
    3.484156e-001,
    6.870818e-002,
    1.492427e-001,
    2.172794e-001,
    -5.769722e-001,
    1.377662e-001,
    -1.834277e+000,
    4.177085e+000,
    9.006938e-002,
    5.023814e-001,
    -2.794397e-001,
    4.937314e+000,
    1.315932e+000,
    -1.254037e+000,
    -2.558145e-001,
    8.004970e-001,
    -6.216810e+000,
    -7.023296e+000,
    2.189299e-001,
    6.137482e-001,
    9.907592e-001,
    1.832353e-001,
    -9.955974e-001,
    -2.589351e-001,
    1.038884e+000,
    1.120433e+001,
    -1.786257e+000,
    2.272482e-002,
    -1.909673e-001,
    1.671990e+000,
    8.631125e-001,
    -1.110414e+000,
    -2.586778e-001,
    1.045794e+000,
    1.124401e+000,
    -3.840677e+000,
    3.735077e-001,
    1.505152e-001,
    1.454710e+000,
    6.730319e-001,
    // albedo 1, turbidity 8
    -1.635667e+000,
    -8.131119e-001,
    -4.171589e+000,
    4.641219e+000,
    -4.350771e-002,
    3.723945e-001,
    -2.049113e-006,
    2.010867e+000,
    5.934344e-001,
    -2.214366e+000,
    -1.311520e+000,
    3.793380e+000,
    -3.350188e+000,
    -1.226524e-001,
    3.356594e-001,
    5.776804e-002,
    6.983348e-001,
    1.530268e-001,
    -1.239997e+000,
    -5.244225e-001,
    -2.461632e+000,
    4.197270e+000,
    2.199133e-001,
    5.825686e-001,
    -2.527450e-001,
    3.975459e+000,
    1.324194e+000,
    -7.336475e-001,
    1.334895e-001,
    1.118725e+000,
    -5.738109e+000,
    -5.950312e+000,
    4.215443e-003,
    5.663922e-001,
    4.087404e-001,
    1.894813e-001,
    -1.217950e+000,
    -4.638698e-001,
    8.432382e-001,
    1.095769e+001,
    -1.561150e+000,
    1.225719e-003,
    -1.482825e-001,
    1.228810e+000,
    8.733385e-001,
    -1.060230e+000,
    -2.655999e-001,
    1.051311e+000,
    3.715708e-001,
    -3.685457e+000,
    3.614902e-001,
    1.514342e-001,
    1.033589e+000,
    6.741195e-001,
    // albedo 1, turbidity 9
    -1.964667e+000,
    -1.110762e+000,
    -3.976656e+000,
    4.403654e+000,
    -3.780277e-002,
    3.443986e-001,
    -3.233346e-006,
    1.722715e+000,
    7.127703e-001,
    -2.077601e+000,
    -1.135454e+000,
    3.496127e+000,
    -2.951249e+000,
    -1.431638e-001,
    2.312402e-001,
    4.836856e-002,
    1.155030e+000,
    -5.791263e-002,
    -2.740695e+000,
    -1.711055e+000,
    -2.097533e+000,
    2.851130e+000,
    3.088396e-001,
    7.702220e-001,
    -2.113389e-001,
    3.076191e+000,
    1.466423e+000,
    8.929964e-002,
    5.542300e-001,
    8.631582e-001,
    -3.981243e+000,
    -5.607647e+000,
    -2.920111e-001,
    4.720100e-001,
    -1.119004e-001,
    1.195876e-001,
    -1.420061e+000,
    -6.359551e-001,
    9.080369e-001,
    1.134709e+001,
    -1.565058e+000,
    9.662359e-002,
    -1.172665e-001,
    5.789787e-001,
    8.948043e-001,
    -1.046449e+000,
    -3.101057e-001,
    9.485704e-001,
    5.593907e-001,
    -3.376759e+000,
    1.950279e-001,
    1.618748e-001,
    7.358054e-001,
    6.676193e-001,
    // albedo 1, turbidity 10
    -2.805943e+000,
    -1.616668e+000,
    -4.191956e+000,
    4.465920e+000,
    -2.542722e-002,
    3.304580e-001,
    -4.335373e-006,
    1.619409e+000,
    7.598093e-001,
    -1.725471e+000,
    -1.157190e+000,
    3.580220e+000,
    -2.891528e+000,
    -1.188402e-001,
    1.289080e-001,
    4.081220e-002,
    1.063422e+000,
    -7.171288e-002,
    -5.635358e+000,
    -2.815327e+000,
    -2.322135e+000,
    2.161998e+000,
    2.108986e-001,
    6.224373e-001,
    -1.805553e-001,
    3.008028e+000,
    1.312112e+000,
    9.479154e-001,
    1.989261e-001,
    6.850003e-001,
    -2.704175e+000,
    -3.438381e+000,
    2.878602e-001,
    4.182057e-001,
    1.197714e-001,
    3.238870e-001,
    -1.433670e+000,
    -6.003251e-001,
    1.164103e+000,
    1.018706e+001,
    -2.896680e+000,
    -6.517243e-001,
    -1.962824e-001,
    -1.268030e+000,
    7.794479e-001,
    -1.009540e+000,
    -1.798109e-001,
    4.961939e-001,
    -2.284225e-003,
    -2.469327e+000,
    6.503337e-001,
    3.226878e-001,
    1.913340e+000,
    6.786333e-001,
};

double datasetXYZRad3[] =
{
    // albedo 0, turbidity 1
    1.168084e+000,
    2.156455e+000,
    -3.980314e+000,
    1.989302e+001,
    1.328335e+001,
    1.435621e+001,
    // albedo 0, turbidity 2
    1.135488e+000,
    2.294701e+000,
    -4.585886e+000,
    2.090208e+001,
    1.347840e+001,
    1.467658e+001,
    // albedo 0, turbidity 3
    1.107408e+000,
    2.382765e+000,
    -5.112357e+000,
    2.147823e+001,
    1.493128e+001,
    1.460882e+001,
    // albedo 0, turbidity 4
    1.054193e+000,
    2.592891e+000,
    -6.115000e+000,
    2.268967e+001,
    1.635672e+001,
    1.518999e+001,
    // albedo 0, turbidity 5
    1.006946e+000,
    2.705420e+000,
    -6.698930e+000,
    2.291830e+001,
    1.834324e+001,
    1.570651e+001,
    // albedo 0, turbidity 6
    9.794044e-001,
    2.742440e+000,
    -6.805283e+000,
    2.225271e+001,
    2.050797e+001,
    1.563130e+001,
    // albedo 0, turbidity 7
    9.413577e-001,
    2.722009e+000,
    -6.760707e+000,
    2.098242e+001,
    2.342588e+001,
    1.605011e+001,
    // albedo 0, turbidity 8
    8.917923e-001,
    2.592780e+000,
    -6.152635e+000,
    1.774141e+001,
    2.858324e+001,
    1.657910e+001,
    // albedo 0, turbidity 9
    8.288391e-001,
    2.153434e+000,
    -4.118327e+000,
    1.078118e+001,
    3.681710e+001,
    1.738139e+001,
    // albedo 0, turbidity 10
    7.623528e-001,
    1.418187e+000,
    -8.845235e-001,
    7.590129e-001,
    4.629859e+001,
    1.921657e+001,
    // albedo 1, turbidity 1
    1.352858e+000,
    2.048862e+000,
    -2.053393e+000,
    1.405874e+001,
    3.045344e+001,
    3.044430e+001,
    // albedo 1, turbidity 2
    1.330497e+000,
    2.126497e+000,
    -2.466296e+000,
    1.467559e+001,
    3.090738e+001,
    3.069707e+001,
    // albedo 1, turbidity 3
    1.286344e+000,
    2.200436e+000,
    -2.877228e+000,
    1.492701e+001,
    3.236288e+001,
    3.077223e+001,
    // albedo 1, turbidity 4
    1.234428e+000,
    2.289628e+000,
    -3.404699e+000,
    1.499436e+001,
    3.468390e+001,
    3.084842e+001,
    // albedo 1, turbidity 5
    1.178660e+000,
    2.306071e+000,
    -3.549159e+000,
    1.411006e+001,
    3.754188e+001,
    3.079730e+001,
    // albedo 1, turbidity 6
    1.151366e+000,
    2.333005e+000,
    -3.728627e+000,
    1.363374e+001,
    3.905894e+001,
    3.092599e+001,
    // albedo 1, turbidity 7
    1.101593e+000,
    2.299422e+000,
    -3.565787e+000,
    1.196745e+001,
    4.188472e+001,
    3.102755e+001,
    // albedo 1, turbidity 8
    1.038322e+000,
    2.083539e+000,
    -2.649585e+000,
    8.037389e+000,
    4.700869e+001,
    3.065948e+001,
    // albedo 1, turbidity 9
    9.596146e-001,
    1.671470e+000,
    -8.751538e-001,
    1.679772e+000,
    5.345784e+001,
    3.054520e+001,
    // albedo 1, turbidity 10
    8.640731e-001,
    9.858301e-001,
    1.854956e+000,
    -6.798097e+000,
    5.936468e+001,
    3.110255e+001,
};

double* datasetsXYZ[] =
{
    datasetXYZ1,
    datasetXYZ2,
    datasetXYZ3
};

double* datasetsXYZRad[] =
{
    datasetXYZRad1,
    datasetXYZRad2,
    datasetXYZRad3
};

double datasetRGB1[] =
{
    // albedo 0, turbidity 1
    -1.099459e+000,
    -1.335146e-001,
    -4.083223e+000,
    5.919603e+000,
    -1.104166e-001,
    1.600158e+000,
    -1.326538e-006,
    4.917807e+000,
    5.127716e-001,
    -1.169858e+000,
    -1.832793e-001,
    9.694744e-001,
    9.495762e-002,
    -4.738918e-002,
    2.194171e-001,
    1.095749e-001,
    3.603604e+000,
    3.815119e-001,
    -9.665225e-001,
    -1.403888e-001,
    5.194457e+000,
    -1.107607e+000,
    -8.135181e-001,
    4.969661e+000,
    -2.300508e-001,
    -2.489350e+000,
    1.279158e+000,
    -1.292508e+000,
    -1.299552e-001,
    -2.071404e+000,
    -4.752482e-002,
    1.215598e+000,
    -1.904179e+000,
    3.027985e-001,
    8.707768e+000,
    6.332446e-002,
    -9.264666e-001,
    -1.696780e-001,
    4.574070e+000,
    -4.232936e-001,
    -7.575833e+000,
    5.079755e+000,
    -2.576343e-001,
    -4.506805e+000,
    6.908129e-001,
    -1.139072e+000,
    -1.796056e-001,
    1.923311e+000,
    6.788529e+000,
    -2.364389e+000,
    -1.064041e+000,
    1.717010e-001,
    1.534681e+000,
    5.015810e-001,
    // albedo 0, turbidity 2
    -1.107257e+000,
    -1.384411e-001,
    -4.285744e+000,
    5.713157e+000,
    -1.015992e-001,
    1.372638e+000,
    6.555893e-002,
    5.127514e+000,
    6.550471e-001,
    -1.187337e+000,
    -1.969013e-001,
    8.551048e-001,
    5.289708e-002,
    -7.626406e-002,
    1.733153e-002,
    1.779454e-001,
    3.801038e+000,
    4.742709e-001,
    -9.685321e-001,
    -1.553308e-001,
    4.732492e+000,
    -1.178935e+000,
    -7.852791e-001,
    4.604492e+000,
    -2.666518e-001,
    -2.367663e+000,
    1.177527e+000,
    -1.252817e+000,
    -5.129949e-002,
    -2.800433e+000,
    -1.295992e-002,
    1.308964e+000,
    -2.204331e+000,
    7.276011e-001,
    8.699265e+000,
    1.188388e-001,
    -9.459509e-001,
    -2.322133e-001,
    4.375041e+000,
    -1.712018e-001,
    -7.451681e+000,
    5.078019e+000,
    -4.223538e-001,
    -4.595561e+000,
    1.074719e+000,
    -1.125092e+000,
    -1.796750e-001,
    1.626399e+000,
    6.989743e+000,
    -2.406382e+000,
    -9.060383e-001,
    2.961611e-001,
    1.337715e+000,
    5.438140e-001,
    // albedo 0, turbidity 3
    -1.135338e+000,
    -1.716160e-001,
    -1.499253e+000,
    2.373491e+000,
    -1.654023e-001,
    9.566404e-001,
    1.113453e-001,
    4.528473e+000,
    6.579439e-001,
    -1.132780e+000,
    -1.456214e-001,
    -1.736672e+000,
    1.756589e+000,
    -1.087003e-001,
    3.757927e-001,
    2.525070e-001,
    7.178513e+000,
    5.003814e-001,
    -1.167176e+000,
    -2.927225e-001,
    5.727667e+000,
    -3.139244e+000,
    -6.425204e-001,
    2.822634e+000,
    -1.457812e-001,
    -6.787080e+000,
    1.017072e+000,
    -1.042529e+000,
    4.110823e-002,
    -4.000629e+000,
    4.362364e+000,
    1.090540e+000,
    -1.338674e+000,
    8.246964e-001,
    1.095249e+001,
    2.912211e-001,
    -1.061598e+000,
    -2.096143e-001,
    3.803155e+000,
    -7.977069e+000,
    -3.637880e+000,
    3.707671e+000,
    -1.903128e-001,
    -3.397953e+000,
    9.971500e-001,
    -1.073560e+000,
    -2.077964e-001,
    1.492052e+000,
    1.626322e+001,
    -5.015304e+000,
    -4.059889e-001,
    2.659782e-001,
    6.395380e-001,
    5.634436e-001,
    // albedo 0, turbidity 4
    -1.172794e+000,
    -2.111186e-001,
    -1.360013e+000,
    1.604080e+000,
    -8.473723e-002,
    7.217312e-001,
    1.548030e-001,
    4.257010e+000,
    6.328974e-001,
    -1.238374e+000,
    -2.670827e-001,
    3.247678e-001,
    5.466311e-001,
    -7.425952e-001,
    5.276440e-001,
    2.678026e-002,
    5.484169e+000,
    6.814734e-001,
    -1.176923e+000,
    -2.574586e-001,
    2.304045e+000,
    -2.797678e+000,
    1.464405e+000,
    1.998552e+000,
    2.550559e-001,
    -4.199772e+000,
    7.544892e-001,
    -1.003284e+000,
    1.943984e-002,
    -2.145066e+000,
    1.030924e+001,
    -1.525413e+001,
    -2.023010e+000,
    5.448699e-001,
    8.159497e+000,
    5.539148e-001,
    -1.060017e+000,
    -2.037206e-001,
    2.483018e+000,
    -4.595459e+000,
    6.526991e+000,
    4.031804e+000,
    1.206513e-001,
    -2.586527e+000,
    7.875752e-001,
    -1.081141e+000,
    -2.123302e-001,
    1.092275e+000,
    2.683841e+000,
    -4.166938e+000,
    -1.396582e+000,
    4.371205e-001,
    1.030233e+000,
    6.664862e-001,
    // albedo 0, turbidity 5
    -1.222392e+000,
    -2.651924e-001,
    -4.625037e-001,
    3.521964e-001,
    2.148855e-002,
    5.078494e-001,
    1.791590e-001,
    3.852516e+000,
    5.998216e-001,
    -1.424610e+000,
    -4.710155e-001,
    -1.826815e-001,
    1.786277e+000,
    -1.952442e+000,
    5.277612e-001,
    -1.773629e-002,
    2.415874e+000,
    6.701272e-001,
    -1.130655e+000,
    -1.358609e-001,
    9.171203e-001,
    -4.660394e+000,
    6.251162e+000,
    1.904529e+000,
    2.639668e-001,
    1.856130e+000,
    8.228440e-001,
    -9.739015e-001,
    -6.674749e-002,
    -4.768897e-001,
    1.248589e+001,
    -1.994688e+001,
    -2.353043e+000,
    5.885575e-001,
    1.287251e+000,
    4.830135e-001,
    -1.082178e+000,
    -1.974495e-001,
    1.050245e+000,
    -4.792855e+000,
    8.663406e+000,
    3.246969e+000,
    1.556731e-001,
    8.117442e-001,
    8.050376e-001,
    -1.063354e+000,
    -1.727108e-001,
    9.681592e-001,
    2.736077e+000,
    -4.969269e+000,
    -8.360570e-001,
    5.994612e-001,
    1.024039e+000,
    6.786935e-001,
    // albedo 0, turbidity 6
    -1.261936e+000,
    -3.053676e-001,
    -4.262222e-001,
    4.000196e-001,
    -2.059388e-002,
    4.721802e-001,
    1.480028e-001,
    3.505343e+000,
    6.121337e-001,
    -1.681088e+000,
    -6.971919e-001,
    -1.105652e-001,
    7.437426e-001,
    -6.594399e-001,
    2.254221e-001,
    8.710195e-002,
    1.263913e+000,
    5.681865e-001,
    -9.453001e-001,
    3.460388e-002,
    6.067038e-001,
    -1.985128e+000,
    3.457236e+000,
    2.655483e+000,
    -1.162354e-002,
    3.304716e+000,
    1.001950e+000,
    -1.086609e+000,
    -2.029011e-001,
    -6.399170e-001,
    6.926885e+000,
    -1.512189e+001,
    -3.793051e+000,
    9.456120e-001,
    2.222222e-001,
    2.893725e-001,
    -1.041259e+000,
    -1.388790e-001,
    1.147331e+000,
    6.282086e+000,
    3.679836e+000,
    4.398314e+000,
    -1.355232e-001,
    1.031134e+000,
    9.273509e-001,
    -1.063473e+000,
    -1.916051e-001,
    6.556979e-001,
    -3.371891e-003,
    -3.699664e+000,
    -1.926783e+000,
    7.371154e-001,
    1.179975e+000,
    6.367068e-001,
    // albedo 0, turbidity 7
    -1.336390e+000,
    -3.778927e-001,
    -7.259477e-001,
    2.270247e-001,
    4.627513e-001,
    1.366459e-001,
    2.637347e-001,
    3.292059e+000,
    4.998211e-001,
    -2.119878e+000,
    -1.055472e+000,
    5.422052e-001,
    7.826648e-001,
    -1.286065e+000,
    9.517905e-001,
    -1.432358e-001,
    -2.379816e-001,
    5.910513e-001,
    -7.761432e-001,
    2.124336e-001,
    -6.845184e-001,
    -9.812342e-001,
    4.347257e+000,
    9.671980e-001,
    3.773150e-001,
    5.789529e+000,
    9.646598e-001,
    -1.118734e+000,
    -3.513815e-001,
    5.500918e-001,
    9.449627e-001,
    -1.262070e+001,
    -1.825280e+000,
    4.731260e-001,
    -3.326892e+000,
    3.568768e-001,
    -1.026437e+000,
    -8.257946e-002,
    3.221701e-001,
    1.198372e+001,
    1.555130e+000,
    2.560304e+000,
    1.406465e-001,
    2.912858e+000,
    8.643181e-001,
    -1.069949e+000,
    -2.029607e-001,
    5.825042e-001,
    -2.398595e-003,
    -3.278335e+000,
    -1.349882e+000,
    7.208433e-001,
    8.505164e-001,
    6.625391e-001,
    // albedo 0, turbidity 8
    -1.392309e+000,
    -4.454945e-001,
    -5.664000e-001,
    6.283393e-001,
    -3.761727e-001,
    6.949802e-001,
    7.748178e-002,
    3.192797e+000,
    5.968661e-001,
    -2.713405e+000,
    -1.395112e+000,
    2.029230e-001,
    1.877272e-001,
    -3.715859e-001,
    -1.652929e-001,
    2.385861e-001,
    -4.150768e-001,
    1.375467e-001,
    -9.588644e-001,
    2.433900e-002,
    -1.527493e+000,
    -9.632874e-001,
    5.496269e+000,
    1.094931e+000,
    2.004044e-001,
    6.084554e+000,
    1.369604e+000,
    -8.028546e-001,
    -2.473563e-001,
    1.617898e+000,
    2.073591e+000,
    -1.149446e+001,
    -8.394131e-001,
    2.726847e-001,
    -4.634538e+000,
    1.367293e-001,
    -1.198326e+000,
    -1.804865e-001,
    -3.565414e-001,
    4.073200e+000,
    1.662086e+000,
    1.239770e+000,
    3.367978e-001,
    2.997402e+000,
    9.360383e-001,
    -1.013531e+000,
    -1.859060e-001,
    5.799857e-001,
    1.331883e+001,
    -4.346873e+000,
    -1.113820e+000,
    5.275714e-001,
    8.045177e-001,
    6.496373e-001,
    // albedo 0, turbidity 9
    -1.530103e+000,
    -6.107468e-001,
    -3.841771e-001,
    1.881508e+000,
    -1.464807e+000,
    6.654690e-001,
    -5.950797e-006,
    2.738912e+000,
    8.101012e-001,
    -2.415469e+000,
    -1.057499e+000,
    -4.161968e-001,
    -2.357548e+000,
    6.300296e-001,
    6.224915e-001,
    1.545048e-002,
    2.038561e+000,
    -1.339415e-001,
    -3.096796e+000,
    -1.465688e+000,
    -1.199232e+000,
    4.567061e+000,
    3.260980e+000,
    -9.794907e-001,
    8.950491e-001,
    2.049235e+000,
    1.331015e+000,
    2.713904e-001,
    2.852852e-001,
    1.202090e+000,
    -8.206784e+000,
    -5.805762e+000,
    1.804431e+000,
    -6.090648e-001,
    -1.990902e+000,
    3.288858e-001,
    -1.456580e+000,
    -3.455960e-001,
    -6.409257e-002,
    1.667697e+001,
    -2.311094e+000,
    -9.771104e-001,
    6.759863e-001,
    1.245136e+000,
    7.911932e-001,
    -9.860389e-001,
    -2.099564e-001,
    2.946650e-001,
    -3.547800e-003,
    -2.268313e+000,
    -6.205647e-002,
    4.705185e-001,
    8.657995e-001,
    6.856284e-001,
    // albedo 0, turbidity 10
    -1.971736e+000,
    -9.414047e-001,
    -3.400557e-001,
    1.468763e+000,
    -1.474284e+000,
    5.501062e-001,
    -1.109750e-005,
    2.356370e+000,
    9.001702e-001,
    -1.589845e+000,
    -7.797079e-001,
    -5.582240e-001,
    -8.137376e-001,
    5.846617e-001,
    1.129459e-001,
    -2.658005e-002,
    2.707248e+000,
    -2.112486e-001,
    -6.940173e+000,
    -2.823963e+000,
    -1.620848e+000,
    1.090696e+000,
    2.391730e+000,
    1.370047e+000,
    5.890462e-001,
    1.728400e+000,
    1.331253e+000,
    1.293144e+000,
    -1.919778e-003,
    1.644206e+000,
    -8.666967e-001,
    -7.161953e+000,
    -1.385018e+000,
    -1.505374e-001,
    -1.388643e+000,
    2.530122e-001,
    -1.488880e+000,
    -2.495496e-001,
    -2.377137e-001,
    1.167714e+001,
    -8.617124e-001,
    1.053828e+000,
    1.992744e-001,
    3.633564e-001,
    8.553304e-001,
    -1.060891e+000,
    -4.035829e-001,
    2.823207e-001,
    -2.369798e-003,
    -1.876577e+000,
    -5.950265e-001,
    4.241017e-001,
    3.140802e-001,
    6.631669e-001,
    // albedo 1, turbidity 1
    -1.101204e+000,
    -1.351353e-001,
    -4.030882e+000,
    6.096353e+000,
    -1.148599e-001,
    1.606507e+000,
    -1.555474e-006,
    4.436084e+000,
    5.973715e-001,
    -1.154597e+000,
    -1.923378e-001,
    8.512132e-001,
    2.934895e-001,
    -6.522777e-002,
    1.389077e-001,
    9.091469e-002,
    3.133307e+000,
    2.108541e-001,
    -1.031588e+000,
    -1.546804e-001,
    5.266214e+000,
    -9.491390e-001,
    -7.184867e-001,
    4.875626e+000,
    -1.911907e-001,
    -2.865642e+000,
    1.087895e+000,
    -1.159454e+000,
    -9.546699e-002,
    -1.508146e+000,
    -2.031411e-002,
    1.040653e+000,
    -2.333508e+000,
    2.540592e-001,
    8.594981e+000,
    9.316770e-002,
    -1.035940e+000,
    -2.021151e-001,
    4.719343e+000,
    -9.019318e-001,
    -7.858046e+000,
    3.901234e+000,
    -2.233137e-001,
    -4.344739e+000,
    6.550733e-001,
    -1.096669e+000,
    -1.558196e-001,
    2.057553e+000,
    6.274495e+000,
    -2.678352e+000,
    -1.814927e+000,
    1.550676e-001,
    1.903276e+000,
    4.998989e-001,
    // albedo 1, turbidity 2
    -1.114209e+000,
    -1.473531e-001,
    -7.602914e+000,
    8.973685e+000,
    -4.980074e-002,
    1.289198e+000,
    8.366906e-002,
    4.557987e+000,
    6.118757e-001,
    -1.149397e+000,
    -1.981628e-001,
    4.914096e+000,
    -3.498986e+000,
    -6.257090e-002,
    1.667401e-001,
    1.048980e-001,
    2.284689e+000,
    5.935965e-001,
    -1.056121e+000,
    -1.456172e-001,
    4.272656e-001,
    2.912649e+000,
    -5.501745e-001,
    4.406542e+000,
    -1.387680e-001,
    1.245555e+000,
    9.733011e-001,
    -1.125047e+000,
    -4.003662e-002,
    1.058457e+000,
    -3.462236e+000,
    4.395278e-001,
    -2.395805e+000,
    5.177589e-001,
    4.866247e+000,
    4.253189e-001,
    -1.051444e+000,
    -2.804541e-001,
    3.364668e+000,
    3.293787e+000,
    -1.015741e+001,
    3.807407e+000,
    -3.592377e-001,
    -3.367415e+000,
    7.900825e-001,
    -1.093847e+000,
    -1.436965e-001,
    2.384780e+000,
    5.787070e+000,
    -2.445987e+000,
    -1.311171e+000,
    2.326563e-001,
    1.158439e+000,
    5.555416e-001,
    // albedo 1, turbidity 3
    -1.134824e+000,
    -1.680468e-001,
    -3.325620e+000,
    4.458596e+000,
    -1.135063e-001,
    1.104500e+000,
    7.794544e-002,
    4.609952e+000,
    6.854854e-001,
    -1.143017e+000,
    -1.565926e-001,
    3.014687e-001,
    -1.763027e-001,
    -3.557925e-002,
    -2.342406e-001,
    2.528705e-001,
    5.884085e+000,
    4.750602e-001,
    -1.136801e+000,
    -2.907502e-001,
    3.682423e+000,
    -4.061202e-001,
    -8.728159e-001,
    4.001510e+000,
    -1.522202e-001,
    -5.528713e+000,
    1.044847e+000,
    -1.063652e+000,
    7.808107e-002,
    -1.983678e+000,
    3.648078e-001,
    2.102276e+000,
    -3.065050e+000,
    8.431951e-001,
    1.038830e+001,
    2.662834e-001,
    -1.061015e+000,
    -2.859814e-001,
    4.223615e+000,
    -2.290138e+000,
    -8.314010e+000,
    4.405718e+000,
    -4.613627e-001,
    -4.502910e+000,
    1.008383e+000,
    -1.106302e+000,
    -1.697123e-001,
    2.087196e+000,
    8.238929e+000,
    -2.992416e+000,
    -1.821776e+000,
    3.434859e-001,
    7.755179e-001,
    5.341190e-001,
    // albedo 1, turbidity 4
    -1.171110e+000,
    -2.106304e-001,
    -1.614361e+000,
    2.378103e+000,
    -1.625969e-001,
    8.504483e-001,
    1.059312e-001,
    4.046256e+000,
    6.618227e-001,
    -1.200480e+000,
    -2.235733e-001,
    1.014390e+000,
    -1.174074e+000,
    -4.440180e-001,
    2.262406e-001,
    1.665868e-001,
    5.461829e+000,
    5.676310e-001,
    -1.223587e+000,
    -3.502622e-001,
    1.699106e+000,
    6.724266e-001,
    1.268567e+000,
    2.135102e+000,
    8.039374e-004,
    -5.221111e+000,
    9.445690e-001,
    -9.452673e-001,
    1.468459e-001,
    -1.335034e+000,
    4.346628e+000,
    -1.285652e+001,
    -1.807046e+000,
    8.175243e-001,
    9.301065e+000,
    3.656798e-001,
    -1.134681e+000,
    -3.310951e-001,
    3.571244e+000,
    -2.208948e+000,
    6.041580e+000,
    3.107577e+000,
    -3.112127e-001,
    -4.186351e+000,
    9.188333e-001,
    -1.083237e+000,
    -1.831394e-001,
    2.062654e+000,
    1.385424e+000,
    -5.004950e+000,
    -1.332669e+000,
    3.627352e-001,
    3.323150e-001,
    6.191181e-001,
    // albedo 1, turbidity 5
    -1.211527e+000,
    -2.590617e-001,
    -1.660874e-001,
    3.627905e-001,
    -1.039258e-001,
    4.697924e-001,
    1.671653e-001,
    3.507497e+000,
    6.022506e-001,
    -1.433017e+000,
    -4.733592e-001,
    1.724445e-001,
    9.953236e-001,
    -1.874457e+000,
    4.432099e-001,
    1.715810e-002,
    2.339272e+000,
    6.441470e-001,
    -1.084920e+000,
    -1.587903e-001,
    8.999585e-001,
    -2.537516e+000,
    5.877859e+000,
    2.014554e+000,
    9.689141e-002,
    3.177242e-001,
    9.030399e-001,
    -1.008242e+000,
    2.793030e-003,
    -3.507469e-001,
    1.028300e+001,
    -2.080454e+001,
    -2.781026e+000,
    8.995090e-001,
    3.366951e+000,
    3.473867e-001,
    -1.103151e+000,
    -2.799598e-001,
    2.525791e+000,
    -4.255704e+000,
    9.903388e+000,
    3.722668e+000,
    -3.603941e-001,
    -1.303292e+000,
    9.369454e-001,
    -1.102235e+000,
    -2.025061e-001,
    2.085660e+000,
    1.686787e+000,
    -5.010957e+000,
    -1.656458e+000,
    4.584029e-001,
    -2.751759e-001,
    6.184162e-001,
    // albedo 1, turbidity 6
    -1.256130e+000,
    -3.104904e-001,
    1.639350e-001,
    1.315502e-001,
    -7.297583e-001,
    4.778480e-001,
    1.259265e-001,
    3.012108e+000,
    6.202728e-001,
    -1.620114e+000,
    -6.552670e-001,
    -2.877157e-001,
    1.094371e+000,
    2.818914e-001,
    3.696830e-001,
    9.428521e-002,
    1.450951e+000,
    5.681308e-001,
    -9.686204e-001,
    -3.755647e-002,
    1.469980e+000,
    -3.103414e+000,
    2.856583e+000,
    1.883209e+000,
    -5.746099e-002,
    1.286383e+000,
    1.001751e+000,
    -1.089377e+000,
    -1.023062e-001,
    -1.498891e+000,
    1.066455e+001,
    -1.720184e+001,
    -2.759314e+000,
    1.061258e+000,
    2.910211e+000,
    2.624701e-001,
    -1.044681e+000,
    -2.156857e-001,
    3.230136e+000,
    -5.863862e-001,
    6.096640e+000,
    3.550019e+000,
    -4.255773e-001,
    -1.500033e+000,
    9.687696e-001,
    -1.133658e+000,
    -2.505101e-001,
    1.717840e+000,
    8.480428e-003,
    -5.011789e+000,
    -1.740989e+000,
    4.983430e-001,
    -2.081829e-001,
    6.088641e-001,
    // albedo 1, turbidity 7
    -1.335366e+000,
    -3.863319e-001,
    -5.279971e-001,
    3.638324e-001,
    3.230699e-001,
    8.339707e-002,
    2.483293e-001,
    2.678646e+000,
    4.998346e-001,
    -2.004511e+000,
    -9.957121e-001,
    1.250807e+000,
    1.625025e-002,
    -3.410754e-001,
    7.858244e-001,
    -9.506757e-002,
    2.651876e-002,
    5.788643e-001,
    -8.714157e-001,
    1.192051e-001,
    -8.486879e-001,
    -3.702497e-001,
    1.818277e+000,
    1.103427e+000,
    2.454866e-001,
    3.841575e+000,
    9.847350e-001,
    -1.042618e+000,
    -2.285793e-001,
    3.620175e-001,
    2.983368e+000,
    -9.776844e+000,
    -1.971587e+000,
    6.691674e-001,
    -7.901947e-001,
    3.213200e-001,
    -1.099112e+000,
    -1.869868e-001,
    2.044065e+000,
    2.062964e+000,
    1.265668e+000,
    2.710130e+000,
    -1.099443e-001,
    2.179353e-001,
    9.024108e-001,
    -1.106985e+000,
    -2.396881e-001,
    1.809807e+000,
    8.523319e+000,
    -5.011788e+000,
    -1.590086e+000,
    3.248449e-001,
    -1.003187e-001,
    6.550606e-001,
    // albedo 1, turbidity 8
    -1.421285e+000,
    -4.767024e-001,
    -3.885004e-001,
    8.274590e-001,
    -3.644229e-001,
    6.999513e-001,
    5.196710e-002,
    2.578431e+000,
    6.246310e-001,
    -2.611217e+000,
    -1.398846e+000,
    4.527425e-001,
    -5.932142e-001,
    2.224617e-001,
    -5.593581e-001,
    3.389633e-001,
    -7.767112e-001,
    6.536004e-002,
    -9.881543e-001,
    4.684782e-002,
    -8.616613e-001,
    8.799807e-001,
    4.003130e+000,
    1.739543e+000,
    -8.098378e-002,
    5.524802e+000,
    1.499673e+000,
    -7.544759e-001,
    -2.314808e-001,
    8.125770e-001,
    -7.724135e-001,
    -9.577645e+000,
    -1.629433e+000,
    6.790832e-001,
    -4.193895e+000,
    -2.526624e-002,
    -1.273719e+000,
    -2.187030e-001,
    1.401798e+000,
    5.231832e+000,
    7.405093e-001,
    1.775166e+000,
    -7.269476e-002,
    1.996087e+000,
    1.057450e+000,
    -1.046864e+000,
    -2.247559e-001,
    1.679449e+000,
    1.140057e+001,
    -4.948829e+000,
    -1.182664e+000,
    3.241038e-001,
    -2.470012e-001,
    6.115900e-001,
    // albedo 1, turbidity 9
    -1.514607e+000,
    -5.985430e-001,
    -1.877610e-001,
    1.756930e+000,
    -1.314206e+000,
    6.115810e-001,
    -5.970460e-006,
    2.412975e+000,
    8.124304e-001,
    -2.308414e+000,
    -1.083797e+000,
    -1.179959e-001,
    -1.728246e+000,
    7.784742e-001,
    5.494505e-001,
    6.203168e-003,
    9.326251e-001,
    -1.419518e-001,
    -3.230837e+000,
    -1.438670e+000,
    -9.868286e-001,
    2.974393e+000,
    1.949339e+000,
    -6.337857e-001,
    8.160271e-001,
    3.278606e+000,
    1.354373e+000,
    5.149378e-001,
    2.754789e-001,
    1.040965e+000,
    -4.501186e+000,
    -3.399057e+000,
    9.661861e-001,
    -4.736173e-001,
    -4.037574e+000,
    2.794847e-001,
    -1.621870e+000,
    -3.192763e-001,
    8.786242e-001,
    9.785565e+000,
    -2.727652e+000,
    1.903691e-002,
    5.521261e-001,
    2.138764e+000,
    8.419871e-001,
    -9.951701e-001,
    -2.550607e-001,
    1.498952e+000,
    -2.737197e-003,
    -3.101832e+000,
    -5.921329e-001,
    2.864422e-001,
    -4.405218e-001,
    6.631410e-001,
    // albedo 1, turbidity 10
    -1.902954e+000,
    -9.056918e-001,
    -2.069570e-001,
    1.191499e+000,
    -1.092577e+000,
    5.849556e-001,
    -9.649602e-006,
    2.048407e+000,
    9.001527e-001,
    -1.271627e+000,
    -7.193923e-001,
    -1.136606e-002,
    -1.167951e-001,
    3.286175e-003,
    -5.262827e-002,
    -2.473874e-002,
    1.716125e+000,
    -2.187133e-001,
    -7.647175e+000,
    -3.114129e+000,
    -1.490128e+000,
    -5.266488e-001,
    3.063090e+000,
    1.474262e+000,
    5.481458e-001,
    2.052174e+000,
    1.353089e+000,
    2.191403e+000,
    3.421120e-001,
    1.446510e+000,
    2.170943e+000,
    -7.768187e+000,
    -1.471207e+000,
    -1.456708e-001,
    -1.753574e+000,
    2.310576e-001,
    -1.932296e+000,
    -3.814739e-001,
    6.245422e-001,
    6.748294e+000,
    -3.060171e-001,
    1.067747e+000,
    2.500671e-001,
    -1.252596e-001,
    8.614611e-001,
    -9.471101e-001,
    -4.052640e-001,
    1.300174e+000,
    -3.951536e-003,
    -1.908284e+000,
    -5.385721e-001,
    2.133578e-001,
    -6.250292e-001,
    6.658012e-001,
};

double datasetRGBRad1[] =
{
    // albedo 0, turbidity 1
    1.962684e+000,
    1.159831e+000,
    4.450588e+000,
    5.079633e+000,
    4.437388e+000,
    4.324573e+000,
    // albedo 0, turbidity 2
    1.946487e+000,
    1.287515e+000,
    3.703696e+000,
    8.782833e+000,
    3.440437e+000,
    5.160333e+000,
    // albedo 0, turbidity 3
    1.882170e+000,
    1.335878e+000,
    2.648641e+000,
    1.358368e+001,
    3.105473e+000,
    5.907387e+000,
    // albedo 0, turbidity 4
    1.738159e+000,
    1.624289e+000,
    -8.786695e-003,
    2.118253e+001,
    2.770255e+000,
    7.055672e+000,
    // albedo 0, turbidity 5
    1.571896e+000,
    2.301786e+000,
    -4.028545e+000,
    2.966806e+001,
    1.630876e+000,
    8.711031e+000,
    // albedo 0, turbidity 6
    1.475048e+000,
    2.679086e+000,
    -6.311315e+000,
    3.377896e+001,
    2.140975e+000,
    9.385283e+000,
    // albedo 0, turbidity 7
    1.326174e+000,
    3.378759e+000,
    -9.831444e+000,
    3.942061e+001,
    2.852702e+000,
    1.082542e+001,
    // albedo 0, turbidity 8
    1.153344e+000,
    3.967771e+000,
    -1.265181e+001,
    4.195016e+001,
    7.468239e+000,
    1.221350e+001,
    // albedo 0, turbidity 9
    9.746081e-001,
    4.051626e+000,
    -1.298454e+001,
    3.754964e+001,
    1.749232e+001,
    1.420619e+001,
    // albedo 0, turbidity 10
    8.448016e-001,
    3.181809e+000,
    -8.757338e+000,
    2.197962e+001,
    3.524033e+001,
    1.639549e+001,
    // albedo 1, turbidity 1
    2.029623e+000,
    1.364434e+000,
    4.201529e+000,
    5.415099e+000,
    9.825839e+000,
    1.063328e+001,
    // albedo 1, turbidity 2
    2.023126e+000,
    1.494728e+000,
    3.420413e+000,
    9.072178e+000,
    9.205157e+000,
    1.186639e+001,
    // albedo 1, turbidity 3
    1.956307e+000,
    1.648665e+000,
    2.039712e+000,
    1.430239e+001,
    9.039526e+000,
    1.330453e+001,
    // albedo 1, turbidity 4
    1.825053e+000,
    1.985022e+000,
    -8.036307e-001,
    2.202493e+001,
    9.415361e+000,
    1.517659e+001,
    // albedo 1, turbidity 5
    1.650367e+000,
    2.593201e+000,
    -4.469328e+000,
    2.969817e+001,
    9.410977e+000,
    1.744850e+001,
    // albedo 1, turbidity 6
    1.555202e+000,
    2.962925e+000,
    -6.608170e+000,
    3.329887e+001,
    1.064559e+001,
    1.850816e+001,
    // albedo 1, turbidity 7
    1.412478e+000,
    3.439403e+000,
    -9.196616e+000,
    3.685077e+001,
    1.345341e+001,
    2.003128e+001,
    // albedo 1, turbidity 8
    1.252990e+000,
    3.820805e+000,
    -1.115338e+001,
    3.721593e+001,
    2.014916e+001,
    2.182320e+001,
    // albedo 1, turbidity 9
    1.091952e+000,
    3.663027e+000,
    -1.031330e+001,
    2.978985e+001,
    3.296835e+001,
    2.375450e+001,
    // albedo 1, turbidity 10
    9.501691e-001,
    2.664579e+000,
    -5.545167e+000,
    1.281159e+001,
    5.154768e+001,
    2.574284e+001,
};

double datasetRGB2[] =
{
    // albedo 0, turbidity 1
    -1.140530e+000,
    -1.982747e-001,
    -7.512730e+000,
    8.403899e+000,
    -5.699038e-002,
    9.015907e-001,
    3.392161e-002,
    4.772522e+000,
    5.111184e-001,
    -1.165117e+000,
    -1.852955e-001,
    2.963684e+000,
    -2.262274e+000,
    -1.571683e-001,
    6.339974e-001,
    4.977879e-002,
    7.243307e+000,
    4.220053e-001,
    -1.169936e+000,
    -3.357429e-001,
    1.911291e+000,
    -2.391074e-001,
    -4.791643e-001,
    1.446113e+000,
    -9.178108e-002,
    -4.700239e+000,
    8.096219e-001,
    -1.060246e+000,
    -1.051633e-001,
    5.013829e-001,
    2.832309e+000,
    -3.707855e-001,
    1.523131e+000,
    9.163749e-002,
    5.604183e+000,
    7.208566e-001,
    -1.089753e+000,
    -2.382167e-001,
    2.360312e+000,
    -5.902562e+000,
    -8.799894e+000,
    1.377692e+000,
    -6.131633e-002,
    -1.415472e+000,
    6.124057e-001,
    -1.075481e+000,
    -1.242391e-001,
    1.425781e+000,
    8.810319e+000,
    -2.922646e+000,
    1.486520e+000,
    3.270580e-002,
    3.889783e+000,
    4.999482e-001,
    // albedo 0, turbidity 2
    -1.149342e+000,
    -2.076337e-001,
    -7.446587e+000,
    8.014559e+000,
    -4.866227e-002,
    8.203043e-001,
    6.386483e-002,
    4.894198e+000,
    5.452051e-001,
    -1.120531e+000,
    -1.513311e-001,
    2.735504e+000,
    -2.417591e+000,
    -1.361114e-001,
    4.296342e-001,
    9.427488e-002,
    8.171403e+000,
    4.102448e-001,
    -1.226964e+000,
    -3.516378e-001,
    1.308298e+000,
    -5.097487e-002,
    -4.846783e-001,
    1.654619e+000,
    -1.134940e-001,
    -3.347854e+000,
    1.131147e+000,
    -9.664377e-001,
    2.767589e-002,
    1.658235e-001,
    2.407439e+000,
    -1.300304e-001,
    9.170958e-001,
    2.742895e-001,
    6.642633e+000,
    2.550064e-001,
    -1.153358e+000,
    -3.126223e-001,
    2.078934e+000,
    -5.857733e+000,
    -8.659848e+000,
    1.758505e+000,
    -9.616094e-002,
    -1.230863e+000,
    9.663832e-001,
    -1.053850e+000,
    -1.330743e-001,
    1.481738e+000,
    1.049485e+001,
    -3.528854e+000,
    9.142363e-001,
    1.244880e-001,
    2.644615e+000,
    5.001048e-001,
    // albedo 0, turbidity 3
    -1.173687e+000,
    -2.360362e-001,
    -3.741454e+000,
    4.088507e+000,
    -7.528205e-002,
    6.645237e-001,
    7.718265e-002,
    4.651220e+000,
    5.586318e-001,
    -1.213757e+000,
    -2.589561e-001,
    7.132551e-001,
    -4.259327e-001,
    -1.980821e-001,
    3.627815e-001,
    4.666560e-002,
    5.807984e+000,
    5.847377e-001,
    -1.108794e+000,
    -2.259870e-001,
    1.574179e+000,
    -3.753731e-001,
    -5.984743e-001,
    1.659414e+000,
    -1.681021e-002,
    6.785219e-001,
    8.647325e-001,
    -1.060896e+000,
    -1.346690e-002,
    -7.529656e-001,
    1.711319e+000,
    -9.792435e-001,
    2.022433e-001,
    3.826487e-001,
    5.725157e+000,
    5.290714e-001,
    -1.085145e+000,
    -2.840715e-001,
    2.088029e+000,
    -4.935097e+000,
    -9.056542e+000,
    1.976149e+000,
    -3.912485e-002,
    -8.636064e-001,
    7.452125e-001,
    -1.077983e+000,
    -1.416633e-001,
    1.100848e+000,
    1.015875e+001,
    -2.943712e+000,
    5.255135e-001,
    2.164224e-001,
    2.941143e+000,
    6.699937e-001,
    // albedo 0, turbidity 4
    -1.223293e+000,
    -2.867444e-001,
    -1.624136e+000,
    1.668299e+000,
    -9.537589e-002,
    5.015947e-001,
    1.130741e-001,
    4.244812e+000,
    5.082152e-001,
    -1.325342e+000,
    -4.280991e-001,
    4.705490e-001,
    6.926592e-002,
    -4.572587e-001,
    5.344144e-001,
    -2.554192e-002,
    3.093939e+000,
    6.639401e-001,
    -1.113581e+000,
    -1.192133e-001,
    4.011536e-001,
    7.011889e-001,
    2.052842e-001,
    9.880724e-001,
    1.807533e-002,
    4.690160e+000,
    8.576240e-001,
    -1.016063e+000,
    -1.038138e-001,
    -2.280391e-001,
    7.898918e-001,
    -1.127333e+001,
    2.074545e-001,
    5.388182e-001,
    1.364263e+000,
    4.660455e-001,
    -1.099582e+000,
    -2.228607e-001,
    1.332648e+000,
    5.135188e+000,
    1.653152e+000,
    1.417020e+000,
    -1.087532e-001,
    1.809275e+000,
    8.080874e-001,
    -1.064357e+000,
    -1.520775e-001,
    8.207368e-001,
    -1.323565e-003,
    -5.009523e+000,
    3.946298e-001,
    4.337902e-001,
    2.593198e+000,
    6.719172e-001,
    // albedo 0, turbidity 5
    -1.278702e+000,
    -3.512866e-001,
    -4.511055e-001,
    3.895760e-001,
    -2.429672e-001,
    4.270577e-001,
    1.135348e-001,
    3.719130e+000,
    4.998867e-001,
    -1.580069e+000,
    -7.095475e-001,
    -3.198904e-001,
    1.715748e+000,
    -1.185915e+000,
    4.523161e-001,
    -1.026159e-002,
    7.927188e-001,
    5.538350e-001,
    -9.474023e-001,
    1.173703e-001,
    4.881381e-001,
    -2.618684e+000,
    3.251661e+000,
    1.213931e+000,
    -1.736274e-002,
    8.000768e+000,
    1.025998e+000,
    -1.129091e+000,
    -3.287694e-001,
    -3.524077e-001,
    3.352892e+000,
    -1.416073e+001,
    -8.485617e-001,
    6.560766e-001,
    -2.820937e+000,
    3.111303e-001,
    -1.030884e+000,
    -1.137581e-001,
    1.109855e+000,
    8.082276e+000,
    1.519214e+000,
    2.112433e+000,
    -1.592299e-001,
    3.675905e+000,
    8.703367e-001,
    -1.075192e+000,
    -1.627166e-001,
    3.514910e-001,
    1.168164e+000,
    -4.255822e+000,
    -6.015348e-001,
    6.265776e-001,
    2.884818e+000,
    6.548384e-001,
    // albedo 0, turbidity 6
    -1.316017e+000,
    -3.889652e-001,
    -5.030854e-001,
    4.488704e-001,
    -3.186800e-001,
    4.570763e-001,
    8.909201e-002,
    3.659274e+000,
    5.011746e-001,
    -1.731876e+000,
    -8.493806e-001,
    1.194871e-001,
    2.002781e+000,
    -2.006547e+000,
    4.872233e-001,
    -2.854606e-002,
    2.662137e-001,
    4.611629e-001,
    -9.273680e-001,
    1.380954e-001,
    -3.302179e-001,
    -3.553265e+000,
    4.633345e+000,
    9.696729e-001,
    8.799775e-002,
    8.291129e+000,
    1.094451e+000,
    -1.099377e+000,
    -3.325392e-001,
    2.501063e-001,
    2.613712e+000,
    -1.328142e+001,
    -5.579527e-001,
    4.992081e-001,
    -3.504402e+000,
    3.022924e-001,
    -1.048420e+000,
    -1.227773e-001,
    5.845373e-001,
    1.105869e+001,
    3.813151e-002,
    1.330409e+000,
    1.978131e-002,
    3.959430e+000,
    8.396439e-001,
    -1.063233e+000,
    -1.560639e-001,
    2.840033e-001,
    8.751565e-001,
    -3.411820e+000,
    -1.436564e-001,
    5.846580e-001,
    2.899292e+000,
    6.799095e-001,
    // albedo 0, turbidity 7
    -1.376715e+000,
    -4.541567e-001,
    -1.445491e+000,
    1.569898e+000,
    -1.390627e-001,
    5.558270e-001,
    4.109877e-002,
    3.349451e+000,
    5.516123e-001,
    -1.953391e+000,
    -1.035869e+000,
    1.690563e+000,
    -1.964690e-001,
    -7.787096e-001,
    5.799605e-001,
    2.945626e-002,
    4.217906e-002,
    2.451373e-001,
    -1.012422e+000,
    7.136451e-002,
    -1.862534e+000,
    -7.228653e-001,
    1.947997e-001,
    2.091805e-001,
    6.399233e-002,
    7.928994e+000,
    1.290733e+000,
    -9.706708e-001,
    -2.880950e-001,
    1.107797e+000,
    -2.731734e+000,
    -8.445995e+000,
    4.296774e-001,
    5.117648e-001,
    -3.824277e+000,
    1.761207e-001,
    -1.110611e+000,
    -1.789409e-001,
    2.108488e-001,
    2.071430e+001,
    -1.763174e+000,
    9.554695e-002,
    -2.943103e-002,
    3.422079e+000,
    8.815496e-001,
    -1.048334e+000,
    -1.614087e-001,
    2.475184e-001,
    2.146938e-002,
    -2.983901e+000,
    2.538224e-001,
    5.601370e-001,
    2.461925e+000,
    6.777394e-001,
    // albedo 0, turbidity 8
    -1.393719e+000,
    -5.002724e-001,
    -2.408940e+000,
    2.680983e+000,
    -1.362825e-001,
    7.395067e-001,
    -3.300343e-006,
    3.260889e+000,
    8.132057e-001,
    -2.128663e+000,
    -1.151182e+000,
    2.923026e+000,
    -1.931838e+000,
    -4.426170e-001,
    2.309983e-001,
    -5.485890e-003,
    3.279529e-001,
    -2.229467e-001,
    -1.618022e+000,
    -3.766490e-001,
    -3.163544e+000,
    1.611608e+000,
    -3.967476e-001,
    3.933680e-001,
    3.006742e-001,
    6.835177e+000,
    1.613765e+000,
    -5.669064e-001,
    -1.481749e-001,
    2.071817e+000,
    -8.157422e+000,
    -5.988088e+000,
    2.387202e-001,
    1.447191e-001,
    -4.296385e+000,
    5.011258e-002,
    -1.241724e+000,
    -2.519348e-001,
    -1.908609e-001,
    2.952235e+001,
    -3.333660e+000,
    -1.837651e-002,
    1.022249e-001,
    2.929320e+000,
    8.867262e-001,
    -1.021670e+000,
    -1.667327e-001,
    1.789771e-001,
    -2.178108e-003,
    -2.641572e+000,
    -5.641484e-002,
    5.303758e-001,
    2.138196e+000,
    6.780350e-001,
    // albedo 0, turbidity 9
    -1.669332e+000,
    -7.588708e-001,
    -2.993557e+000,
    3.178760e+000,
    -8.066442e-002,
    6.544672e-001,
    -8.089880e-006,
    2.628924e+000,
    9.001272e-001,
    -1.755806e+000,
    -8.735348e-001,
    3.258881e+000,
    -2.504785e+000,
    -3.300791e-001,
    1.180565e-001,
    -9.315982e-003,
    1.785154e+000,
    -3.205824e-001,
    -3.720277e+000,
    -1.733350e+000,
    -3.332272e+000,
    1.515869e+000,
    1.734218e-001,
    8.011956e-001,
    1.995440e-001,
    3.817666e+000,
    1.638502e+000,
    4.724641e-001,
    3.209828e-001,
    2.051443e+000,
    -5.105574e+000,
    -6.509139e+000,
    -4.232041e-001,
    2.598931e-001,
    -2.151756e+000,
    -3.493910e-003,
    -1.525600e+000,
    -4.897606e-001,
    -9.891121e-002,
    2.346818e+001,
    -2.278152e+000,
    1.681219e-001,
    -4.469389e-002,
    1.051000e+000,
    9.294666e-001,
    -9.908649e-001,
    -2.008182e-001,
    1.605143e-001,
    -2.463113e-003,
    -2.477349e+000,
    -1.218647e-001,
    4.750121e-001,
    1.460813e+000,
    6.661364e-001,
    // albedo 0, turbidity 10
    -2.122119e+000,
    -1.125475e+000,
    -3.066599e+000,
    3.145078e+000,
    -5.411593e-002,
    5.133628e-001,
    -7.823408e-006,
    2.268448e+000,
    9.001416e-001,
    -1.528158e+000,
    -9.370249e-001,
    2.567559e+000,
    -1.591439e+000,
    -3.634460e-001,
    1.763256e-001,
    1.119624e-003,
    1.811848e+000,
    -2.637929e-001,
    -6.524387e+000,
    -2.673507e+000,
    -2.940472e+000,
    -6.025609e-001,
    7.852067e-001,
    1.073499e+000,
    -3.540435e-002,
    3.517416e+000,
    1.490466e+000,
    8.886026e-001,
    -9.681828e-002,
    1.430554e+000,
    4.993717e+000,
    -6.071355e+000,
    -6.053986e-001,
    5.092997e-001,
    -1.273010e+000,
    7.491329e-002,
    -1.481997e+000,
    -5.897282e-001,
    2.659264e-001,
    1.267239e+000,
    -5.741291e-001,
    5.983011e-002,
    -2.217312e-001,
    -3.016452e-001,
    9.260830e-001,
    -1.010943e+000,
    -2.075134e-001,
    5.066749e-002,
    1.470708e+001,
    -3.780501e+000,
    7.253223e-002,
    4.045458e-001,
    1.320164e+000,
    6.559925e-001,
    // albedo 1, turbidity 1
    -1.129907e+000,
    -1.884011e-001,
    -8.047670e+000,
    9.035776e+000,
    -5.539419e-002,
    8.823349e-001,
    3.197135e-002,
    4.839388e+000,
    5.042822e-001,
    -1.133821e+000,
    -1.510781e-001,
    3.362822e+000,
    -2.453381e+000,
    -1.463925e-001,
    4.728708e-001,
    5.958140e-002,
    7.636300e+000,
    4.805162e-001,
    -1.176518e+000,
    -3.549902e-001,
    1.729044e+000,
    -2.160966e-001,
    -5.075865e-001,
    1.675584e+000,
    -8.906902e-002,
    -5.386842e+000,
    5.452218e-001,
    -1.043563e+000,
    -7.520975e-002,
    8.750644e-001,
    2.510518e+000,
    7.584882e-003,
    9.361250e-001,
    7.889083e-002,
    6.066644e+000,
    5.813108e-001,
    -1.081304e+000,
    -2.222253e-001,
    2.517638e+000,
    -4.453820e+000,
    -8.663691e+000,
    8.662558e-001,
    -4.802657e-002,
    -8.965449e-001,
    4.886656e-001,
    -1.083774e+000,
    -1.375469e-001,
    1.685818e+000,
    5.631120e+000,
    -3.100752e+000,
    4.045941e-001,
    2.346895e-002,
    3.390321e+000,
    5.008309e-001,
    // albedo 1, turbidity 2
    -1.143158e+000,
    -2.058334e-001,
    -9.660198e+000,
    1.062394e+001,
    -4.434119e-002,
    8.607615e-001,
    3.177325e-002,
    4.416481e+000,
    5.918162e-001,
    -1.146773e+000,
    -1.727385e-001,
    4.626048e+000,
    -4.684602e+000,
    -8.307137e-002,
    1.619616e-001,
    1.484866e-001,
    7.572868e+000,
    2.681126e-001,
    -1.151324e+000,
    -3.099303e-001,
    4.125596e-001,
    2.340752e+000,
    -4.214444e-001,
    1.987375e+000,
    -1.913410e-001,
    -3.845978e+000,
    1.337311e+000,
    -1.034258e+000,
    -7.778759e-003,
    7.050094e-001,
    -8.036369e-001,
    3.138570e-001,
    2.469452e-001,
    3.559970e-001,
    7.485917e+000,
    4.790329e-002,
    -1.096568e+000,
    -2.673169e-001,
    2.575654e+000,
    -8.057121e-001,
    -8.884928e+000,
    1.416170e+000,
    -2.091315e-001,
    -1.543494e+000,
    1.065445e+000,
    -1.083304e+000,
    -1.528265e-001,
    1.697727e+000,
    2.503702e+000,
    -2.885296e+000,
    -1.298500e-001,
    1.548870e-001,
    2.479652e+000,
    5.066496e-001,
    // albedo 1, turbidity 3
    -1.165736e+000,
    -2.329945e-001,
    -5.967964e+000,
    6.705959e+000,
    -5.931355e-002,
    7.485638e-001,
    3.913878e-002,
    4.221591e+000,
    6.183926e-001,
    -1.212422e+000,
    -2.545910e-001,
    2.418626e+000,
    -2.266104e+000,
    -1.102014e-001,
    1.363887e-002,
    1.055411e-001,
    5.648062e+000,
    4.557412e-001,
    -1.070436e+000,
    -2.163341e-001,
    7.098718e-001,
    7.843075e-001,
    -4.323930e-001,
    2.109823e+000,
    -9.589700e-002,
    -1.985193e-001,
    1.060428e+000,
    -1.104879e+000,
    -3.013622e-002,
    2.976276e-002,
    1.069707e+000,
    1.410000e-001,
    -4.880020e-001,
    4.452288e-001,
    6.418590e+000,
    3.195986e-001,
    -1.048969e+000,
    -2.655317e-001,
    2.689426e+000,
    -3.941038e+000,
    -9.506461e+000,
    1.837119e+000,
    -1.892124e-001,
    -1.562146e+000,
    9.043414e-001,
    -1.106145e+000,
    -1.601642e-001,
    1.544544e+000,
    7.388492e+000,
    -2.924600e+000,
    -4.328453e-001,
    1.763161e-001,
    2.523111e+000,
    5.851902e-001,
    // albedo 1, turbidity 4
    -1.203666e+000,
    -2.776587e-001,
    -2.084286e+000,
    2.450840e+000,
    -8.746613e-002,
    5.258507e-001,
    7.983316e-002,
    3.860055e+000,
    5.486167e-001,
    -1.340448e+000,
    -4.230590e-001,
    3.462849e-001,
    4.707607e-001,
    -2.512626e-001,
    1.530746e-001,
    2.724218e-002,
    3.035216e+000,
    5.876133e-001,
    -1.014554e+000,
    -1.168790e-001,
    9.477794e-001,
    -1.061218e+000,
    -4.196730e-001,
    2.058832e+000,
    -5.989624e-002,
    3.058168e+000,
    9.763861e-001,
    -1.137388e+000,
    -9.854030e-002,
    -2.984893e-001,
    3.647820e+000,
    -6.585571e-001,
    -1.479180e+000,
    6.102932e-001,
    3.265914e+000,
    3.480333e-001,
    -1.021816e+000,
    -2.344957e-001,
    2.463671e+000,
    -7.240685e+000,
    -8.862697e+000,
    2.514058e+000,
    -2.122768e-001,
    -3.313968e-002,
    9.028136e-001,
    -1.126581e+000,
    -1.874347e-001,
    1.454154e+000,
    1.034398e+001,
    -3.237393e+000,
    -8.654927e-001,
    2.457248e-001,
    1.845769e+000,
    6.002482e-001,
    // albedo 1, turbidity 5
    -1.263727e+000,
    -3.439354e-001,
    -1.786388e-001,
    3.980166e-001,
    -3.349517e-001,
    3.825166e-001,
    1.029225e-001,
    3.331096e+000,
    4.998955e-001,
    -1.530010e+000,
    -6.879698e-001,
    2.380415e-001,
    1.608216e+000,
    -1.682679e+000,
    3.546360e-001,
    -3.915220e-003,
    4.517655e-001,
    5.128605e-001,
    -9.685659e-001,
    9.480403e-002,
    6.076844e-002,
    -3.217561e+000,
    4.568074e+000,
    1.069299e+000,
    2.083638e-002,
    7.301088e+000,
    1.072165e+000,
    -1.113925e+000,
    -3.112382e-001,
    3.954133e-001,
    5.105907e+000,
    -1.456866e+001,
    -4.917378e-001,
    5.289909e-001,
    -2.678374e+000,
    3.014709e-001,
    -1.046864e+000,
    -1.215754e-001,
    1.778308e+000,
    4.661489e+000,
    2.565583e-001,
    1.353680e+000,
    -1.175767e-001,
    3.415972e+000,
    8.457746e-001,
    -1.104480e+000,
    -1.940913e-001,
    1.343668e+000,
    -1.759206e-003,
    -5.009204e+000,
    -4.186951e-001,
    3.125710e-001,
    1.628183e+000,
    6.720408e-001,
    // albedo 1, turbidity 6
    -1.286902e+000,
    -3.781238e-001,
    -8.977253e-002,
    3.545393e-001,
    -4.866515e-001,
    3.843664e-001,
    8.281675e-002,
    3.122231e+000,
    5.046991e-001,
    -1.712597e+000,
    -8.549112e-001,
    4.809286e-001,
    1.515398e+000,
    -2.212211e+000,
    2.539029e-001,
    2.335997e-002,
    -6.089466e-002,
    4.268444e-001,
    -8.807283e-001,
    1.646097e-001,
    -4.437898e-001,
    -3.188247e+000,
    5.984417e+000,
    1.334779e+000,
    -4.026975e-002,
    7.546431e+000,
    1.175751e+000,
    -1.147253e+000,
    -3.538199e-001,
    6.101836e-001,
    4.437780e+000,
    -1.559813e+001,
    -1.103222e+000,
    6.242039e-001,
    -3.091472e+000,
    2.174290e-001,
    -1.038230e+000,
    -1.213475e-001,
    1.547505e+000,
    5.893176e+000,
    1.368738e+000,
    1.663127e+000,
    -1.377130e-001,
    3.185279e+000,
    8.736453e-001,
    -1.101026e+000,
    -1.874907e-001,
    1.272667e+000,
    3.596524e+000,
    -5.007243e+000,
    -6.352483e-001,
    3.048985e-001,
    1.931613e+000,
    6.788844e-001,
    // albedo 1, turbidity 7
    -1.342753e+000,
    -4.384971e-001,
    -1.213491e+000,
    1.621399e+000,
    -1.551441e-001,
    5.614218e-001,
    2.591739e-002,
    2.958967e+000,
    5.782132e-001,
    -1.937684e+000,
    -1.066019e+000,
    1.913336e+000,
    -7.347719e-001,
    -5.916167e-001,
    1.587590e-001,
    1.092568e-001,
    -6.275002e-001,
    1.599071e-001,
    -9.302391e-001,
    1.486187e-001,
    -1.603835e+000,
    1.783713e-001,
    1.100461e+000,
    1.174181e+000,
    -1.602361e-001,
    7.868331e+000,
    1.468971e+000,
    -1.053631e+000,
    -3.727050e-001,
    1.114117e+000,
    -9.603286e-001,
    -1.062469e+001,
    -1.162140e+000,
    7.952797e-001,
    -4.478765e+000,
    -4.440862e-002,
    -1.083629e+000,
    -1.261405e-001,
    1.229344e+000,
    1.127825e+001,
    1.319010e-001,
    1.624729e+000,
    -2.825898e-001,
    3.661082e+000,
    1.036911e+000,
    -1.093950e+000,
    -2.067455e-001,
    1.258035e+000,
    7.548645e+000,
    -4.598387e+000,
    -8.944932e-001,
    3.292634e-001,
    1.311304e+000,
    6.291871e-001,
    // albedo 1, turbidity 8
    -1.385867e+000,
    -5.068139e-001,
    -1.486490e+000,
    1.969049e+000,
    -1.698025e-001,
    6.629167e-001,
    -5.289365e-006,
    2.760315e+000,
    8.644368e-001,
    -2.107367e+000,
    -1.175639e+000,
    2.313241e+000,
    -1.001653e+000,
    -4.843139e-001,
    1.124485e-001,
    3.901494e-005,
    -3.502469e-001,
    -3.204780e-001,
    -1.475244e+000,
    -2.833055e-001,
    -2.085824e+000,
    1.192563e+000,
    -7.645200e-001,
    8.380081e-001,
    2.203580e-001,
    7.157885e+000,
    1.753702e+000,
    -6.644372e-001,
    -2.549735e-001,
    1.600273e+000,
    -8.589034e+000,
    -6.144718e+000,
    -7.599731e-001,
    2.898370e-001,
    -5.770923e+000,
    -9.656242e-002,
    -1.211687e+000,
    -1.653494e-001,
    8.393400e-001,
    2.792988e+001,
    -3.395461e+000,
    9.933752e-001,
    -3.976877e-002,
    3.776659e+000,
    9.546526e-001,
    -1.063757e+000,
    -2.037563e-001,
    1.117207e+000,
    -1.252806e-003,
    -3.332330e+000,
    -6.971409e-001,
    3.388719e-001,
    1.311398e+000,
    6.635171e-001,
    // albedo 1, turbidity 9
    -1.678889e+000,
    -7.992295e-001,
    -2.421687e+000,
    2.871029e+000,
    -7.662842e-002,
    6.046208e-001,
    -7.598099e-006,
    2.002314e+000,
    9.001307e-001,
    -1.692144e+000,
    -8.804250e-001,
    3.060895e+000,
    -2.000009e+000,
    -3.183563e-001,
    8.385862e-002,
    -6.326713e-003,
    1.206639e+000,
    -3.369967e-001,
    -3.676795e+000,
    -1.719207e+000,
    -2.534697e+000,
    1.005285e+000,
    1.550407e-001,
    1.072910e+000,
    1.318094e-001,
    3.717018e+000,
    1.689191e+000,
    5.424542e-001,
    3.263528e-001,
    1.551055e+000,
    -3.841058e+000,
    -6.598996e+000,
    -1.201779e+000,
    3.530669e-001,
    -2.542945e+000,
    -6.482523e-002,
    -1.553849e+000,
    -4.576860e-001,
    9.324676e-001,
    1.950982e+001,
    -2.344516e+000,
    1.121020e+000,
    -1.221537e-001,
    7.285496e-001,
    9.582816e-001,
    -1.020650e+000,
    -2.215797e-001,
    1.009774e+000,
    -2.056855e-003,
    -2.740338e+000,
    -8.122355e-001,
    3.328967e-001,
    8.982766e-001,
    6.594676e-001,
    // albedo 1, turbidity 10
    -2.247360e+000,
    -1.221267e+000,
    -3.072346e+000,
    3.385139e+000,
    -4.387559e-002,
    5.084887e-001,
    -7.418833e-006,
    1.750107e+000,
    9.001401e-001,
    -1.248499e+000,
    -8.442718e-001,
    3.062611e+000,
    -2.020314e+000,
    -2.815341e-001,
    5.254745e-002,
    3.345008e-003,
    1.433225e+000,
    -2.835911e-001,
    -7.004119e+000,
    -2.927978e+000,
    -2.649852e+000,
    7.971894e-001,
    5.466893e-001,
    1.442667e+000,
    -6.063912e-002,
    2.806194e+000,
    1.547429e+000,
    1.434882e+000,
    9.114639e-002,
    1.170089e+000,
    3.512808e-002,
    -5.861915e+000,
    -1.411843e+000,
    5.400486e-001,
    -7.746522e-001,
    2.386984e-002,
    -1.559053e+000,
    -5.502302e-001,
    1.200396e+000,
    1.347741e+001,
    -2.344397e+000,
    8.868907e-001,
    -3.292661e-001,
    -1.362105e+000,
    9.217826e-001,
    -1.044436e+000,
    -2.360719e-001,
    7.054471e-001,
    -2.904518e-003,
    -2.092829e+000,
    -5.119668e-001,
    4.174861e-001,
    9.687435e-001,
    6.588427e-001,
};

double datasetRGBRad2[] =
{
    // albedo 0, turbidity 1
    1.590330e+000,
    1.355401e+000,
    1.151412e+000,
    1.359116e+001,
    5.857714e+000,
    8.090833e+000,
    // albedo 0, turbidity 2
    1.552540e+000,
    1.510040e+000,
    1.276413e-001,
    1.604643e+001,
    5.912162e+000,
    8.350009e+000,
    // albedo 0, turbidity 3
    1.470871e+000,
    1.880464e+000,
    -1.865398e+000,
    2.030808e+001,
    5.471461e+000,
    9.109834e+000,
    // albedo 0, turbidity 4
    1.356563e+000,
    2.373866e+000,
    -4.653245e+000,
    2.570922e+001,
    5.686009e+000,
    1.009480e+001,
    // albedo 0, turbidity 5
    1.244232e+000,
    2.851519e+000,
    -7.130942e+000,
    2.993449e+001,
    6.382120e+000,
    1.114578e+001,
    // albedo 0, turbidity 6
    1.173693e+000,
    3.120604e+000,
    -8.491886e+000,
    3.187393e+001,
    7.290615e+000,
    1.180066e+001,
    // albedo 0, turbidity 7
    1.091845e+000,
    3.368888e+000,
    -9.722083e+000,
    3.268508e+001,
    1.032424e+001,
    1.236508e+001,
    // albedo 0, turbidity 8
    9.858985e-001,
    3.500541e+000,
    -1.026328e+001,
    3.092956e+001,
    1.610881e+001,
    1.331222e+001,
    // albedo 0, turbidity 9
    8.864993e-001,
    3.172888e+000,
    -8.687550e+000,
    2.362161e+001,
    2.621851e+001,
    1.474967e+001,
    // albedo 0, turbidity 10
    7.946973e-001,
    2.189355e+000,
    -4.207953e+000,
    9.399091e+000,
    4.062849e+001,
    1.681753e+001,
    // albedo 1, turbidity 1
    1.711696e+000,
    1.657311e+000,
    9.328021e-001,
    1.317880e+001,
    1.506751e+001,
    1.863556e+001,
    // albedo 1, turbidity 2
    1.666968e+000,
    1.849993e+000,
    -2.088601e-001,
    1.586653e+001,
    1.486880e+001,
    1.940719e+001,
    // albedo 1, turbidity 3
    1.584846e+000,
    2.170022e+000,
    -2.019597e+000,
    1.970826e+001,
    1.490684e+001,
    2.045055e+001,
    // albedo 1, turbidity 4
    1.469412e+000,
    2.524017e+000,
    -4.197267e+000,
    2.365249e+001,
    1.664588e+001,
    2.134477e+001,
    // albedo 1, turbidity 5
    1.369714e+000,
    2.843548e+000,
    -6.059031e+000,
    2.634993e+001,
    1.881361e+001,
    2.232186e+001,
    // albedo 1, turbidity 6
    1.310477e+000,
    2.984444e+000,
    -6.831686e+000,
    2.682340e+001,
    2.123267e+001,
    2.259755e+001,
    // albedo 1, turbidity 7
    1.222552e+000,
    3.176523e+000,
    -7.731496e+000,
    2.671760e+001,
    2.484358e+001,
    2.336863e+001,
    // albedo 1, turbidity 8
    1.115781e+000,
    3.130635e+000,
    -7.581744e+000,
    2.336531e+001,
    3.171048e+001,
    2.413859e+001,
    // albedo 1, turbidity 9
    1.013181e+000,
    2.699342e+000,
    -5.602709e+000,
    1.500158e+001,
    4.217613e+001,
    2.515957e+001,
    // albedo 1, turbidity 10
    8.976323e-001,
    1.726948e+000,
    -1.296120e+000,
    1.183675e+000,
    5.503215e+001,
    2.643066e+001,
};

double datasetRGB3[] =
{
    // albedo 0, turbidity 1
    -1.372629e+000,
    -4.905585e-001,
    -4.100789e+001,
    4.122169e+001,
    -7.389360e-003,
    4.839359e-001,
    6.474757e-003,
    3.471755e+000,
    5.092936e-001,
    -1.523025e+000,
    -6.497084e-001,
    6.249857e+000,
    -5.662543e+000,
    -1.908402e-002,
    5.512810e-001,
    -2.181049e-005,
    2.507663e+000,
    4.339598e-001,
    -1.035567e+000,
    -7.478740e-002,
    9.221030e-001,
    -2.140047e+000,
    -2.374146e-002,
    3.795517e-001,
    -1.769134e-002,
    7.479831e+000,
    7.729303e-001,
    -1.271086e+000,
    -5.588190e-001,
    6.908023e-001,
    2.096832e+000,
    -2.453967e-001,
    1.410648e+000,
    4.475036e-002,
    -4.719115e+000,
    5.741186e-001,
    -9.712598e-001,
    -7.033926e-002,
    9.167274e-001,
    -9.502097e-001,
    3.004684e-001,
    4.547054e-001,
    -5.929017e-002,
    5.266196e+000,
    7.204135e-001,
    -1.087457e+000,
    -1.888896e-001,
    8.156686e-001,
    3.101712e-001,
    -2.155419e+000,
    1.422205e+000,
    9.692261e-002,
    3.122404e+000,
    4.999430e-001,
    // albedo 0, turbidity 2
    -1.425280e+000,
    -5.413508e-001,
    -3.454883e+001,
    3.481142e+001,
    -8.686975e-003,
    4.914268e-001,
    -2.479243e-006,
    3.239879e+000,
    6.094201e-001,
    -1.688557e+000,
    -8.070865e-001,
    7.018459e+000,
    -6.244574e+000,
    -2.149341e-002,
    3.993971e-001,
    1.252502e-002,
    1.630662e+000,
    1.097860e-001,
    -8.664152e-001,
    7.869125e-002,
    -5.236535e-001,
    -1.218960e+000,
    -2.059093e-002,
    6.684898e-001,
    -5.584112e-002,
    8.602299e+000,
    1.410496e+000,
    -1.319763e+000,
    -5.985323e-001,
    1.253918e+000,
    1.914706e+000,
    -3.216739e-001,
    9.011213e-001,
    1.324845e-001,
    -5.252749e+000,
    6.231252e-002,
    -9.706008e-001,
    -5.914059e-002,
    5.693150e-001,
    -1.175362e+000,
    5.221644e-001,
    7.518213e-001,
    -8.247655e-002,
    5.875635e+000,
    9.850863e-001,
    -1.085330e+000,
    -1.956105e-001,
    8.019605e-001,
    5.338101e-001,
    -3.423464e+000,
    1.110444e+000,
    1.507923e-001,
    2.864942e+000,
    4.999481e-001,
    // albedo 0, turbidity 3
    -1.431967e+000,
    -5.478935e-001,
    -3.286288e+001,
    3.305288e+001,
    -8.380797e-003,
    4.772050e-001,
    -3.044274e-006,
    3.289973e+000,
    5.976303e-001,
    -1.801361e+000,
    -9.315889e-001,
    5.391756e+000,
    -4.588592e+000,
    -2.040076e-002,
    4.144684e-001,
    1.814534e-002,
    1.051795e+000,
    1.145651e-001,
    -7.905357e-001,
    1.451332e-001,
    -1.605661e-001,
    -1.592174e+000,
    4.561348e-004,
    3.380323e-001,
    -7.770275e-002,
    8.775384e+000,
    1.489512e+000,
    -1.308575e+000,
    -5.539232e-001,
    9.184133e-001,
    2.011479e+000,
    -3.842472e-001,
    1.432274e+000,
    1.637153e-001,
    -4.408856e+000,
    5.272957e-002,
    -9.829872e-001,
    -8.183048e-002,
    4.464556e-001,
    -1.442716e+000,
    1.029641e+000,
    -6.991617e-002,
    8.702356e-003,
    5.706417e+000,
    9.116452e-001,
    -1.087130e+000,
    -2.038013e-001,
    7.260801e-001,
    9.164376e-001,
    -5.006183e+000,
    1.511271e+000,
    1.257134e-001,
    2.715439e+000,
    6.201652e-001,
    // albedo 0, turbidity 4
    -1.448662e+000,
    -5.799075e-001,
    -2.833268e+001,
    2.858023e+001,
    -9.134061e-003,
    4.404783e-001,
    -2.709026e-006,
    3.029357e+000,
    5.540071e-001,
    -2.061772e+000,
    -1.145190e+000,
    7.918478e+000,
    -7.212525e+000,
    -2.020760e-002,
    2.962715e-001,
    4.689670e-002,
    8.517209e-001,
    2.334587e-001,
    -6.413755e-001,
    1.780425e-001,
    -2.412919e+000,
    1.064484e+000,
    -1.949986e-002,
    6.769741e-001,
    -1.752760e-001,
    7.262714e+000,
    1.325869e+000,
    -1.304871e+000,
    -3.975581e-001,
    1.219002e+000,
    7.285178e-001,
    -2.710105e-001,
    7.779727e-001,
    3.247139e-001,
    -8.818168e-001,
    1.839517e-001,
    -1.001104e+000,
    -1.994801e-001,
    3.676742e-001,
    -1.409737e+000,
    2.901555e-001,
    2.506940e-001,
    2.468899e-003,
    3.398923e+000,
    8.584645e-001,
    -1.111552e+000,
    -2.487204e-001,
    7.410842e-001,
    1.703749e+000,
    -5.007855e+000,
    1.057763e+000,
    1.354511e-001,
    2.088715e+000,
    6.600013e-001,
    // albedo 0, turbidity 5
    -1.547227e+000,
    -6.679466e-001,
    -1.861465e+001,
    1.884045e+001,
    -1.242210e-002,
    4.157339e-001,
    -2.432805e-006,
    2.812423e+000,
    5.446957e-001,
    -2.043890e+000,
    -1.149081e+000,
    2.304118e+000,
    -1.715757e+000,
    -2.433628e-002,
    2.816836e-001,
    7.185458e-002,
    1.064860e+000,
    2.706789e-001,
    -9.040720e-001,
    -8.274472e-002,
    -2.555676e-001,
    -6.326215e-001,
    -2.770880e-002,
    6.676024e-001,
    -2.513532e-001,
    5.903839e+000,
    1.241452e+000,
    -1.000013e+000,
    -1.010774e-001,
    3.699166e-001,
    8.774526e-001,
    -3.042007e-001,
    6.951053e-001,
    4.361813e-001,
    6.793421e-001,
    2.573892e-001,
    -1.171332e+000,
    -3.768188e-001,
    3.701377e-001,
    -1.470757e+000,
    5.525942e-001,
    2.991456e-002,
    1.581823e-002,
    2.365233e+000,
    8.214514e-001,
    -1.068667e+000,
    -2.326330e-001,
    6.725059e-001,
    2.243733e+000,
    -4.614370e+000,
    1.033677e+000,
    1.376291e-001,
    2.013334e+000,
    6.865304e-001,
    // albedo 0, turbidity 6
    -1.592991e+000,
    -7.246948e-001,
    -2.598204e+001,
    2.621960e+001,
    -8.365176e-003,
    4.207571e-001,
    -2.742772e-006,
    2.623735e+000,
    5.873190e-001,
    -2.271349e+000,
    -1.280884e+000,
    6.308739e+000,
    -5.758350e+000,
    -1.977049e-002,
    3.671835e-001,
    6.698038e-002,
    1.150597e+000,
    1.759218e-001,
    -6.368620e-001,
    -7.436052e-003,
    -2.230026e+000,
    1.640997e+000,
    -1.548497e-002,
    3.145331e-001,
    -2.492644e-001,
    5.083843e+000,
    1.260215e+000,
    -1.177925e+000,
    -9.628114e-002,
    3.051152e-001,
    -3.749544e-002,
    -2.713209e-001,
    1.164226e+000,
    4.559969e-001,
    2.175429e+000,
    2.874284e-001,
    -1.078500e+000,
    -3.801779e-001,
    4.788906e-001,
    -4.795969e-001,
    5.977621e-001,
    -4.488535e-001,
    3.386874e-002,
    1.538143e+000,
    8.062054e-001,
    -1.108028e+000,
    -2.596892e-001,
    5.162202e-001,
    1.557081e+000,
    -4.265039e+000,
    1.182535e+000,
    1.563762e-001,
    2.095084e+000,
    6.883383e-001,
    // albedo 0, turbidity 7
    -1.668427e+000,
    -7.908511e-001,
    -2.779690e+001,
    2.799746e+001,
    -7.186935e-003,
    3.757766e-001,
    -3.326858e-006,
    2.563421e+000,
    5.439687e-001,
    -2.156175e+000,
    -1.220004e+000,
    3.585732e+000,
    -3.235988e+000,
    -1.086239e-002,
    1.846143e-001,
    1.046017e-001,
    1.234427e+000,
    2.842191e-001,
    -1.117051e+000,
    -4.101627e-001,
    -8.463730e-001,
    7.671472e-001,
    -2.226609e-002,
    8.574943e-001,
    -3.434124e-001,
    4.475715e+000,
    1.154824e+000,
    -7.444840e-001,
    2.312078e-001,
    -5.393724e-001,
    1.574213e-001,
    -1.763914e-001,
    2.751692e-001,
    5.564200e-001,
    2.217672e+000,
    3.483932e-001,
    -1.273036e+000,
    -5.275562e-001,
    4.902512e-001,
    -4.498436e-002,
    4.339366e-001,
    2.386682e-001,
    2.380879e-002,
    1.413444e+000,
    7.855923e-001,
    -1.084192e+000,
    -2.936753e-001,
    4.719432e-001,
    1.384436e+000,
    -3.257789e+000,
    6.119543e-001,
    1.681884e-001,
    1.650441e+000,
    6.936631e-001,
    // albedo 0, turbidity 8
    -1.848490e+000,
    -9.512670e-001,
    -3.005251e+001,
    3.024315e+001,
    -5.635304e-003,
    3.447780e-001,
    -2.782999e-006,
    2.309422e+000,
    5.643559e-001,
    -2.300008e+000,
    -1.252335e+000,
    -1.218876e+000,
    1.493730e+000,
    -6.107100e-003,
    7.974860e-002,
    1.023449e-001,
    1.505934e+000,
    2.360948e-001,
    -1.483705e+000,
    -8.547575e-001,
    -7.797146e-001,
    6.447971e-001,
    -2.678052e-002,
    1.091263e+000,
    -3.344889e-001,
    3.830416e+000,
    1.189425e+000,
    -5.348005e-001,
    3.982733e-001,
    -4.071573e-001,
    3.265569e-001,
    -8.658789e-002,
    -2.370892e-001,
    5.369097e-001,
    1.478279e+000,
    3.143303e-001,
    -1.320401e+000,
    -6.043247e-001,
    3.019196e-001,
    -7.732911e-002,
    4.768381e-001,
    6.745764e-001,
    3.694098e-002,
    1.158234e+000,
    8.169056e-001,
    -1.101040e+000,
    -3.420019e-001,
    3.775661e-001,
    1.769338e+000,
    -2.990515e+000,
    1.649529e-001,
    1.970125e-001,
    1.453355e+000,
    6.759757e-001,
    // albedo 0, turbidity 9
    -2.251946e+000,
    -1.229349e+000,
    -3.271808e+001,
    3.283114e+001,
    -4.252027e-003,
    3.372289e-001,
    -3.001937e-006,
    2.154046e+000,
    5.842674e-001,
    -1.867834e+000,
    -9.531252e-001,
    -1.229365e+001,
    1.269149e+001,
    -6.844772e-003,
    1.185107e-001,
    7.539587e-002,
    1.846381e+000,
    1.899412e-001,
    -3.398629e+000,
    -2.180862e+000,
    2.335213e+000,
    -3.382823e+000,
    -8.613985e-003,
    8.431602e-001,
    -2.393567e-001,
    3.112460e+000,
    1.218556e+000,
    5.708381e-001,
    9.406030e-001,
    -6.890113e-001,
    2.746233e+000,
    -5.772068e-002,
    1.096005e-001,
    3.491978e-001,
    7.281453e-001,
    3.212049e-001,
    -1.705909e+000,
    -8.517224e-001,
    1.131160e-001,
    -2.141434e+000,
    4.274043e-001,
    3.397600e-001,
    1.786490e-001,
    9.026101e-001,
    7.882800e-001,
    -1.012865e+000,
    -3.495551e-001,
    3.369038e-001,
    3.724205e+000,
    -3.089586e+000,
    1.266964e-001,
    1.461790e-001,
    1.170199e+000,
    6.931052e-001,
    // albedo 0, turbidity 10
    -2.890318e+000,
    -1.665573e+000,
    -3.493756e+001,
    3.500369e+001,
    -2.984251e-003,
    2.622419e-001,
    -4.259360e-006,
    1.947681e+000,
    6.905752e-001,
    -1.956022e+000,
    -1.062900e+000,
    -1.919714e+001,
    1.975164e+001,
    -8.865396e-003,
    2.165540e-001,
    5.475637e-002,
    1.761134e+000,
    3.164249e-003,
    -5.612198e+000,
    -3.101371e+000,
    4.098034e+000,
    -6.144001e+000,
    9.944958e-003,
    2.905472e-001,
    -1.707110e-001,
    3.199107e+000,
    1.337660e+000,
    8.353756e-001,
    4.855943e-001,
    -1.243589e+000,
    5.147385e+000,
    -7.013963e-002,
    9.380410e-001,
    2.335714e-001,
    1.727744e-001,
    2.802696e-001,
    -1.524329e+000,
    -7.388547e-001,
    3.259025e-001,
    -4.050634e+000,
    4.058549e-001,
    -2.591384e-001,
    1.898299e-001,
    3.556071e-001,
    7.884126e-001,
    -1.070371e+000,
    -4.207858e-001,
    1.739862e-001,
    5.293410e+000,
    -3.136757e+000,
    2.323856e-001,
    1.673706e-001,
    1.007227e+000,
    6.844287e-001,
    // albedo 1, turbidity 1
    -1.341720e+000,
    -4.834889e-001,
    -4.633447e+001,
    4.682148e+001,
    -6.137296e-003,
    4.599216e-001,
    7.047323e-003,
    2.895798e+000,
    4.999398e-001,
    -1.529104e+000,
    -6.498631e-001,
    1.534103e+001,
    -1.450675e+001,
    -1.531439e-002,
    3.280082e-001,
    1.682926e-002,
    1.901587e+000,
    5.013227e-001,
    -1.014776e+000,
    -1.454495e-001,
    -4.071085e+000,
    2.954982e+000,
    -2.630348e-002,
    5.681531e-001,
    -3.016505e-002,
    6.773854e+000,
    5.003504e-001,
    -1.172413e+000,
    -4.026320e-001,
    2.960428e+000,
    2.020710e-001,
    -2.004947e-001,
    9.375572e-001,
    5.998168e-002,
    -4.945934e+000,
    4.502898e-001,
    -9.898161e-001,
    -5.772814e-002,
    4.470024e-001,
    -5.786656e-001,
    1.158168e-001,
    3.468040e-001,
    -5.043360e-002,
    6.867947e+000,
    8.012363e-001,
    -1.085111e+000,
    -1.882675e-001,
    1.223748e+000,
    3.565495e-001,
    -3.688357e+000,
    5.653723e-001,
    6.727646e-002,
    2.690130e+000,
    4.999400e-001,
    // albedo 1, turbidity 2
    -1.389119e+000,
    -5.290250e-001,
    -4.055774e+001,
    4.105972e+001,
    -7.062577e-003,
    4.560060e-001,
    -1.736334e-006,
    2.775512e+000,
    6.671455e-001,
    -1.584641e+000,
    -7.200619e-001,
    1.248067e+001,
    -1.156028e+001,
    -1.659568e-002,
    3.050029e-001,
    1.099895e-002,
    1.438927e+000,
    -2.138015e-002,
    -9.826068e-001,
    -8.887254e-002,
    -2.960031e+000,
    1.808816e+000,
    -2.478159e-002,
    6.035733e-001,
    -4.868441e-002,
    7.347705e+000,
    1.584739e+000,
    -1.150423e+000,
    -4.073793e-001,
    2.412991e+000,
    4.870840e-001,
    -2.337902e-001,
    8.295114e-001,
    1.129914e-001,
    -5.150045e+000,
    -9.016643e-002,
    -1.016933e+000,
    -6.311501e-002,
    5.218937e-001,
    -5.716430e-001,
    1.250993e-001,
    3.601524e-001,
    -5.497586e-002,
    7.060139e+000,
    1.018333e+000,
    -1.073151e+000,
    -1.845444e-001,
    1.155394e+000,
    3.004486e-001,
    -3.431711e+000,
    4.657031e-001,
    9.401223e-002,
    2.688620e+000,
    4.999544e-001,
    // albedo 1, turbidity 3
    -1.391257e+000,
    -5.365815e-001,
    -4.255881e+001,
    4.299132e+001,
    -5.838466e-003,
    4.229134e-001,
    -2.760038e-006,
    2.775531e+000,
    6.234597e-001,
    -1.780062e+000,
    -9.228880e-001,
    1.376172e+001,
    -1.260946e+001,
    -1.507526e-002,
    3.117435e-001,
    2.205045e-002,
    6.093731e-001,
    3.463446e-002,
    -7.388169e-001,
    1.275670e-001,
    -3.999528e+000,
    2.223993e+000,
    -1.856853e-002,
    5.439310e-001,
    -8.834054e-002,
    8.037139e+000,
    1.645951e+000,
    -1.322387e+000,
    -5.320143e-001,
    2.659359e+000,
    1.086712e+000,
    -2.129712e-001,
    8.704649e-001,
    1.800315e-001,
    -4.967241e+000,
    -1.383720e-001,
    -9.378288e-001,
    -1.599895e-002,
    3.607555e-001,
    -1.980561e+000,
    3.791456e-001,
    1.212268e-001,
    -2.845992e-002,
    6.825542e+000,
    1.059139e+000,
    -1.100832e+000,
    -2.172313e-001,
    1.211561e+000,
    2.002721e+000,
    -5.010011e+000,
    5.717583e-001,
    6.777702e-002,
    2.160006e+000,
    5.676392e-001,
    // albedo 1, turbidity 4
    -1.409373e+000,
    -5.708751e-001,
    -3.034974e+001,
    3.079809e+001,
    -7.280715e-003,
    3.723304e-001,
    -2.436279e-006,
    2.577348e+000,
    5.913377e-001,
    -1.954312e+000,
    -1.116510e+000,
    5.399148e+000,
    -4.299553e+000,
    -1.724739e-002,
    3.742824e-001,
    4.187077e-002,
    1.044883e-001,
    1.232727e-001,
    -6.772215e-001,
    2.001396e-001,
    -3.670523e-001,
    -1.014628e+000,
    -3.497152e-003,
    4.099858e-001,
    -1.584633e-001,
    7.750400e+000,
    1.514559e+000,
    -1.291600e+000,
    -4.977437e-001,
    9.641914e-001,
    1.562420e+000,
    -3.227782e-001,
    9.055427e-001,
    3.046444e-001,
    -3.385619e+000,
    9.546291e-003,
    -9.750857e-001,
    -8.770560e-002,
    9.054256e-001,
    -1.429236e+000,
    8.974777e-001,
    -1.217961e-001,
    -5.194608e-002,
    4.909409e+000,
    9.589153e-001,
    -1.088007e+000,
    -1.959301e-001,
    9.745799e-001,
    1.260761e+000,
    -5.008864e+000,
    7.271248e-001,
    1.096661e-001,
    2.717295e+000,
    6.340731e-001,
    // albedo 1, turbidity 5
    -1.456050e+000,
    -6.223072e-001,
    -2.228088e+001,
    2.269604e+001,
    -9.340812e-003,
    4.118308e-001,
    -2.418083e-006,
    2.442117e+000,
    5.589638e-001,
    -2.176449e+000,
    -1.302416e+000,
    2.222836e+000,
    -1.222730e+000,
    -1.728051e-002,
    1.323513e-001,
    7.027731e-002,
    4.835745e-002,
    2.093351e-001,
    -5.789641e-001,
    2.215407e-001,
    2.142291e-001,
    -1.201725e+000,
    -1.185728e-002,
    8.122982e-001,
    -2.380420e-001,
    6.706841e+000,
    1.404146e+000,
    -1.307463e+000,
    -4.515174e-001,
    6.447827e-001,
    1.223841e+000,
    -2.902391e-001,
    4.986588e-001,
    4.073652e-001,
    -1.706696e+000,
    1.060885e-001,
    -9.698678e-001,
    -1.307094e-001,
    9.389347e-001,
    -1.522852e+000,
    7.768797e-001,
    -1.368595e-001,
    -3.857426e-002,
    3.676935e+000,
    8.980966e-001,
    -1.104349e+000,
    -2.380323e-001,
    1.047043e+000,
    1.865421e+000,
    -5.011664e+000,
    7.014954e-001,
    9.622701e-002,
    1.891360e+000,
    6.687354e-001,
    // albedo 1, turbidity 6
    -1.502249e+000,
    -6.724523e-001,
    -2.888092e+001,
    2.930360e+001,
    -6.685766e-003,
    3.685464e-001,
    -2.469442e-006,
    2.310797e+000,
    5.566754e-001,
    -2.217125e+000,
    -1.364924e+000,
    4.048243e+000,
    -3.111333e+000,
    -1.317747e-002,
    1.921948e-001,
    8.627702e-002,
    1.981769e-003,
    2.213689e-001,
    -6.215757e-001,
    1.687995e-001,
    -5.949131e-001,
    -1.551293e-001,
    3.356129e-004,
    6.897657e-001,
    -2.855053e-001,
    6.271042e+000,
    1.363084e+000,
    -1.216317e+000,
    -3.489429e-001,
    7.566226e-001,
    5.409809e-001,
    -2.830843e-001,
    6.191825e-001,
    4.755163e-001,
    -9.131387e-001,
    1.383909e-001,
    -1.030437e+000,
    -2.034064e-001,
    8.335995e-001,
    -1.050947e+000,
    8.689093e-001,
    -3.672310e-001,
    -4.056183e-002,
    3.111269e+000,
    8.856842e-001,
    -1.078984e+000,
    -2.070549e-001,
    9.683145e-001,
    1.497022e+000,
    -5.007653e+000,
    7.702541e-001,
    1.285822e-001,
    2.225188e+000,
    6.587911e-001,
    // albedo 1, turbidity 7
    -1.559291e+000,
    -7.374039e-001,
    -3.596311e+001,
    3.634470e+001,
    -4.667132e-003,
    3.277964e-001,
    -2.487945e-006,
    2.215652e+000,
    5.764681e-001,
    -2.356929e+000,
    -1.444755e+000,
    6.244526e+000,
    -5.540162e+000,
    -8.794510e-003,
    1.792100e-001,
    9.578517e-002,
    3.737676e-001,
    1.922194e-001,
    -6.589752e-001,
    -2.926910e-002,
    -1.831779e+000,
    1.869962e+000,
    -2.030095e-003,
    7.552089e-001,
    -3.168157e-001,
    4.632196e+000,
    1.294054e+000,
    -1.161046e+000,
    -1.472506e-001,
    6.494138e-001,
    -8.327174e-001,
    -2.320724e-001,
    3.391212e-001,
    5.269637e-001,
    9.376341e-001,
    2.458573e-001,
    -1.034427e+000,
    -3.062504e-001,
    8.975634e-001,
    3.203531e-001,
    8.565142e-001,
    -1.250162e-001,
    -4.094017e-002,
    1.861304e+000,
    8.223468e-001,
    -1.109954e+000,
    -2.740277e-001,
    1.063811e+000,
    7.077398e-001,
    -4.695734e+000,
    5.621696e-001,
    1.248956e-001,
    1.297723e+000,
    6.789720e-001,
    // albedo 1, turbidity 8
    -1.788293e+000,
    -9.368751e-001,
    -4.382980e+001,
    4.424963e+001,
    -3.652530e-003,
    3.094331e-001,
    -2.810503e-006,
    1.904402e+000,
    5.861599e-001,
    -2.268206e+000,
    -1.312676e+000,
    2.863082e+000,
    -2.373727e+000,
    -5.144980e-003,
    1.711072e-001,
    9.316041e-002,
    9.309598e-001,
    1.791683e-001,
    -1.376966e+000,
    -7.418582e-001,
    -1.349589e+000,
    1.563419e+000,
    -3.124219e-003,
    6.967139e-001,
    -3.061887e-001,
    3.602731e+000,
    1.255669e+000,
    -6.017540e-001,
    2.815928e-001,
    5.424052e-001,
    -6.885450e-001,
    -1.620001e-001,
    2.980046e-001,
    4.995571e-001,
    7.371203e-001,
    2.812466e-001,
    -1.278853e+000,
    -5.245326e-001,
    7.870520e-001,
    3.125067e-001,
    7.748105e-001,
    -7.788581e-002,
    3.490956e-003,
    1.283748e+000,
    8.130190e-001,
    -1.050930e+000,
    -2.786331e-001,
    1.056344e+000,
    1.053002e+000,
    -4.047789e+000,
    4.432174e-001,
    1.169077e-001,
    9.532621e-001,
    6.806764e-001,
    // albedo 1, turbidity 9
    -2.084927e+000,
    -1.203954e+000,
    -4.881638e+001,
    4.920160e+001,
    -2.896045e-003,
    2.882977e-001,
    -3.073517e-006,
    1.702211e+000,
    6.374180e-001,
    -2.328567e+000,
    -1.238023e+000,
    -1.891019e+000,
    2.451520e+000,
    -5.847581e-003,
    2.084702e-001,
    7.848130e-002,
    1.211048e+000,
    8.095008e-002,
    -2.634632e+000,
    -1.789460e+000,
    -1.370558e-001,
    -3.326435e-001,
    2.783737e-003,
    5.239451e-001,
    -2.548881e-001,
    2.896327e+000,
    1.324116e+000,
    6.882616e-002,
    5.997821e-001,
    1.535398e-001,
    1.375209e+000,
    -1.267285e-001,
    4.239743e-001,
    4.013122e-001,
    1.794675e-001,
    2.395382e-001,
    -1.430918e+000,
    -6.439041e-001,
    8.325980e-001,
    -1.705612e+000,
    7.236426e-001,
    -5.567593e-002,
    6.408718e-002,
    6.836524e-001,
    8.388887e-001,
    -1.037956e+000,
    -3.215402e-001,
    9.457349e-001,
    3.178114e+000,
    -4.152156e+000,
    2.230992e-001,
    1.156198e-001,
    7.606223e-001,
    6.656923e-001,
    // albedo 1, turbidity 10
    -2.967314e+000,
    -1.728778e+000,
    -3.730988e+001,
    3.755578e+001,
    -2.588835e-003,
    2.927966e-001,
    -3.935038e-006,
    1.592161e+000,
    6.868694e-001,
    -2.123311e+000,
    -1.175148e+000,
    -1.314988e+001,
    1.386882e+001,
    -7.828537e-003,
    1.852026e-001,
    5.481038e-002,
    1.294309e+000,
    2.428177e-002,
    -5.443597e+000,
    -3.156344e+000,
    2.110838e+000,
    -3.421556e+000,
    1.181890e-002,
    1.196951e-001,
    -1.742902e-001,
    2.404353e+000,
    1.272805e+000,
    1.029898e+000,
    5.912521e-001,
    -3.983531e-001,
    3.286069e+000,
    -9.252065e-002,
    1.331381e+000,
    2.560642e-001,
    8.001754e-001,
    3.624178e-001,
    -1.547574e+000,
    -7.881604e-001,
    1.020902e+000,
    -2.897069e+000,
    5.213470e-001,
    -9.242315e-001,
    1.185594e-001,
    -1.150721e+000,
    7.317211e-001,
    -9.621043e-001,
    -1.991406e-001,
    6.531287e-001,
    3.925839e+000,
    -3.596904e+000,
    6.317332e-001,
    1.531334e-001,
    1.457846e+000,
    6.966285e-001,
};

double datasetRGBRad3[] =
{
    // albedo 0, turbidity 1
    9.926518e-001,
    1.999494e+000,
    -4.136109e+000,
    1.856270e+001,
    1.351028e+001,
    1.390238e+001,
    // albedo 0, turbidity 2
    9.634366e-001,
    2.119694e+000,
    -4.614523e+000,
    1.919701e+001,
    1.376644e+001,
    1.418731e+001,
    // albedo 0, turbidity 3
    9.446537e-001,
    2.171610e+000,
    -4.915556e+000,
    1.918240e+001,
    1.537135e+001,
    1.400530e+001,
    // albedo 0, turbidity 4
    9.073074e-001,
    2.330536e+000,
    -5.577596e+000,
    1.961615e+001,
    1.688365e+001,
    1.446955e+001,
    // albedo 0, turbidity 5
    8.739124e-001,
    2.388682e+000,
    -5.842995e+000,
    1.923265e+001,
    1.887735e+001,
    1.485698e+001,
    // albedo 0, turbidity 6
    8.563688e-001,
    2.391534e+000,
    -5.769133e+000,
    1.828709e+001,
    2.097209e+001,
    1.469587e+001,
    // albedo 0, turbidity 7
    8.270533e-001,
    2.342790e+000,
    -5.558071e+000,
    1.684993e+001,
    2.356498e+001,
    1.505975e+001,
    // albedo 0, turbidity 8
    7.908339e-001,
    2.190341e+000,
    -4.852571e+000,
    1.374862e+001,
    2.806846e+001,
    1.548444e+001,
    // albedo 0, turbidity 9
    7.403619e-001,
    1.783998e+000,
    -2.983854e+000,
    7.622563e+000,
    3.507610e+001,
    1.615805e+001,
    // albedo 0, turbidity 10
    6.840111e-001,
    1.154457e+000,
    -2.393830e-001,
    -7.896893e-001,
    4.282765e+001,
    1.779469e+001,
    // albedo 1, turbidity 1
    1.168300e+000,
    1.860993e+000,
    -2.129074e+000,
    1.251952e+001,
    3.032499e+001,
    2.938716e+001,
    // albedo 1, turbidity 2
    1.150338e+000,
    1.918813e+000,
    -2.413527e+000,
    1.274862e+001,
    3.087134e+001,
    2.951432e+001,
    // albedo 1, turbidity 3
    1.114719e+000,
    1.964689e+000,
    -2.625423e+000,
    1.247837e+001,
    3.237949e+001,
    2.943596e+001,
    // albedo 1, turbidity 4
    1.077948e+000,
    2.006292e+000,
    -2.846934e+000,
    1.190195e+001,
    3.459293e+001,
    2.937492e+001,
    // albedo 1, turbidity 5
    1.035143e+000,
    1.986681e+000,
    -2.752584e+000,
    1.060972e+001,
    3.722185e+001,
    2.918594e+001,
    // albedo 1, turbidity 6
    1.015992e+000,
    1.992054e+000,
    -2.812626e+000,
    1.001416e+001,
    3.847300e+001,
    2.924624e+001,
    // albedo 1, turbidity 7
    9.756887e-001,
    1.939897e+000,
    -2.533281e+000,
    8.319176e+000,
    4.083907e+001,
    2.925586e+001,
    // albedo 1, turbidity 8
    9.264164e-001,
    1.716454e+000,
    -1.597044e+000,
    4.739725e+000,
    4.507683e+001,
    2.878915e+001,
    // albedo 1, turbidity 9
    8.595191e-001,
    1.346034e+000,
    -2.801895e-002,
    -6.582906e-001,
    5.017523e+001,
    2.852953e+001,
    // albedo 1, turbidity 10
    7.754116e-001,
    7.709245e-001,
    2.200201e+000,
    -7.487661e+000,
    5.436622e+001,
    2.893432e+001,
};

double* datasetsRGB[] =
{
    datasetRGB1,
    datasetRGB2,
    datasetRGB3
};

double* datasetsRGBRad[] =
{
    datasetRGBRad1,
    datasetRGBRad2,
    datasetRGBRad3
};
