import numpy as np

cur_scale = 1
downsample_scale = 64

s_block_size = 1024
t_block_size = 256


twill_config = {
    "data_dir": "./",
    "tmp_dir": "./",

    "scene_filename": ("lobe_%dx" % cur_scale) + ".xml",
    "scene_filename_low": ("lobe_%dx" % downsample_scale) + ".xml",

    # angular
    "s_xy_reso": 1,
    "s_block_size": s_block_size,

    # spatial
    "t_xy_reso": 4,
    "t_block_size": t_block_size,

    # bsdf simulator parameters
    "wi_reso": 15,
    "wo_reso": 15,

    "min_depth": 1,
    "max_depth": 10,
    "shadow_option": 2,

    "s_sqrt_samples_per_block": 1000,

    "t_sqrt_samples_per_block": 50,
    "t_4D_samples": 4000,

    "s_high_res_dir": "eff_brdf/gi_rLobes_{:d}x_blocksize_{:d}".format(cur_scale, s_block_size),
    "s_low_res_dir": "eff_brdf/gi_rLobes_{:d}x_blocksize_{:d}".format(downsample_scale, s_block_size),
    "t_high_res_dir": "eff_brdf/gi_albedo_{:d}x_blocksize_{:d}".format(cur_scale, t_block_size),
    "t_low_res_dir": "eff_brdf/gi_albedo_{:d}x_blocksize_{:d}".format(downsample_scale, t_block_size),

    "s_res_filename_prefix": "rLobe_path_",
    "t_res_filename_prefix": "albedo",

    "s_scale_filename": "S",
    "t_scale_filename": "T",

    # fixed according to the scene file
    "tile_x": 4,
    "tile_y": 4,
    "x_scale": 13.12,
    "y_scale": 8.96,
}
