import numpy as np


def squareToDisk(u, v):
    r1 = 2.0 * u - 1.0
    r2 = 2.0 * v - 1.0

    if r1 == 0 and r2 == 0:
        r = 0
        phi = 0
    elif r1 * r1 > r2 * r2:
        r = r1
        phi = (np.pi * 0.25) * (r2 / r1)
    else:
        r = r2
        phi = (np.pi * 0.5) - (r1 / r2) * (np.pi * 0.25)

    x = r * np.cos(phi)
    y = r * np.sin(phi)
    return x, y


def diskToSquare(x, y):
    r = np.sqrt(x * x + y * y)
    phi = np.arctan2(y, x)
    if phi < np.pi * 0.25:
        phi += np.pi * 2.0
    if phi < np.pi * 0.25:
        a = r
        b = phi * a / (np.pi * 0.25)
    elif phi < np.pi * 0.75:
        b = r
        a = -(phi - np.pi * 0.5) * b / (np.pi * 0.25)
    elif phi < 1.25 * np.pi:
        a = -r
        b = (phi - np.pi) * a / (np.pi * 0.25)
    else:
        b = -r
        a = -(phi - np.pi * 1.5) * b / (np.pi * 0.25)
    u = (a + 1.0) * 0.5
    v = (b + 1.0) * 0.5
    return u, v


def squareToHemisphere(u, v):
    x, y = squareToDisk(u, v)
    r2 = x * x + y * y
    tmp = np.sqrt(2.0 - r2)
    return x * tmp, y * tmp, 1.0 - r2


def hemisphereToSquare(dx, dy, dz):
    r2 = 1.0 - dz
    tmp = np.sqrt(2.0 - r2)
    x = dx / tmp
    y = dy / tmp
    return diskToSquare(x, y)


def squareToCosineHemisphere(u, v):
    x, y = squareToDisk(u, v)
    z = np.sqrt(max(0.0, 1.0 - x * x - y * y))
    z = max(z, 1e-8)
    return x, y, z
