%{
    @author: Fujun Luan
    @email : fl356@cornell.edu
%}

function params = ParseConfig(config_fn)
    fid = fopen(config_fn, 'r');
    tline = fgetl(fid);
    while ischar(tline)      
       colon_matches = strfind(tline, ':');
       if isempty(colon_matches)
           tline = fgetl(fid);
           continue;
       end
       
       C = strsplit(tline);
       if length(C) < 2
           tline = fgetl(fid);
           continue;
       end
       
       p_name = C{1};
       
       if strcmp(p_name, 'ply_num:')
           params.ply_num = int32(str2double(C{2}));
       elseif strcmp(p_name, 'fiber_num:')
           params.fiber_num = int32(str2double(C{2}));
       elseif strcmp(p_name, 'aabb_min:') 
           min_vec_str = C{2}(1, 2:end-1);
           min_vec = strsplit(min_vec_str, ',');
           params.aabb_min = [str2double(min_vec{1}),str2double(min_vec{2}),str2double(min_vec{3})];
       elseif strcmp(p_name, 'aabb_max:')
           max_vec_str = C{2}(1, 2:end-1);
           max_vec = strsplit(max_vec_str, ',');
           params.aabb_max = [str2double(max_vec{1}),str2double(max_vec{2}),str2double(max_vec{3})];
       elseif strcmp(p_name, 'z_step_size:')
           params.z_step_size = str2double(C{2});
       elseif strcmp(p_name, 'z_step_num:') 
           params.z_step_num = int32(str2double(C{2}));
       elseif strcmp(p_name, 'yarn_clock_wise:')
           params.yarn_clock_wise = int32(str2double(C{2}));
       elseif strcmp(p_name, 'fiber_clock_wise:')
           params.fiber_clock_wise = int32(str2double(C{2}));
       elseif strcmp(p_name, 'yarn_alpha:') 
           params.yarn_alpha = str2double(C{2});
       elseif strcmp(p_name, 'alpha:')
           params.alpha = str2double(C{2});
       elseif strcmp(p_name, 'yarn_radius:')
           params.yarn_radius = str2double(C{2});
       elseif strcmp(p_name, 'ellipse_long:')
           params.ellipse_long = str2double(C{2});
       elseif strcmp(p_name, 'ellipse_short:')
           params.ellipse_short = str2double(C{2});
       elseif strcmp(p_name, 'epsilon:')
           params.epsilon = str2double(C{2});
       elseif strcmp(p_name, 'beta:')
           params.beta = str2double(C{2});
       elseif strcmp(p_name, 'R_max:')
           params.R_max = str2double(C{2});
       elseif strcmp(p_name, 'use_migration:')
           params.use_migration = int32(str2double(C{2}));
       elseif strcmp(p_name, 's_i:')
           params.s_i = str2double(C{2});
       elseif strcmp(p_name, 'rho_min:')
           params.rho_min = str2double(C{2});
       elseif strcmp(p_name, 'rho_max:')
           params.rho_max = str2double(C{2});
       elseif strcmp(p_name, 'use_flyaways:')
           params.use_flyaways = int32(str2double(C{2}));
       elseif strcmp(p_name, 'flyaway_hair_density:')
           params.flyaway_hair_density = str2double(C{2});
       elseif strcmp(p_name, 'flyaway_hair_ze:')
           params.flyaway_hair_ze = [str2double(C{2}) str2double(C{3})];
       elseif strcmp(p_name, 'flyaway_hair_r0:')
           params.flyaway_hair_r0 = [str2double(C{2}) str2double(C{3})];
       elseif strcmp(p_name, 'flyaway_hair_re:')
           params.flyaway_hair_re = [str2double(C{2}) str2double(C{3})];
       elseif strcmp(p_name, 'flyaway_hair_pe:')
           params.flyaway_hair_pe = [str2double(C{2}) str2double(C{3})];
       elseif strcmp(p_name, 'flyaway_loop_density:')
           params.flyaway_loop_density = str2double(C{2});
       elseif strcmp(p_name, 'flyaway_loop_r1:')
           params.flyaway_loop_r1 = [str2double(C{2}) str2double(C{3})];
       end
       
       tline = fgetl(fid);
    end
    
    fclose(fid);
end