function addAnimation(id, height, start, end, fps, interval, files) {
    'use strict'

    var nframes = (end - start)/interval;
    var imgs = new Array(nframes);
    var totLoaded = 0;

    for ( var i = start; i < end; i+=interval ) {
        var j = (i - start)/interval;
        imgs[j] = new Image();
        imgs[j].onload = function() {
            if ( ++totLoaded == nframes ) {
                var canvasId = id + "_canvas";
                $("#" + id).css("background-image", "none").css("height", "auto")
                           .append("<canvas id='" + canvasId + "'></canvas>");
                var canvasObj = $("#" + canvasId);
                var ctx = canvasObj[0].getContext("2d");

                var h = height, scl = height/imgs[0].height;
                var w = imgs[0].width*scl;

                canvasObj.attr("width", w);
                canvasObj.attr("height", h);
                ctx.scale(scl, scl);

                canvasObj.css("display", "block");
                canvasObj.css("cursor", "pointer");
                ctx.drawImage(imgs[0], 0, 0);

                var playing = false;
                var curFrame = 0;
                var timer = null;
                canvasObj.click(function() {
                    if ( !playing ) {
                        playing = true;
                        timer = setInterval(function() {
                            if ( curFrame == nframes ) {
                                clearTimeout(timer);
                                playing = false;
                                curFrame = 0;
                            }
                            else {
                                ctx.drawImage(imgs[curFrame++], 0, 0);
                            }
                        }, 1000/fps);
                    } else {
                        clearTimeout(timer);
                        playing = false;
                    }
                }).contextmenu(function() {
                    clearTimeout(timer);
                    playing = false;
                    ctx.drawImage(imgs[curFrame = 0], 0, 0);
                    return false;
                });
            }
        };
        imgs[j].src = sprintf(files, i);
    }
}

$(document).ready(function() {
    'use strict'
    addAnimation("teasor", 960, 0, 376, 50, 1, "images/teasor/frame_%03d.jpg");

    addAnimation("mora", 200, 0, 200, 25, 1, "images/inverse_rendering/mora/frame_%03d.jpg");

    addAnimation("dodoco_color", 200, 0, 175, 25, 1, "images/inverse_rendering/dodoco_color/frame_%03d.jpg");

    addAnimation("dodoco_glass", 200, 0, 140, 25, 1, "images/inverse_rendering/dodoco_glass/frame_%03d.jpg");

    addAnimation("kirby", 480, 0, 81, 15, 1, "images/inverse_rendering/kirby/frame_%03d.jpg");

    addAnimation("sansan", 200, 0, 125, 20, 1, "images/inverse_rendering/sansan/frame_%03d.jpg");

    addAnimation("kitty", 200, 0, 80, 20, 1, "images/inverse_rendering/duck/frame_%03d.jpg");
    addAnimation("jp_edge", 720, 0, 66, 15, 1, "images/inverse_rendering/jp_edge/frame_%03d.jpg");
    addAnimation("jp_noedge", 720, 0, 66, 15, 1, "images/inverse_rendering/jp_noedge/frame_%03d.jpg");

    addAnimation("klee_edge", 720, 0, 41, 15, 1, "images/inverse_rendering/klee_edge/frame_%03d.jpg");
    addAnimation("klee_noedge", 720, 0, 41, 15, 1, "images/inverse_rendering/klee_noedge/frame_%03d.jpg");


    addAnimation("bunny_sha", 480, 0, 60, 15, 1, "images/inverse_rendering/bunny_sha/frame_%03d.jpg");
    addAnimation("bunny_glass_video", 480, 0, 200, 30, 1, "images/inverse_rendering/bunny_glass_video/frame_%03d.jpg");
});
