# PSDR-Enzyme

## Installation

PSDR-Enzyme has been tested in the following environment.

### OS
Ubuntu 22.04

### Other
LLVM 16
Clang 16
Python >= 3.8

### Installing dependencies

```
sudo apt install binutils-gold binutils-dev libfmt-dev libembree-dev
```

### Installing Enzyme

<https://enzyme.mit.edu/Installation/>

- Build LLVM from source
```
git clone https://github.com/llvm/llvm-project.git && cd llvm-project
git checkout release/16.x
mkdir build && cd build
cmake -G Ninja                        \
  -DLLVM_TARGETS_TO_BUILD="host"      \
  -DLLVM_ENABLE_PROJECTS="clang;lld;compiler-rt"  \
  -DLLVM_ENABLE_RUNTIMES="openmp"     \
  -DLLVM_ENABLE_PLUGINS=ON            \
  -DCMAKE_BUILD_TYPE=Release          \
  -DLLVM_ENABLE_ASSERTIONS=ON         \
  -DLLVM_BINUTILS_INCDIR=/usr/include \
  ../llvm
ninja
sudo ninja install
```

- Build Enzyme

```
git clone https://github.com/wsmoses/Enzyme.git && cd Enzyme
git checkout v0.0.98
cd enzyme
mkdir build && cd build
cmake -G Ninja .. -DLLVM_DIR=/usr/local/lib/cmake/llvm/
ninja
sudo ninja install
```

### Building PSDR-Enzyme
```
mkdir build && cd build
cmake -DCMAKE_C_COMPILER=clang \
  -DCMAKE_CXX_COMPILER=clang++ \
  ..
make -j
```

### Testing PSDR-Enzyme
```
cd inverse_rendering
sh bunny.sh
```