#pragma once
#include <core/fwd.h>
#include <core/ray.h>
#include <embree3/rtcore.h>
#include <embree3/rtcore_ray.h>

struct EmbreeScene
{
    struct Intersection
    {
        int shape_id;
        int triangle_id;
        Float t;
    };
    EmbreeScene();
    ~EmbreeScene();

    void insert(const std::vector<Vector3> &V, const std::vector<Vector3i> &F, bool commit_scene = true);
    void commit();
    bool rayIntersect(const Ray &ray, Intersection &its);
    bool rayIntersect(const Ray &ray, bool onSurface, Intersection &its);
    
    // Embree handles
    RTCDevice embree_device = nullptr;
    RTCScene embree_scene = nullptr;
};