#pragma once
#include <core/aabb.h>
#include <core/fstream.h>
#include <core/fwd.h>
#include <core/object.h>
#include <core/properties.h>

#include <filesystem>
#include <iostream>
#include <vector>
namespace fs = std::filesystem;

/**
 * type of VolumeGrid:
 *  constvolume
 *      is_constant = true
 *      m_data
 *      m_nchannel
 *  gridvolume
 *      is_constant = false
 *      m_res
 *      m_min
 *      m_max
 *      m_nchannel
 */
struct VolumeGrid : public Object {
    VolumeGrid(){};
    VolumeGrid(const Properties &props);
    // constructor for gridvolume
    VolumeGrid(const Vector3i &res, int nchannel,
               const Vector &min, const Vector &max,
               const std::vector<Float> &data,
               const Matrix4x4          &toWorld = Matrix4x4::Identity());
    // constructor for constvolume
    VolumeGrid(const Spectrum &value);
    VolumeGrid(const std::string &filename);
    VolumeGrid(const fs::path &path);
    VolumeGrid(Stream &stream);
    void configure();
    void setZero();
    void merge(const VolumeGrid &other);

    Float max() const { return m_max; }

    const AABB &getAABB() const { return m_bbox; }

    Float    lookupFloat(const Vector &p) const;
    Spectrum lookupSpectrum(const Vector &p) const;

    Matrix4x4 worldToVolume() const;
    Matrix4x4 volumeToGrid() const;
    Matrix4x4 worldToGrid() const;

    Vector toGrid(const Vector &x) const;
    Vector toLocal(const Vector &x) const;

    void read(Stream &stream);

    bool               is_constant;
    Vector3i           m_res;
    int                m_nchannel;
    AABB               m_bbox;
    std::vector<Float> m_data;
    Float              m_max;
    std::vector<Float> m_channel_max;

    // cached values
    Matrix4x4 m_volumeToGrid;
    Matrix4x4 m_volumeToWorld;
    Matrix4x4 m_worldToVolume;
    Matrix4x4 m_worldToGrid;

    PSDR_DECLARE_CLASS(VolumeGrid)
};