import pyvredner
import vredner
import torch


def gen_camera(positions, target, fov, resolution):
    return [pyvredner.Camera(position=torch.tensor(p, dtype=torch.float32),
                             look_at=torch.tensor(target, dtype=torch.float32),
                             up=torch.tensor(
                                 [0., 0., 1.], dtype=torch.float32),
                             fov=torch.tensor([fov], dtype=torch.float32),
                             clip_near=0.01,
                             resolution=resolution) for p in positions]
