import argparse
from re import VERBOSE
from utils.utils import gen_camera
from utils.file import create_output_dir
from utils.render import render_scene
import numpy as np
import vredner
if __name__ == "__main__":
    
    parser = argparse.ArgumentParser(
        prog='ESSVBRSDF',
        description='envmap shape optimization',
        epilog='Kai Yan (kyan8@uci.edu)'
    )

    parser.add_argument('--scene', required=True, type=str)
    args = parser.parse_args()

    scene_path = "./output/"+args.scene+"/"
    create_output_dir("./output/")
    create_output_dir(scene_path)
    create_output_dir(scene_path+"target/")

    cam_pos = np.loadtxt('cam_pos.txt')
    
    cameras = gen_camera(positions=cam_pos,
                         target=[0., 0., 0.],
                         fov=10.,
                         resolution=[256, 256])
    render_scene(scene_path+"target/", "./tar.xml", cameras, 2048, 1)
