import numpy as np
import argparse

def draw_circle(batch, radius):
    # cosPhi = np.linspace(1.0 - 0.01, -1.0 + 0.01, batch)
    cosPhi = np.linspace(1.0 - 0.01, -0.01, batch)
    # theta  = np.linspace(0, np.pi * 10, batch) + np.random.uniform(0, 1, batch) * (1/float(batch))
    theta  = np.linspace(0, np.pi * 10, batch)
    
    sinPhi = np.sqrt(1 - cosPhi * cosPhi)
    sinTheta = np.sin(theta) 
    cosTheta = np.cos(theta) 

    return [sinPhi * cosTheta * radius, sinPhi * sinTheta * radius, cosPhi * radius]


def write_camera_pos(batch, radius):
    cam_pos = np.array(draw_circle(batch, radius))
    np.savetxt("cam_pos.txt", cam_pos.T)

if __name__ == "__main__":
    parser = argparse.ArgumentParser(
        prog='ESSVBRSDF',
        description='envmap shape optimization',
        epilog='Kai Yan (kyan8@uci.edu)'
    )

    parser.add_argument('--batch_size', required=False, type=int, default = 100)
    parser.add_argument('--radius', required=False, type=int, default = 100)

    args = parser.parse_args()
    write_camera_pos(args.batch_size, args.radius)

