import numpy as np
import matplotlib.pyplot as plt


def image_loss(npass, data, output_dir):
    x = np.arange(0, npass)
    fig = plt.figure()
    plt.title("Image loss")
    plt.xlabel("Iteration")
    plt.ylabel("Loss")
    plt.plot(x, data, color ="red")
    plt.savefig(output_dir+"loss.png", dpi=100, bbox_inches='tight')
    plt.close()

def para_loss(npass, data, output_dir):
    x = np.arange(0, npass)
    fig = plt.figure()
    plt.title("Parameter difference")
    plt.xlabel("Iteration")
    plt.ylabel("Para diff")
    plt.plot(x, data, color ="red")
    plt.savefig(output_dir+"para.png", dpi=100, bbox_inches='tight')
    plt.close()

def write_obj(verts, faces, fname='test.obj'):
    verts = np.copy(verts)
    faces = np.copy(faces)
    faces += 1
    thefile = open(fname, 'w')
    for item in verts:
        thefile.write("v {0} {1} {2}\n".format(item[0], item[1], item[2]))
    for item in faces:
        thefile.write(
            # "f {0}//{0} {1}//{1} {2}//{2}\n".format(item[0], item[1], item[2]))
            "f {0} {1} {2}\n".format(item[0], item[1], item[2]))
    thefile.close()