from typing import List
import pyvredner
from pyvredner import image
from pyvredner.camera import Camera
import vredner
import cv2
import numpy as np
from .file import create_output_dir
import torch

def render_scene(init_path, scene_file, cameras: List[Camera], spp, max_bounce):
    create_output_dir(init_path)
    """ convert pycamera to c_camera """
    c_cameras = [c.c_obj() for c in cameras]
    scene, integrator = pyvredner.load_mitsuba(scene_file)
    c_scene = scene.c_obj()

    integrator = vredner.Direct()
    vredner.verbose = True
    num_sensors = len(cameras)
    """ iterate all the cameras """
    for sensor_id in range(num_sensors):
        camera = cameras[sensor_id]
        c_camera = c_cameras[sensor_id]
        c_scene.camera = c_camera
        res = camera.resolution
        image = torch.zeros(res[1], res[0], 3)
        options = vredner.RenderOptions(spp,                 # random seed
                                        spp,    # spp
                                        max_bounce,                  # max bounces
                                        0,   # sppe
                                        0,  # sppse0
                                        False)
        integrator.render(c_scene, options,
                          vredner.float_ptr(image.data_ptr()))
        image = image.numpy().reshape((res[1], res[0], 3))
        output = cv2.cvtColor(image, cv2.COLOR_RGB2BGR)
        cv2.imwrite(init_path+"sensor_"+str(sensor_id)+".exr", output)
        del image, output
        print("(%d/%d) cameras done." % (sensor_id, num_sensors), end="\r")
