import numpy


class float_ptr:
    def __init__(self, p): ...


class int_ptr:
    def __init__(self, p): ...


class Spectrum3f:
    def __init__(self, r: float, g: float, b: float): ...


class Vector3f:
    def __init__(self, x: float, y: float, z: float): ...


class Ray:
    org: Vector3f
    dir: Vector3f

    def __init__(self, org: Vector3f, dir: Vector3f): ...


class Object: ...


class ImageBlock:
    offset: numpy.ndarray[numpy.int32]
    blockSize: numpy.ndarray[numpy.int32]
    data: numpy.ndarray

    def __init__(self, offset: numpy.ndarray[numpy.int32], blockSize: numpy.ndarray[numpy.int32]): ...

    def put(self, *args): ...


class VolumeGrid:
    size: numpy.ndarray
    m_nchannel: int
    m_data: numpy.ndarray
    m_max: float
    m_channel_max: numpy.ndarray
    is_constant: bool
    m_volumeToGrid: numpy.ndarray
    m_volumeToWorld: numpy.ndarray
    m_worldToVolume: numpy.ndarray
    m_worldToGrid: numpy.ndarray

    def __init__(self, *args): ...

    def setZero(self): ...

    def lookupFloat(self, p: Vector3f) -> float: ...

    def lookupSpectrum(self, p: Vector3f) -> Spectrum3f: ...


class EVertex: ...

EVInvalid: int
EVSensor: int
EVSurface: int
EVEmitter: int
EVVolume: int
EVNull: int


class Properties:
    def __init__(self, *args): ...

    def merge(self, p: Properties): ...

    def get(self, key: str) -> int: ...

    def set(self, key: str, value) -> Properties: ...

    def setVectorX(self, key: str, value: numpy.ndarray) -> Properties: ...

    def setVectorX2(self, key: str, value: numpy.ndarray) -> Properties: ...

    def setVectorX3i(self, key: str, value: numpy.ndarray) -> Properties: ...

    def data(self) -> Properties: ...


class Shape:
    num_vertices: int
    light_id: int
    to_world: numpy.ndarray
    vertices_world: list
    vertices: list
    vertices_raw: list
    normals: list
    faceNormals: list
    uvs: list
    uv_indices: list
    use_face_normals: bool
    edges: list
    adjacentFaces: list
    indices: list
    bsdf_id: int
    light_id: int
    med_int_id: int
    med_ext_id: int
    enable_edge: bool
    enable_draw: bool
    sort_config: Sort_config

    def __init__(self, *args): ...

    def load(self, filename: str, auto_configure: bool): ...

    def setZero(self): ...

    def configure(self): ...

    def setVertex(self, id: int, v: numpy.ndarray): ...

    def setVertices(self, _vertices: list): ...

    def has_uvs(self) -> bool: ...

    def has_normals(self) -> bool: ...

    def getEdges(self) -> numpy.ndarray: ...

    def save(self, name: str): ...


class Medium: ...


class BSDF: ...


class Emitter: ...


class Frame: ...


class Intersection:
    ptr_shape: Shape
    ptr_med_int: Medium
    ptr_med_ext: Medium
    ptr_bsdf: BSDF
    ptr_emitter: Emitter
    t: float
    p: numpy.ndarray
    geoFrame: Frame
    shFrame: Frame
    uv: numpy.ndarray
    wi: numpy.ndarray
    J: float
    type: EVertex | int
    pdf: float
    shape_id: int
    triangle_id: int
    int_med_id: int
    ext_med_id: int
    medium_id: int
    pixel_idx: numpy.ndarray
    value: Spectrum3f
    nee_bsdf: Spectrum3f
    bsdf_bsdf: Spectrum3f
    l_nee_id: int
    l_bsdf_id: int
    barycentric: numpy.ndarray
    indices: numpy.ndarray

    def __init__(self): ...


class LightPath:
    pixel_idx: numpy.ndarray
    vertices: list
    vs: list
    def __init__(self): ...


class LightPathAD:
    val: LightPath
    der: LightPath

    def __init__(self, val: LightPathAD): ...


class RndSampler:
    saved: int
    state: int
    inc: int

    def __init__(self, seed: int, idx: int): ...

    def next1D(self) -> float: ...

    def next2D(self) -> numpy.ndarray: ...

    def next3D(self) -> numpy.ndarray: ...

    def save(self): ...

    def restore(self): ...


class RadianceQueryRecord:
    pixel_idx: numpy.ndarray
    sampler: RndSampler
    max_bounces: int

    def __init__(self, pixel_idx: numpy.ndarray, sampler: RndSampler, max_bounces: int): ...


class PixelQueryRecord(RadianceQueryRecord):
    def __init__(self, pixel_idx: numpy.ndarray, sampler: RndSampler, max_bounces: int, nsamples: int, enable_antithetic: bool = True): ...


class RGBSpectrum:
    def __init__(self, r: float, g: float, b: float): ...

    def data(self): ...

    def rows(self) -> int: ...

    def cols(self) -> int: ...


class DiscreteDistribution:
    m_cdf: list

    def __init__(self): ...


class CubeDistribution:
    m_distrb: DiscreteDistribution
    m_res: numpy.ndarray
    m_num_cells: int
    m_cells: numpy.ndarray
    m_unit: numpy.ndarray
    m_ready: bool

    def __init__(self): ...


class Sort_config:
    max_length: int
    cos_val_local: float
    cos_val_global: float

    def __init__(self, *args): ...


class adaptive3D:
    def printTree(self): ...

    def sample(self, rnd: numpy.ndarray, pdf: float) -> numpy.ndarray: ...


class aq_config:
    thold: float
    spg: int
    min_spg: int
    sample_decay: float
    weight_decay: float
    max_depth: int
    npass: int
    use_heap: bool
    edge_draw: bool
    max_depth_x: int
    max_depth_y: int
    max_depth_z: int
    eps: float
    shape_opt_id: int
    local_backward: bool

    def __init__(self, *args): ...


class grid_config:
    dims: numpy.ndarray
    spp: int

    def __init__(self, dims: numpy.ndarray, spp: int): ...


class ReconstructionFilter: ...


class TentFilter(ReconstructionFilter):
    padding: float

    def __init__(self, padding: float): ...


class BoxFilter(ReconstructionFilter):
    def __init__(self): ...


class AnisotropicGaussianFilter(ReconstructionFilter):
    def __init__(self): ...


class CropRectangle:
    offset_x: int
    offset_y: int
    crop_width: int
    crop_height: int


class Camera:
    cpos: numpy.ndarray
    world_to_cam: numpy.ndarray
    cam_to_world: numpy.ndarray
    cam_to_ndc: numpy.ndarray
    width: int
    height: int
    fov: float
    rfilter: ReconstructionFilter
    sigX: numpy.ndarray
    sigY: numpy.ndarray
    rect: CropRectangle

    def __init__(self, *args, **kwargs): ...

    def set_rect(self, offset_x: int, offset_y: int, crop_width: int, crop_height: int): ...

    def getCropSize(self) -> numpy.ndarray: ...

    def samplePrimaryRay(self, x: float, y: float) -> Ray: ...

    def samplePrimaryBoundaryRay(self, pixel_idx: numpy.ndarray, rnd: float) -> tuple: ...


class Edge:
    v0: int
    v1: int
    f0: int
    f1: int


class Bitmap:
    m_data: numpy.ndarray
    m_res: numpy.ndarray

    def __init__(self, *args): ...

    def save(self, filename: str): ...


class DiffuseBSDF(BSDF):
    reflectance: Spectrum3f

    def __init__(self, reflectance: Spectrum3f): ...


class RoughConductorBSDF(BSDF):
    def __init__(self, alpha: float, intEta: Spectrum3f, K: Spectrum3f): ...


class RoughDielectricBSDF(BSDF):
    def __init__(self, alpha: float, intIOR: float, extIOR: float): ...


class NullBSDF(BSDF):
    def __init__(self): ...


class Phase: ...


class HG(Phase):
    def __init__(self, g: float): ...


class Isotropic(Phase):
    def __init__(self): ...


class TetrahedronMesh:
    TV: numpy.ndarray
    TT: numpy.ndarray
    volume: list
    vertices: list
    ids: list

    def __init__(self, vertices: list, faces: list, ids: list): ...


def tetrahedralize(V: numpy.ndarray, F: numpy.ndarray, switches: str): ...


class Homogeneous(Medium):
    sigma_t: float
    albedo: VolumeGrid
    sampling_weight: float
    phase_id: int
    tetmesh: TetrahedronMesh

    def __init__(self, *args): ...


class Heterogeneous(Medium):
    max_density: float
    inv_max_density: float
    scale: float
    sigmaT: VolumeGrid
    albedo: VolumeGrid

    def __init__(self, *args): ...

    def configure(self): ...


class AreaLight(Emitter):
    def __init__(self, shape_id: int, intensity: Spectrum3f): ...


class EnvironmentMap(Emitter):
    m_data: Bitmap
    m_cube_distrb: CubeDistribution
    m_scale: float

    def __init__(self, *args): ...


class ParamMap: ...


class State: ...


class Scene(Object):
    param_map: ParamMap
    shapes: list
    bsdfs: list
    emitters: list
    mediums: list
    phases: list
    cameras: list
    camera: Camera
    state: State
    medium_shape_distrb: DiscreteDistribution

    def __init__(self, *args, **kwargs): ...

    def clone(self) -> Scene: ...

    def setZero(self): ...

    def configure(self, props: Properties = Properties()): ...

    def load_file(self, file_name: str, auto_configure: bool = True, props: Properties = Properties()): ...


class GradientManager:
    d_scenes: list

    def merge(self): ...


class SceneAD:
    val: Scene
    der: Scene
    gm: GradientManager

    def __init__(self, s: Scene): ...

    def getDer(self) -> Scene: ...

    def zeroGrad(self): ...


class RenderOptions:
    seed: int
    spp: int
    sppe: int
    sppse: int
    max_bounces: int
    quiet: bool
    mode: int
    ddistCoeff: float
    sppse0: int
    sppse1: int
    sppe0: int
    grad_threshold: float

    def __init__(self, *args): ...


class Integrator:
    enable_antithetic: bool
    two_point_antithetic: bool

    def configure(self, scene: Scene): ...
    
    def renderC(self, scene: Scene, options: RenderOptions) -> numpy.ndarray: ...

    def renderD(self, sceneAD: SceneAD, options: RenderOptions, d_image: numpy.ndarray) -> numpy.ndarray: ...


class MISIntegrator:
    class ESamplingMode: ...

    ESolidAngle: int
    EArea: int
    EMISBalance: int
    EMISPower: int
    EMISFirst: int
    EMISPath: int
    ESkipSensor: int
    EDebugMISBalance: int
    EDebugMISPower: int

    def __init__(self, *args): ...


class IntegratorBoundary:
    def configure(self, scene: Scene): ...


class UnidirectionalPathTracer(Integrator):
    def pixelColor(self, scene: Scene, pRec: PixelQueryRecord): ...

    def pixelColorAD(self, sceneAD: SceneAD, pRec: PixelQueryRecord, d_res: Spectrum3f): ...


class Path2(UnidirectionalPathTracer):
    def __init__(self, *args): ...

    def Li(self, scene: Scene, ray: Ray, rRec: RadianceQueryRecord) -> Spectrum3f: ...

    def LiAD(self, sceneAD: SceneAD, ray: Ray, rRec: RadianceQueryRecord, d_res: Spectrum3f): ...

    def forwardRenderD(self, sceneAD: SceneAD, options: RenderOptions) -> numpy.ndarray: ...


class PrimaryEdgeIntegrator(IntegratorBoundary):
    def __init__(self, *args): ...

    def renderD(self, sceneAD: SceneAD, options: RenderOptions, d_image: numpy.ndarray) -> numpy.ndarray: ...

    def forwardRenderD(self, sceneAD: SceneAD, options: RenderOptions) -> numpy.ndarray: ...

    def configure(self, scene: Scene): ...


class DirectEdgeIntegrator(IntegratorBoundary):
    edge_indices: list
    aq_distrb: adaptive3D

    def __init__(self, *args): ...

    def preprocess_aq(self, scene: Scene, config, max_bounces: int): ...

    def preprocess_grid(self, scene: Scene, config, max_bounces: int): ...

    def renderD(self, sceneAD: SceneAD, options: RenderOptions, d_image: numpy.ndarray) -> numpy.ndarray: ...

    def forwardRenderD(self, sceneAD: SceneAD, options: RenderOptions) -> numpy.ndarray: ...


class IndirectEdgeIntegrator(IntegratorBoundary):
    edge_indices: list
    aq_distrb: adaptive3D

    def __init__(self, *args): ...

    def preprocess_aq(self, scene: Scene, config, max_bounces: int): ...

    def preprocess_grid(self, scene: Scene, config, max_bounces: int): ...

    def renderD(self, sceneAD: SceneAD, options: RenderOptions, d_image: numpy.ndarray) -> numpy.ndarray: ...

    def forwardRenderD(self, sceneAD: SceneAD, options: RenderOptions) -> numpy.ndarray: ...


class BoundaryIntegrator(IntegratorBoundary):
    def __init__(self, scene: Scene): ...

    def configure_primary(self, scene: Scene): ...

    def recompute_direct_edge(self, scene: Scene): ...

    def recompute_indirect_edge(self, scene: Scene): ...

    def preprocess_grid_direct(self, scene: Scene, config, max_bounces: int): ...

    def preprocess_aq_direct(self, scene: Scene, config, max_bounces: int): ...

    def preprocess_grid_indirect(self, scene: Scene, config, max_bounces: int): ...

    def preprocess_aq_indirect(self, scene: Scene, config, max_bounces: int): ...

    def renderD(self, sceneAD: SceneAD, options: RenderOptions, d_image: numpy.ndarray) -> numpy.ndarray: ...

    def forwardRenderD(self, sceneAD: SceneAD, options: RenderOptions) -> numpy.ndarray: ...

    def configure_primary(self, scene: Scene): ...


class BoundarySegmentInfo:
    xS_0: numpy.ndarray
    xS_1: numpy.ndarray
    xS_2: numpy.ndarray
    xB_0: numpy.ndarray
    xB_1: numpy.ndarray
    xD_0: numpy.ndarray
    xD_1: numpy.ndarray
    xD_2: numpy.ndarray


class PixelBoundarySamplingRecord:
    onSurface_S: bool
    dir_local: numpy.ndarray
    dir_visible: numpy.ndarray
    dir_edge: numpy.ndarray
    shape_id: int
    triangle_id: int
    med_id_S: int
    tet_id_S: int
    barycentric4_S: numpy.ndarray

    def __init__(self): ...


class PixelBoundarySegmentInfo:
    xD: numpy.ndarray
    xB: numpy.ndarray
    xS_0: numpy.ndarray
    xS_1: numpy.ndarray
    xS_2: numpy.ndarray

    def __init__(self): ...

    def getVelocities(self) -> numpy.ndarray: ...

    def maxCoeff(self) -> float: ...

    def setZero(self): ...


class PixelBoundaryIntegrator(IntegratorBoundary):
    guideMap: numpy.ndarray

    def __init__(self, *args): ...

    def renderC(self, scene: Scene, options: RenderOptions) -> numpy.ndarray: ...

    def renderD(self, sceneAD: SceneAD, options: RenderOptions, d_image: numpy.ndarray) -> numpy.ndarray: ...

    def guide(self, scene: Scene, options: RenderOptions, weight: float = 1.0) -> numpy.ndarray: ...

    def getSampleMap(self, guideMap: numpy.ndarray, sppe0: int) -> numpy.ndarray: ...

    def getVarMap(self, sceneAD: SceneAD, options: RenderOptions, d_image: numpy.ndarray) -> numpy.ndarray: ...

    def guidingDensity(self, scene: Scene, options: RenderOptions, pixelIdx: numpy.ndarray) -> float: ...

    def normalVelocity(self, seg: PixelBoundarySegmentInfo, vB: numpy.ndarray, n: numpy.ndarray) -> PixelBoundarySegmentInfo: ...

    def Li(self, scene: Scene, ray: Ray, rec: RadianceQueryRecord) -> Spectrum3f: ...

    def velocities(self, scene: Scene, pRec: PixelBoundarySamplingRecord) -> Properties: ...


verbose: bool

def get_verbose() -> bool: ...

def set_verbose(verbose: bool): ...


forward: bool

def get_forward() -> bool: ...

def set_forward(forward: bool): ...


def load_from_string(scene_xml: str) -> Scene: ...


def omp_get_thread_num() -> int: ...

def omp_get_num_procs() -> int: ...

