from typing import List
from scipy.spatial.transform import Rotation as R
import dataclasses
from pypsdr.common import sample_on_sphere, sample_on_hemisphere
import psdr_cpu
import gin
import os
import numpy as np


@gin.configurable
def camera_positions(filename):
    pos = np.loadtxt(filename)
    assert(pos.shape[1] == 3)
    return pos


@gin.configurable
def gen_camera_positions(batch, radius, hemisphere):
    np.random.seed(batch)
    if hemisphere:
        return sample_on_hemisphere(batch=batch, radius=radius)
    else:
        return sample_on_sphere(batch=batch, radius=radius)


@gin.configurable
def gen_camera_positions1(batch, radius, cos_phi_min=-1., cos_phi_max=1.):
    return sample_on_sphere(batch=batch, radius=radius, cos_phi_min=cos_phi_min, cos_phi_max=cos_phi_max)


@gin.configurable
@dataclasses.dataclass
class Camera:
    origin: List = dataclasses.field(default_factory=lambda: [1., 1., 1.])
    target: List = dataclasses.field(default_factory=lambda: [0., 0., 0.])
    up: List = dataclasses.field(default_factory=lambda: [0., 0., 1.])
    fov: float = 10.
    type: int = None
