from genericpath import isdir, isfile
import numpy as np
from pypsdr.utils.io import imread, imwrite
import argparse
import os
from pathlib import Path

if __name__ == "__main__":
    parser = argparse.ArgumentParser(
        description='Script for simple EXR utilities',
        epilog='Cheng Zhang (chengz20@uci.edu)')

    parser.add_argument('filename', metavar='filename',
                        type=str, help='input filename')
    parser.add_argument('-exposure', metavar='exposure',
                        type=float, default=1.0, help='exposure value')
    parser.add_argument('-out', metavar='out', type=str,
                        help='input filename', default='./out')

    args = parser.parse_args()
    out_dir = Path(args.out)
    out_dir.mkdir(parents=True, exist_ok=True)

    filename = Path(args.filename)
    if not filename.exists():
        raise ValueError("File not found: {}".format(filename))

    if filename.is_dir():
        os.chdir(args.filename)
        exrs = filename.glob('*.exr')
        for exr in exrs:
            img = imread(exr) * 2**args.exposure
            out_name = out_dir / (exr.stem + '.png')
            imwrite(img, out_name)

    if filename.is_file():
        if not filename.suffix == '.exr':
            raise ValueError("File not an exr: {}".format(filename))
        img = imread(filename) * 2**args.exposure
        out_name = out_dir / (exr.stem + '.png')
        imwrite(img, out_name)
