from genericpath import isdir, isfile
import numpy as np
from pypsdr.utils.io import imread, imwrite
import argparse, os
from pathlib import Path

if __name__ == "__main__":
    parser = argparse.ArgumentParser(
            description='Script for simple EXR utilities',
            epilog='Cheng Zhang (chengz20@uci.edu)')

    parser.add_argument('filename', metavar='filename', type=str, help='input filename')
    parser.add_argument('-out', metavar='out', type=str, help='input filename', default='./out')
    args = parser.parse_args()
    image = imread(args.filename)
    image[:, :, 1:3] = 0
    imwrite(image, args.out)