#include <render/scene.h>
#include "algorithm1.h"
#include "algorithm1_vol.h"

NAMESPACE_BEGIN(algorithm1_vol)

void __evalPath(const Scene &scene, LightPath &path, Spectrum &value)
{
    value = evalPath(scene, path);
}

void d_evalPath(const Scene &scene, Scene &d_scene,
                const LightPath &path, LightPath &d_path,
                Spectrum d_value)
{
    [[maybe_unused]] Spectrum value;
#if defined(ENZYME) && defined(VOLPATH)
    __enzyme_autodiff((void *)__evalPath,
                      enzyme_dup, &scene, &d_scene,
                      enzyme_dup, &path, &d_path,
                      enzyme_dup, &value, &d_value);
#endif
}

std::pair<Spectrum, Spectrum>
evalPathFwd(const Scene &scene, Scene &d_scene,
            const LightPath &path, LightPath &d_path)
{
    [[maybe_unused]] Spectrum value(0.);
    [[maybe_unused]] Spectrum d_value(0.);
#if defined(ENZYME) && defined(VOLPATH)
    __enzyme_fwddiff((void *)__evalPath,
                     enzyme_dup, &scene, &d_scene,
                     enzyme_dup, &path, &d_path,
                     enzyme_dup, &value, &d_value);
#endif
    return {value, d_value};
}

NAMESPACE_END(algorithm1_vol)
