#include "algorithm1.h"
#include "algorithm1_vol.h"
#include <render/scene.h>

NAMESPACE_BEGIN(algorithm1_vol)

void d_getPoint(const Scene &scene, Scene &d_scene, const Intersection &v, Intersection &d_v)
{
#if defined(ENZYME) && defined(VOLPATH)
    __enzyme_autodiff((void *)getPoint,
                      enzyme_dup, &scene, &d_scene,
                      enzyme_dup, &v, &d_v);
#endif
}

void d_getPath(const Scene &scene, Scene &d_scene, LightPath &path, LightPath &d_path)
{
    for (int i = 0; i < path.vertices.size(); i++)
        if (path.vertices[i].type & EVSurface || path.vertices[i].type & EVVolume)
            d_getPoint(scene, d_scene, path.vertices[i], d_path.vertices[i]);
}

void getPointFwd(const Scene &scene, Scene &d_scene, const Intersection &v, Intersection &d_v)
{
    #if defined(ENZYME)
    __enzyme_fwddiff((void *)getPoint,
                     enzyme_dup, &scene, &d_scene,
                     enzyme_dup, &v, &d_v);
    #endif
}

void getPathFwd(const Scene &scene, Scene &d_scene, LightPath &path, LightPath &d_path)
{
    for (int i = 0; i < path.vertices.size(); i++)
        if (path.vertices[i].type & EVSurface || path.vertices[i].type & EVVolume)
            getPointFwd(scene, d_scene, path.vertices[i], d_path.vertices[i]);
}

NAMESPACE_END(algorithm1_vol)