#include <bsdf/diffuse.h>
#include <bsdf/null.h>
#include <bsdf/roughconductor.h>
#include <bsdf/roughdielectric.h>
#include <render/bsdf.h>
#include <render/intersection.h>

namespace bsdf {
void __eval(const BSDF *bsdf, const Intersection &its, const Vector &wo,
            EBSDFMode mode, Spectrum &res) {
    if (bsdf->m_type == DiffuseBSDF::TYPE_ID) {
        PSDR_INVOKE_BSDF_HELPER_EVAL(DiffuseBSDF,
                                     bsdf, its,
                                     wo, mode, res);
    } else if (bsdf->m_type == RoughConductorBSDF::TYPE_ID) {
        PSDR_INVOKE_BSDF_HELPER_EVAL(RoughConductorBSDF,
                                     bsdf, its,
                                     wo, mode, res);
    } else if (bsdf->m_type == RoughDielectricBSDF::TYPE_ID) {
        PSDR_INVOKE_BSDF_HELPER_EVAL(RoughDielectricBSDF,
                                     bsdf, its,
                                     wo, mode, res);
    } else if (bsdf->m_type == NullBSDF::TYPE_ID) {
        PSDR_INVOKE_BSDF_HELPER_EVAL(NullBSDF,
                                     bsdf, its,
                                     wo, mode, res);
    }
}

__attribute__((noinline)) void __sample(const BSDF *bsdf, const Intersection &its, const Array3 &sample,
                                        Vector &wo, Float &pdf, Float &eta,
                                        EBSDFMode mode, BSDFEvalType &res) {
    if (bsdf->m_type == DiffuseBSDF::TYPE_ID) {
        PSDR_INVOKE_BSDF_HELPER_SAMPLE(DiffuseBSDF, bsdf, its, sample, wo, pdf, eta, mode, res);
    } else if (bsdf->m_type == RoughConductorBSDF::TYPE_ID) {
        PSDR_INVOKE_BSDF_HELPER_SAMPLE(RoughConductorBSDF, bsdf, its, sample, wo, pdf, eta, mode, res);
    } else if (bsdf->m_type == RoughDielectricBSDF::TYPE_ID) {
        PSDR_INVOKE_BSDF_HELPER_SAMPLE(RoughDielectricBSDF, bsdf, its, sample, wo, pdf, eta, mode, res);
    } else if (bsdf->m_type == NullBSDF::TYPE_ID) {
        PSDR_INVOKE_BSDF_HELPER_SAMPLE(NullBSDF, bsdf, its, sample, wo, pdf, eta, mode, res);
    }
}

__attribute__((noinline)) void __pdf(const BSDF *bsdf, const Intersection &its, const Vector3 &wo, Float &res) {
    if (bsdf->m_type == DiffuseBSDF::TYPE_ID) {
        PSDR_INVOKE_BSDF_HELPER_PDF(DiffuseBSDF, bsdf, its, wo, res);
    } else if (bsdf->m_type == RoughConductorBSDF::TYPE_ID) {
        PSDR_INVOKE_BSDF_HELPER_PDF(RoughConductorBSDF, bsdf, its, wo, res);
    } else if (bsdf->m_type == RoughDielectricBSDF::TYPE_ID) {
        PSDR_INVOKE_BSDF_HELPER_PDF(RoughDielectricBSDF, bsdf, its, wo, res);
    } else if (bsdf->m_type == NullBSDF::TYPE_ID) {
        PSDR_INVOKE_BSDF_HELPER_PDF(NullBSDF, bsdf, its, wo, res);
    }
}

bool __isNull(const BSDF *bsdf) {
    bool res = false;
    if (bsdf->m_type == DiffuseBSDF::TYPE_ID) {
        PSDR_INVOKE_BSDF_HELPER_ISNULL(DiffuseBSDF, bsdf, res);
    } else if (bsdf->m_type == RoughConductorBSDF::TYPE_ID) {
        PSDR_INVOKE_BSDF_HELPER_ISNULL(RoughConductorBSDF, bsdf, res);
    } else if (bsdf->m_type == RoughDielectricBSDF::TYPE_ID) {
        PSDR_INVOKE_BSDF_HELPER_ISNULL(RoughDielectricBSDF, bsdf, res);
    } else if (bsdf->m_type == NullBSDF::TYPE_ID) {
        PSDR_INVOKE_BSDF_HELPER_ISNULL(NullBSDF, bsdf, res);
    }
    return res;
}

INACTIVE_FN(__pdf, __pdf);
INACTIVE_FN(__sample, __sample);

} // namespace bsdf

PSDR_INACTIVE_CLASS(BSDF)

BSDFEvalType BSDF::eval(const Intersection &its, const Vector &wo,
                        EBSDFMode mode) const {
    Spectrum ret;
    bsdf::__eval(this, its, wo, mode, ret);
    return ret;
}

Float BSDF::correction(const Intersection &its, const Vector &wo) const {
    Vector wi_global = its.toWorld(its.wi);
    Vector wo_global = its.toWorld(wo);
    Float  wiDotGeoN = wi_global.dot(its.geoFrame.n),
           woDotGeoN = wo_global.dot(its.geoFrame.n);
    return std::abs((its.wi.z() * woDotGeoN) / (wo.z() * wiDotGeoN));
}

BSDFEvalType BSDF::sample(const Intersection &its, const Array3 &sample,
                          Vector &wo, Float &pdf, Float &eta,
                          EBSDFMode mode) const {
    BSDFEvalType res;
    bsdf::__sample(this, its, sample, wo, pdf, eta, mode, res);
    return res;
}

Float BSDF::pdf(const Intersection &its, const Vector3 &wo) const {
    Float res;
    bsdf::__pdf(this, its, wo, res);
    return res;
}

#define PSDR_IMPLEMENT_BSDF(...)                        \
                                                        \
    bool BSDF::isTransmissive() const                   \
    {                                                   \
        PSDR_MAP_STMT_F(isTransmissive(), __VA_ARGS__); \
        assert(false);                                  \
        return true;                                    \
    }                                                   \
                                                        \
    bool BSDF::isTwosided() const                       \
    {                                                   \
        PSDR_MAP_STMT_F(isTwosided(), __VA_ARGS__);     \
        assert(false);                                  \
        return true;                                    \
    }

bool BSDF::isNull() const {
    return bsdf::__isNull(this);                          
}                                            

//* insert an entry here when a new BSDF is added
PSDR_IMPLEMENT_BSDF(DiffuseBSDF, RoughConductorBSDF, RoughDielectricBSDF, NullBSDF)

std::string BSDF::toString() const {
    std::ostringstream oss;
    oss << "Base BSDF []" << std::endl;
    return oss.str();
}

INACTIVE_FN(BSDF_pdf, &BSDF::pdf);
INACTIVE_FN(BSDF_sample, &BSDF::sample);
