#include <bsdf/null.h>
#include <render/intersection.h>

NullBSDF::NullBSDF() {
    this->m_type = this->TYPE_ID;
}

BSDF *NullBSDF::clone() const {
    return new NullBSDF(*this);
}

BSDFEvalType NullBSDF::eval(const Intersection &, const Vector &,
                            EBSDFMode) const {
    return Spectrum::Ones();
}

Spectrum NullBSDF::sample(const Intersection &its, const Array3 &,
                          Vector &wo, Float &pdf, Float &eta,
                          EBSDFMode) const {
    wo = -its.wi;
    pdf = 1.0;
    eta = 1.0;
    return Spectrum::Ones();
}

Float NullBSDF::pdf(const Intersection &, const Vector &) const {
    return 1.0;
}

PSDR_IMPL_BSDF_HELPER_FUNCTIONS(NullBSDF);
