#pragma once

#include <render/bsdf.h>

struct NullBSDF : public BSDF {
    NullBSDF();
    BSDF *clone() const override;
    void merge(BSDF *) override {}
    void setZero() override {}

    BSDFEvalType eval(const Intersection &its, const Vector &wo,
                      EBSDFMode mode = EBSDFMode::ERadiance) const;
    BSDFEvalType sample(const Intersection &its, const Array3 &sample,
                        Vector &wo, Float &pdf, Float &eta,
                        EBSDFMode mode = EBSDFMode::ERadiance) const;
    Float        pdf(const Intersection &its, const Vector &wo) const;
    inline bool  isTransmissive() const { return true; }
    inline bool  isTwosided() const { return true; }
    inline bool  isNull() const { return true; }
    std::string  toString() const override {
        std::ostringstream oss;
        oss << "BSDF_null []" << std::endl;
        return oss.str();
    }

    static const int TYPE_ID = 4;

    PSDR_DECLARE_CLASS(NullBSDF)
    PSDR_IMPLEMENT_VIRTUAL_CLASS(NullBSDF)
};

PSDR_DECLARE_BSDF_HELPER_FUNCTIONS(NullBSDF);
