#include <emitter/area.h>
#include <emitter/envmap.h>
#include <render/emitter.h>

PSDR_INACTIVE_CLASS(Emitter)

/* To let Enzyme differentiate the member functions in the derived class automatically,
we need to explicitly call these member functions of the derived class. */
#define PSDR_IMPLEMENT_EMITTER(...)                                                            \
    Spectrum Emitter::eval(const Intersection &its, const Vector &d) const {                   \
        PSDR_MAP_STMT_F(eval(its, d), __VA_ARGS__);                                            \
        assert(false);                                                                         \
        return Spectrum();                                                                     \
    }                                                                                          \
    Float Emitter::pdf(const Intersection &its, const Vector &d) const {                       \
        PSDR_MAP_STMT_F(pdf(its, d), __VA_ARGS__);                                             \
        assert(false);                                                                         \
        return 0.;                                                                             \
    }                                                                                          \
    Spectrum Emitter::eval(const Vector &norm, const Vector &d) const {                        \
        PSDR_MAP_STMT_F(eval(norm, d), __VA_ARGS__);                                           \
        assert(false);                                                                         \
        return Spectrum();                                                                     \
    }                                                                                          \
    Float Emitter::evalDirection(const Vector &norm, const Vector &d) const {                  \
        PSDR_MAP_STMT_F(evalDirection(norm, d), __VA_ARGS__);                                  \
        assert(false);                                                                         \
        return 0;                                                                              \
    }                                                                                          \
    Float Emitter::sampleDirection(const Array2 &rnd, Vector &dir, Float *pdf) const {         \
        PSDR_MAP_STMT_F(sampleDirection(rnd, dir, pdf), __VA_ARGS__);                          \
        assert(false);                                                                         \
        return 0;                                                                              \
    }                                                                                          \
    Spectrum Emitter::sampleDirect(const Vector2 &rnd, DirectSamplingRecord &dRec) const {     \
        PSDR_MAP_STMT_F(sampleDirect(rnd, dRec), __VA_ARGS__);                                 \
        assert(false);                                                                         \
        return Spectrum();                                                                     \
    }                                                                                          \
    Spectrum Emitter::samplePosition(const Vector2 &rnd, PositionSamplingRecord &pRec) const { \
        PSDR_MAP_STMT_F(samplePosition(rnd, pRec), __VA_ARGS__);                               \
        assert(false);                                                                         \
        return Spectrum();                                                                     \
    }                                                                                          \
    Spectrum Emitter::getIntensity() const {                                                   \
        PSDR_MAP_STMT_F(getIntensity(), __VA_ARGS__);                                          \
        assert(false);                                                                         \
        return Spectrum();                                                                     \
    }

INACTIVE_FN(Emitter_eval, static_cast<Spectrum (Emitter::*)(const Intersection &, const Vector &) const>(&Emitter::eval));
INACTIVE_FN(Emitter_pdf, static_cast<Float (Emitter::*)(const Intersection &, const Vector &) const>(&Emitter::pdf));
INACTIVE_FN(Emitter_pdfDirect, static_cast<Float (Emitter::*)(const DirectSamplingRecord &dRec) const>(&Emitter::pdfDirect));
INACTIVE_FN(Emitter_evalDirection, static_cast<Float (Emitter::*)(const Vector &, const Vector &) const>(&Emitter::evalDirection));
INACTIVE_FN(Emitter_sampleDirection, static_cast<Float (Emitter::*)(const Array2 &, Vector &, Float *) const>(&Emitter::sampleDirection));
INACTIVE_FN(Emitter_sampleDirect, static_cast<Spectrum (Emitter::*)(const Vector2 &, DirectSamplingRecord &) const>(&Emitter::sampleDirect));
INACTIVE_FN(Emitter_samplePosition, static_cast<Spectrum (Emitter::*)(const Vector2 &, PositionSamplingRecord &) const>(&Emitter::samplePosition));
INACTIVE_FN(Emitter_getIntensity, static_cast<Spectrum (Emitter::*)() const>(&Emitter::getIntensity));

Spectrum Emitter::eval(const Intersection &its, const Vector &d) const {
    char name[100];
    name[0] = 0;
    className(name);
    if (strcmp(name, "AreaLight") == 0)
        return dynamic_cast<const AreaLight *>(this)->eval(its, d);
    if (strcmp(name, "EnvironmentMap") == 0)
        return dynamic_cast<const EnvironmentMap *>(this)->eval(its, d);
    assert(false);
    return Spectrum();
}
Float Emitter::pdf(const Intersection &its, const Vector &d) const {
    char name[100];
    name[0] = 0;
    className(name);
    if (strcmp(name, "AreaLight") == 0)
        return dynamic_cast<const AreaLight *>(this)->pdf(its, d);
    if (strcmp(name, "EnvironmentMap") == 0)
        return dynamic_cast<const EnvironmentMap *>(this)->pdf(its, d);

    assert(false);
    return 0.;
}

Float Emitter::pdfDirect(const DirectSamplingRecord &dRec) const {
    char name[100];
    name[0] = 0;
    className(name);
    if (strcmp(name, "AreaLight") == 0)
        return dynamic_cast<const AreaLight *>(this)->pdfDirect(dRec);
    if (strcmp(name, "EnvironmentMap") == 0)
        return dynamic_cast<const EnvironmentMap *>(this)->pdfDirect(dRec);

    assert(false);
    return 0.;
}
Float Emitter::evalDirection(const Vector &norm, const Vector &d) const {
    char name[100];
    name[0] = 0;
    className(name);
    if (strcmp(name, "AreaLight") == 0)
        return dynamic_cast<const AreaLight *>(this)->evalDirection(norm, d);
    if (strcmp(name, "EnvironmentMap") == 0)
        return dynamic_cast<const EnvironmentMap *>(this)->evalDirection(norm, d);

    assert(false);
    return 0;
}
Float Emitter::sampleDirection(const Array2 &rnd, Vector &dir, Float *pdf) const {
    char name[100];
    name[0] = 0;
    className(name);
    if (strcmp(name, "AreaLight") == 0)
        return dynamic_cast<const AreaLight *>(this)->sampleDirection(rnd, dir, pdf);
    if (strcmp(name, "EnvironmentMap") == 0)
        return dynamic_cast<const EnvironmentMap *>(this)->sampleDirection(rnd, dir, pdf);

    assert(false);
    return 0;
}
Spectrum Emitter::sampleDirect(const Vector2 &rnd, DirectSamplingRecord &dRec) const {
    char name[100];
    name[0] = 0;
    className(name);
    if (strcmp(name, "AreaLight") == 0)
        return dynamic_cast<const AreaLight *>(this)->sampleDirect(rnd, dRec);
    if (strcmp(name, "EnvironmentMap") == 0)
        return dynamic_cast<const EnvironmentMap *>(this)->sampleDirect(rnd, dRec);
    assert(false);
    return Spectrum();
}
Spectrum Emitter::samplePosition(const Vector2 &rnd, PositionSamplingRecord &pRec) const {
    char name[100];
    name[0] = 0;
    className(name);
    if (strcmp(name, "AreaLight") == 0)
        return dynamic_cast<const AreaLight *>(this)->samplePosition(rnd, pRec);
    if (strcmp(name, "EnvironmentMap") == 0)
        return dynamic_cast<const EnvironmentMap *>(this)->samplePosition(rnd, pRec);

    assert(false);
    return Spectrum();
}
Spectrum Emitter::getIntensity() const {
    char name[100];
    name[0] = 0;
    className(name);
    if (strcmp(name, "AreaLight") == 0)
        return dynamic_cast<const AreaLight *>(this)->getIntensity();
    if (strcmp(name, "EnvironmentMap") == 0)
        return dynamic_cast<const EnvironmentMap *>(this)->getIntensity();

    assert(false);
    return Spectrum();
}

namespace emitter {
void __eval(const Emitter *emitter, const Vector &norm, const Vector &d, Spectrum &res) {
    if (emitter->m_type == AreaLight::TYPE_ID) {
        PSDR_INVOKE_EMITTER_HELPER_EVAL(AreaLight, emitter, norm, d, res);
    } else if (emitter->m_type == EnvironmentMap::TYPE_ID) {
        PSDR_INVOKE_EMITTER_HELPER_EVAL(EnvironmentMap, emitter, norm, d, res);
    }
}
} // namespace emitter

Spectrum Emitter::eval(const Vector &norm, const Vector &d) const {
    Spectrum ret;
    emitter::__eval(this, norm, d, ret);
    return ret;
}
