#pragma once
#include <core/bitmap.h>
#include <core/cube_distrb.h>
#include <core/distr_2d.h>
#include <render/emitter.h>

struct EnvironmentMap : public Emitter {
    EnvironmentMap(const Properties &props);
    EnvironmentMap(const std::string filename, int shape_id);

    void     configure();
    Emitter *clone() const override;
    void     merge(Emitter *emitter) override;
    void     setZero() override;

    Spectrum eval(const Intersection &its, const Vector &d) const;
    Spectrum eval(const Vector &norm, const Vector &d) const;
    Float    evalDirection(const Vector &norm, const Vector &d) const;
    Float    sampleDirection(const Array2 &rnd, Vector &dir, Float *pdf = nullptr) const;
    Float    pdf(const Intersection &its, const Vector &d) const;
    Float    pdfDirect(const DirectSamplingRecord &dRec) const;
    Spectrum sampleDirect(const Vector2 &rnd, DirectSamplingRecord &dRec) const;
    Spectrum getIntensity() const { return Spectrum::Zero(); };
    Spectrum samplePosition(const Vector2 &rnd, PositionSamplingRecord &pRec) const;

    // importance sample the environment map
    std::pair<Vector, Float> sampleDirection(const Vector2 &rnd) const;

    Bitmap           m_data;
    Matrix4x4        m_to_world;
    Matrix4x4        m_to_local;
    CubeDistribution m_cube_distrb;
    Float            m_scale;
    Float            m_power;
    bool             m_ready = false;

    static const int TYPE_ID = 2;

    PSDR_IMPLEMENT_VIRTUAL_CLASS(EnvironmentMap)
    PSDR_DECLARE_CLASS(EnvironmentMap)
};

PSDR_DECLARE_EMITTER_HELPER_FUNCTIONS(EnvironmentMap);