#include "mask.h"
#include <render/common.h>
#include <render/imageblock.h>
#include <core/ray.h>
#include <core/sampler.h>
#include <render/scene.h>
#include <core/timer.h>
#include <iomanip>
#include "algorithm1.h"
#include <signal.h>

Spectrum Mask::Li(const Scene &scene, const Ray &ray, RadianceQueryRecord &rRec) const
{
    Ray _ray(ray);
    Intersection its;
    scene.rayIntersect(_ray, true, its);
    if (!its.isValid())
        return Spectrum::Zero();
    else 
        return Spectrum::Ones();
}
