#include "boundaryMIS.h"

BoundaryMIS::BoundaryMIS(const Properties &props)
    : Integrator(props),
      MISIntegrator(props),
      boundaryUnidirectional(props),
      boundaryBidirectional(props) {}

void BoundaryMIS::configure(const Scene &scene) {
    boundaryUnidirectional.configure(scene);
    boundaryBidirectional.configure(scene);
}

ArrayXd BoundaryMIS::renderC(const Scene         &scene,
                             const RenderOptions &options) const {
    return ArrayXd::Zero(1, 3);
}

ArrayXd BoundaryMIS::renderD(SceneAD             &sceneAD,
                             const RenderOptions &options,
                             const ArrayXd       &d_image) const {
    return boundaryUnidirectional.renderD(sceneAD, options, d_image) +
           boundaryBidirectional.renderD(sceneAD, options, d_image);
}
